-- TIMS Database creation script for TIMS V 5.0.0- Edited on 2023-11-07
CREATE DATABASE IF NOT EXISTS TIMS;
USE TIMS;

DROP TABLE IF EXISTS T_DROIT;
CREATE TABLE T_DROIT (
  CLE_DROIT INTEGER(10) unsigned NOT NULL auto_increment,
  CLE_PROFIL INTEGER NOT NULL,
  CLE_FICHE INTEGER(3) unsigned DEFAULT 0,
  ECRITURE TINYINT(1) DEFAULT 0,
  MODIFICATION TINYINT(1) DEFAULT 0,
  SUPPRESSION TINYINT(1) DEFAULT 0,
  CONSULTATION TINYINT(1) DEFAULT 0,
  PRIMARY KEY (`CLE_DROIT`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS T_FICHE;
CREATE TABLE T_FICHE (
  CLE_FICHE INTEGER(11) NOT NULL auto_increment,
  NOM_FICHE varchar(64) DEFAULT '',
  DESCRIPTION_FICHE text,
  DROIT_DEFAUT varchar(4) DEFAULT '1111',
  PRIMARY KEY  (`CLE_FICHE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS T_PROFIL;
CREATE TABLE T_PROFIL (
  CLE_PROFIL INTEGER(11) NOT NULL auto_increment,
  NOM_PROFIL varchar(64) default '',
  DESCRIPTION_PROFIL varchar(255) default NULL,
  DEFAUT TINYINT DEFAULT 0,
  PRIMARY KEY  (`CLE_PROFIL`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS T_RESTRICTION;
CREATE TABLE T_RESTRICTION (
  CLE_RESTRICTION INTEGER(10) unsigned NOT NULL auto_increment,
  CLE_USER INTEGER(10) unsigned DEFAULT 0,
  CLE_AGENCE INTEGER(10) unsigned DEFAULT 0,
  CLE_SOCIETE INTEGER(10) unsigned DEFAULT 0,
  PRIMARY KEY  (`CLE_RESTRICTION`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS T_SOCIETE;
CREATE TABLE T_SOCIETE (
  CLE_SOCIETE INTEGER(10) unsigned NOT NULL auto_increment,
  COMPANY_NAME VARCHAR(64) NOT NULL,
  BASE_NAME VARCHAR(64) NOT NULL,
  CODE VARCHAR(8) DEFAULT NULL,
  CONTACT VARCHAR(32) DEFAULT NULL,
  PHONE VARCHAR(32) DEFAULT NULL,
  FAX VARCHAR(32) DEFAULT NULL,
  MAIL VARCHAR(64) DEFAULT NULL,
  ADDRESS VARCHAR(128) DEFAULT NULL,
  CITY VARCHAR(64) DEFAULT NULL,
  POSTAL_CODE VARCHAR(8) DEFAULT NULL,
  COUNTRY TINYINT DEFAULT 17,
  FIRST_NAME VARCHAR(128) DEFAULT NULL,
  LAST_NAME VARCHAR(128) DEFAULT NULL,
  FTP_DIRECTORY VARCHAR(64) DEFAULT NULL,
  USER_DB_PWD VARCHAR(64),
  PRIMARY KEY  (`CLE_SOCIETE`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS T_UTILISATEUR;
CREATE TABLE T_UTILISATEUR (
  CLE_UTILISATEUR INTEGER(10) unsigned NOT NULL auto_increment,
  CLE_CHAUFFEUR INTEGER(10) unsigned DEFAULT 0,
  CLE_PROFIL INTEGER(10) unsigned NOT NULL DEFAULT 2,
  NOM_SOCIETE varchar(64) NOT NULL DEFAULT 0,
  LOGIN_UTILISATEUR varchar(64) NOT NULL DEFAULT '',
  PASSWORD_UTILISATEUR varchar(64) NOT NULL DEFAULT '',
  NOM_UTILISATEUR varchar(64) NOT NULL DEFAULT '',
  PRENOM_UTILISATEUR varchar(64) DEFAULT '',
  CLE_AGENCE INTEGER(3) unsigned DEFAULT 0,
  ADRESSE varchar(255) NOT NULL DEFAULT '',
  TELEPHONE varchar(20) NOT NULL DEFAULT '',
  VILLE varchar(45) NOT NULL DEFAULT '',
  CODE_POSTAL varchar(8) NOT NULL DEFAULT '',
  CHANGEMENT_PASSE DATE default '0000-00-00',
  ANCIEN_PASSE text NOT NULL,
  EMAIL varchar(45) NOT NULL DEFAULT '',
  RESTRICTION_SOCIETE TINYINT unsigned NOT NULL DEFAULT 0,
  RESTRICTION_AGENCE TINYINT unsigned NOT NULL DEFAULT 0,
  RESTRICTION_CONDUCTEUR TINYINT unsigned NOT NULL DEFAULT 0,
  ENABLE TINYINT(1) DEFAULT 1,
  ALERTED TINYINT(1) DEFAULT 0,
  LAST_ACTIVATION_ACTION DATETIME DEFAULT NULL,
  USER_FUNCTION VARCHAR(32) DEFAULT NULL,
  SUPER_USER_ALERT TINYINT DEFAULT 0,
  PRIMARY KEY  (`CLE_UTILISATEUR`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS CONNEXION ;
CREATE TABLE CONNEXION (
 CLE INTEGER(11) NOT NULL auto_increment,
 CLE_USER INTEGER(10) unsigned NOT NULL DEFAULT 0,
 CONNEXION TIMESTAMP NOT NULL DEFAULT 0,
 DECONNEXION TIMESTAMP NOT NULL DEFAULT 0,
 CLOSED TINYINT DEFAULT 0,
 VERSION VARCHAR(10) DEFAULT "2.9.0",
 PRIMARY KEY  (`CLE`),
 INDEX ind (CLE_USER),
 FOREIGN KEY (CLE_USER) REFERENCES t_utilisateur(CLE_UTILISATEUR) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS report;
CREATE TABLE report (
  ID int(10) unsigned NOT NULL auto_increment,
  TRANSLATION_ID varchar(64) NOT NULL default '',
  CUSTOMIZED_NAME varchar(64) NOT NULL default '',
  FILE_NAME varchar(64) NOT NULL default '',
  MINIMUM_VERSION TINYINT unsigned NOT NULL default '0',
  CLASS VARCHAR(64) DEFAULT "NONE",
  TYPE TINYINT UNSIGNED DEFAULT 1,
  MODULE TINYINT DEFAULT -1,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS droit_rapport;
CREATE TABLE droit_rapport (
  CLE INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  CLE_PROFIL INTEGER NOT NULL,
  CLE_RAPPORT INTEGER(2) UNSIGNED NOT NULL,
  ENABLE TINYINT UNSIGNED NOT NULL,
  PRIMARY KEY(`CLE`),
  FOREIGN KEY (CLE_PROFIL) REFERENCES `tims`.`t_profil`(CLE_PROFIL) ON DELETE CASCADE
) ENGINE = InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE TIMS.USER_WIDGET (
  `ID` INTEGER(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `USER_ID` INTEGER(10) UNSIGNED NOT NULL,
  `WIDGET_ID` TINYINT UNSIGNED NOT NULL,
  `POSITION` TINYINT UNSIGNED NOT NULL,
  PRIMARY KEY(`ID`)
) ENGINE = InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE configuration (
  ID INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  VALUE text,
  EVAL text,
  ENABLED TINYINT(1) DEFAULT 1,
  USER_ID INTEGER(10) UNSIGNED DEFAULT 0,
  EDITABLE TINYINT(1) DEFAULT 1,
  PRIMARY KEY  (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

ALTER TABLE T_DROIT ADD FOREIGN KEY (CLE_PROFIL) REFERENCES t_profil(CLE_PROFIL) ON DELETE CASCADE;
ALTER TABLE T_RESTRICTION ADD FOREIGN KEY (CLE_USER) REFERENCES T_UTILISATEUR(CLE_UTILISATEUR) ON DELETE CASCADE;

INSERT INTO T_PROFIL VALUES (1,'ADMIN','Profil administrateur avec tous les droits.',1);

INSERT INTO T_FICHE (NOM_FICHE, DESCRIPTION_FICHE, DROIT_DEFAUT) VALUES ('CONDUCTEUR','Fiche descriptive pour chaque conducteur.','1110'),
('SOCIETE','Fiche descriptive pour chaque socit.','1110'),
('TABLEAU DE BORD','Accs au tableau de bord et au dtails.','1000'),
('ACTIVITE','Gestion des activits.','1000'),
('INFRACTION','Gestion des infractions.','1000'),
('ADMINISTRATION','Gestion des droits utilisateurs et des profils.','1000'),
('MENU_CAP','Accs aux tlchargements via la CAP.','0000'),
('MENU','Accs aux menus non grsen droit.','0000'),
('AGENCE','Fiche agence.','1000'),
('FRAIS','Fiche frais.','1000'),
('VEHICULE','Fiche vhicule.','1000'),
('RAPPORT','Fiche rapport.','1000'),
('SCAN','Fiche scan.','1000'),
('REGLEMENTATION','Rglementation.','1111'),
('DBOX','Fiche scan.','1111'),
('TYPE_PAIE', '','1111'),
('TYPE_PERSONNEL', '','1111'),
('COMMENTAIRE', '','1111'),
('TAILLE_AGENCE', '','1111'),
('TYPE_AGENCE', '','1111'),
('TYPE_ACTIVITE','', '1111'),
('PERMIS','', '1111'),
('CALENDRIER','', '1111'),
('CAL_PREVISION','Futurs paramtres de journes','0000'),
('REGION','Gestion des rgions','0000'),
('PAY_PERIOD','Priode de paie (clotre, import...)','0000'),
('EXPORT','Accs  l\'archivage des fiches','0000'),
('FAULT','Gestion des anomalies','0000'),
('DAY_TYPE','Paramtres type de journes','0000'),
('COMPANY_CARD','Gestion des cartes entreprises','0000'),
('EXPENSES_VALIDATION','Validation des frais','0000'),
('INTERVENTION','accs aux interventions','0000'),
('INTERVENTION_TYPE','gestion des types d\'intervention','0000'),
('V1B','gestion des fichiers V1B','0000'),
('EMPLOYEE_OBLIGATION','obligations salari','0000'),
('EMPLOYEE_OBLIGATION_TYPE','gestion des types d\'obligations salari','0000'),
('VEHICLE_TYPE','type de vhicule','0000'),
('BODY','type de carrosserie','0000'),
('VEHICLE_AFFECTATION','affectation vhicule','0000'),
('GARAGE','gestion des garages','0000'),
('ACCIDENT','partie accident','0000'),
('ACCIDENT_FINANCIAL','partie financire des accidents','0000'),
('VEHICLE_MODEL','modle de vhicule','0000'),
('VEHICLE_ANALYTIC_CODE','Fiche code analytique des vhicules','0000'),
('DRIVER_ANALYTIC_CODE','Fiche code analytique des conducteurs','0000'),
('CONSOMMATION','accs aux consommation de carburant','0000'),
('CONSUMPTION_CRITERIA','paramtrage valuation pour consommation','0000'),
('ATTACHMENT','pices jointes','0000'),
('VEHICLE_ATTACHMENT','pices jointes vehicule','0000'),
('HARDNESS','pnibilit','0000'),
('POSITION','position','0000');
-- on ne cr pas pour export_paie sur une base locale...
-- ('CAL_PREVISION','Futurs paramtres de journ?es','0000'),
-- ('PLANNING','Planning prvisionnel','0000'),
-- ('TOURNEE','Gestion des tournes.','1000'),

INSERT INTO T_DROIT (`CLE_PROFIL`,`CLE_FICHE`,`ECRITURE`,`MODIFICATION`,`SUPPRESSION`,`CONSULTATION`) (select CLE_PROFIL, CLE_FICHE, 1,1,1,1 from TIMS.T_PROFIL, TIMS.T_FICHE);

INSERT INTO REPORT (`TRANSLATION_ID`,`CUSTOMIZED_NAME`,`FILE_NAME`,`MINIMUM_VERSION`,`CLASS`,`TYPE`) VALUES 
("ra", "rapport d'activit", "activite", 1, "NONE", 1),
("rs", "rapport de service", "service", 2, "transport.report.ServiceReport", 1),
("ss", "synthse des services", "sservice", 2, "transport.report.ServiceSynthese", 1),
("aac", "analyse des activits conducteurs", "aac", 2, "transport.report.Aac", 1),
("sa", "synthse d'activit", "synthese", 2, "NONE", 1),
("rhn", "rapport des heures de nuit", "nuit", 2, "transport.report.Night", 1),
("rj", "rapport journalier", "jour", 2, "transport.report.DailyReport", 1),
("rsm", "rapport de saisie manuelle", "saiman", 2, "transport.report.ManualInput", 1),
("ri", "rapport d'infraction", "infraction", 2, "transport.report.Offence", 1),
("rsup", "rapport de suppression", "suppression", 2, "NONE", 1),
("ci", "courrier infraction", "courrier", 2, "transport.report.Offence", 1),
("rc", "repos compensateur", "rc", 3, "transport.report.ReposCompensateur", 1),
("sh", "suivi des heures", "suivi", 3, "transport.report.HourCalculation", 1),
("sv", "suivi des vhicules", "vehicule", 2, "NONE", 2),
("rm", "rapport de modification", "modification", 2, "transport.report.Update", 1),
("pp", "prparation  la paie", "prepaie", 3, "transport.report.HourCalculation", 1),
("attestation", "attestation de non activit", "attestation", 3,"transport.report.Attestation", 1),
("expenses", "rapport de frais", "templatePortrait.jrxml", 3,"transport.report.DynamicDriverExpenses",1),
("sexpense", "synthse de frais", "templatePortrait.jrxml", 3,"transport.report.DynamicExpenseSynthesis",1),
("soffence", "synthse des infractions", "templatePortrait.jrxml", 2,"transport.report.DynamicOffenceSynthesis",1),
("voffence", "infraction vhicule", "templatePortrait.jrxml", 2,"transport.report.VehicleOffence", 2),
("vlocation", "projection location", "templatePortrait.jrxml", 3,"transport.report.VehicleLocation", 2),
("card", "fichier renouvellement de carte chronoservice", "template.jrxml", 2, "transport.report.CardRenewal", 1),
("soffence-gravity", "synthse des infractions par gravit", "template.jrxml", 2, "transport.report.DynamicOffenceSynthesisByGravity", 1),
("accident-report", "rapport des accidents", "template.jrxml", 3, "transport.report.AccidentReportList", 2),
("accident-analysis", "analyses des accidents", "template.jrxml", 3, "transport.report.AccidentSynthesis", 2),
("accident-graphic", "analyse graphique des accidents", "accident-graphic", 3, "transport.report.AccidentGraphic", 2),
("accident-cost-graphic", "analyse graphique (cot) des accidents", "accident-graphic", 3, "transport.report.AccidentGraphic", 2),
("round-analysis", "analyses des tournes", "accident-graphic", 3, "transport.report.RoundAnalysis", 2),
("consumption", "consommation carburant", "templatePortrait.jrxml", 3, "transport.report.ConsumptionReport", 1),
("tipp", "rapport TIPP", "templatePortrait.jrxml", 2, "transport.report.VehicleTIPP", 2),
("vehicleSynthesis", "synthse vhicule", "templatePortrait.jrxml", 2, "transport.report.DynamicVehicleSynthesis", 1),
("globalActivity", "synthse globale d'activit", "templatePortrait.jrxml", 3, "transport.report.GlobalActivitySynthesis", 1),
("payExport", "export paie", "templatePortrait.jrxml", 3, "transport.report.PayExport", 1),
("hardnessCounter", "rapport de penibilit", "templateLandscape.jrxml", 2, "transport.report.DynamicHardnessCounter", 1),
("dayPrint", "graphe d'activit", "dayGraph", 2, "transport.report.DayPrint", 1),
("offChallenge", "rcapitulatif des infractions", "template.jrxml", 2, "transport.report.DynamicOffenceChallenge", 2);
-- on ne gre plus les rapports suivants sur une version locale :
-- ("distribution", "rapport de suivi des heures (distribution)", "distribution", 3,"transport.report.Distribution", 1),
-- ("traction", "rapport de suivi des heures (traction)", "traction", 3, "transport.report.Traction", 1),
-- ("controle", "rapport de gestion", "controle", 3,"transport.report.Controle", 1),
-- ("projection", "future projection", "projection", 3,"transport.report.Projection", 1),

CREATE TABLE TIMS.USER_MESSAGE (
  ID INTEGER(11) unsigned NOT NULL AUTO_INCREMENT,
  NAME VARCHAR(64) NOT NULL,
  MESSAGE TEXT NOT NULL,
  CREATION_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (ID)
) ENGINE=InnoDB;

CREATE TABLE TIMS.USER_MESSAGE_ACTIVATION (
  ID INTEGER(11) unsigned NOT NULL AUTO_INCREMENT,
  MESSAGE_ID INTEGER(11) NOT NULL,
  USER_ID INTEGER(11) NOT NULL,
  VALIDATED TINYINT DEFAULT 0,
  VALIDATION_DATE DATETIME DEFAULT NULL,
  PRIMARY KEY (ID)
) ENGINE=InnoDB;

-- on gre les modules pour le logiciel en local...
UPDATE TIMS.REPORT SET MINIMUM_VERSION = 0, MODULE=0 WHERE TRANSLATION_ID = "accident-report";
UPDATE TIMS.REPORT SET MINIMUM_VERSION = 0, MODULE=0 WHERE TRANSLATION_ID = "accident-analysis";
UPDATE TIMS.REPORT SET MINIMUM_VERSION = 0, MODULE=0 WHERE TRANSLATION_ID = "accident-graphic";
UPDATE TIMS.REPORT SET MINIMUM_VERSION = 0, MODULE=0 WHERE TRANSLATION_ID = "accident-cost-graphic";
UPDATE TIMS.REPORT SET MINIMUM_VERSION = 0, MODULE=1 WHERE TRANSLATION_ID = "consumption";

INSERT INTO DROIT_RAPPORT (CLE_PROFIL,CLE_RAPPORT,ENABLE) select CLE_PROFIL, ID, 1 from TIMS.T_PROFIL, TIMS.REPORT;

INSERT INTO CONFIGURATION (VALUE, EVAL, ENABLED, USER_ID) VALUES ("price-fixed_default","1",1,0);
INSERT INTO CONFIGURATION (VALUE, EVAL, ENABLED, USER_ID) VALUES ("show_country","0",1,0);
INSERT INTO CONFIGURATION (VALUE, EVAL, ENABLED, USER_ID) VALUES ("show_region","0",1,0);
INSERT INTO CONFIGURATION (VALUE, EVAL, ENABLED, USER_ID) VALUES ("pay_period","0",1,0);
INSERT INTO CONFIGURATION (VALUE, EVAL, ENABLED, USER_ID) VALUE ("mysql5","1",1,1);
INSERT INTO CONFIGURATION (VALUE, EVAL, ENABLED, USER_ID, EDITABLE) values ('scan.vehicle.enlarge','0',1,0,1);
INSERT INTO CONFIGURATION (VALUE, EVAL, ENABLED, USER_ID, EDITABLE) values ('data.path','undefined',1,0,1);
INSERT INTO CONFIGURATION (VALUE, EVAL, ENABLED, USER_ID, EDITABLE) values ('activity.vehicle.detail','false',1,0,0);
INSERT INTO CONFIGURATION (VALUE, EVAL, ENABLED, USER_ID, EDITABLE) VALUES ("auto.save.activation","1",1,0,1);
INSERT INTO CONFIGURATION (VALUE, EVAL, ENABLED, USER_ID, EDITABLE) VALUES ("auto.save.frequency","21",1,0,1);

CREATE TABLE TIMS.AUTOMATIC_WARNING (
  ID INTEGER(3) UNSIGNED NOT NULL AUTO_INCREMENT,
  NAME VARCHAR(64) NOT NULL,
  CALCULATION_CLASS VARCHAR(96) NOT NULL,
  FREQUENCY TINYINT(1) DEFAULT 0,
  EXECUTION_DATE TINYINT(1) UNSIGNED NOT NULL DEFAULT 1,
  PRIMARY KEY(`ID`)
) ENGINE = InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE TIMS.COMPANY_WARNING_ACTIVATION (
  ID INTEGER(3) UNSIGNED NOT NULL AUTO_INCREMENT,
  ID_WARNING INTEGER(3) UNSIGNED NOT NULL,
  ID_COMPANY INTEGER(10) UNSIGNED NOT NULL,
  PRIMARY KEY(`ID`)
) ENGINE = InnoDB DEFAULT CHARSET=latin1;

ALTER TABLE TIMS.COMPANY_WARNING_ACTIVATION ADD FOREIGN KEY (ID_WARNING) REFERENCES TIMS.AUTOMATIC_WARNING(ID) ON DELETE CASCADE;
ALTER TABLE TIMS.COMPANY_WARNING_ACTIVATION ADD FOREIGN KEY (ID_COMPANY) REFERENCES TIMS.T_SOCIETE(CLE_SOCIETE) ON DELETE CASCADE;

CREATE TABLE TIMS.USER_WARNING_ACTIVATION (
  ID INTEGER(3) UNSIGNED NOT NULL AUTO_INCREMENT,
  ID_WARNING INTEGER(3) UNSIGNED NOT NULL,
  ID_USER INTEGER(10) UNSIGNED NOT NULL,
  PRIMARY KEY(`ID`)
) ENGINE = InnoDB DEFAULT CHARSET=latin1;

ALTER TABLE TIMS.USER_WARNING_ACTIVATION ADD FOREIGN KEY (ID_WARNING) REFERENCES TIMS.AUTOMATIC_WARNING(ID) ON DELETE CASCADE;
ALTER TABLE TIMS.USER_WARNING_ACTIVATION ADD FOREIGN KEY (ID_USER) REFERENCES TIMS.T_UTILISATEUR(CLE_UTILISATEUR) ON DELETE CASCADE;

CREATE TABLE TIMS.WS_USER (
  `ID` INTEGER(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `USER_ID` INTEGER(10) UNSIGNED NOT NULL,
  `SELECTED_COMPANY_ID` INTEGER(10) UNSIGNED NOT NULL,
  `IP` VARCHAR(32) NOT NULL,
  `AUTH` DATETIME NOT NULL,
  `ENABLE` TINYINT NOT NULL,
  PRIMARY KEY(`ID`)
) ENGINE = InnoDB DEFAULT CHARSET=latin1;

INSERT INTO CONFIGURATION (VALUE, EVAL, ENABLED, USER_ID, EDITABLE) VALUES ("database_version","4.3.1",1,0, 0);
INSERT INTO CONFIGURATION (VALUE, EVAL, ENABLED, USER_ID, EDITABLE) VALUES ("software_version","4.3.1",1,0, 0);
INSERT INTO CONFIGURATION (VALUE, EVAL, ENABLED, USER_ID, EDITABLE) VALUES ("original_version","4.3.1",1,0, 0);

UPDATE mysql.user SET Password=PASSWORD('mysql1') WHERE User='root';
FLUSH PRIVILEGES;