/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.examples.events;

import be.fedict.commons.eid.client.CardAndTerminalManager;
import be.fedict.commons.eid.client.event.CardEventsListener;
import java.math.BigInteger;
import javax.smartcardio.Card;
import javax.smartcardio.CardTerminal;

public class CardEventsExamples {
    public CardEventsExamples cardterminals_basic_asynchronous() throws InterruptedException {
        CardAndTerminalManager cardAndTerminalManager = new CardAndTerminalManager();
        cardAndTerminalManager.addCardListener(new CardEventsListener(){

            @Override
            public void cardInserted(CardTerminal cardTerminal, Card card) {
                if (card != null) {
                    System.err.println("Card [" + String.format("%x", new BigInteger(1, card.getATR().getBytes())) + "] Inserted Into Terminal [" + cardTerminal.getName() + "]");
                } else {
                    System.err.println("Card present but failed to connect()");
                }
            }

            @Override
            public void cardRemoved(CardTerminal cardTerminal) {
                System.err.println("Card Removed From [" + cardTerminal.getName() + "]");
            }

            @Override
            public void cardEventsInitialized() {
                System.out.println("From now on you'll see Cards being Inserted/Removed");
            }
        });
        System.out.println("First, you'll see Inserted events for Cards that were already inserted");
        cardAndTerminalManager.start();
        while (true) {
            Thread.sleep(2000L);
        }
    }

    public static void main(String[] args) throws InterruptedException {
        CardEventsExamples examples = new CardEventsExamples();
        examples.cardterminals_basic_asynchronous();
    }
}

