/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.util.Fonctions;

public class JNotificationFrame
extends JFrame
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static Vector<JNotificationFrame> frameList = new Vector();
    private static final Dimension SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
    private static final Insets INSETS = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
    public static final Corner DEFAULT_CORNER = Corner.BOTTOM_RIGHT;
    public static final int DEFAULT_SPEED = 30;
    public static final int DEFAULT_MOVE = 8;
    private static final int SHOW_NOTIFICATION = 0;
    private static final int HIDE_NOTIFICATION = 1;
    private static final int MESSAGE_HEIGHT = 50;
    private Corner corner;
    private Dimension defaultWindowSize = null;
    private Vector<NotificationMessage> messages = new Vector();
    private int speed;
    private int duration = 3;
    private boolean slide = true;
    private boolean isShowing = false;
    private boolean isHiding = false;
    private JPanel panel;
    private boolean mouseOn = false;

    public static JNotificationFrame getFrame(Corner corner) {
        for (JNotificationFrame frame : frameList) {
            if (frame.getCorner() != corner) continue;
            return frame;
        }
        JNotificationFrame newFrame = new JNotificationFrame(corner);
        frameList.add(newFrame);
        return newFrame;
    }

    public JNotificationFrame() {
        this(DEFAULT_CORNER, 30);
    }

    public JNotificationFrame(Corner corner) {
        this(corner, 30);
    }

    public JNotificationFrame(Corner corner, int speed) {
        this.setCorner(corner);
        this.setSize(this.getDefaultWindowSize());
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.setUndecorated(true);
        this.panel = new JPanel(new GridBagLayout());
        JScrollPane jsp = new JScrollPane(this.panel);
        jsp.setBorder(new CompoundBorder(new BevelBorder(0, new Color(0, 0, 0), null, null, null), new BevelBorder(1, new Color(0, 0, 0), null, null, null)));
        jsp.setVerticalScrollBarPolicy(22);
        this.getContentPane().add((Component)jsp, "Center");
        this.setSpeed(speed);
        this.panel.addMouseListener(this);
        this.setDefaultLocation();
    }

    private boolean continueShowingNotification(Corner corner) {
        boolean continueToShow = true;
        int currentY = this.getBounds().y;
        switch (corner) {
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                if (currentY > JNotificationFrame.SCREEN_SIZE.height - MainFrameTransport.getInstance().getTrayHeight() - this.getSize().height - JNotificationFrame.INSETS.bottom) break;
                continueToShow = false;
                break;
            }
            case TOP_RIGHT: 
            case TOP_LEFT: {
                if (currentY < 0) break;
                continueToShow = false;
            }
        }
        return continueToShow;
    }

    public synchronized void showNotification(int duration) {
        if (Transport.apiMode == 1) {
            TimsLogger.debug("#JNotificationFrame.showNotification# Attempt to show notification in apiMode");
            return;
        }
        if (this.isVisible()) {
            // empty if block
        }
        this.setDuration(duration);
        this.showNotification();
    }

    public synchronized void showNotification() {
        new Thread(){

            @Override
            public void run() {
                while (JNotificationFrame.this.isHiding) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                TimsLogger.debug("isShowing");
                JNotificationFrame.this.isShowing = true;
                JNotificationFrame.this.setVisible(true);
                Corner corner = JNotificationFrame.this.getCorner();
                while (JNotificationFrame.this.continueShowingNotification(corner)) {
                    TimsLogger.debug("show");
                    try {
                        Thread.sleep(JNotificationFrame.this.speed);
                        JNotificationFrame.this.moveNotificationWindow(0);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                JNotificationFrame.this.isShowing = false;
                if (JNotificationFrame.this.duration > 0) {
                    while (JNotificationFrame.this.duration > 0) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (JNotificationFrame.this.mouseOn) continue;
                        JNotificationFrame jNotificationFrame = JNotificationFrame.this;
                        jNotificationFrame.duration = jNotificationFrame.duration - 1;
                    }
                    JNotificationFrame.this.hideNotification(JNotificationFrame.this.slide);
                }
            }
        }.start();
    }

    private boolean continueHidingNotification(Corner corner) {
        boolean continueToHide = true;
        int current_Y = this.getBounds().y;
        switch (corner) {
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                if (current_Y < JNotificationFrame.SCREEN_SIZE.height) break;
                continueToHide = false;
                break;
            }
            case TOP_RIGHT: 
            case TOP_LEFT: {
                if (current_Y > -this.getSize().height) break;
                continueToHide = false;
            }
        }
        return continueToHide;
    }

    public synchronized void hideNotification() {
        this.hideNotification(this.slide);
    }

    public synchronized void hideNotification(final boolean slide) {
        if (!this.isVisible() || this.duration == -1) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                if (JNotificationFrame.this.isShowing) {
                    return;
                }
                JNotificationFrame.this.isHiding = true;
                if (slide) {
                    Corner corner = JNotificationFrame.this.getCorner();
                    while (JNotificationFrame.this.continueHidingNotification(corner)) {
                        try {
                            Thread.sleep(JNotificationFrame.this.speed);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        JNotificationFrame.this.moveNotificationWindow(1);
                    }
                }
                JNotificationFrame.this.isHiding = false;
                JNotificationFrame.this.dispose();
            }
        }.start();
    }

    private void moveNotificationWindow(int showOrHide) {
        Corner corner = this.getCorner();
        if (corner == null) {
            throw new NullPointerException("Corner cannot be null !!!");
        }
        Rectangle bounds = this.getBounds();
        int dy = 8;
        switch (corner) {
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                if (showOrHide == 0) {
                    dy = -dy;
                }
                bounds.y += dy;
                break;
            }
            case TOP_RIGHT: 
            case TOP_LEFT: {
                if (showOrHide == 1) {
                    dy = -dy;
                }
                bounds.y += dy;
                break;
            }
            default: {
                corner = DEFAULT_CORNER;
                this.moveNotificationWindow(showOrHide);
            }
        }
        this.setBounds(bounds);
    }

    private void setDefaultLocation() {
        Corner corner = this.getCorner();
        if (corner == null) {
            throw new NullPointerException("Corner cannot be null !!!");
        }
        int x = 0;
        int y = 0;
        Dimension windowSize = this.getSize();
        switch (corner) {
            case BOTTOM_RIGHT: {
                x = JNotificationFrame.SCREEN_SIZE.width - windowSize.width;
                y = JNotificationFrame.SCREEN_SIZE.height - JNotificationFrame.INSETS.bottom;
                break;
            }
            case BOTTOM_LEFT: {
                x = 0;
                y = JNotificationFrame.SCREEN_SIZE.height - JNotificationFrame.INSETS.bottom;
                break;
            }
            case TOP_RIGHT: {
                x = JNotificationFrame.SCREEN_SIZE.width - windowSize.width - JNotificationFrame.INSETS.bottom;
                y = -windowSize.height;
                break;
            }
            case TOP_LEFT: {
                x = 0;
                y = -windowSize.height;
                break;
            }
            default: {
                corner = DEFAULT_CORNER;
                this.setDefaultLocation();
            }
        }
        this.setLocation(x, y);
    }

    public void setCorner(Corner corner) {
        this.corner = corner;
        this.setDefaultLocation();
    }

    public Corner getCorner() {
        return this.corner;
    }

    public Dimension getDefaultWindowSize() {
        if (this.defaultWindowSize == null) {
            int height = JNotificationFrame.SCREEN_SIZE.height / 8;
            int visibleMessages = height / 50 + 1;
            this.defaultWindowSize = new Dimension(JNotificationFrame.SCREEN_SIZE.width / 3 + 100, visibleMessages * 50);
        }
        return this.defaultWindowSize;
    }

    public void setDefaultWindowSize(Dimension defaultWindowSize) {
        this.defaultWindowSize = defaultWindowSize;
    }

    public NotificationMessage addMessage(String title) {
        NotificationMessage toAdd = new NotificationMessage(title);
        return this.addMessage(toAdd);
    }

    public NotificationMessage addMessage(JLabel message) {
        NotificationMessage toAdd = new NotificationMessage(message);
        return this.addMessage(toAdd);
    }

    public NotificationMessage addMessage(String title, Icon icon) {
        NotificationMessage toAdd = new NotificationMessage(title, null, icon);
        return this.addMessage(toAdd);
    }

    public NotificationMessage addMessage(String title, JComponent message, Icon icon) {
        NotificationMessage toAdd = new NotificationMessage(title, message, icon);
        return this.addMessage(toAdd);
    }

    private NotificationMessage addMessage(NotificationMessage toAdd) {
        int msgCount = this.messages.size();
        if (msgCount > 0) {
            this.messages.get(msgCount - 1).setEnabled(false);
        }
        GridBagConstraints gcb = Fonctions.getGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 2, 18, new Insets(2, 5, 2, 5));
        this.messages.add(toAdd);
        Component[] componentArray = this.panel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            GridBagLayout gbl = (GridBagLayout)this.panel.getLayout();
            GridBagConstraints gcbo = gbl.getConstraints(comp);
            ++gcbo.gridy;
            gbl.setConstraints(comp, gcbo);
            ++n2;
        }
        this.panel.add((Component)toAdd, gcb);
        this.panel.repaint();
        return toAdd;
    }

    public String getMessage() {
        return this.messages.get(this.messages.size() - 1).getText();
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public static void main(String[] args) {
        JNotificationFrame w1 = new JNotificationFrame(Corner.BOTTOM_RIGHT);
        w1.addMessage("I use transparency !");
        w1.showNotification(5);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        TimsLogger.debug("mouseEntered");
        this.mouseOn = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        TimsLogger.debug("mouseExited");
        this.mouseOn = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public static enum Corner {
        TOP_RIGHT,
        TOP_LEFT,
        BOTTOM_RIGHT,
        BOTTOM_LEFT;

    }

    public class NotificationMessage
    extends JPanel {
        private JLabel title = null;
        private JComponent content = null;

        public NotificationMessage(String sTitle, JComponent content, Icon icon) {
            this.title = new JLabel(sTitle, icon, 10);
            this.content = content;
            this.initialize();
        }

        public NotificationMessage(JLabel title, JComponent content) {
            this.title = title;
            this.content = content;
            this.initialize();
        }

        public NotificationMessage(String title) {
            this(title, null, null);
        }

        public NotificationMessage(String title, JComponent content) {
            this(title, content, null);
        }

        public NotificationMessage(JLabel message) {
            this(message.getText(), null, message.getIcon());
        }

        public String getText() {
            return this.title.getText();
        }

        public void setTitle(String text) {
            this.title.setText(text);
            this.repaint();
        }

        public JComponent getContent() {
            return this.content;
        }

        public void setContent(JComponent content) {
            this.content = content;
            this.repaint();
        }

        public void setIcon(Icon icon) {
            this.title.setIcon(icon);
            this.repaint();
        }

        public void initialize() {
            this.setMaximumSize(new Dimension(0, 50));
            this.setMinimumSize(new Dimension(0, 50));
            this.setPreferredSize(new Dimension(0, 50));
            this.setSize(new Dimension(0, 50));
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.title, "North");
            this.add((Component)new JSeparator(), "South");
            if (this.content != null) {
                this.add((Component)this.content, "Center");
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.title.setEnabled(false);
            if (this.content != null) {
                this.content.setEnabled(false);
            }
            super.setEnabled(enabled);
        }
    }
}

