/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.component;

import fr.pgh.component.JMultiListBox;
import fr.pgh.component.model.MultiListBoxModel;
import fr.pgh.component.ui.renderer.CheckListCellRenderer;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import transpo.system.TimsLogger;

public class MultiListBoxPopup
extends JPopupMenu {
    private Handler handler;
    private JList list = null;
    private JMultiListBox multiSelBox = null;
    protected MouseMotionListener mouseMotionListener;
    protected MouseListener mouseListener;
    protected PropertyChangeListener propertyChangeListener;
    protected JScrollPane scroller;
    private static Border LIST_BORDER = new LineBorder(Color.BLACK, 1);
    int hotspot;

    public MultiListBoxPopup(JMultiListBox multiSelBox) {
        this.hotspot = new JCheckBox().getPreferredSize().width;
        this.multiSelBox = multiSelBox;
        this.list = this.createList();
        this.configureList();
        this.scroller = this.createScroller();
        this.configurePopup();
        this.installListeners();
    }

    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(LIST_BORDER);
        this.setOpaque(false);
        this.add(this.scroller);
        this.setDoubleBuffered(true);
        this.setFocusable(false);
    }

    @Override
    public void show() {
        Point location = this.getPopupLocation();
        super.show(this.multiSelBox, location.x, location.y);
    }

    @Override
    public void hide() {
        this.setVisible(false);
    }

    public JList createList() {
        return new JList(this.multiSelBox.getModel());
    }

    protected JScrollPane createScroller() {
        JScrollPane sp = new JScrollPane(this.list, 20, 31);
        sp.setHorizontalScrollBar(null);
        return sp;
    }

    @Override
    protected void firePopupMenuWillBecomeVisible() {
        super.firePopupMenuWillBecomeVisible();
        this.multiSelBox.firePopupMenuWillBecomeVisible();
    }

    @Override
    protected void firePopupMenuWillBecomeInvisible() {
        super.firePopupMenuWillBecomeInvisible();
        this.multiSelBox.firePopupMenuWillBecomeInvisible();
    }

    @Override
    protected void firePopupMenuCanceled() {
        super.firePopupMenuCanceled();
        this.multiSelBox.firePopupMenuCanceled();
    }

    public JList getList() {
        return this.list;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    public MouseListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = this.createMouseListener();
        }
        return this.mouseListener;
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    public void uninstallingUI() {
        if (this.propertyChangeListener != null) {
            this.multiSelBox.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.list.removeMouseListener(this.getHandler());
        this.list.removeMouseMotionListener(this.getHandler());
        this.list.setModel(null);
    }

    protected void configureList() {
        ((MultiListBoxModel)this.list.getModel()).addListSelectionListener(this.getHandler());
        this.list.setCellRenderer(new CheckListCellRenderer(this.multiSelBox.getPrinter()));
        this.list.registerKeyboardAction(this.getHandler(), KeyStroke.getKeyStroke(32, 0), 0);
        this.list.addMouseListener(this.getHandler());
        this.list.addMouseMotionListener(this.getHandler());
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.multiSelBox.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private Point getPopupLocation() {
        Dimension popupSize = this.multiSelBox.getSize();
        Insets insets = this.getInsets();
        int rowCount = this.multiSelBox.getModel().getSize();
        if (rowCount > this.multiSelBox.maximumRowCount) {
            rowCount = this.multiSelBox.maximumRowCount;
        }
        int height = rowCount * this.getList().getFixedCellHeight() + 4;
        popupSize.setSize(popupSize.width - (insets.right + insets.left), height <= 4 ? 100 : height);
        Rectangle popupBounds = this.computePopupBounds(0, this.multiSelBox.getBounds().height, popupSize.width, popupSize.height);
        Dimension scrollSize = popupBounds.getSize();
        Point popupLocation = popupBounds.getLocation();
        this.scroller.setMaximumSize(scrollSize);
        this.scroller.setPreferredSize(scrollSize);
        this.scroller.setMinimumSize(scrollSize);
        this.list.revalidate();
        return popupLocation;
    }

    protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
        Rectangle screenBounds;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = this.multiSelBox.getGraphicsConfiguration();
        Point p = new Point();
        SwingUtilities.convertPointFromScreen(p, this.multiSelBox);
        if (gc != null) {
            Insets screenInsets = toolkit.getScreenInsets(gc);
            screenBounds = gc.getBounds();
            screenBounds.width -= screenInsets.left + screenInsets.right;
            screenBounds.height -= screenInsets.top + screenInsets.bottom;
            screenBounds.x += p.x + screenInsets.left;
            screenBounds.y += p.y + screenInsets.top;
        } else {
            screenBounds = new Rectangle(p, toolkit.getScreenSize());
        }
        Rectangle rect = new Rectangle(px, py, pw, ph);
        if (py + ph > screenBounds.y + screenBounds.height && ph < screenBounds.height) {
            rect.y = -rect.height;
        }
        return rect;
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
            this.list.requestFocus();
        }
    }

    private class Handler
    extends MouseAdapter
    implements MouseMotionListener,
    ListSelectionListener,
    ActionListener,
    PropertyChangeListener,
    Serializable {
        int hotspot;

        public Handler() {
            this.hotspot = new JCheckBox().getPreferredSize().width;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TimsLogger.debug("#MultiListBoxPopup.mouseReleased# Source of clic " + e.getSource());
            if (!((JComponent)e.getSource()).isEnabled()) {
                return;
            }
            if (e.getSource() != MultiListBoxPopup.this.list) {
                MultiListBoxPopup.this.togglePopup();
                return;
            }
            int index = MultiListBoxPopup.this.list.locationToIndex(e.getPoint());
            if (index < 0) {
                return;
            }
            if (e.getX() > ((MultiListBoxPopup)MultiListBoxPopup.this).list.getCellBounds((int)index, (int)index).x + this.hotspot) {
                TimsLogger.debug("#MultiBoxPopup.handler.mouseReleased# clicked on " + index + " index name");
                ((MultiListBoxModel)MultiListBoxPopup.this.list.getModel()).clearSelection();
                this.toggleSelection(index);
                MultiListBoxPopup.this.togglePopup();
            } else {
                TimsLogger.debug("#MultiBoxPopup.handler.mouseReleased# clicked on " + index + " index checkbox");
                this.toggleSelection(index);
            }
        }

        private void toggleSelection(int index) {
            if (index < 0) {
                return;
            }
            if (((MultiListBoxModel)MultiListBoxPopup.this.list.getModel()).isSelectedIndex(index)) {
                TimsLogger.debug("#MultiBoxPopup.handler.toggleSelection# removeSelectionInterval " + index);
                ((MultiListBoxModel)MultiListBoxPopup.this.list.getModel()).removeSelectionInterval(index, index);
            } else {
                TimsLogger.debug("#MultiBoxPopup.handler.toggleSelection# addSelectionInterval " + index);
                ((MultiListBoxModel)MultiListBoxPopup.this.list.getModel()).addSelectionInterval(index, index);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            TimsLogger.debug("#MultiBoxPopup.handler.valueChanged# repaint... from " + e.getFirstIndex() + " to " + e.getLastIndex());
            MultiListBoxPopup.this.list.repaint(MultiListBoxPopup.this.list.getCellBounds(e.getFirstIndex(), e.getLastIndex()));
            TimsLogger.debug("" + MultiListBoxPopup.this.list.getCellBounds(e.getFirstIndex(), e.getLastIndex()));
            MultiListBoxPopup.this.repaint();
            MultiListBoxPopup.this.multiSelBox.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TimsLogger.debug("#MiltiListBox.handler.getActionPerformed# list.getSelectedIndex() = " + MultiListBoxPopup.this.list.getSelectedIndex());
            this.toggleSelection(MultiListBoxPopup.this.list.getSelectedIndex());
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName == "model") {
                TimsLogger.debug("#MultiListPopup.handler.propertyChange# change model of " + e.getSource());
                MultiListBoxModel newModel = (MultiListBoxModel)e.getNewValue();
                MultiListBoxPopup.this.list.setModel(newModel);
                ((MultiListBoxModel)MultiListBoxPopup.this.list.getModel()).addListSelectionListener(this);
                if (MultiListBoxPopup.this.isVisible()) {
                    MultiListBoxPopup.this.hide();
                }
            } else if (propertyName == "componentOrientation") {
                ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                if (MultiListBoxPopup.this.list != null && MultiListBoxPopup.this.list.getComponentOrientation() != o) {
                    MultiListBoxPopup.this.list.setComponentOrientation(o);
                }
                if (MultiListBoxPopup.this.scroller != null && MultiListBoxPopup.this.scroller.getComponentOrientation() != o) {
                    MultiListBoxPopup.this.scroller.setComponentOrientation(o);
                }
                if (o != MultiListBoxPopup.this.getComponentOrientation()) {
                    MultiListBoxPopup.this.setComponentOrientation(o);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (e.getSource() != MultiListBoxPopup.this.list) {
                return;
            }
            int index = MultiListBoxPopup.this.list.locationToIndex(e.getPoint());
            if (index < 0) {
                return;
            }
            MultiListBoxPopup.this.list.setSelectionInterval(index, index);
        }
    }
}

