/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.component.model;

import fr.pgh.data.bdd.MultiBoxItem;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class MultiListBoxModel<T>
extends DefaultListSelectionModel
implements ListModel<T> {
    private static final long serialVersionUID = 1L;
    private Vector<T> list = null;
    private boolean selectAllOption = true;

    public MultiListBoxModel(Vector<T> list, boolean selectAllOption) {
        this.list = list;
        this.selectAllOption = selectAllOption;
        if (selectAllOption) {
            super.addSelectionInterval(0, this.getSize());
        }
    }

    public void updateList(Vector<T> list, boolean selectAllOption) {
        this.list = list;
        this.selectAllOption = selectAllOption;
        if (selectAllOption) {
            super.addSelectionInterval(0, this.getSize());
        }
    }

    public void setSelectAllOption(boolean selectAllOption) {
        TimsLogger.debug("#MultiBoxModel.setSelectAllOption# new selectAllOption = " + selectAllOption);
        boolean oldSelectOption = this.selectAllOption;
        this.selectAllOption = selectAllOption;
    }

    public boolean isSelectAllOption() {
        return this.selectAllOption;
    }

    @Override
    public int getSize() {
        return this.list.size() + (this.selectAllOption ? 1 : 0);
    }

    @Override
    public T getElementAt(int index) {
        if (this.selectAllOption) {
            return this.getElementAtAllOption(index);
        }
        return this.list.get(index);
    }

    public T getElementAtAllOption(int index) {
        if (index == 0) {
            return null;
        }
        return this.list.get(index - 1);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listenerList.add(ListDataListener.class, l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listenerList.remove(ListDataListener.class, l);
    }

    public Vector<T> getSelectedItems() {
        Vector<T> toReturn = new Vector<T>();
        int index = 0;
        int maxIndex = this.list.size();
        if (this.selectAllOption) {
            ++maxIndex;
            ++index;
        }
        while (index < maxIndex) {
            if (this.isSelectedIndex(index)) {
                TimsLogger.debug("#MultiListeBoxModel.getSelectedItems# add " + this.list.get(this.selectAllOption ? index - 1 : index));
                toReturn.add(this.list.get(this.selectAllOption ? index - 1 : index));
            }
            ++index;
        }
        return toReturn;
    }

    public Vector<Integer> getSelectedId(boolean nullIfSelectAll) {
        Vector<Integer> toReturn = new Vector<Integer>();
        int index = 0;
        int maxIndex = this.list.size();
        if (this.selectAllOption && this.isSelectedIndex(0)) {
            if (nullIfSelectAll) {
                return null;
            }
            ++maxIndex;
            ++index;
        }
        while (index < maxIndex) {
            if (this.isSelectedIndex(index) && this.list.get(this.selectAllOption ? index - 1 : index) instanceof MultiBoxItem) {
                toReturn.add(((MultiBoxItem)this.list.get(this.selectAllOption ? index - 1 : index)).getId());
            }
            ++index;
        }
        return toReturn;
    }

    public Object selectionDetail() {
        int index = 0;
        int maxIndex = this.list.size();
        if (this.selectAllOption) {
            if (this.isSelectedIndex(index)) {
                return LanguageTranslator.getString("generics.all");
            }
            ++maxIndex;
            ++index;
        }
        Vector<T> returnVector = new Vector<T>();
        while (index < maxIndex) {
            if (this.isSelectedIndex(index)) {
                returnVector.add(this.list.get(this.selectAllOption ? index - 1 : index));
            }
            ++index;
        }
        return returnVector.size() > 0 ? returnVector : LanguageTranslator.getString("generics.none");
    }

    public int getIndexOf(T anObject) {
        int indexList = this.list.indexOf(anObject);
        if (indexList == -1) {
            return -1;
        }
        return indexList + (this.selectAllOption ? 1 : 0);
    }

    public void addSelectedItem(T anObject) {
        int index = 0;
        while (index < this.list.size()) {
            if (anObject.equals(this.list.get(index))) {
                this.addSelectedIndex(index);
                return;
            }
            ++index;
        }
    }

    public void addSelectedId(int itemId) {
        int index = 0;
        while (index < this.list.size()) {
            T item = this.list.get(index);
            if (item instanceof MultiBoxItem && ((MultiBoxItem)item).getId() == itemId) {
                this.addSelectedIndex(index + (this.selectAllOption ? 1 : 0));
                return;
            }
            ++index;
        }
    }

    public boolean addSelectedIndex(int index) {
        if (index < 0 || index >= this.list.size()) {
            return false;
        }
        this.addSelectionInterval(index, index);
        return true;
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        if (index0 == 0 && index1 == 0 && this.selectAllOption) {
            index1 = this.getSize();
            TimsLogger.debug("\t\t#MultiBoxModel.addeSelectionInterval# on s\u00e9lectionne tout de " + index0 + " \u00e0 " + index1 + " (" + this.getSize() + ")");
        }
        super.addSelectionInterval(index0, index1);
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        if (index0 == 0 && index1 == 0 && this.selectAllOption) {
            index1 = this.getSize();
            TimsLogger.debug("\t\t#MultiBoxModel.removeIndexInterval# on d\u00e9s\u00e9lectionne tout de " + index0 + " \u00e0 " + index1);
        }
        if (this.selectAllOption) {
            super.removeSelectionInterval(0, 0);
        }
        super.removeSelectionInterval(index0, index1);
    }
}

