/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.component.ui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.plaf.LayerUI;
import transpo.system.TimsLogger;

public class WaiterLayerUI
extends LayerUI<JPanel>
implements ActionListener {
    private boolean mIsRunning;
    private boolean mIsFadingOut;
    private Timer mTimer;
    private int mAngle;
    private int mFadeCount;
    private int mFadeLimit = 15;

    @Override
    public void paint(Graphics g, JComponent c) {
        int w = c.getWidth();
        int h = c.getHeight();
        super.paint(g, c);
        if (!this.mIsRunning) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        float fade = (float)this.mFadeCount / (float)this.mFadeLimit;
        TimsLogger.debug("fade = " + fade);
        Composite urComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, 0.5f * fade));
        g2.fillRect(0, 0, w, h);
        g2.setComposite(urComposite);
        int s = Math.min(w, h) / 5;
        int cx = w / 2;
        int cy = h / 2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(s / 4, 1, 1));
        g2.setPaint(Color.white);
        g2.rotate(Math.PI * (double)this.mAngle / 180.0, cx, cy);
        int i = 0;
        while (i < 12) {
            float scale = (11.0f - (float)i) / 11.0f;
            g2.drawLine(cx + s, cy, cx + s * 2, cy);
            g2.rotate(-0.5235987755982988, cx, cy);
            g2.setComposite(AlphaComposite.getInstance(3, scale * fade));
            ++i;
        }
        g2.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.mIsRunning) {
            this.firePropertyChange("tick", 0, 1);
            this.mAngle += 3;
            if (this.mAngle >= 360) {
                this.mAngle = 0;
            }
            if (this.mIsFadingOut) {
                if (--this.mFadeCount <= 0) {
                    this.mIsRunning = false;
                    this.mTimer.stop();
                }
            } else if (this.mFadeCount < this.mFadeLimit) {
                ++this.mFadeCount;
            }
        }
    }

    public void start() {
        if (this.mIsRunning) {
            return;
        }
        TimsLogger.debug("WaiterLayerUI.start");
        this.mIsRunning = true;
        this.mIsFadingOut = false;
        this.mFadeCount = 0;
        int fps = 24;
        int tick = 1000 / fps;
        this.mTimer = new Timer(tick, this);
        this.mTimer.start();
    }

    public void stop() {
        TimsLogger.debug("WaiterLayerUI.stop");
        this.mIsFadingOut = true;
    }

    @Override
    public void applyPropertyChange(PropertyChangeEvent pce, JLayer l) {
        if ("tick".equals(pce.getPropertyName())) {
            l.repaint();
        }
    }
}

