/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.component.ui.basic;

import fr.pgh.component.JMultiListBox;
import fr.pgh.component.MultiListBoxPopup;
import fr.pgh.component.model.MultiListBoxModel;
import fr.pgh.component.ui.MultiListBoxUI;
import fr.pgh.component.ui.renderer.MultiBoxRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import sun.swing.DefaultLookup;

public class BasicMultiListBoxUI
extends MultiListBoxUI {
    protected JMultiListBox multiBox;
    private MultiListBoxPopup popup;
    protected JList list;
    private Handler handler;
    protected boolean hasFocus = false;
    protected CellRendererPane currentValuePane = new CellRendererPane();
    protected JButton popupButton;
    protected boolean isMinimumSizeDirty = true;
    private boolean isDisplaySizeDirty = true;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener popupMouseListener;
    protected MouseMotionListener popupMouseMotionListener;
    protected KeyListener popupKeyListener;
    protected Dimension cachedMinimumSize = new Dimension(0, 0);
    private Dimension cachedDisplaySize = new Dimension(0, 0);

    public static ComponentUI createUI(JComponent c) {
        return new BasicMultiListBoxUI();
    }

    @Override
    public void setPopupVisible(JMultiListBox c, boolean v) {
        if (v) {
            this.popup.show();
        } else {
            this.popup.hide();
        }
    }

    @Override
    public void installUI(JComponent c) {
        this.isMinimumSizeDirty = true;
        this.multiBox = (JMultiListBox)c;
        if (this.multiBox.getPrinter() == null || this.multiBox.getPrinter() instanceof UIResource) {
            this.multiBox.setPrinter(this.createPrinter());
        }
        this.installDefaults();
        this.popup = this.createPopup();
        this.list = this.popup.getList();
        this.installListeners();
        this.installComponents();
        this.multiBox.setLayout(this.createLayoutManager());
        this.multiBox.setRequestFocusEnabled(true);
    }

    protected MultiBoxRenderer createPrinter() {
        return new MultiBoxRenderer();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.setPopupVisible(this.multiBox, false);
        this.popup.uninstallingUI();
        this.multiBox.setLayout(null);
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.handler = null;
        this.keyListener = null;
        this.focusListener = null;
        this.propertyChangeListener = null;
        this.popup = null;
        this.list = null;
        this.multiBox = null;
    }

    protected void installComponents() {
        this.popupButton = this.createPopupButton();
        this.multiBox.add(this.popupButton);
        if (this.popupButton != null) {
            this.configurePopupButton();
        }
        this.multiBox.add(this.currentValuePane);
    }

    protected void uninstallComponents() {
        if (this.popupButton != null) {
            this.unconfigurePopupButton();
        }
        this.multiBox.removeAll();
        this.popupButton = null;
    }

    public void configurePopupButton() {
        if (this.popupButton != null) {
            this.popupButton.setEnabled(this.multiBox.isEnabled());
            this.popupButton.setRequestFocusEnabled(false);
            this.popupButton.addMouseListener(this.popup.getMouseListener());
            this.popupButton.resetKeyboardActions();
            this.popupButton.setInheritsPopupMenu(true);
        }
    }

    public void unconfigurePopupButton() {
        if (this.popupButton != null) {
            this.popupButton.removeMouseListener(this.popup.getMouseListener());
        }
    }

    protected JButton createPopupButton() {
        BasicArrowButton button = new BasicArrowButton(5, UIManager.getColor("ComboBox.buttonBackground"), UIManager.getColor("ComboBox.buttonShadow"), UIManager.getColor("ComboBox.buttonDarkShadow"), UIManager.getColor("ComboBox.buttonHighlight"));
        button.setName("ComboBox.arrowButton");
        return button;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.multiBox, "MultiSelBox.background", "MultiSelBox.foreground", "MultiSelBox.font");
        LookAndFeel.installBorder(this.multiBox, "MultiSelBox.border");
        LookAndFeel.installProperty(this.multiBox, "opaque", Boolean.TRUE);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.multiBox.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.multiBox.addFocusListener(this.focusListener);
        }
        if ((this.popupMouseListener = this.popup.getMouseListener()) != null) {
            this.multiBox.addMouseListener(this.popupMouseListener);
        }
    }

    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected LayoutManager createLayoutManager() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void uninstallDefaults() {
        LookAndFeel.installColorsAndFont(this.multiBox, "MultiSelBox.background", "MultiSelBox.foreground", "MultiSelBox.font");
        LookAndFeel.uninstallBorder(this.multiBox);
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.multiBox.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.focusListener != null) {
            this.multiBox.removeFocusListener(this.focusListener);
        }
        if (this.popupMouseListener != null) {
            this.multiBox.removeMouseListener(this.popupMouseListener);
        }
    }

    protected MultiListBoxPopup createPopup() {
        return new MultiListBoxPopup(this.multiBox);
    }

    @Override
    public boolean isPopupVisible(JMultiListBox c) {
        return this.popup.isVisible();
    }

    private void updateToolTipTextForChildren() {
        Component[] children = this.multiBox.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof JComponent) {
                ((JComponent)children[i]).setToolTipText(this.multiBox.getToolTipText());
            }
            ++i;
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.hasFocus = this.multiBox.hasFocus();
        Rectangle r = this.rectangleForCurrentValue();
        this.paintCurrentValueBackground(g, r, this.hasFocus);
        this.paintCurrentValue(g, r, this.hasFocus);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = this.getDisplaySize();
        Insets insets = this.getInsets();
        size.height += insets.top + insets.bottom;
        int buttonSize = size.height - (insets.top + insets.bottom);
        size.width += insets.left + insets.right + buttonSize;
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(size);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Component c;
        MultiBoxRenderer printer = this.multiBox.getPrinter();
        bounds.x += 2;
        bounds.y += 2;
        bounds.width -= 3;
        bounds.height -= 4;
        if (hasFocus && !this.isPopupVisible(this.multiBox)) {
            c = printer.getListCellRendererComponent(this.list, this.multiBox.getSelectionDetail(), -1, true, false);
        } else {
            c = printer.getListCellRendererComponent(this.list, this.multiBox.getSelectionDetail(), -1, false, false);
            c.setBackground(UIManager.getColor("MultiSelBox.background"));
        }
        c.setFont(this.multiBox.getFont());
        if (hasFocus && !this.isPopupVisible(this.multiBox)) {
            c.setForeground(this.list.getSelectionForeground());
            c.setBackground(this.list.getSelectionBackground());
        } else if (this.multiBox.isEnabled()) {
            c.setForeground(this.multiBox.getForeground());
            c.setBackground(this.multiBox.getBackground());
        } else {
            c.setForeground(DefaultLookup.getColor(this.multiBox, this, "MultiBox.disabledForeground", null));
            c.setBackground(DefaultLookup.getColor(this.multiBox, this, "MultiBox.disabledBackground", null));
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        this.currentValuePane.paintComponent(g, c, this.multiBox, bounds.x, bounds.y, bounds.width, bounds.height, shouldValidate);
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
    }

    void repaintCurrentValue() {
        Rectangle r = this.rectangleForCurrentValue();
        this.multiBox.repaint(r.x, r.y, r.width, r.height);
    }

    protected Dimension getDefaultSize() {
        Dimension d = this.getSizeForComponent(this.createPrinter().getListCellRendererComponent(this.list, " ", -1, false, false));
        return new Dimension(d.width, d.height);
    }

    protected Dimension getDisplaySize() {
        MultiListBoxModel model;
        int modelSize;
        if (!this.isDisplaySizeDirty) {
            return new Dimension(this.cachedDisplaySize);
        }
        Dimension result = new Dimension();
        MultiBoxRenderer printer = this.multiBox.getPrinter();
        if (printer == null) {
            printer = new MultiBoxRenderer();
        }
        int n = modelSize = (model = this.multiBox.getModel()) == null ? 0 : model.getSize();
        if (modelSize > 0) {
            int i = 0;
            while (i < modelSize) {
                Dimension d = this.getSizeForComponent(printer.getListCellRendererComponent(this.list, model.getElementAt(i), -1, false, false));
                result.width = Math.max(result.width, d.width);
                result.height = Math.max(result.height, d.height);
                ++i;
            }
        } else {
            result = this.getDefaultSize();
            result.width = 100;
        }
        this.cachedDisplaySize.setSize(result.width, result.height);
        this.isDisplaySizeDirty = false;
        return result;
    }

    private Dimension getSizeForComponent(Component comp) {
        this.currentValuePane.add(comp);
        comp.setFont(this.multiBox.getFont());
        Dimension d = comp.getPreferredSize();
        this.currentValuePane.remove(comp);
        return d;
    }

    protected Insets getInsets() {
        return this.multiBox.getInsets();
    }

    protected Rectangle rectangleForCurrentValue() {
        int width = this.multiBox.getWidth();
        int height = this.multiBox.getHeight();
        Insets insets = this.getInsets();
        int buttonSize = height - (insets.top + insets.bottom);
        if (this.popupButton != null) {
            buttonSize = this.popupButton.getWidth();
        }
        if (this.multiBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + buttonSize, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
    }

    @Override
    public boolean isFocusTraversable(JMultiListBox c) {
        return false;
    }

    public class ComboBoxLayoutManager
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return BasicMultiListBoxUI.this.getHandler().preferredLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return BasicMultiListBoxUI.this.getHandler().minimumLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            BasicMultiListBoxUI.this.getHandler().layoutContainer(parent);
        }
    }

    private class Handler
    implements FocusListener,
    LayoutManager,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            JMultiListBox multiSelBox = (JMultiListBox)e.getSource();
            if (propertyName == "model") {
                BasicMultiListBoxUI.this.isMinimumSizeDirty = true;
                BasicMultiListBoxUI.this.isDisplaySizeDirty = true;
                multiSelBox.revalidate();
                multiSelBox.repaint();
            } else if (propertyName == "enabled") {
                boolean enabled = (Boolean)e.getNewValue();
                if (BasicMultiListBoxUI.this.popupButton != null) {
                    BasicMultiListBoxUI.this.popupButton.setEnabled(enabled);
                }
            } else if (propertyName == "maximumRowCount") {
                if (BasicMultiListBoxUI.this.isPopupVisible(multiSelBox)) {
                    BasicMultiListBoxUI.this.setPopupVisible(multiSelBox, false);
                    BasicMultiListBoxUI.this.setPopupVisible(multiSelBox, true);
                }
            } else if (propertyName == "font") {
                BasicMultiListBoxUI.this.list.setFont(multiSelBox.getFont());
                BasicMultiListBoxUI.this.isMinimumSizeDirty = true;
                multiSelBox.validate();
            } else if (propertyName == "ToolTipText") {
                BasicMultiListBoxUI.this.updateToolTipTextForChildren();
            } else if (propertyName == "prototypeDisplayValue") {
                BasicMultiListBoxUI.this.isMinimumSizeDirty = true;
                BasicMultiListBoxUI.this.isDisplaySizeDirty = true;
                multiSelBox.revalidate();
            } else if (propertyName == "renderer") {
                BasicMultiListBoxUI.this.isMinimumSizeDirty = true;
                BasicMultiListBoxUI.this.isDisplaySizeDirty = true;
                multiSelBox.revalidate();
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            JMultiListBox msb = (JMultiListBox)parent;
            int width = msb.getWidth();
            int height = msb.getHeight();
            Insets insets = BasicMultiListBoxUI.this.getInsets();
            int buttonSize = height - (insets.top + insets.bottom);
            if (BasicMultiListBoxUI.this.popupButton != null) {
                if (msb.getComponentOrientation().isLeftToRight()) {
                    BasicMultiListBoxUI.this.popupButton.setBounds(width - (insets.right + buttonSize), insets.top, buttonSize, buttonSize);
                } else {
                    BasicMultiListBoxUI.this.popupButton.setBounds(insets.left, insets.top, buttonSize, buttonSize);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            BasicMultiListBoxUI.this.getHandler().propertyChange(e);
        }
    }
}

