/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.component.ui.renderer;

import java.awt.Component;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class CheckBoxHeader
extends JCheckBox
implements TableCellRenderer,
MouseListener {
    protected int column;
    protected boolean mousePressed = false;

    public CheckBoxHeader(ItemListener itemListener) {
        this.addItemListener(itemListener);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
            header.addMouseListener(this);
        }
        this.setColumn(column);
        this.setText(value == null ? "" : value.toString());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setBorderPainted(true);
        return this;
    }

    protected void setColumn(int column) {
        this.column = column;
    }

    public int getColumn() {
        return this.column;
    }

    protected void handleClickEvent(MouseEvent e) {
        if (this.mousePressed) {
            this.mousePressed = false;
            JTableHeader header = (JTableHeader)e.getSource();
            JTable tableView = header.getTable();
            TableColumnModel columnModel = tableView.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = tableView.convertColumnIndexToModel(viewColumn);
            if (viewColumn == this.column && e.getClickCount() == 1 && column != -1) {
                this.doClick();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.handleClickEvent(e);
        ((JTableHeader)e.getSource()).repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mousePressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

