/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.component.ui.renderer;

import fr.pgh.conversion.ConversionTime;
import java.awt.Component;
import java.util.Date;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class MultiBoxRenderer
extends JLabel
implements ListCellRenderer {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

    public MultiBoxRenderer() {
        this.setOpaque(true);
        this.setBorder(MultiBoxRenderer.getNoFocusBorder());
    }

    private static Border getNoFocusBorder() {
        if (System.getSecurityManager() != null) {
            return SAFE_NO_FOCUS_BORDER;
        }
        return noFocusBorder;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        if (value instanceof Vector) {
            String label = "";
            for (Object tmp : (Vector)value) {
                if (tmp instanceof Date) {
                    label = String.valueOf(label) + ConversionTime.dateToString((Date)tmp, "dd/MM/yyyy") + ";";
                    continue;
                }
                this.setIcon(null);
                label = String.valueOf(label) + (tmp == null ? "" : String.valueOf(tmp.toString()) + ";");
            }
            this.setText(label);
            this.setToolTipText(label);
            return this;
        }
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
            this.setText("");
        } else if (value instanceof Date) {
            this.setText(ConversionTime.dateToString((Date)value, "dd/MM/yyyy"));
        } else {
            this.setIcon(null);
            this.setText(value == null ? LanguageTranslator.getString("generics.all") : value.toString());
        }
        this.setBackground(list.getBackground());
        return this;
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

