/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.connexion;

import fr.pgh.connexion.MdpUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.core.Exitable;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.Fmresources;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class ConnexionUI
extends JFrame
implements Exitable {
    private static ConnexionUI instance = null;
    private JPanel jContentPane = null;
    private JTextField texteLogin = null;
    private JLabel lblLogin = null;
    private JPasswordField textePassword = null;
    private JLabel lblPassword = null;
    private JButton boutonValider = null;
    private JButton boutonQuitter = null;

    public static ConnexionUI getInstance() {
        if (instance == null) {
            instance = new ConnexionUI();
        }
        return instance;
    }

    public ConnexionUI() {
        this.initialize();
    }

    private void initialize() {
        this.setTitle("TIMS");
        this.setUndecorated(true);
        this.setContentPane(this.getJContentPane());
        this.setLocation(150, 100);
        this.setSize(new Dimension(400, 150));
        this.getRootPane().setDefaultButton(this.boutonValider);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.insets = new Insets(10, 100, 0, 0);
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 2;
            gridBagConstraints21.insets = new Insets(10, 0, 0, 10);
            gridBagConstraints21.anchor = 13;
            gridBagConstraints21.gridy = 2;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = 13;
            gridBagConstraints11.insets = new Insets(5, 10, 0, 10);
            gridBagConstraints11.gridy = 1;
            this.lblPassword = new JLabel();
            this.lblPassword.setText(LanguageTranslator.getString("connexion.password"));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(5, 10, 0, 10);
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(0, 10, 5, 10);
            gridBagConstraints1.anchor = 13;
            gridBagConstraints1.gridy = 0;
            this.lblLogin = new JLabel();
            this.lblLogin.setText(LanguageTranslator.getString("connexion.login"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 10, 5, 10);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getTexteLogin(), gridBagConstraints);
            this.jContentPane.add((Component)this.lblLogin, gridBagConstraints1);
            this.jContentPane.add((Component)this.getTextePassword(), gridBagConstraints2);
            this.jContentPane.add((Component)this.lblPassword, gridBagConstraints11);
            this.jContentPane.add((Component)this.getBoutonValider(), gridBagConstraints21);
            this.jContentPane.add((Component)this.getBoutonQuitter(), gridBagConstraints3);
        }
        return this.jContentPane;
    }

    private JTextField getTexteLogin() {
        if (this.texteLogin == null) {
            this.texteLogin = new JTextField();
        }
        return this.texteLogin;
    }

    private JPasswordField getTextePassword() {
        if (this.textePassword == null) {
            this.textePassword = new JPasswordField();
        }
        return this.textePassword;
    }

    private JButton getBoutonValider() {
        if (this.boutonValider == null) {
            this.boutonValider = new JButton();
            this.boutonValider.setText(LanguageTranslator.getString("button.valid"));
            this.boutonValider.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String passe = new String(new StringBuffer().append(ConnexionUI.this.textePassword.getPassword()).toString());
                    String utilisateur = ConnexionUI.this.texteLogin.getText();
                    ConnexionUI.this.chargeSettings(utilisateur, passe);
                }
            });
        }
        return this.boutonValider;
    }

    private void chargeSettings(String utilisateur, String passe) {
        int n = Transport.conn.chargerUser(utilisateur, passe);
        switch (n) {
            case 1: 
            case 2: {
                this.chargeUtilisateur();
                break;
            }
            case 4: {
                JOptionPane.showMessageDialog(this, LanguageTranslator.getString("connexion.expiredPassword"), LanguageTranslator.getString("connexion.identification.error"), 2);
                Fmresources res = new Fmresources();
                if (!res.getResourceString("bloquant").equals("0")) break;
                MdpUI mdp = new MdpUI((Frame)this, Transport.conn.user);
                if (!mdp.changement) break;
                this.chargeUtilisateur();
                break;
            }
            case 0: {
                JOptionPane.showMessageDialog(this, LanguageTranslator.getString("connexion.badUser"), LanguageTranslator.getString("connexion.identification.error"), 0);
                break;
            }
            case 3: {
                String[] societe = new String[]{Transport.conn.getUserSociete()};
                JOptionPane.showMessageDialog(this, LanguageTranslator.getString("connexion.badSociety", societe), LanguageTranslator.getString("connexion.identification.error"), 0);
                System.exit(0);
                break;
            }
            case 5: {
                JOptionPane.showMessageDialog(this, LanguageTranslator.getString("connexion.user.disabled"), LanguageTranslator.getString("connexion.identification.error"), 0);
                System.exit(0);
            }
        }
    }

    private void chargeUtilisateur() {
        TimsLogger.debug("#ConnexionUI.chargeUtilisateur# loading...");
        Transport.conn.chargerDroit(Transport.bdd);
        this.dispose();
        MainFrameTransport.getInstance().setVisible(true);
    }

    private JButton getBoutonQuitter() {
        if (this.boutonQuitter == null) {
            this.boutonQuitter = new JButton();
            this.boutonQuitter.setText(LanguageTranslator.getString("button.quit"));
            this.boutonQuitter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnexionUI.this.exit();
                }
            });
        }
        return this.boutonQuitter;
    }

    @Override
    public void exit() {
        System.exit(0);
    }
}

