/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.conversion;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class ConversionTime {
    public static int STRING = 2;
    public static int DATE = 1;
    public static int MONDAY_START = 0;
    public static int SUNDAY_START = 1;
    public static final int TIME_HUNDREDTH = 0;
    public static final int TIME_MINUTE = 1;
    public static final String FRENCH_FORMAT = "dd/MM/yyyy";
    public static final String DATABASE_FORMAT = "yyyy-MM-dd";
    public static final String DATABASE_HOUR_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static Date getDate(long time) {
        GregorianCalendar tim = new GregorianCalendar();
        ((Calendar)tim).setTimeZone(TimeZone.getTimeZone("GMT"));
        tim.setTimeInMillis(time * 1000L);
        return tim.getTime();
    }

    public static String intToDate(String date) {
        String annee = date.substring(0, 4);
        String mois = date.substring(4, 6);
        String jour = date.substring(6, 8);
        return String.valueOf(annee) + "-" + mois + "-" + jour;
    }

    public static String heureIntToString(String sMinutes, String separateur) {
        return ConversionTime.heureIntToString(Integer.parseInt(sMinutes), separateur);
    }

    public static String heureIntToString(int minutes, String separateur) {
        if (minutes == 0) {
            return "00" + separateur + "00";
        }
        boolean negValue = false;
        if (minutes < 0) {
            negValue = true;
            minutes = Math.abs(minutes);
        }
        int h = minutes / 60;
        int m = minutes - h * 60;
        String ms = "";
        String hs = m < 10 ? String.valueOf(separateur) + "0" : separateur;
        if (h < 10) {
            ms = "0";
        }
        return String.valueOf(negValue ? "-" : "") + ms + h + hs + m;
    }

    public static int heureStringToInt(String heuresMinutes, String separateur) {
        block6: {
            try {
                if (!heuresMinutes.equals("")) break block6;
                return 0;
            }
            catch (Exception ex) {
                TimsLogger.error("#ConversionTime.heureStringToInt# impossible de convertir en entier l'heure " + heuresMinutes + " (" + separateur + ") => " + ex.getMessage());
                return 0;
            }
        }
        boolean negValue = false;
        if (heuresMinutes.startsWith("-")) {
            negValue = true;
            heuresMinutes = heuresMinutes.substring(1);
        } else if (heuresMinutes.startsWith("+")) {
            heuresMinutes = heuresMinutes.substring(1);
        }
        StringTokenizer s = new StringTokenizer(heuresMinutes, separateur);
        int h = Integer.parseInt(s.nextToken());
        int m = Integer.parseInt(s.nextToken());
        int value = (int)((double)(h * 60) + (separateur.equals(",") ? (double)m * 0.6 : (double)m));
        return negValue ? 0 - value : value;
    }

    public static String getJour(String jour) {
        return ConversionTime.dateStringToFormat(jour, DATABASE_FORMAT, "E");
    }

    public static Date stringToDateDb(String date) {
        return ConversionTime.stringToDate(date, DATABASE_FORMAT);
    }

    public static Date stringToDateDb(String date, boolean withHour) {
        return ConversionTime.stringToDate(date, DATABASE_FORMAT + (withHour ? " HH:mm:ss" : ""));
    }

    public static Date stringToDateFr(String date) {
        return ConversionTime.stringToDate(date, FRENCH_FORMAT);
    }

    public static Date stringToDateFr(String date, boolean withHour) {
        return ConversionTime.stringToDate(date, FRENCH_FORMAT + (withHour ? " HH:mm:ss" : ""));
    }

    public static Date stringToDate(String sDate, String sFormat) {
        if (sDate == null) {
            return null;
        }
        if (sDate.equals("")) {
            return ConversionTime.stringToDate("1970-01-01", DATABASE_FORMAT);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(sFormat);
        try {
            return sdf.parse(sDate);
        }
        catch (ParseException ex) {
            TimsLogger.error("#ConversionTime.stringToDate erreur # " + sDate + " (" + sFormat + ") => " + ex.getMessage());
            return null;
        }
    }

    public static Date stringToDate2(String sDate, String sFormat) {
        if (sDate == null) {
            return null;
        }
        if (sDate.equals("")) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(sFormat);
        try {
            return sdf.parse(sDate);
        }
        catch (ParseException ex) {
            TimsLogger.error("#ConversionTime.stringToDate erreur # " + sDate + " (" + sFormat + ") => " + ex.getMessage());
            return null;
        }
    }

    public static String dateToString(Date date, String format) {
        return ConversionTime.dateToString(date, format, LanguageTranslator.getString("generics.unfilled"));
    }

    public static String dateToString(Date date, String format, String defaultValue) {
        if (date == null) {
            return null;
        }
        if (date.getTime() < 100000L && defaultValue != null) {
            TimsLogger.debug("#dateToString# " + date + " (" + date.getTime() + ") under 100000 return default : " + defaultValue);
            return defaultValue;
        }
        String retour = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        retour = dateFormat.format(date);
        return retour;
    }

    public static String dateToStringFr(Date date) {
        return ConversionTime.dateToString(date, FRENCH_FORMAT);
    }

    public static String dateToStringDb(Date date) {
        return ConversionTime.dateToString(date, DATABASE_FORMAT);
    }

    public static String dateStringToFormat(String date, String format, String formatRetour) {
        String retour = "";
        SimpleDateFormat dateFormaRetour = new SimpleDateFormat(formatRetour);
        retour = dateFormaRetour.format(ConversionTime.stringToDate(date, format));
        return retour;
    }

    public static String dateFromBDDToFrance(String dateBDD) {
        return ConversionTime.dateFromBDDToFrance(dateBDD, false, true);
    }

    public static String dateFromBDDToFrance(String dateBDD, boolean withHeure, boolean canBeEmpty) {
        if (dateBDD == null || dateBDD.equals("")) {
            if (withHeure) {
                if (!canBeEmpty) {
                    return "01/01/1970 00:00";
                }
                return "";
            }
            if (!canBeEmpty) {
                return "01/01/1970";
            }
            return "";
        }
        String dateFrance = "";
        String mm = dateBDD.substring(5, 7);
        String yyyy = dateBDD.substring(0, 4);
        String jj = dateBDD.substring(8, 10);
        if (withHeure) {
            String hh = dateBDD.substring(11, 13);
            String min = dateBDD.substring(14, 16);
            String sec = dateBDD.substring(17, 19);
            dateFrance = String.valueOf(jj) + "/" + mm + "/" + yyyy + " " + hh + "h" + min;
        } else {
            dateFrance = String.valueOf(jj) + "/" + mm + "/" + yyyy;
        }
        return dateFrance;
    }

    public static SimpleDateFormat getDateFormat(int type) {
        DateFormat toReturn = null;
        toReturn = type == 3 ? DateFormat.getDateInstance(3, LanguageTranslator.getLocale()) : DateFormat.getDateTimeInstance(3, 3, LanguageTranslator.getLocale());
        if (toReturn instanceof SimpleDateFormat) {
            SimpleDateFormat sdf = (SimpleDateFormat)toReturn;
            String pattern = sdf.toLocalizedPattern();
            if (pattern.indexOf("yyyy") == -1) {
                toReturn = new SimpleDateFormat(pattern.replaceFirst("yy", "yyyy"));
            }
            return (SimpleDateFormat)toReturn;
        }
        return null;
    }

    public static String timestampBddToUi(Timestamp dateBdd) {
        if (dateBdd == null) {
            return null;
        }
        SimpleDateFormat df = ConversionTime.getDateFormat(3);
        return df.format(new Date(dateBdd.getTime()));
    }

    public static Timestamp timestampUiToBdd(String dateUi) {
        if (dateUi == null) {
            return null;
        }
        SimpleDateFormat df = null;
        if (dateUi.length() == 10) {
            df = ConversionTime.getDateFormat(3);
        }
        if (dateUi.length() == 19) {
            df = ConversionTime.getDateFormat(0);
        }
        try {
            Date tmp = df.parse(dateUi);
            return new Timestamp(tmp.getTime());
        }
        catch (Exception ex) {
            TimsLogger.error("#ConversionTime.timestampUiToBdd# " + dateUi + " : Timestamp conversion failed => " + ex.getMessage());
            return null;
        }
    }

    public static String dateFromFranceToBDD(String dateFrance, boolean withHeure) {
        if (dateFrance == null || dateFrance.equals("")) {
            if (withHeure) {
                return "1970-01-01 00:00:00.0";
            }
            return "1970-01-01";
        }
        String dateBDD = "";
        String mm = dateFrance.substring(3, 5);
        String yyyy = dateFrance.substring(6, 10);
        String jj = dateFrance.substring(0, 2);
        if (withHeure) {
            String hh = dateFrance.substring(11, 13);
            String min = dateFrance.substring(14, 16);
            dateBDD = String.valueOf(yyyy) + "-" + mm + "-" + jj + " " + hh + ":" + min + ":00";
        } else {
            dateBDD = String.valueOf(yyyy) + "-" + mm + "-" + jj;
        }
        return dateBDD;
    }

    public static int compare(String date1, String date2, String format) {
        return ConversionTime.stringToDate(date1, format).compareTo(ConversionTime.stringToDate(date2, format));
    }

    public static String addDay(String date, String format, int nbJours) {
        String retour = "";
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(ConversionTime.stringToDate(date, format));
        calendar.add(5, nbJours);
        retour = ConversionTime.dateToString(calendar.getTime(), format);
        return retour;
    }

    public static Date addDay(Date date, int nbJours) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(5, nbJours);
        return calendar.getTime();
    }

    public static Date add(Date date, int field, int amount) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static String addHeureBDD(String date, int nbHeure) {
        String retour = "";
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(ConversionTime.stringToDate(date, DATABASE_FORMAT));
        calendar.add(10, nbHeure);
        retour = ConversionTime.dateToString(calendar.getTime(), DATABASE_FORMAT);
        return retour;
    }

    public static boolean isWE(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        return dayOfWeek == 7 || dayOfWeek == 1;
    }

    public static int getWorkday(Date begin, Date end) {
        int workday = 0;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(begin);
        while (calendar.getTime().compareTo(end) <= 0) {
            if (calendar.get(7) != 7 && calendar.get(7) != 1) {
                ++workday;
            }
            calendar.add(5, 1);
        }
        return workday;
    }

    public static int getNbJourBetween(String date1, String date2, String format) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            return ConversionTime.getDaysBetween(dateFormat.parse(date1), dateFormat.parse(date2));
        }
        catch (ParseException ex) {
            TimsLogger.error("Erreur conversion " + date1 + ", " + date2 + " => " + ex.getMessage());
            return 0;
        }
    }

    public static int getDaysBetween(Date date1, Date date2) {
        long nbJour = date2.getTime() - date1.getTime();
        return (int)((nbJour + 3600000L) / 86400000L);
    }

    public static Object getFirstDayOfMonth(Date dateJour, int formatRetour) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateJour);
        calendar.set(5, 1);
        if (formatRetour == DATE) {
            return calendar.getTime();
        }
        if (formatRetour == STRING) {
            return new SimpleDateFormat(FRENCH_FORMAT).format(calendar.getTime());
        }
        return calendar.getTime();
    }

    public static Date getFirstDayOfMonth(Date dateJour) {
        return (Date)ConversionTime.getFirstDayOfMonth(dateJour, DATE);
    }

    public static Object getLastDayOfMonth(Date dateJour, int formatRetour) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateJour);
        calendar.set(5, calendar.getActualMaximum(5));
        if (formatRetour == DATE) {
            return calendar.getTime();
        }
        if (formatRetour == STRING) {
            return new SimpleDateFormat(FRENCH_FORMAT).format(calendar.getTime());
        }
        return calendar.getTime();
    }

    public static Date getLastDayOfMonth(Date dateJour) {
        return (Date)ConversionTime.getLastDayOfMonth(dateJour, DATE);
    }

    public static Object getFirstDayOfWeek(Date dateJour, int formatRetour) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateJour);
        while (calendar.get(7) != 2) {
            TimsLogger.debug(String.valueOf(calendar.getTime().toString()) + " is not monday");
            calendar.add(5, -1);
        }
        if (formatRetour == DATE) {
            return calendar.getTime();
        }
        if (formatRetour == STRING) {
            return new SimpleDateFormat(FRENCH_FORMAT).format(calendar.getTime());
        }
        return calendar.getTime();
    }

    public static Object getLastDayOfWeek(Date dateJour, int formatRetour) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateJour);
        while (calendar.get(7) != 1) {
            TimsLogger.debug(String.valueOf(calendar.getTime().toString()) + " is not sunday");
            calendar.add(5, 1);
        }
        if (formatRetour == DATE) {
            return calendar.getTime();
        }
        if (formatRetour == STRING) {
            return new SimpleDateFormat(FRENCH_FORMAT).format(calendar.getTime());
        }
        return calendar.getTime();
    }

    public static Object getFirstDayOfYear(Date dateJour, int formatRetour) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateJour);
        calendar.set(5, 1);
        calendar.set(2, 0);
        if (formatRetour == DATE) {
            return calendar.getTime();
        }
        if (formatRetour == STRING) {
            return new SimpleDateFormat(FRENCH_FORMAT).format(calendar.getTime());
        }
        return calendar.getTime();
    }

    public static Object getLastDayOfYear(Date dateJour, int formatRetour) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateJour);
        calendar.set(5, 31);
        calendar.set(2, 11);
        if (formatRetour == DATE) {
            return calendar.getTime();
        }
        if (formatRetour == STRING) {
            return new SimpleDateFormat(FRENCH_FORMAT).format(calendar.getTime());
        }
        return calendar.getTime();
    }

    public static int getWeek(String date, String format) {
        return ConversionTime.getWeek(ConversionTime.stringToDate(date, format));
    }

    public static int getWeek(Date date) {
        return ConversionTime.getWeek(date, MONDAY_START);
    }

    public static int getWeek(Date date, int type) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("w");
        if (type == SUNDAY_START) {
            Calendar calendar = Calendar.getInstance();
            calendar.setFirstDayOfWeek(1);
            dateFormat.setCalendar(calendar);
        }
        return Integer.parseInt(dateFormat.format(date));
    }

    public static int getMonth(String date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("M");
        return Integer.parseInt(dateFormat.format(ConversionTime.stringToDate(date, format)));
    }

    public static int getDayOfWeek(String sDate, String sFormat, boolean frRule) {
        return ConversionTime.getDayOfWeek(ConversionTime.stringToDate(sDate, sFormat), frRule);
    }

    public static int getDayOfWeek(Date date, boolean frRule) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        if (frRule) {
            int n = dayOfWeek = dayOfWeek == 0 ? 7 : dayOfWeek - 1;
        }
        if (dayOfWeek == 0) {
            dayOfWeek = 7;
        }
        return dayOfWeek;
    }

    public static String dateStringToBinary(String date, boolean withHour) {
        if (date.startsWith("1970")) {
            return "0000000000000" + (withHour ? "00000000000" : "");
        }
        String bHour = "";
        int year = Integer.parseInt(date.substring(0, 4)) - 2000;
        int month = Integer.parseInt(date.substring(5, 7));
        int day = Integer.parseInt(date.substring(8, 10));
        String bYear = Integer.toBinaryString(year + (int)Math.pow(2.0, 4.0)).substring(1);
        String bMonth = Integer.toBinaryString(month + (int)Math.pow(2.0, 4.0)).substring(1);
        String bDay = Integer.toBinaryString(day + (int)Math.pow(2.0, 5.0)).substring(1);
        if (withHour) {
            int hour = Integer.parseInt(date.substring(11, 13));
            int minute = Integer.parseInt(date.substring(14, 16));
            int min = hour * 60 + minute;
            bHour = Integer.toBinaryString(min + (int)Math.pow(2.0, 11.0)).substring(1);
        }
        return String.valueOf(bDay) + bMonth + bYear + bHour;
    }

    public static String dateStringToBinary(String date) {
        return ConversionTime.dateStringToBinary(date, false);
    }

    public static String binaryToDateString(String date, boolean withHour) {
        if (date.equals("0000000000000")) {
            return "1970-01-01" + (withHour ? " 00:00:00" : "");
        }
        String hour = "";
        int day = Integer.parseInt(date.substring(0, 5), 2);
        int month = Integer.parseInt(date.substring(5, 9), 2);
        int year = 2000 + Integer.parseInt(date.substring(9, 13), 2);
        if (withHour) {
            int minute = Integer.parseInt(date.substring(13, 24), 2);
            hour = String.valueOf(Integer.toString(minute / 60)) + Integer.toString(minute % 60);
        }
        return String.valueOf(year) + "-" + month + "-" + day + (withHour ? hour : "");
    }

    public static String binaryToDateString(String date) {
        return ConversionTime.binaryToDateString(date, false);
    }

    public static String timeToString(int time, int type) {
        if (type == 1) {
            return ConversionTime.heureIntToString(time, "h");
        }
        return new DecimalFormat("#,###,###,##0.00").format(Integer.valueOf(time).doubleValue() / 60.0);
    }

    public static Date dateTruncate(Date toTruncate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(toTruncate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static boolean dateStringEquals(String date1, String date2, boolean compareHour) {
        if (date1 == null || date1.equals(LanguageTranslator.getString("generics.unfilled"))) {
            date1 = "1970-01-01 00:00:00";
        }
        if (date2 == null || date2.equals(LanguageTranslator.getString("generics.unfilled"))) {
            date2 = "1970-01-01 00:00:00";
        }
        return compareHour ? date1.equals(date2) : date1.substring(0, 10).equals(date2.substring(0, 10));
    }

    public static int getMinut(Date date) {
        return ConversionTime.heureStringToInt(ConversionTime.dateToString(date, "HH:mm"), ":");
    }

    public static Date clearSeconds(Date time) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(time);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static String getFirstDayOfPreviousWeek(Date date, DateFormat dateFormat, int nbSemaine) {
        return dateFormat.format(ConversionTime.getFirstDayOfPreviousWeek(date, nbSemaine));
    }

    public static Date getFirstDayOfPreviousWeek(Date date, int nbSemaine) {
        try {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(date);
            c.add(5, nbSemaine * -7 + 1);
            while (c.get(7) != c.getFirstDayOfWeek()) {
                c.add(5, 1);
            }
            return c.getTime();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Date getFirstDayOfPreviousMonth(Date date) {
        if (date == null) {
            date = new Date();
        }
        try {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(date);
            c.add(2, -1);
            c.set(5, 1);
            return c.getTime();
        }
        catch (Exception ex) {
            TimsLogger.warn("Fonctions.getFirstDayOfPreviousMonth " + ex.getMessage());
            return null;
        }
    }

    public static Date getLastDayOfPreviousMonth(Date date) {
        if (date == null) {
            date = new Date();
        }
        try {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(date);
            c.set(5, 1);
            c.add(5, -1);
            return c.getTime();
        }
        catch (Exception ex) {
            TimsLogger.warn("Fonctions.getLastDayOfPreviousMonth " + ex.getMessage());
            return null;
        }
    }

    public static String getLastDayOfPreviousWeek(Date date, DateFormat dateFormat, int nbSemaine) {
        try {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(date);
            c.add(5, nbSemaine * -7 + 1);
            while (c.get(7) != c.getFirstDayOfWeek()) {
                c.add(5, 1);
            }
            c.add(5, -1);
            return dateFormat.format(c.getTime());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

