/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data;

import fr.pgh.data.BddTransport;
import fr.pgh.data.XmlReader;
import fr.pgh.data.bdd.CardDownload;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Configuration;
import fr.pgh.data.bdd.Societe;
import fr.pgh.data.bdd.UevDownload;
import fr.pgh.data.bdd.UpdateFile;
import fr.pgh.data.bdd.Vehicule;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;

public class VersionManager {
    public static final int SUCCESS = 1;
    public static final int DATABASE_OUT_OF_DATE = 2;
    public static final int EXE_OUT_OF_DATE = 3;
    public static final int XML_FILE_NOT_FOUND = 4;
    public static final int VERSIONNING_FILE_NOT_FOUND = 5;
    public static final int VERSIONNING_ERROR = 6;
    public static final int UNKNOWN_VERSION = 7;
    public static final int UNKNOWN_ERROR = 8;
    private String requiredVersion = null;
    private String currentDBVersion = null;
    private String currentCompanyVersion = null;
    private Vector<UpdateFile> files = null;
    private Vector<Societe> companyList = null;
    public BddTransport database = BddTransport.getInstance();

    public VersionManager(String requiredVersion, String currentVersion) {
        this.companyList = Societe.loadList(null);
        this.requiredVersion = requiredVersion;
        this.currentDBVersion = currentVersion;
        this.currentCompanyVersion = currentVersion;
    }

    public String evaluateVersion() {
        TimsLogger.debug("#VersionChecker.evaluateVersion# begin");
        String version = null;
        if (this.companyList.size() != 0) {
            int y = 0;
            while (y < this.companyList.size()) {
                this.database.changeDB(this.companyList.get(y).getNomSociete(), false);
                String dbVersion = this.evaluateDatabaseVersion();
                if (y == 0) {
                    version = dbVersion;
                } else {
                    if (!version.equals(dbVersion)) {
                        return null;
                    }
                    version = dbVersion;
                }
                ++y;
            }
        } else {
            version = this.requiredVersion;
        }
        TimsLogger.info("#VersionChecker.evaluateVersion# end. version found : " + version);
        return version;
    }

    private String evaluateDatabaseVersion() {
        String dbVersion = "1.0.0";
        int x = 0;
        while (x < this.files.size()) {
            if (this.files.get(x).isAllDatabase()) {
                if (!this.files.get(x).checkConstraint()) break;
                dbVersion = this.files.get(x).getVersion();
                TimsLogger.debug("Company dbVersion = " + dbVersion);
            }
            ++x;
        }
        return dbVersion;
    }

    public String evaluateDBVersion() {
        String dbVersion = "1.0.0";
        int x = 0;
        while (x < this.files.size()) {
            if (!this.files.get(x).isAllDatabase()) {
                if (!this.files.get(x).checkConstraint()) break;
                TimsLogger.debug("db verified constraint = " + this.files.get(x).getConstraint() + " version " + this.files.get(x).getFileName());
                dbVersion = this.files.get(x).getVersion();
                TimsLogger.debug("Tims dbVersion = " + dbVersion);
            }
            ++x;
        }
        return dbVersion;
    }

    public int loadFiles() {
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            SAXParser parseur = fabrique.newSAXParser();
            File fichier = new File("version/version.xml");
            XmlReader handler = new XmlReader();
            parseur.parse(fichier, (DefaultHandler)handler);
            this.files = handler.getFilesVector();
            for (UpdateFile tmp : this.files) {
                TimsLogger.debug("File " + tmp.getFileName() + " (version " + tmp.getVersion() + ") found in version.xml");
            }
        }
        catch (ParserConfigurationException pce) {
            TimsLogger.warn("Erreur de configuration du parseur lors de l'appel \u00e0 newSAXParser()");
            pce.printStackTrace();
            return 8;
        }
        catch (SAXException se) {
            TimsLogger.warn("Erreur de parsing lors de l'appel \u00e0 parse()");
            se.printStackTrace();
            return 8;
        }
        catch (IOException ioe) {
            TimsLogger.warn("Erreur d'entr\u00e9e/sortie lors de l'appel \u00e0 parse()");
            ioe.printStackTrace();
            return 4;
        }
        catch (Exception e) {
            TimsLogger.warn("Erreur");
            e.printStackTrace();
            return 8;
        }
        TimsLogger.debug("#VersionManager# loadFiles ok");
        return 1;
    }

    public int isValidFiles() {
        if (this.currentDBVersion == null) {
            this.currentDBVersion = this.evaluateDBVersion();
        }
        if (this.currentDBVersion == null) {
            TimsLogger.debug("#VersionManager# can't determine current database version");
            return 7;
        }
        int x = 0;
        while (x < this.files.size()) {
            if (this.files.get(x).getVersion().equals(this.currentDBVersion)) {
                TimsLogger.info("#VersionManager# On supprime le dernier fichier " + this.files.get(x).getFileName() + " (" + this.files.get(x).getVersion() + " == " + this.currentDBVersion + ")");
                this.files.remove(x);
                if (this.files.get(x).getVersion().equals(this.currentDBVersion)) {
                    TimsLogger.info("#VersionManager# On supprime le fichier de la base de tims \u00e9quivalent ... " + this.files.get(x).getFileName() + " (" + this.files.get(x).getVersion().substring(0, 5) + " == " + this.currentDBVersion + ")");
                    this.files.remove(x);
                }
                TimsLogger.info("#VersionManager# On d\u00e9marre le versionning \u00e0 partir du fichier " + this.files.get(x).getFileName());
                break;
            }
            TimsLogger.info("#VersionManager# On supprime le fichier " + this.files.get(x).getFileName() + " (" + this.files.get(x).getVersion() + " != " + this.currentDBVersion + ")");
            this.files.remove(x);
        }
        while (x < this.files.size()) {
            if (!new File(this.files.get(x).getFileName()).exists()) {
                TimsLogger.warn("#VersionManager# " + this.files.get(x).getFileName() + " not found, can't continue !");
                return 5;
            }
            ++x;
        }
        TimsLogger.info("#VersionManager# les fichiers de mise \u00e0 jour ont \u00e9t\u00e9 v\u00e9rifi\u00e9s avec succ\u00e8s");
        return 1;
    }

    public int doVersionning() {
        TimsLogger.debug("#VersionManager# enter doVersionning");
        int toReturn = 1;
        String results = "";
        TimsLogger.info("Mise \u00e0 jour pour TIMS");
        results = String.valueOf(results) + "\r\n#TIMS results : ";
        int x = 0;
        while (x < this.files.size()) {
            if (!this.files.get(x).isAllDatabase()) {
                TimsLogger.info("execute " + this.files.get(x).getFileName());
                String sqlResults = Fonctions.executeSqlFromFile(this.files.get(x).getFileName(), this.database);
                if (!sqlResults.equals("")) {
                    results = String.valueOf(results) + "\r\n" + this.files.get(x).getFileName() + " results : " + sqlResults + "#";
                }
                if (sqlResults != null && !sqlResults.equals("")) {
                    toReturn = 6;
                }
                Configuration cfg = new Configuration(true);
                cfg.load("database_version");
                cfg.setEval(this.files.get(x).getVersion());
                cfg.update();
            }
            ++x;
        }
        if (this.companyList.size() == 0) {
            this.companyList = Societe.loadList(null);
        }
        if (this.currentCompanyVersion == null) {
            this.currentCompanyVersion = this.evaluateVersion();
        }
        int y = 0;
        while (y < this.companyList.size()) {
            TimsLogger.info("Mise \u00e0 jour pour " + this.companyList.get(y).getNomSociete());
            this.database.changeDB(this.companyList.get(y).getNomSociete(), false);
            results = String.valueOf(results) + "\r\n#" + this.companyList.get(y).getNomSociete() + " results : ";
            int x2 = 0;
            while (x2 < this.files.size()) {
                if (this.files.get(x2).isAllDatabase()) {
                    TimsLogger.info("execute " + this.files.get(x2).getFileName());
                    String sqlResults = Fonctions.executeSqlFromFile(this.files.get(x2).getFileName(), this.database);
                    if (!sqlResults.equals("")) {
                        results = String.valueOf(results) + "\r\n" + this.files.get(x2).getFileName() + " results : " + sqlResults + "####";
                    }
                    if (sqlResults != null && !sqlResults.equals("")) {
                        toReturn = 6;
                    }
                }
                if (this.files.get(x2).isScript() && !Fonctions.executeCompanyVersionning(this.files.get(x2).getVersion())) {
                    toReturn = 6;
                }
                ++x2;
            }
            ++y;
        }
        if (!Configuration.setCurrentVersion(this.requiredVersion)) {
            TimsLogger.warn("#VersionManager.doVersionning# erreur : impossible de mettre \u00e0 jour la version de la base de donn\u00e9es");
            toReturn = 6;
        }
        System.err.println("#VersionManager.doVersionning#  Resultats : " + results + "####");
        System.err.println("#VersionManager.doVersionning#  On v\u00e9rifie la structure de la base de donn\u00e9es : ");
        MainFrameTransport.checkDatabase("version", Transport.savePath);
        File errors = new File(String.valueOf(Transport.savePath) + "\\TIMS - ERROR.txt");
        if (errors.exists() && errors.length() != 0L) {
            TimsLogger.warn("#VersionManager.doVersionning# Errors detected");
            toReturn = 6;
        } else {
            errors.delete();
            new File(String.valueOf(Transport.savePath) + "\\TIMS - WARNING.txt").delete();
        }
        return toReturn;
    }

    public void reorderCard() {
        int nbFiles = 0;
        int transfered = 0;
        int missing = 0;
        int error = 0;
        Vector<CardDownload> dl = CardDownload.getAllTelechargement();
        nbFiles = dl.size();
        for (CardDownload x : dl) {
            File original;
            String finalDirectory = String.valueOf(FileManager.ARCHIVE_DIRECTORY) + x.getDriver().getDataDirName();
            String finalFile = String.valueOf(finalDirectory) + "\\" + x.getFichier();
            String sOriginal = String.valueOf(FileManager.ARCHIVE_DIRECTORY) + x.getFichier();
            File fFinal = new File(finalDirectory);
            if (!fFinal.exists()) {
                fFinal.mkdirs();
            }
            if (!(original = new File(sOriginal)).exists()) {
                ++missing;
                TimsLogger.warn(String.valueOf(x.getFichier()) + " introuvable (" + x.getTelechargement() + " " + x.getDriver().getNom() + ")");
                continue;
            }
            if (!Fonctions.silentCopy(original.getName(), new File(finalFile), true)) {
                ++error;
                TimsLogger.debug("Erreur renommage " + original.getAbsolutePath() + " to " + finalFile);
                continue;
            }
            ++transfered;
        }
        TimsLogger.warn("#CardRenewal# Total files : " + nbFiles + ". Transferred : " + transfered + ". Missing : " + missing + ". Error : " + error);
    }

    private void reorderUev() {
        int nbFiles = 0;
        int transfered = 0;
        int missing = 0;
        int error = 0;
        Vector<UevDownload> dl = UevDownload.getAllTelechargementUEV();
        nbFiles = dl.size();
        for (UevDownload x : dl) {
            File original;
            String finalDirectory = String.valueOf(FileManager.ARCHIVE_DIRECTORY) + x.getVehicle().getDataDirName();
            String finalFile = String.valueOf(finalDirectory) + "\\" + x.getFichier();
            String sOriginal = String.valueOf(FileManager.ARCHIVE_DIRECTORY) + x.getFichier();
            File fFinal = new File(finalDirectory);
            if (!fFinal.exists()) {
                fFinal.mkdirs();
            }
            if (!(original = new File(sOriginal)).exists()) {
                ++missing;
                TimsLogger.warn(String.valueOf(x.getFichier()) + " introuvable (" + x.getTelechargement() + " " + x.getVehicle().getRegistrationNumber() + ")");
                continue;
            }
            if (!Fonctions.silentCopy(original.getName(), new File(finalFile), true)) {
                ++error;
                TimsLogger.warn("Erreur renommage " + original.getAbsolutePath() + " to " + finalFile);
                continue;
            }
            ++transfered;
        }
        TimsLogger.warn("#Uev# Total files : " + nbFiles + ". Transferred : " + transfered + ". Missing : " + missing + ". Error : " + error);
    }

    public void createDriver() {
        Vector<Conducteur> drivers = Conducteur.loadList(new Integer[0]);
        int nbFiles = 0;
        int created = 0;
        nbFiles = drivers.size();
        for (Conducteur tmp : drivers) {
            File file = new File(String.valueOf(FileManager.ARCHIVE_DIRECTORY) + tmp.getDataDirName());
            if (file.exists()) continue;
            ++created;
            file.mkdirs();
        }
        System.err.println("#createConducteur# " + created + " cr\u00e9e sur " + nbFiles + ".");
    }

    public void createUev() {
        Vector<Vehicule> vehicles = Vehicule.loadList(0);
        int nbFiles = 0;
        int created = 0;
        nbFiles = vehicles.size();
        for (Vehicule tmp : vehicles) {
            File file = new File(String.valueOf(FileManager.ARCHIVE_DIRECTORY) + tmp.getDataDirName());
            if (file.exists()) continue;
            ++created;
            file.mkdirs();
        }
        System.err.println("#createUev# " + created + " cr\u00e9e sur " + nbFiles + ".");
    }

    public void saveVersionFile(String repertoireSauvegarde) {
        File ts = new File(String.valueOf(Transport.savePath) + "\\TIMS - ERROR.txt");
        File ds = new File(String.valueOf(Transport.savePath) + "\\TIMS - WARNING.txt");
        if (Transport.debug != 1) {
            Fonctions.copyLocalFile(new File(TimsLogger.currentLogPath), new File(String.valueOf(repertoireSauvegarde) + "\\" + TimsLogger.currentLogPath.substring(TimsLogger.currentLogPath.indexOf("\\"))), true);
        }
        if (ts.exists()) {
            Fonctions.copyLocalFile(ts, new File(String.valueOf(repertoireSauvegarde) + "\\" + ts.getName()), true);
        }
        if (ds.exists()) {
            Fonctions.copyLocalFile(ds, new File(String.valueOf(repertoireSauvegarde) + "\\" + ds.getName()), true);
        }
    }

    public int checkVersionning() {
        return 1;
    }
}

