/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.exception.ActivityTypeNotFoundException;
import transpo.system.TimsLogger;

public abstract class Activite
extends MainElement {
    public static final String CARTE_INSEREE = "INSEREE";
    public static final String CARTE_NON_INSEREE = "NON INSEREE";
    public static final String CONDUITE_SEUL = "SEUL";
    public static final String CONDUITE_DE = "EQUIPAGE";
    public static final String LECTEUR_CONDUCTEUR = "CONDUCTEUR";
    public static final String LECTEUR_CONVOYEUR = "CONVOYEUR";
    protected int cleActivite;
    protected int cleType;
    protected String description = null;
    protected String couleur = null;
    protected int heureDebut;
    protected int heureFin;
    protected int duree;
    protected String etatCarte = null;
    protected String etatConduite = null;
    protected String lecteur = null;
    protected int modification = 0;
    protected int suppression = 0;

    public Activite() {
    }

    public Activite(int cleActivite, int cleType, String description, String couleur, int heureDebut, int heureFin, int duree, String typeSource, String nomSource, String etatCarte, String etatConduite, String lecteur) {
        this.cleActivite = cleActivite;
        this.cleType = cleType;
        this.description = description;
        this.couleur = couleur;
        this.heureDebut = heureDebut;
        this.heureFin = heureFin;
        this.duree = duree;
        this.etatCarte = etatCarte;
        this.etatConduite = etatConduite;
        this.lecteur = lecteur;
    }

    public int getCleActivite() {
        return this.cleActivite;
    }

    public void setCleActivite(int cleActivite) {
        this.cleActivite = cleActivite;
    }

    public int getCleType() {
        return this.cleType;
    }

    public void setCleType(int cleType) {
        this.cleType = cleType;
    }

    public String getCouleur() {
        if (this.couleur == null) {
            try {
                return String.valueOf(TypeActivite.getActivityType(this.cleType).getColor());
            }
            catch (ActivityTypeNotFoundException e) {
                e.printStackTrace();
                return "-16777216";
            }
        }
        return this.couleur;
    }

    public void setCouleur(String couleur) {
        this.couleur = couleur;
    }

    public String getDescription() {
        if (this.description == null) {
            try {
                return String.valueOf(TypeActivite.getActivityType(this.cleType).getName());
            }
            catch (ActivityTypeNotFoundException e) {
                e.printStackTrace();
            }
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getDuree() {
        return this.duree;
    }

    public void setDuree(int duree) {
        this.duree = duree;
    }

    public String getEtatCarte() {
        return this.etatCarte;
    }

    public void setEtatCarte(String etatCarte) {
        this.etatCarte = etatCarte;
    }

    public String getEtatConduite() {
        return this.etatConduite;
    }

    public void setEtatConduite(String etatConduite) {
        this.etatConduite = etatConduite;
    }

    public int getHeureDebut() {
        return this.heureDebut;
    }

    public void setHeureDebut(int heureDebut) {
        this.heureDebut = heureDebut;
        this.duree = this.heureFin - this.heureDebut;
        if (this.duree < 0) {
            TimsLogger.error("#Activite.setHeureFin# erreur de dur\u00e9e");
        }
    }

    public int getHeureFin() {
        return this.heureFin;
    }

    public void setHeureFin(int heureFin) {
        this.heureFin = heureFin;
        this.duree = this.heureFin - this.heureDebut;
        if (this.duree < 0) {
            TimsLogger.error("#Activite.setHeureFin# erreur de dur\u00e9e");
        }
    }

    public String getLecteur() {
        return this.lecteur;
    }

    public void setLecteur(String lecteur) {
        this.lecteur = lecteur;
    }

    public int getModification() {
        return this.modification;
    }

    public void setModification(int modification) {
        this.modification = modification;
    }
}

