/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ClosePayPeriod;
import fr.pgh.data.bdd.ElementArbre;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class Agence
extends MainElement
implements ElementArbre {
    public static final String table = "t_agence";
    public static Vector<Agence> agencies = null;
    private int cleAgence;
    private int clePays = 0;
    private String description = null;
    private String codePostal = null;
    private String ville = null;
    private String tel1 = null;
    private String tel2 = null;
    private String fax = null;
    private String email = null;
    private String cleInterneAgence = null;
    private String dateDebut = null;
    private String dateFin = null;
    private String adresse = null;
    private String logo = null;
    private int cleTypeAgence = 0;
    private int cleTailleAgence = 0;
    private int regionId = 0;
    private int defaultCalendarId = 0;
    private boolean satWork = false;
    private float targetConsumption = 0.0f;
    private float latitude = 0.0f;
    private float longitude = 0.0f;

    public String toString() {
        return this.description;
    }

    public Agence() {
    }

    public Agence(int cleAgence) {
        this.loadById(cleAgence);
    }

    public Agence(int cleAgence, int clePays, String description, String codePostal, String ville, String tel1, String tel2, String fax, String email, String cleInterneAgence, String dateDebut, String dateFin, String adresse, String logo, int cleTypeAgence, int cleTailleAgence) {
        this.cleAgence = cleAgence;
        this.clePays = clePays;
        this.description = description;
        this.codePostal = codePostal;
        this.ville = ville;
        this.tel1 = tel1;
        this.tel2 = tel2;
        this.fax = fax;
        this.email = email;
        this.cleInterneAgence = cleInterneAgence;
        this.dateDebut = dateDebut;
        this.dateFin = dateFin;
        this.adresse = adresse;
        this.logo = logo;
        this.cleTypeAgence = cleTypeAgence;
        this.cleTailleAgence = cleTailleAgence;
    }

    public Agence(int cleAgence, String description) {
        this.cleAgence = cleAgence;
        this.description = description;
    }

    public Agence(int cleAgence, String description, String cleInterneAgence, int regionId) {
        this.cleAgence = cleAgence;
        this.description = description;
        this.cleInterneAgence = cleInterneAgence;
        this.regionId = regionId;
    }

    @Override
    public String getLibelle() {
        return String.valueOf(this.description) + (this.cleInterneAgence != null && !this.cleInterneAgence.equals("") ? " - " + this.cleInterneAgence : "");
    }

    @Override
    public int getStatus() {
        return 0;
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public int getCle() {
        return this.getCleAgence();
    }

    @Override
    public String getCode() {
        return this.getCleInterneAgence();
    }

    public boolean equals(Object object) {
        boolean toReturn = object instanceof Agence && ((Agence)object).getDescription() != null && this.description != null && ((Agence)object).getDescription().equals(this.description);
        return toReturn;
    }

    public int hashCode() {
        int hash = 2;
        hash = 31 * hash + (this.description == null ? 0 : this.description.hashCode());
        return hash;
    }

    public boolean insert() {
        String sql = "";
        boolean retour = false;
        try {
            try {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO t_agence (" + this.getAllFields() + ")" + " VALUES (GEN_T_AGENCE.nextval,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    this.statement = Agence.getConnection().prepareStatement(sql);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO t_agence (" + this.getAllFields().substring(this.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    this.statement = Agence.getConnection().prepareStatement(sql, 1);
                }
                this.statement.setObject(1, (Object)this.clePays, 12);
                this.statement.setObject(2, (Object)this.description, 12);
                this.statement.setObject(3, (Object)this.codePostal, 12);
                this.statement.setObject(4, (Object)this.ville, 12);
                this.statement.setObject(5, (Object)this.tel1, 12);
                this.statement.setObject(6, (Object)this.tel2, 12);
                this.statement.setObject(7, (Object)this.fax, 12);
                this.statement.setObject(8, (Object)this.email, 12);
                this.statement.setObject(9, (Object)this.cleInterneAgence, 12);
                this.statement.setDate(10, Date.valueOf(Agence.getDateToSGBD(this.dateDebut)));
                this.statement.setDate(11, Date.valueOf(Agence.getDateToSGBD(this.dateFin)));
                this.statement.setObject(12, (Object)this.adresse, 12);
                this.statement.setObject(13, (Object)this.logo, 12);
                this.statement.setObject(14, (Object)this.cleTypeAgence, 12);
                this.statement.setObject(15, (Object)this.cleTailleAgence, 12);
                this.statement.setObject(16, (Object)this.regionId, 4);
                this.statement.setObject(17, (Object)(this.satWork ? 1 : 0), 4);
                this.statement.setObject(18, (Object)this.defaultCalendarId, 4);
                this.statement.setObject(19, (Object)Float.valueOf(this.targetConsumption), 6);
                this.statement.setObject(20, (Object)Float.valueOf(this.latitude), 6);
                this.statement.setObject(21, (Object)Float.valueOf(this.longitude), 6);
                this.statement.executeUpdate();
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    ResultSet rs = this.statement.getGeneratedKeys();
                    if (!rs.next()) {
                        TimsLogger.warn("#Agence.insert# no auto generated key availaible");
                    } else {
                        TimsLogger.debug("#Agence.insert# auto generated key value = " + rs.getInt(1));
                        this.cleAgence = rs.getInt(1);
                    }
                    rs.close();
                }
                if (this.cleAgence == 0) {
                    if (this.loadId()) {
                        TimsLogger.warn("#Agence.insert# generated key value = " + this.cleAgence);
                    } else {
                        TimsLogger.debug("#Agence.insert# no generated key availaible");
                    }
                }
                ClosePayPeriod.addAgency(this.cleAgence);
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new java.util.Date(), this.affiche()).insert();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT MAX(CLE_AGENCE) AS CLE_AGENCE FROM t_agence WHERE DES_AGENCE = ?";
        PreparedStatement statement = null;
        try {
            try {
                statement = Agence.getConnection().prepareStatement(sql);
                statement.setObject(1, (Object)this.description, 12);
                rs = statement.executeQuery();
                while (rs.next()) {
                    this.cleAgence = rs.getInt("CLE_AGENCE");
                    TimsLogger.debug("#Agence.loadId# id found " + this.cleAgence);
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.error("#Agence.loadId()# erreur sql = " + sql + " " + ex.getMessage());
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean update() {
        String sql = "UPDATE t_agence SET CLE_PAYS=? , CODE_POSTAL=? , VILLE=? , TEL1=? , TEL2=? , FAX=? , EMAIL=? , CLE_INTERNE_AGENCE=? , DATE_DEBUT=? , DATE_FIN=? , ADRESSE=? , CLE_TYPE_AGENCE=? , CLE_TAILLE_AGENCE=? , DES_AGENCE=?, REGION_ID=?,  SAT_WORKING=?,  DEFAULT_CALENDAR_ID=?,  CONSUMPTION_TARGET =?,  LATITUDE =?,  LONGITUDE =?  WHERE CLE_AGENCE=?";
        try {
            this.statement = Agence.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.clePays, 4);
            this.statement.setObject(2, (Object)this.codePostal, 12);
            this.statement.setObject(3, (Object)this.ville, 12);
            this.statement.setObject(4, (Object)this.tel1, 12);
            this.statement.setObject(5, (Object)this.tel2, 12);
            this.statement.setObject(6, (Object)this.fax, 12);
            this.statement.setObject(7, (Object)this.email, 12);
            this.statement.setObject(8, (Object)this.cleInterneAgence, 12);
            this.statement.setDate(9, Date.valueOf(Agence.getDateToSGBD(this.dateDebut)));
            this.statement.setDate(10, Date.valueOf(Agence.getDateToSGBD(this.dateFin)));
            this.statement.setObject(11, (Object)this.adresse, 12);
            this.statement.setObject(12, (Object)this.cleTypeAgence, 4);
            this.statement.setObject(13, (Object)this.cleTailleAgence, 4);
            this.statement.setObject(14, (Object)this.description, 12);
            this.statement.setObject(15, (Object)this.regionId, 4);
            this.statement.setObject(16, (Object)(this.satWork ? 1 : 0), 4);
            this.statement.setObject(17, (Object)this.defaultCalendarId, 4);
            this.statement.setObject(18, (Object)Float.valueOf(this.targetConsumption), 6);
            this.statement.setObject(19, (Object)Float.valueOf(this.latitude), 6);
            this.statement.setObject(20, (Object)Float.valueOf(this.longitude), 6);
            this.statement.setObject(21, (Object)this.cleAgence, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception e) {
            TimsLogger.error("#Agence.update()# erreur sql = " + sql);
        }
        return false;
    }

    public boolean compareAndUpdate(String name, String code, String address, String cp, String city, int country, String phone1, String phone2, String fax, String mail, String open, String close, int size, int type, int regionId, boolean satWork, int defaultCalendarId) {
        boolean renewCoordinates = false;
        String tracer = String.valueOf(LanguageTranslator.getString("generics.agency")) + " n\u00b0 " + this.cleAgence + "\n";
        if (Fonctions.fieldChange(this.description, name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("agency.name") + " '" + this.description + "' => '" + name + "'\n";
            this.setDescription(name);
        }
        if (Fonctions.fieldChange(this.cleInterneAgence, code)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.code") + " '" + this.cleInterneAgence + "' => " + code + "'\n";
            this.setCleInterneAgence(code);
        }
        if (Fonctions.fieldChange(this.adresse, address)) {
            renewCoordinates = true;
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.address") + " '" + this.adresse + "' => '" + address + "'\n";
            this.setAdresse(address);
        }
        if (Fonctions.fieldChange(this.codePostal, cp)) {
            renewCoordinates = true;
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.cp") + " '" + this.codePostal + "' => '" + cp + "'\n";
            this.setCodePostal(cp);
        }
        if (Fonctions.fieldChange(this.ville, city)) {
            renewCoordinates = true;
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.city") + " '" + this.ville + "' => '" + city + "'\n";
            this.setVille(city);
        }
        if (country != this.clePays) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.country") + " '" + this.clePays + "' => '" + country + "'\n";
            this.setClePays(country);
        }
        if (Fonctions.fieldChange(this.tel1, phone1)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.phone") + " '" + this.tel1 + "' => '" + phone1 + "'\n";
            this.setTel1(phone1);
        }
        if (Fonctions.fieldChange(this.tel2, phone2)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.mobile") + " '" + this.tel2 + "' => '" + phone2 + "'\n";
            this.setTel2(phone2);
        }
        if (Fonctions.fieldChange(this.fax, fax)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.fax") + " '" + this.fax + "' => '" + fax + "'\n";
            this.setFax(fax);
        }
        if (Fonctions.fieldChange(this.email, mail)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.mail") + " '" + this.email + "' => '" + mail + "'\n";
            this.setEmail(mail);
        }
        if (!Agence.getDateFromSGBD(open).equals(this.dateDebut)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("agency.opening") + " '" + this.dateDebut + "' => '" + Agence.getDateFromSGBD(open) + "'\n";
            this.setDateDebut(Agence.getDateFromSGBD(open));
        }
        if (!Agence.getDateFromSGBD(close).equals(this.dateFin)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("agency.closing") + " '" + this.dateFin + "' => '" + Agence.getDateFromSGBD(close) + "'\n";
            this.setDateFin(Agence.getDateFromSGBD(close));
        }
        if (size != this.cleTailleAgence) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("agency.size.title") + " '" + this.cleTailleAgence + "' => '" + size + "'\n";
            this.setCleTailleAgence(size);
        }
        if (type != this.cleTypeAgence) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("agency.type.title") + " '" + this.cleTypeAgence + "' => '" + type + "'\n";
            this.setCleTypeAgence(type);
        }
        if (regionId != this.regionId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.region") + " '" + this.regionId + "' => '" + regionId + "'\n";
            this.setRegionId(regionId);
        }
        if (satWork != this.satWork) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("agency.satOpen") + " '" + this.satWork + "' => '" + satWork + "'\n";
            this.setSatWork(satWork);
        }
        if (defaultCalendarId != this.defaultCalendarId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.calendrier") + " '" + this.defaultCalendarId + "' => '" + defaultCalendarId + "'\n";
            this.setDefaultCalendarId(defaultCalendarId);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.agency")) + " n\u00b0 " + this.cleAgence + "\n")) {
            if (renewCoordinates) {
                try {
                    String fullAddress = String.valueOf(this.getAdresse()) + " " + this.getCodePostal() + " " + this.getVille();
                    float[] position = Fonctions.getCoordinates(fullAddress);
                    if (position != null) {
                        this.setLongitude(position[0]);
                        this.setLatitude(position[1]);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TimsLogger.error("#DCC.add# erreur getPosition");
                }
            }
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new java.util.Date(), tracer).insert();
            return this.update();
        }
        return true;
    }

    public boolean compareAndUpdateConsumption(float target) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.agency")) + " n\u00b0 " + this.cleAgence + "\n";
        if (target != this.targetConsumption) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("consumption.target") + " : '" + this.targetConsumption + "' => '" + target + "'\n";
            this.setTargetConsumption(target);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.agency")) + " n\u00b0 " + this.cleAgence + "\n")) {
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new java.util.Date(), tracer).insert();
            return this.update();
        }
        return true;
    }

    private String getAllFields() {
        return "CLE_AGENCE, CLE_PAYS, DES_AGENCE, CODE_POSTAL, VILLE, TEL1, TEL2, FAX, EMAIL, CLE_INTERNE_AGENCE, " + BddTransport.getDateSGBDRToString("DATE_DEBUT", false, "") + ", " + BddTransport.getDateSGBDRToString("DATE_FIN", false, "") + ", " + " ADRESSE, LOGO, CLE_TYPE_AGENCE, CLE_TAILLE_AGENCE, REGION_ID," + " SAT_WORKING, DEFAULT_CALENDAR_ID, CONSUMPTION_TARGET , LATITUDE, LONGITUDE";
    }

    public boolean loadById(int agencyId) {
        String sql = "SELECT " + this.getAllFields() + " FROM " + table + " WHERE CLE_AGENCE=" + agencyId;
        return this.genericLoad(sql);
    }

    public boolean loadByName(String name) {
        String sql = "SELECT " + this.getAllFields() + " FROM " + table + " WHERE DES_AGENCE='" + name + "'";
        return this.genericLoad(sql);
    }

    public boolean loadByNameOrCode(String name, String code) {
        String sql = "SELECT " + this.getAllFields() + " FROM " + table;
        String restriction = "";
        if (name != null && !"".equals(name)) {
            restriction = String.valueOf(restriction) + " AND DES_AGENCE= '" + name + "'";
        }
        if (code != null && !"".equals(code)) {
            restriction = String.valueOf(restriction) + " AND CLE_INTERNE_AGENCE = '" + code + "'";
        }
        if (!restriction.equals("")) {
            sql = String.valueOf(sql) + " WHERE " + restriction.substring(5);
        }
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = Agence.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    this.cleAgence = rs.getInt("CLE_AGENCE");
                    this.clePays = rs.getInt("CLE_PAYS");
                    this.description = rs.getString("DES_AGENCE");
                    this.ville = rs.getString("VILLE");
                    this.adresse = rs.getString("ADRESSE");
                    this.codePostal = rs.getString("CODE_POSTAL");
                    this.tel1 = rs.getString("TEL1");
                    this.tel2 = rs.getString("TEL2");
                    this.fax = rs.getString("FAX");
                    this.email = rs.getString("EMAIL");
                    this.cleInterneAgence = rs.getString("CLE_INTERNE_AGENCE");
                    this.dateDebut = Agence.getDateFromSGBD(rs.getString("DATE_DEBUT"));
                    this.dateFin = Agence.getDateFromSGBD(rs.getString("DATE_FIN"));
                    this.logo = rs.getString("LOGO");
                    this.cleTypeAgence = rs.getInt("CLE_TYPE_AGENCE");
                    this.cleTailleAgence = rs.getInt("CLE_TAILLE_AGENCE");
                    this.regionId = rs.getInt("REGION_ID");
                    this.satWork = rs.getBoolean("SAT_WORKING");
                    this.defaultCalendarId = rs.getInt("DEFAULT_CALENDAR_ID");
                    this.targetConsumption = rs.getFloat("CONSUMPTION_TARGET");
                    this.latitude = rs.getFloat("LATITUDE");
                    this.longitude = rs.getFloat("LONGITUDE");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("#Agence.genericLoad()#  sql = " + sql + " " + ex.getMessage());
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public String affiche() {
        String toReturn = "d\u00e9tail agence \r\n";
        toReturn = String.valueOf(toReturn) + "nom : " + this.description + " \r\n";
        toReturn = String.valueOf(toReturn) + "code : " + this.cleInterneAgence + " \r\n";
        return toReturn;
    }

    public String getAdresse() {
        return this.adresse;
    }

    public void setAdresse(String adresse) {
        this.adresse = adresse;
    }

    public int getCleAgence() {
        return this.cleAgence;
    }

    public void setCleAgence(int cleAgence) {
        this.cleAgence = cleAgence;
    }

    public String getCleInterneAgence() {
        return this.cleInterneAgence;
    }

    public void setCleInterneAgence(String cleInterneAgence) {
        this.cleInterneAgence = cleInterneAgence;
    }

    public int getClePays() {
        return this.clePays;
    }

    public void setClePays(int clePays) {
        this.clePays = clePays;
    }

    public int getCleTailleAgence() {
        return this.cleTailleAgence;
    }

    public void setCleTailleAgence(int cleTailleAgence) {
        this.cleTailleAgence = cleTailleAgence;
    }

    public int getCleTypeAgence() {
        return this.cleTypeAgence;
    }

    public void setCleTypeAgence(int cleTypeAgence) {
        this.cleTypeAgence = cleTypeAgence;
    }

    public String getCodePostal() {
        return this.codePostal;
    }

    public void setCodePostal(String codePostal) {
        this.codePostal = codePostal;
    }

    public String getDateDebut() {
        return this.dateDebut;
    }

    public void setDateDebut(String dateDebut) {
        this.dateDebut = dateDebut;
    }

    public String getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(String dateFin) {
        this.dateFin = dateFin;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getTel1() {
        return this.tel1;
    }

    public void setTel1(String tel1) {
        this.tel1 = tel1;
    }

    public String getTel2() {
        return this.tel2;
    }

    public void setTel2(String tel2) {
        this.tel2 = tel2;
    }

    public String getVille() {
        return this.ville;
    }

    public void setVille(String ville) {
        this.ville = ville;
    }

    public int getRegionId() {
        return this.regionId;
    }

    public void setRegionId(int regionId) {
        this.regionId = regionId;
    }

    public boolean isSatWork() {
        return this.satWork;
    }

    public void setSatWork(boolean satWork) {
        this.satWork = satWork;
    }

    public int getDefaultCalendarId() {
        return this.defaultCalendarId;
    }

    public void setDefaultCalendarId(int defaultCalendarId) {
        this.defaultCalendarId = defaultCalendarId;
    }

    public float getTargetConsumption() {
        return this.targetConsumption;
    }

    public void setTargetConsumption(float targetConsumption) {
        this.targetConsumption = targetConsumption;
    }

    public float getLatitude() {
        return this.latitude;
    }

    public void setLatitude(float latitude) {
        this.latitude = latitude;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public void setLongitude(float longitude) {
        this.longitude = longitude;
    }

    public static Vector<Agence> getList() {
        if (agencies == null) {
            agencies = Agence.loadList(null, 0);
        }
        return agencies;
    }

    public static void setList(Vector<Agence> agencies) {
        if (Transport.apiMode == 0) {
            TimsLogger.info("#Agence.setList# define a new list");
        }
        Agence.agencies = agencies;
    }

    public static Vector<Agence> loadList(String nomSociete, int regionId) {
        Vector<Agence> toReturn = new Vector<Agence>();
        ResultSet rs = null;
        String sql = "SELECT CLE_AGENCE, CLE_PAYS, DES_AGENCE, CODE_POSTAL, VILLE, TEL1, TEL2, FAX, EMAIL, ADRESSE, CLE_TYPE_AGENCE, REGION_ID, DEFAULT_CALENDAR_ID, CONSUMPTION_TARGET, LATITUDE, LONGITUDE FROM ";
        if (nomSociete != null && !nomSociete.equals("") && System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = String.valueOf(sql) + nomSociete + ".";
        }
        sql = String.valueOf(sql) + table;
        String restriction = "";
        String accessRestriction = BddTransport.addRestriction(table, "");
        if (!accessRestriction.equals("")) {
            restriction = " AND " + accessRestriction;
        }
        if (regionId != 0) {
            restriction = " AND REGION_ID = " + regionId;
        }
        if (restriction != "") {
            sql = String.valueOf(sql) + " WHERE " + restriction.substring(5);
        }
        sql = String.valueOf(sql) + " ORDER BY DES_AGENCE";
        Statement stm = null;
        try {
            try {
                stm = Agence.getConnection().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    Agence toAdd = new Agence(rs.getInt("CLE_AGENCE"), rs.getString("DES_AGENCE"));
                    toAdd.setClePays(rs.getInt("CLE_PAYS"));
                    toAdd.setRegionId(rs.getInt("REGION_ID"));
                    toAdd.setDefaultCalendarId(rs.getInt("DEFAULT_CALENDAR_ID"));
                    toAdd.setVille(rs.getString("VILLE"));
                    toAdd.setCodePostal(rs.getString("CODE_POSTAL"));
                    toAdd.setAdresse(rs.getString("ADRESSE"));
                    toAdd.setTel1(rs.getString("TEL1"));
                    toAdd.setFax(rs.getString("FAX"));
                    toAdd.setEmail(rs.getString("EMAIL"));
                    toAdd.setCleTypeAgence(rs.getInt("CLE_TYPE_AGENCE"));
                    toAdd.setTargetConsumption(rs.getFloat("CONSUMPTION_TARGET"));
                    toAdd.setLatitude(rs.getFloat("LATITUDE"));
                    toAdd.setLongitude(rs.getFloat("LONGITUDE"));
                    toReturn.add(toAdd);
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("#Agence.loadList()# sql = " + sql + " " + ex.getMessage());
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public static Vector<Agence> loadListByRegion(String company) {
        Vector<Agence> toReturn = new Vector<Agence>();
        ResultSet rs = null;
        String sql = "";
        if (System.getProperty("show_region", "0").equals("1")) {
            sql = String.valueOf(sql) + "SELECT CLE_AGENCE, region.NAME, REGION_ID, DEFAULT_CALENDAR_ID, DES_AGENCE FROM ";
            sql = company != null && !company.equals("") && System.getProperty("SGBDR", "mysql").equals("mysql") ? String.valueOf(sql) + company + "." + table + " JOIN " + company + "." + "region" + " ON REGION_ID = " + "region" + ".ID" : String.valueOf(sql) + "t_agence JOIN region ON REGION_ID = region.ID";
            sql = String.valueOf(sql) + " ORDER BY NAME, DES_AGENCE";
        } else {
            sql = "SELECT CLE_AGENCE, REGION_ID, DEFAULT_CALENDAR_ID, DES_AGENCE FROM ";
            if (company != null && !company.equals("") && System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = String.valueOf(sql) + company + ".";
            }
            sql = String.valueOf(sql) + table;
            sql = String.valueOf(sql) + " ORDER BY DES_AGENCE";
        }
        Statement stm = null;
        try {
            try {
                stm = Agence.getConnection().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    Agence toAdd = new Agence(rs.getInt("CLE_AGENCE"), rs.getString("DES_AGENCE"));
                    toAdd.setRegionId(rs.getInt("REGION_ID"));
                    toAdd.setDefaultCalendarId(rs.getInt("DEFAULT_CALENDAR_ID"));
                    toReturn.add(toAdd);
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("#Agence.loadListByRegion()# sql = " + sql + " " + ex.getMessage());
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public static Agence find(Vector<Agence> agencies, int agencyId) {
        if (agencyId == 0) {
            return null;
        }
        if (agencies == null) {
            agencies = Agence.getList();
        }
        for (Agence tmp : agencies) {
            if (tmp.getCleAgence() != agencyId) continue;
            return tmp;
        }
        TimsLogger.warn("#Agence.find# unable to find agency " + agencyId);
        return null;
    }
}

