/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.CompanyWarningActivation;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class AgencyRestriction
extends MainElement {
    public static final String table = "T_RESTRICTION";
    private int id = 0;
    private int userId = 0;
    private int companyId = 0;
    private int agencyId = 0;

    public AgencyRestriction(int id, int agencyId, int userId, int companyId) {
        this.id = id;
        this.agencyId = agencyId;
        this.userId = userId;
        this.companyId = companyId;
    }

    public boolean equals(Object obj) {
        return obj instanceof CompanyWarningActivation && ((AgencyRestriction)obj).getAgencyId() == this.agencyId && ((AgencyRestriction)obj).getUserId() == this.userId && ((AgencyRestriction)obj).getCompanyId() == this.companyId;
    }

    public int hashCode() {
        return Integer.valueOf(this.userId).hashCode() + Integer.valueOf(this.agencyId).hashCode() + Integer.valueOf(this.companyId).hashCode();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getAgencyId() {
        return this.agencyId;
    }

    public void setAgencyId(int agencyId) {
        this.agencyId = agencyId;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public int getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(int companyId) {
        this.companyId = companyId;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean retour = false;
        Statement statement = null;
        String sql = null;
        try {
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO T_RESTRICTION(CLE_RESTRICTION, CLE_USER, CLE_SOCIETE, CLE_AGENCE) VALUES (GEN_T_RESTRICTION.nextval,?,?,?)";
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + "(CLE_USER, CLE_SOCIETE, CLE_AGENCE) VALUES " + "(?,?,?)";
            }
            if (sql == null) {
                TimsLogger.error("#AgencyRestriction.insert# unknown database " + System.getProperty("SGBDR", "mysql"));
                return false;
            }
            try {
                statement = AgencyRestriction.getConnection().prepareStatement(sql);
                statement.setObject(1, this.userId, 4);
                statement.setObject(2, this.companyId, 4);
                statement.setObject(3, this.agencyId, 4);
                if (statement.executeUpdate() == 1) {
                    retour = true;
                }
                statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean updateValue() {
        boolean retour = false;
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET " + " CLE_USER=?, " + " CLE_SOCIETE=?, " + " CLE_AGENCE=? " + " WHERE ID=?";
        try {
            try {
                this.statement = AgencyRestriction.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.userId, 4);
                this.statement.setObject(2, (Object)this.companyId, 4);
                this.statement.setObject(3, (Object)this.agencyId, 4);
                this.statement.setObject(4, (Object)this.id, 4);
                if (this.statement.executeUpdate() == 1) {
                    retour = true;
                }
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean delete() {
        String sql = "DELETE FROM " + BddTransport.getBaseDefault(true) + table + " WHERE ID =?";
        try {
            this.statement = AgencyRestriction.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.id);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public static boolean multipleCreate(int userId, Vector<Integer> toUpdate, int companyId) {
        BddTransport.getInstance().startTransaction();
        for (Integer agencyId : toUpdate) {
            if (new AgencyRestriction(0, agencyId, userId, companyId).insert()) continue;
            BddTransport.getInstance().rollback();
            return false;
        }
        BddTransport.getInstance().commit();
        return true;
    }

    public static boolean multipleDelete(int userId, Vector<Agence> toDelete) {
        if (userId == 0) {
            TimsLogger.error("Cannot call multiple delete without filter");
            return false;
        }
        boolean toReturn = false;
        String where = "";
        if (userId != 0) {
            where = String.valueOf(where) + " AND CLE_USER = " + userId;
        }
        if (toDelete != null) {
            where = String.valueOf(where) + " AND CLE_AGENCE IN (";
            String list = "";
            for (Agence iter : toDelete) {
                list = String.valueOf(list) + "," + iter.getCleAgence();
            }
            where = String.valueOf(where) + list.substring(1) + ")";
        }
        String sql = "DELETE FROM " + BddTransport.getBaseDefault(true) + table;
        if (!where.equals("")) {
            sql = String.valueOf(sql) + " WHERE " + where.substring(5);
        }
        Statement stm = null;
        try {
            try {
                stm = AgencyRestriction.getConnection().createStatement();
                stm.executeUpdate(sql);
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                TimsLogger.error("#multipleDelete# sql error (" + sql + ")" + " => " + e.getMessage());
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public static ArrayList<AgencyRestriction> getList(int userId) {
        ArrayList<AgencyRestriction> toReturn = new ArrayList<AgencyRestriction>();
        String sql = "SELECT * FROM " + BddTransport.getBaseDefault(true) + table;
        if (userId != -1) {
            sql = String.valueOf(sql) + " WHERE CLE_UTILISATEUR = " + userId;
        }
        TimsLogger.debug("#AgencyRestriction.getList# sql => " + sql);
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                stm = AgencyRestriction.getConnection().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    toReturn.add(new AgencyRestriction(rs.getInt("CLE_RESTRICTION"), rs.getInt("CLE_UTILISATEUR"), rs.getInt("CLE_AGENCE"), rs.getInt("CLE_SOCIETE")));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }
}

