/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.MainElement;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class CardDownload
extends MainElement {
    public static final int OFFSET = 116;
    private Conducteur driver = null;
    private String downloadDate = null;
    private String fileName = null;
    private int userId;

    public CardDownload() {
    }

    public CardDownload(Conducteur driver, int userId, String date, String fichier) {
        this.driver = driver;
        this.userId = userId;
        this.downloadDate = date;
        this.fileName = fichier;
    }

    public void affiche() {
        TimsLogger.debug("#CardDownload.affiche# file " + this.fileName + ", date " + this.downloadDate);
    }

    public String getTelechargement() {
        return this.downloadDate;
    }

    public String getFichier() {
        return this.fileName;
    }

    public int getUserId() {
        return this.userId;
    }

    public Conducteur getDriver() {
        return this.driver;
    }

    public boolean insert() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO t_telechargement (CLE_TELECHARGEMENT ,CLE_CHAUFFEUR, CLE_USER, DATE_TELECHARGEMENT, NOM_FICHIER) VALUES (GEN_T_TELECHARGEMENT.nextval,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO t_telechargement (CLE_CHAUFFEUR, CLE_USER, DATE_TELECHARGEMENT, NOM_FICHIER) VALUES (?,?,?,?)";
        }
        try {
            this.statement = CardDownload.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.driver.getCleConducteur(), 4);
            this.statement.setObject(2, (Object)this.userId, 4);
            this.statement.setTimestamp(3, Timestamp.valueOf(this.downloadDate));
            this.statement.setObject(4, (Object)this.fileName, 12);
            this.statement.executeUpdate();
            TimsLogger.debug("#CardDownload.insert# insertion effectu\u00e9e : " + sql + " (" + this.driver.getCleConducteur() + "," + this.userId + "," + this.downloadDate + "," + this.fileName + ")");
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent("t_telechargement", Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public byte[] write(OutputStream out) {
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            String activite = ConversionTime.dateStringToBinary(this.downloadDate);
            activite = String.valueOf(activite) + Integer.toBinaryString(this.userId + (int)Math.pow(2.0, 11.0)).substring(1);
            int x = 0;
            while (x < 3) {
                tmp.write(Integer.parseInt(activite.substring(x * 8, (x + 1) * 8), 2));
                ++x;
            }
            if (this.fileName != null) {
                tmp.write(this.fileName.getBytes());
            }
            out.write(116);
            out.write((byte)(tmp.size() / 255 + 1));
            out.write((byte)tmp.size());
            tmp.writeTo(out);
            return tmp.toByteArray();
        }
        catch (Exception ex) {
            TimsLogger.error("#CardDownload.write# " + ex.getMessage());
            return null;
        }
    }

    public void read(byte[] fileBuffer) {
        int x = 0;
        String tmp = "";
        while (x < 3) {
            tmp = String.valueOf(tmp) + Integer.toBinaryString(256 + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x])).substring(1);
            TimsLogger.debug("#CardDownload.read#" + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x]) + " => " + tmp.substring(x * 8));
            ++x;
        }
        this.downloadDate = ConversionTime.binaryToDateString(tmp);
        this.userId = Integer.parseInt(tmp.substring(13, 24), 2);
        this.fileName = new String(fileBuffer).substring(3);
    }

    public static Vector<CardDownload> getTelechargement(int cleAgence, int cleConducteur, String dateDebut, String dateFin) {
        Vector<CardDownload> result = new Vector<CardDownload>();
        String sql = "";
        try {
            String restriction;
            sql = "SELECT CLE_USER, c.CLE_CHAUFFEUR, CLE_AGENCE, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, NUM_CARTE_CHAUFFEUR, " + BddTransport.getDateSGBDRToString("DATE_TELECHARGEMENT", true, "") + ", NOM_FICHIER" + " FROM " + "t_conducteur" + " c INNER JOIN " + "t_telechargement" + " t ON c.CLE_CHAUFFEUR = t.CLE_CHAUFFEUR";
            if (cleAgence != 0) {
                sql = String.valueOf(sql) + " AND CLE_AGENCE = " + cleAgence;
            }
            if (cleConducteur != 0) {
                sql = String.valueOf(sql) + " AND t.CLE_CHAUFFEUR = " + cleConducteur;
            }
            if (dateDebut != null && !dateDebut.equals("")) {
                sql = String.valueOf(sql) + " AND DATE_TELECHARGEMENT >= " + BddTransport.getDateStringToSGBDR(dateDebut, false);
            }
            if (dateFin != null && !dateFin.equals("")) {
                sql = String.valueOf(sql) + " AND DATE_TELECHARGEMENT <= " + BddTransport.getDateStringToSGBDR(dateFin, false);
            }
            if (!(restriction = BddTransport.addRestriction("c", "t")).equals("")) {
                sql = String.valueOf(sql) + " AND " + restriction;
            }
            sql = String.valueOf(sql) + " ORDER BY NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, DATE_TELECHARGEMENT";
            Statement stm = CardDownload.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Conducteur tmp = new Conducteur(rs.getInt("CLE_CHAUFFEUR"), rs.getString("NOM_CONDUCTEUR"), rs.getString("PRENOM_CONDUCTEUR"));
                tmp.setCleAgence(rs.getInt("CLE_AGENCE"));
                tmp.setNumeroCarte(rs.getString("NUM_CARTE_CHAUFFEUR"));
                result.add(new CardDownload(tmp, rs.getInt("CLE_USER"), rs.getString("DATE_TELECHARGEMENT"), rs.getString("NOM_FICHIER")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("getTelechargement()# sql = " + sql + " - " + ex.getMessage());
        }
        return result;
    }

    public static Vector<CardDownload> loadList(String filters) {
        Vector<CardDownload> result = new Vector<CardDownload>();
        String sql = "";
        try {
            sql = "SELECT CLE_USER, c.CLE_CHAUFFEUR, CLE_AGENCE, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, NUM_CARTE_CHAUFFEUR, " + BddTransport.getDateSGBDRToString("DATE_TELECHARGEMENT", true, "") + ", NOM_FICHIER" + " FROM " + "t_conducteur" + " c INNER JOIN " + "t_telechargement" + " t ON c.CLE_CHAUFFEUR = t.CLE_CHAUFFEUR";
            if (filters != null && !filters.equals("")) {
                sql = String.valueOf(sql) + " WHERE " + filters;
            }
            sql = String.valueOf(sql) + " ORDER BY NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, DATE_TELECHARGEMENT";
            TimsLogger.error("loadList()# sql = " + sql);
            Statement stm = CardDownload.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Conducteur tmp = new Conducteur(rs.getInt("CLE_CHAUFFEUR"), rs.getString("NOM_CONDUCTEUR"), rs.getString("PRENOM_CONDUCTEUR"));
                tmp.setCleAgence(rs.getInt("CLE_AGENCE"));
                tmp.setNumeroCarte(rs.getString("NUM_CARTE_CHAUFFEUR"));
                result.add(new CardDownload(tmp, rs.getInt("CLE_USER"), rs.getString("DATE_TELECHARGEMENT"), rs.getString("NOM_FICHIER")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("getAllTelechargement()# sql = " + sql + " - " + ex.getMessage());
        }
        return result;
    }

    public static Vector<CardDownload> getAllTelechargement() {
        Vector<CardDownload> result = new Vector<CardDownload>();
        String sql = "";
        try {
            sql = "SELECT CLE_USER, c.CLE_CHAUFFEUR, CLE_AGENCE, NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, NUM_CARTE_CHAUFFEUR, " + BddTransport.getDateSGBDRToString("DATE_TELECHARGEMENT", true, "") + ", NOM_FICHIER" + " FROM " + "t_conducteur" + " c INNER JOIN " + "t_telechargement" + " t ON c.CLE_CHAUFFEUR = t.CLE_CHAUFFEUR";
            sql = String.valueOf(sql) + " ORDER BY NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, DATE_TELECHARGEMENT";
            Statement stm = CardDownload.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                Conducteur tmp = new Conducteur(rs.getInt("CLE_CHAUFFEUR"), rs.getString("NOM_CONDUCTEUR"), rs.getString("PRENOM_CONDUCTEUR"));
                tmp.setCleAgence(rs.getInt("CLE_AGENCE"));
                tmp.setNumeroCarte(rs.getString("NUM_CARTE_CHAUFFEUR"));
                result.add(new CardDownload(tmp, rs.getInt("CLE_USER"), rs.getString("DATE_TELECHARGEMENT"), rs.getString("NOM_FICHIER")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("getAllTelechargement()# sql = " + sql + " - " + ex.getMessage());
        }
        return result;
    }

    public static boolean exists(String fileName) {
        boolean toReturn = false;
        String sql = "";
        try {
            sql = "SELECT NOM_FICHIER FROM t_telechargement WHERE NOM_FICHIER='" + fileName + "'";
            Statement stm = CardDownload.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            if (rs.next()) {
                toReturn = true;
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("exists()# sql = " + sql + " - " + ex.getMessage());
        }
        return toReturn;
    }
}

