/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;

public class ClosePayPeriod
extends MainElement {
    public static final String table = "CLOSE_PAY_PERIOD";
    public static final int AGENCY_AND_REGION = 0;
    public static final int AGENCY_ONLY = 1;
    public static final int REGION_ONLY = 2;
    private int id = 0;
    private int payPeriodId = 0;
    private int agencyId = 0;
    private int userId = 0;
    private int cloture = 0;
    private int exported = 0;
    private Date clotureDate = null;
    private int active = 0;

    public ClosePayPeriod() {
    }

    public ClosePayPeriod(int id, int payPeriodId, int agencyId, int userId, int cloture, int exported, Date clotureDate, int active) {
        this.id = id;
        this.payPeriodId = payPeriodId;
        this.agencyId = agencyId;
        this.userId = userId;
        this.cloture = cloture;
        this.exported = exported;
        this.clotureDate = clotureDate;
        this.active = active;
    }

    public boolean update() {
        this.affiche();
        if (this.id != 0) {
            return this.updateValue();
        }
        return this.insert();
    }

    public void affiche() {
        TimsLogger.info("#GCD.affiche()# id period " + this.payPeriodId + ", id agency " + this.agencyId + ",  day = " + this.clotureDate);
    }

    public boolean insert() {
        String sql = "";
        try {
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO CLOSE_PAY_PERIOD(ID, PAY_PERIOD_ID, AGENCY_ID, USER_ID, CLOTURE, EXPORTED, CLOTURE_DATE, ACTIVE) VALUES (GEN_CALENDAR_DAY.nextval,?,?,?,?,?,?,?)";
                this.statement = ClosePayPeriod.getConnection().prepareStatement(sql);
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO CLOSE_PAY_PERIOD(PAY_PERIOD_ID, AGENCY_ID, USER_ID, CLOTURE, EXPORTED, CLOTURE_DATE, ACTIVE) VALUES (?,?,?,?,?,?,?)";
                this.statement = ClosePayPeriod.getConnection().prepareStatement(sql, 1);
            }
            this.statement.setObject(1, (Object)this.payPeriodId, 4);
            this.statement.setObject(2, (Object)this.agencyId, 4);
            this.statement.setObject(3, (Object)this.userId, 4);
            this.statement.setObject(4, (Object)this.cloture, 4);
            this.statement.setObject(5, (Object)this.exported, 4);
            this.statement.setDate(6, new java.sql.Date(this.clotureDate.getTime()));
            this.statement.setObject(7, (Object)this.active, 4);
            this.statement.executeUpdate();
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            TimsLogger.error("insert()# sql = " + sql + " => " + e);
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    private boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT MAX(ID) as ID FROM CLOSE_PAY_PERIOD WHERE PAY_PERIOD_ID = ? AND AGENCY_ID = ?";
        try {
            try {
                this.statement = ClosePayPeriod.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.payPeriodId, 4);
                this.statement.setObject(2, (Object)this.agencyId, 4);
                rs = this.statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("ID");
                    TimsLogger.debug("#ClosePayPeriod.loadId# id found " + rs.getInt("ID"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.error("loadId()# sql = " + sql + " => " + ex);
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean delete() {
        String sql = "DELETE FROM CLOSE_PAY_PERIOD WHERE CLE= ?";
        try {
            this.statement = ClosePayPeriod.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.error("delete()# sql = " + sql + " => " + ex);
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public boolean compareAndUpdate(int agencyId, int payPeriodId, int userId, int cloture, int exported, Date clotureDate, int active) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.closePayPeriod")) + " n\u00b0 " + this.id + "\n";
        if (agencyId != this.agencyId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.agency") + " '" + this.agencyId + "' => '" + agencyId + "'\n";
            this.setAgencyId(agencyId);
        }
        if (payPeriodId != this.payPeriodId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.payPeriod") + " '" + this.payPeriodId + "' => '" + payPeriodId + "'\n";
            this.setPayPeriodId(payPeriodId);
        }
        if (userId != this.userId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.user") + " '" + this.userId + "' => '" + userId + "'\n";
            this.setUserId(userId);
        }
        if (cloture != this.cloture) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("payPeriod.close") + " '" + this.cloture + "' => '" + cloture + "'\n";
            this.setCloture(cloture);
        }
        if (exported != this.exported) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("payPeriod.close") + " '" + this.exported + "' => '" + exported + "'\n";
            this.setExported(exported);
        }
        if (active != this.active) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.active") + " '" + this.active + "' => '" + active + "'\n";
            this.setActive(active);
        }
        if (!this.clotureDate.equals(clotureDate)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.date") + " '" + this.clotureDate + "' => '" + clotureDate + "'\n";
            this.setClotureDate(clotureDate);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.closePayPeriod")) + " n\u00b0 " + this.id + "\n")) {
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
            return this.updateValue();
        }
        return true;
    }

    public boolean updateValue() {
        String sql = "UPDATE CLOSE_PAY_PERIOD SET  PAY_PERIOD_ID = ? , AGENCY_ID = ? , USER_ID = ? ,  CLOTURE = ? , EXPORTED = ? , CLOTURE_DATE = ?, ACTIVE = ? WHERE ID= ?";
        try {
            this.statement = ClosePayPeriod.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.payPeriodId, 4);
            this.statement.setObject(2, (Object)this.agencyId, 4);
            this.statement.setObject(3, (Object)this.userId, 4);
            this.statement.setObject(4, (Object)this.cloture, 4);
            this.statement.setObject(5, (Object)this.exported, 4);
            this.statement.setDate(6, new java.sql.Date(this.clotureDate.getTime()));
            this.statement.setObject(7, (Object)this.active, 4);
            this.statement.setObject(8, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.error("updateValue()# sql = " + sql + " => " + ex);
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public int getPayPeriodId() {
        return this.payPeriodId;
    }

    public void setPayPeriodId(int calendarId) {
        this.payPeriodId = calendarId;
    }

    public int getAgencyId() {
        return this.agencyId;
    }

    public void setAgencyId(int dayTypeId) {
        this.agencyId = dayTypeId;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getCloture() {
        return this.cloture;
    }

    public void setCloture(int clotureLevel) {
        this.cloture = clotureLevel;
    }

    public int getExported() {
        return this.exported;
    }

    public void setExported(int exported) {
        this.exported = exported;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public Date getClotureDate() {
        return this.clotureDate;
    }

    public void setClotureDate(Date clotureDate) {
        this.clotureDate = clotureDate;
    }

    public int getActive() {
        return this.active;
    }

    public void setActive(int active) {
        this.active = active;
    }

    public static Vector<ClosePayPeriod> loadList(int agencyId, int payPeriodId, Date begin, Date end) {
        Vector<ClosePayPeriod> toReturn;
        block31: {
            toReturn = new Vector<ClosePayPeriod>();
            ResultSet rs = null;
            String sql = "SELECT ID, PAY_PERIOD_ID, AGENCY_ID, USER_ID, CLOTURE, EXPORTED, CLOTURE_DATE, ACTIVE FROM CLOSE_PAY_PERIOD";
            if (begin != null) {
                sql = String.valueOf(sql) + " JOIN PAY_PERIOD ON PAY_PERIOD_ID = PAY_PERIOD.ID";
            }
            String restriction = "";
            if (agencyId != 0) {
                restriction = String.valueOf(restriction) + " AND AGENCY_ID = ?";
            }
            if (payPeriodId != 0) {
                restriction = String.valueOf(restriction) + " AND PAY_PERIOD_ID = ?";
            }
            if (begin != null) {
                restriction = end == null ? String.valueOf(restriction) + " AND BEGIN = ?" : String.valueOf(restriction) + " AND BEGIN BETWEEN ? AND ?";
            }
            if (!restriction.equals("")) {
                sql = String.valueOf(sql) + " WHERE " + restriction.substring(5);
            }
            sql = String.valueOf(sql) + " ORDER BY AGENCY_ID";
            PreparedStatement stm = null;
            try {
                stm = ClosePayPeriod.getConnection().prepareStatement(sql);
                int index = 1;
                if (agencyId != 0) {
                    stm.setObject(index, (Object)agencyId, 12);
                    ++index;
                }
                if (payPeriodId != 0) {
                    stm.setObject(index, (Object)payPeriodId, 12);
                    ++index;
                }
                if (begin != null) {
                    stm.setDate(index, new java.sql.Date(begin.getTime()));
                    ++index;
                }
                if (end != null) {
                    stm.setDate(index, new java.sql.Date(end.getTime()));
                    ++index;
                }
                rs = stm.executeQuery();
                while (rs.next()) {
                    toReturn.add(new ClosePayPeriod(rs.getInt("ID"), rs.getInt("PAY_PERIOD_ID"), rs.getInt("AGENCY_ID"), rs.getInt("USER_ID"), rs.getInt("CLOTURE"), rs.getInt("EXPORTED"), rs.getDate("CLOTURE_DATE"), rs.getInt("ACTIVE")));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                    break block31;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                break block31;
            }
            catch (SQLException ex) {
                try {
                    TimsLogger.error("loadList()# sql = " + sql + " => " + ex);
                    break block31;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stm != null) {
                            stm.close();
                        }
                    }
                    catch (Exception ex3) {
                        ex3.printStackTrace();
                    }
                }
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        TimsLogger.debug("ClosePayPeriod.loadList# agencyId " + agencyId + " payPeriodId " + payPeriodId + " return " + toReturn.size());
        return toReturn;
    }

    public static Vector<ClosePayPeriod> loadTdoExportList(int agencyId, int payPeriod) {
        Vector<ClosePayPeriod> toReturn = new Vector<ClosePayPeriod>();
        ResultSet rs = null;
        String sql = "SELECT ID, PAY_PERIOD_ID, AGENCY_ID, USER_ID, CLOTURE, EXPORTED, CLOTURE_DATE FROM CLOSE_PAY_PERIOD WHERE EXPORTED=0";
        if (agencyId != 0) {
            sql = String.valueOf(sql) + "  AND AGENCY_ID = ?";
        }
        if (payPeriod != 0) {
            sql = String.valueOf(sql) + "  AND PAY_PERIOD_ID = ?";
        }
        sql = String.valueOf(sql) + " ORDER BY AGENCY_ID";
        PreparedStatement stm = null;
        try {
            try {
                int paramCounter = 1;
                stm = ClosePayPeriod.getConnection().prepareStatement(sql);
                if (agencyId != 0) {
                    stm.setObject(paramCounter, (Object)agencyId, 12);
                    ++paramCounter;
                }
                if (payPeriod != 0) {
                    stm.setObject(2, (Object)payPeriod, 12);
                }
                rs = stm.executeQuery();
                while (rs.next()) {
                    toReturn.add(new ClosePayPeriod(rs.getInt("ID"), rs.getInt("PAY_PERIOD_ID"), rs.getInt("AGENCY_ID"), rs.getInt("USER_ID"), rs.getInt("CLOTURE"), rs.getInt("EXPORTED"), rs.getDate("CLOTURE_DATE"), rs.getInt("EXPORTED")));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("loadList()# sql = " + sql + " => " + ex);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public static boolean isClosed(int agencyId, Date date) {
        String sql;
        boolean toReturn;
        block22: {
            toReturn = false;
            ResultSet rs = null;
            sql = "SELECT CLOTURE FROM CLOSE_PAY_PERIOD JOIN PAY_PERIOD ON PAY_PERIOD_ID=PAY_PERIOD.ID WHERE ACTIVE = 1 AND AGENCY_ID = ? AND BEGIN <= ? AND END >= ?";
            PreparedStatement stm = null;
            try {
                stm = ClosePayPeriod.getConnection().prepareStatement(sql);
                stm.setObject(1, (Object)agencyId, 4);
                stm.setDate(2, new java.sql.Date(date.getTime()));
                stm.setDate(3, new java.sql.Date(date.getTime()));
                rs = stm.executeQuery();
                while (rs.next()) {
                    if (rs.getInt("CLOTURE") != 1) continue;
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                    break block22;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                break block22;
            }
            catch (SQLException ex) {
                try {
                    TimsLogger.error("isClosed()# sql = " + sql + " => " + ex);
                    break block22;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stm != null) {
                            stm.close();
                        }
                    }
                    catch (Exception ex3) {
                        ex3.printStackTrace();
                    }
                }
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        TimsLogger.debug("#CPP.isClosed()# date : " + date + " agence : " + agencyId + " => return " + toReturn + " (sql = " + sql + ")");
        return toReturn;
    }

    public static boolean addAgency(int agencyId) {
        boolean toReturn = false;
        ResultSet rs = null;
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO CLOSE_PAY_PERIOD(ID, PAY_PERIOD_ID, AGENCY_ID,USER_ID, CLOTURE, EXPORTED, CLOTURE_DATE, ACTIVE) SELECT GEN_CALENDAR_DAY.nextval,ID,?,?,1,1,?,1 FROM PAY_PERIOD WHERE END < ?";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO CLOSE_PAY_PERIOD(PAY_PERIOD_ID, AGENCY_ID, USER_ID, CLOTURE, EXPORTED, CLOTURE_DATE, ACTIVE) SELECT ID, ?,?,1,1,?,1 FROM PAY_PERIOD WHERE END < ?";
        }
        PreparedStatement stm = null;
        try {
            try {
                stm = ClosePayPeriod.getConnection().prepareStatement(sql);
                stm.setObject(1, (Object)agencyId, 4);
                stm.setObject(2, (Object)ConnexionSettings.getInstance().getUserCle(), 4);
                stm.setDate(3, new java.sql.Date(new Date().getTime()));
                stm.setDate(4, new java.sql.Date(new Date().getTime()));
                int ret = stm.executeUpdate();
                if (ret != 0) {
                    TimsLogger.warn("#CPP.addAgency()# " + ret + " cl\u00f4tures ins\u00e9r\u00e9es");
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("addAgency()# sql = " + sql + " => " + ex);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }
}

