/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.SQLException;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class Comment
extends MainElement {
    public static final int OFFSET = 117;
    private int id = 0;
    private int driverId = 0;
    private String date = null;
    private String designation = null;
    private boolean mailed = false;

    public Comment() {
    }

    public Comment(int cle, int cleConducteur, String date, String designation, boolean mailed) {
        this.id = cle;
        this.driverId = cleConducteur;
        this.date = date;
        this.designation = designation;
        this.mailed = mailed;
    }

    public boolean insert() {
        String sql = "";
        TimsLogger.info("#CardDownload.insert()");
        this.affiche();
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO t_lien_jour_commass (CLE_LIEN_JOUR_COMMASS,CLE_CHAUFFEUR, DATE_JOUR, COMM_ASS) VALUES (GEN_T_LIEN_JOUR_COMMASS.nextval,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO t_lien_jour_commass (CLE_CHAUFFEUR, DATE_JOUR, COMM_ASS) VALUES (?,?,?)";
        }
        try {
            this.statement = Comment.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.driverId, 4);
            this.statement.setDate(2, Date.valueOf(this.date));
            this.statement.setObject(3, (Object)this.designation, 12);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent("t_lien_jour_commass", Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean updateValue() {
        String sql = "UPDATE t_lien_jour_commass SET  CLE_CHAUFFEUR=? , DATE_JOUR=? , DESIGNATION=? WHERE CLE_LIEN_JOUR_COMMASS = ?";
        try {
            this.statement = Comment.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.driverId, 4);
            this.statement.setDate(2, Date.valueOf(this.date));
            this.statement.setObject(3, (Object)this.designation, 12);
            this.statement.setObject(4, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent("t_lien_jour_commass", Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean delete() {
        String sql = "DELETE FROM t_lien_jour_commass WHERE CLE=?";
        try {
            this.statement = Comment.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.id);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent("t_lien_jour_commass", Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public String getDesignation() {
        return this.designation;
    }

    public void setDesignation(String designation) {
        this.designation = designation;
    }

    public void affiche() {
        TimsLogger.info("#Comment.affiche# " + this.designation);
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int cleConducteur) {
        this.driverId = cleConducteur;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public boolean isMailed() {
        return this.mailed;
    }

    public void setMailed(boolean mailed) {
        this.mailed = mailed;
    }

    public byte[] write(OutputStream out) {
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            String activite = String.valueOf(ConversionTime.dateStringToBinary(this.date)) + "000";
            int x = 0;
            while (x < 2) {
                tmp.write(Integer.parseInt(activite.substring(x * 8, (x + 1) * 8), 2));
                ++x;
            }
            if (this.designation != null) {
                tmp.write(this.designation.getBytes());
            }
            out.write(117);
            out.write((byte)(tmp.size() / 255 + 1));
            out.write((byte)tmp.size());
            tmp.writeTo(out);
            return tmp.toByteArray();
        }
        catch (Exception ex) {
            TimsLogger.error("write()#  => " + ex);
            return null;
        }
    }

    public void read(byte[] fileBuffer) {
        int x = 0;
        String tmp = "";
        while (x < 2) {
            tmp = String.valueOf(tmp) + Integer.toBinaryString(256 + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x])).substring(1);
            TimsLogger.debug("#Comment.read#" + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x]) + " => " + tmp.substring(x * 8));
            ++x;
        }
        this.date = ConversionTime.binaryToDateString(tmp);
        this.designation = new String(fileBuffer).substring(2);
    }
}

