/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class CompanyCard
extends MainElement {
    private static final String table = "COMPANY_CARD";
    private int id = 0;
    private int agencyId = 0;
    private String cardNumber = null;
    private int memberState = 17;
    private Date issueDate = null;
    private Date validityBegin = null;
    private Date expiryDate;
    private String companyName = null;
    private String companyAddress = null;
    private int preferredLanguage = 0;
    private boolean archived = false;
    private String owner = null;

    public CompanyCard() {
    }

    public CompanyCard(int id, int agencyId, String cardNumber, int memberState, Date issueDate, Date validityBegin, Date expiryDate, String companyName, String companyAddress, int preferredLanguage, boolean archived, String owner) {
        this.id = id;
        this.agencyId = agencyId;
        this.cardNumber = cardNumber;
        this.memberState = memberState;
        this.issueDate = issueDate;
        this.validityBegin = validityBegin;
        this.expiryDate = expiryDate;
        this.companyName = companyName;
        this.companyAddress = companyAddress;
        this.preferredLanguage = preferredLanguage;
        this.archived = archived;
        this.owner = owner;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getAgencyId() {
        return this.agencyId;
    }

    public void setAgencyId(int agencyId) {
        this.agencyId = agencyId;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public int getMemberState() {
        return this.memberState;
    }

    public void setMemberState(int memberState) {
        this.memberState = memberState;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public Date getValidityBegin() {
        return this.validityBegin;
    }

    public void setValidityBegin(Date validityBegin) {
        this.validityBegin = validityBegin;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getCompanyAddress() {
        return this.companyAddress;
    }

    public void setCompanyAddress(String companyAddress) {
        this.companyAddress = companyAddress;
    }

    public int getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public void setPreferredLanguage(int preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        try {
            try {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO COMPANY_CARD(ID, AGENCY_ID, CARD_NUMBER, MEMBER_STATE, ISSUE_DATE, VALIDITY_BEGIN, EXPIRY, COMPANY_NAME, COMPANY_ADDRESS, PREFERRED_LANGUAGE, ARCHIVED, OWNER) VALUES (GEN_COMPANY_CARD.nextval,?,?,?,?,?,?,?,?,?,?,?)";
                    this.statement = CompanyCard.getConnection().prepareStatement(sql);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO COMPANY_CARD(AGENCY_ID, CARD_NUMBER, MEMBER_STATE, ISSUE_DATE, VALIDITY_BEGIN, EXPIRY, COMPANY_NAME, COMPANY_ADDRESS, PREFERRED_LANGUAGE, ARCHIVED, OWNER) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
                    this.statement = CompanyCard.getConnection().prepareStatement(sql, 1);
                }
                this.statement.setObject(1, (Object)this.agencyId, 4);
                this.statement.setObject(2, (Object)this.cardNumber, 12);
                this.statement.setObject(3, (Object)this.memberState, 4);
                this.statement.setDate(4, new java.sql.Date(this.issueDate.getTime()));
                this.statement.setDate(5, new java.sql.Date(this.validityBegin.getTime()));
                this.statement.setDate(6, new java.sql.Date(this.expiryDate.getTime()));
                this.statement.setObject(7, (Object)this.companyAddress, 12);
                this.statement.setObject(8, (Object)this.companyName, 12);
                this.statement.setObject(9, (Object)this.preferredLanguage, 4);
                this.statement.setObject(10, (Object)(this.archived ? 1 : 0), 4);
                this.statement.setObject(11, (Object)this.owner, 12);
                this.statement.executeUpdate();
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    ResultSet rs = this.statement.getGeneratedKeys();
                    if (!rs.next()) {
                        TimsLogger.warn("#CompanyCard.insert# no auto generated key availaible");
                    } else {
                        TimsLogger.debug("#CompanyCard.insert# auto generated key value = " + rs.getInt(1));
                        this.id = rs.getInt(1);
                    }
                    rs.close();
                }
                if (this.id == 0) {
                    if (this.loadId()) {
                        TimsLogger.debug("#CompanyCard.insert# generated key value = " + this.id);
                    } else {
                        TimsLogger.warn("#CompanyCard.insert# no generated key availaible");
                    }
                }
                String tracer = String.valueOf(LanguageTranslator.getString("card.company")) + " n\u00b0 " + this.id + " (" + this.getCardNumber() + ") \n";
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT MAX(ID) AS ID FROM COMPANY_CARD";
        try {
            try {
                Statement statement = CompanyCard.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    this.id = rs.getInt("ID");
                    TimsLogger.debug("#CompanyCard.loadId# id found " + rs.getInt("ID"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.error("loadId()# sql = " + sql + " => " + ex);
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean delete() {
        String sql = "DELETE FROM COMPANY_CARD WHERE ID= ?";
        try {
            this.statement = CompanyCard.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public boolean compareAndUpdate(String cardNumber, int agencyId, int memberState, Date issueDate, Date validityBegin, Date expiryDate, String companyAddress, String companyName, int preferredLanguage, boolean archived, String owner) {
        String tracer = String.valueOf(LanguageTranslator.getString("card.company")) + " n\u00b0 " + this.id + " (" + this.getCardNumber() + ") \n";
        if (Fonctions.fieldChange(cardNumber, this.cardNumber)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.cardNumber") + " '" + this.cardNumber + "' => '" + cardNumber + "'\n";
            this.setCardNumber(cardNumber);
        }
        if (agencyId != this.agencyId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.agency") + " '" + this.agencyId + "' => '" + agencyId + "'\n";
            this.setAgencyId(agencyId);
        }
        if (memberState != this.memberState) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.memberState") + " '" + this.memberState + "' => '" + memberState + "'\n";
            this.setMemberState(memberState);
        }
        if (Fonctions.fieldChange(issueDate, this.issueDate)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.delivery") + " '" + this.issueDate + "' => '" + issueDate + "'\n";
            this.setIssueDate(issueDate);
        }
        if (Fonctions.fieldChange(validityBegin, this.validityBegin)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.validityBegin") + " '" + this.validityBegin + "' => '" + validityBegin + "'\n";
            this.setValidityBegin(validityBegin);
        }
        if (Fonctions.fieldChange(expiryDate, this.expiryDate)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.expiry") + " '" + this.expiryDate + "' => '" + expiryDate + "'\n";
            this.setExpiryDate(expiryDate);
        }
        if (Fonctions.fieldChange(companyAddress, this.companyAddress)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.companyAddress") + " '" + this.companyAddress + "' => '" + companyAddress + "'\n";
            this.setCompanyAddress(companyAddress);
        }
        if (Fonctions.fieldChange(companyName, this.companyName)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.companyName") + " '" + this.companyName + "' => '" + companyName + "'\n";
            this.setCompanyName(companyName);
        }
        if (preferredLanguage != this.preferredLanguage) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.preferredLanguage") + " '" + this.preferredLanguage + "' => '" + preferredLanguage + "'\n";
            this.setPreferredLanguage(preferredLanguage);
        }
        if (archived != this.archived) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.archived") + " '" + this.archived + "' => '" + archived + "'\n";
            this.setArchived(archived);
        }
        if (Fonctions.fieldChange(owner, this.owner)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.owner") + " '" + this.owner + "' => '" + owner + "'\n";
            this.setOwner(owner);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("card.company")) + " n\u00b0 " + this.id + " (" + this.getCardNumber() + ") \n")) {
            if (this.update()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#TypeActivite# no changes");
        return true;
    }

    public boolean update() {
        String sql = "UPDATE COMPANY_CARD SET  AGENCY_ID = ? , CARD_NUMBER = ? , MEMBER_STATE = ?,  ISSUE_DATE = ? , VALIDITY_BEGIN = ?, EXPIRY = ?,  COMPANY_NAME = ? , COMPANY_ADDRESS = ? , PREFERRED_LANGUAGE = ?,  ARCHIVED = ?,  OWNER = ?  WHERE ID= ?";
        try {
            this.statement = CompanyCard.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.agencyId, 4);
            this.statement.setObject(2, (Object)this.cardNumber, 12);
            this.statement.setObject(3, (Object)this.memberState, 4);
            this.statement.setDate(4, new java.sql.Date(this.issueDate.getTime()));
            this.statement.setDate(5, new java.sql.Date(this.validityBegin.getTime()));
            this.statement.setDate(6, new java.sql.Date(this.expiryDate.getTime()));
            this.statement.setObject(7, (Object)this.companyName, 12);
            this.statement.setObject(8, (Object)this.companyAddress, 12);
            this.statement.setObject(9, (Object)this.preferredLanguage, 4);
            this.statement.setObject(10, (Object)(this.archived ? 1 : 0), 4);
            this.statement.setObject(11, (Object)this.owner, 12);
            this.statement.setObject(12, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public static Vector<CompanyCard> loadList(int ... agenciesId) {
        String restrict;
        Vector<CompanyCard> liste = new Vector<CompanyCard>();
        String sql = "SELECT ID, AGENCY_ID, CARD_NUMBER, MEMBER_STATE, ISSUE_DATE, VALIDITY_BEGIN, EXPIRY, COMPANY_NAME, COMPANY_ADDRESS, PREFERRED_LANGUAGE, ARCHIVED, OWNER FROM COMPANY_CARD";
        String restriction = "";
        if (agenciesId.length != 0) {
            String agencies = "";
            int[] nArray = agenciesId;
            int n = agenciesId.length;
            int n2 = 0;
            while (n2 < n) {
                int agencyId = nArray[n2];
                agencies = String.valueOf(agencies) + "," + agencyId;
                ++n2;
            }
            restriction = String.valueOf(restriction) + " AND AGENCY_ID IN (" + agencies.substring(1) + ")";
        }
        if ((restrict = BddTransport.addNewRestriction(table, true, null, false)) != "") {
            restriction = String.valueOf(restriction) + " AND " + restrict;
        }
        if ((restriction = String.valueOf(restriction) + " AND ARCHIVED = " + (MainFrameTransport.archivage ? "1" : "0")) != "") {
            sql = String.valueOf(sql) + " WHERE " + restriction.substring(5);
        }
        sql = String.valueOf(sql) + " ORDER BY CARD_NUMBER";
        try {
            ResultSet rs = null;
            Statement stm = CompanyCard.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                CompanyCard toAdd = new CompanyCard(rs.getInt("ID"), rs.getInt("AGENCY_ID"), rs.getString("CARD_NUMBER"), rs.getInt("MEMBER_STATE"), new Date(rs.getDate("ISSUE_DATE").getTime()), new Date(rs.getDate("VALIDITY_BEGIN").getTime()), new Date(rs.getDate("EXPIRY").getTime()), rs.getString("COMPANY_NAME"), rs.getString("COMPANY_ADDRESS"), rs.getInt("PREFERRED_LANGUAGE"), rs.getBoolean("ARCHIVED"), rs.getString("OWNER"));
                liste.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("loadList()# sql = " + sql + " => " + ex);
        }
        return liste;
    }

    public static CompanyCard find(Vector<CompanyCard> ccList, String cardNumber, int memberState) {
        for (CompanyCard tmp : ccList) {
            if (tmp.getCardNumber() == null || tmp.getCardNumber().length() < 14 || !tmp.getCardNumber().substring(0, 14).equals(cardNumber.substring(0, 14)) || memberState != -1 && memberState != tmp.getMemberState()) continue;
            return tmp;
        }
        return null;
    }
}

