/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.AutomaticWarning;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class CompanyWarningActivation
extends MainElement {
    public static final String table = "COMPANY_WARNING_ACTIVATION";
    private int id = 0;
    private int autoWarningId = 0;
    private int companyId = 0;

    public CompanyWarningActivation(int id, int autoWarningId, int companyId) {
        this.id = id;
        this.autoWarningId = autoWarningId;
        this.companyId = companyId;
    }

    public boolean equals(Object obj) {
        return obj instanceof CompanyWarningActivation && ((CompanyWarningActivation)obj).getAutoWarningId() == this.autoWarningId && ((CompanyWarningActivation)obj).getCompanyId() == this.companyId;
    }

    public int hashCode() {
        return Integer.valueOf(this.companyId).hashCode() + Integer.valueOf(this.autoWarningId).hashCode();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getAutoWarningId() {
        return this.autoWarningId;
    }

    public void setAutoWarningId(int autoWarningId) {
        this.autoWarningId = autoWarningId;
    }

    public int getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(int companyId) {
        this.companyId = companyId;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean retour = false;
        Statement statement = null;
        String sql = null;
        try {
            try {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO COMPANY_WARNING_ACTIVATION(ID, ID_WARNING, ID_COMPANY) VALUES (GEN_COMPANY_WARNING_ACTIVATION.nextval,?,?)";
                } else if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + "(ID_WARNING, ID_COMPANY) VALUES " + "(?,?)";
                }
                statement = CompanyWarningActivation.getConnection().prepareStatement(sql);
                statement.setObject(1, this.autoWarningId, 4);
                statement.setObject(2, this.companyId, 4);
                if (statement.executeUpdate() == 1) {
                    retour = true;
                }
                statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean updateValue() {
        boolean retour = false;
        String sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET " + " ID_WARNING=?, " + " ID_COMPANY=? " + " WHERE ID=?";
        try {
            try {
                this.statement = CompanyWarningActivation.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.autoWarningId, 4);
                this.statement.setObject(2, (Object)this.companyId, 4);
                this.statement.setObject(7, (Object)this.id, 4);
                if (this.statement.executeUpdate() == 1) {
                    retour = true;
                }
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean delete() {
        String sql = "DELETE FROM " + BddTransport.getBaseDefault(true) + table + " WHERE ID =?";
        try {
            this.statement = CompanyWarningActivation.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.id);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public static boolean multipleCreate(int companyId, Vector<AutomaticWarning> toUpdate) {
        BddTransport.getInstance().startTransaction();
        for (AutomaticWarning iter : toUpdate) {
            if (new CompanyWarningActivation(0, iter.getId(), companyId).insert()) continue;
            BddTransport.getInstance().rollback();
            return false;
        }
        BddTransport.getInstance().commit();
        return true;
    }

    public static boolean multipleDelete(int companyId, Vector<AutomaticWarning> toDelete) {
        boolean toReturn = false;
        String where = "";
        if (toDelete != null) {
            for (AutomaticWarning iter : toDelete) {
                where = String.valueOf(where) + "," + iter.getId();
            }
        }
        String sql = "DELETE FROM " + BddTransport.getBaseDefault(true) + table;
        if (!where.equals("")) {
            sql = String.valueOf(sql) + " WHERE ID_WARNING IN (" + where.substring(1) + ")";
        }
        Statement stm = null;
        try {
            try {
                stm = CompanyWarningActivation.getConnection().createStatement();
                stm.executeUpdate(sql);
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public static ArrayList<CompanyWarningActivation> getList(int companyId) {
        ArrayList<CompanyWarningActivation> toReturn = new ArrayList<CompanyWarningActivation>();
        String sql = "SELECT * FROM " + BddTransport.getBaseDefault(true) + table;
        if (companyId != -1) {
            sql = String.valueOf(sql) + " WHERE ID_COMPANY = " + companyId;
        }
        TimsLogger.debug("#CWA.getList# soci\u00e9t\u00e9 : " + companyId + " => " + sql);
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                stm = CompanyWarningActivation.getConnection().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    toReturn.add(new CompanyWarningActivation(rs.getInt("ID"), rs.getInt("ID_WARNING"), rs.getInt("ID_COMPANY")));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }
}

