/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Constants;

public class Configuration
extends MainElement {
    public static final String table = "configuration";
    private int id = 0;
    private String value = null;
    private String eval = null;
    private boolean enabled = false;
    private boolean editable = false;
    private boolean general = false;

    public Configuration(boolean general) {
        this.general = general;
    }

    public Configuration(boolean general, int key, String value, String eval, boolean enabled, boolean editable) {
        this.general = general;
        this.id = key;
        this.value = value;
        this.eval = eval;
        this.enabled = enabled;
        this.editable = editable;
    }

    public Configuration(String value, boolean general) {
        this.general = general;
        this.load(value);
    }

    public String toString() {
        return String.valueOf(this.value) + " => " + this.eval;
    }

    public void update() {
        String sql = "UPDATE " + (this.general ? BddTransport.getBaseDefault(true) : "") + table + " SET EVAL=?," + " ENABLED=?, " + " EDITABLE=?" + " WHERE VALUE=?";
        try {
            this.statement = Configuration.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.eval, 12);
            this.statement.setObject(2, (Object)(this.enabled ? 1 : 0), 4);
            this.statement.setObject(3, (Object)(this.editable ? 1 : 0), 4);
            this.statement.setObject(4, (Object)this.value, 12);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void insert() {
        try {
            String sql = "";
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO " + (this.general ? BddTransport.getBaseDefault(true) : "") + table + " (" + Configuration.getAllFields() + ")" + " VALUES (GEN_EMPLOYEE_OBLIGATION.nextval,?,?,?,?)";
                this.statement = Configuration.getConnection().prepareStatement(sql);
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO " + (this.general ? BddTransport.getBaseDefault(true) : "") + table + " (" + Configuration.getAllFields().substring(Configuration.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?)";
                this.statement = Configuration.getConnection().prepareStatement(sql, 1);
            }
            this.statement.setObject(1, (Object)this.value, 12);
            this.statement.setObject(2, (Object)this.eval, 12);
            this.statement.setObject(3, (Object)(this.enabled ? 1 : 0), 4);
            this.statement.setObject(4, (Object)(this.editable ? 1 : 0), 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean load(String value) {
        String sql;
        boolean toReturn;
        block24: {
            toReturn = false;
            ResultSet rs = null;
            sql = "SELECT * FROM " + (this.general ? BddTransport.getBaseDefault(true) : "") + table + " WHERE value=?";
            try {
                this.statement = Configuration.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)value, 12);
                rs = this.statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("id");
                    this.value = rs.getString("value");
                    this.eval = rs.getString("eval");
                    this.enabled = rs.getBoolean("enabled");
                    this.editable = rs.getBoolean("editable");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    this.statement.close();
                    if (rs != null) {
                        rs.close();
                    }
                    break block24;
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
                break block24;
            }
            catch (SQLException ex) {
                try {
                    sql = "SELECT id, value, eval, enabled FROM " + BddTransport.getBaseDefault(true) + table + " WHERE value=?";
                    try {
                        this.statement = Configuration.getConnection().prepareStatement(sql);
                        this.statement.setObject(1, (Object)value, 12);
                        rs = this.statement.executeQuery();
                        while (rs.next()) {
                            this.id = rs.getInt("id");
                            this.value = rs.getString("value");
                            this.eval = rs.getString("eval");
                            this.enabled = rs.getBoolean("enabled");
                            this.editable = false;
                            toReturn = true;
                        }
                        break block24;
                    }
                    catch (CommunicationsException e) {
                        BddTransport.getInstance().showTimeout();
                    }
                    catch (SQLException e) {
                        TimsLogger.error("load()# sql = " + sql + " => " + e.getMessage());
                    }
                    break block24;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        this.statement.close();
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException ex3) {
                        ex3.printStackTrace();
                    }
                }
            }
            try {
                this.statement.close();
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        if (!toReturn) {
            TimsLogger.warn("#Cofiguration.load# " + value + " not found (" + sql + ")");
        }
        return toReturn;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String getEval() {
        return this.eval;
    }

    public void setEval(String eval) {
        this.eval = eval;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    private static String getAllFields() {
        return "id, value, eval, enabled, editable";
    }

    public static Vector<Configuration> loadList(String companyBaseName, boolean fillProperty) {
        Vector<Configuration> toReturn = new Vector<Configuration>();
        ResultSet rs = null;
        String sql = "SELECT id, value, eval, enabled, editable FROM ";
        if (companyBaseName != null) {
            sql = String.valueOf(sql) + companyBaseName + ".";
        }
        sql = String.valueOf(sql) + table;
        if ("tims".equals(companyBaseName)) {
            sql = String.valueOf(sql) + " WHERE user_id in (0," + ConnexionSettings.getInstance().getUserCle() + ")";
        }
        sql = String.valueOf(sql) + " ORDER BY value";
        try {
            Statement stm = Configuration.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                toReturn.add(new Configuration(false, rs.getInt("id"), rs.getString("value"), rs.getString("eval"), rs.getBoolean("enabled"), rs.getBoolean("editable")));
                if (rs.getInt("enabled") != 1 || !fillProperty) continue;
                System.setProperty(rs.getString("value"), rs.getString("eval"));
            }
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.error("loadList()# sql = " + sql + " => " + ex.getMessage());
        }
        TimsLogger.debug("#Configuration.load# " + toReturn.size() + " param\u00e8tres de configuration charg\u00e9es." + (Transport.debug >= 2 ? toReturn + ". SQL = " + sql : ""));
        return toReturn;
    }

    public static boolean setCurrentVersion(String currentVersion) {
        String sql = "";
        Statement stm = null;
        try {
            sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET EVAL = \"" + currentVersion + "\"" + " WHERE VALUE=\"database_version\"";
            stm = Configuration.getConnection().createStatement();
            int rows = stm.executeUpdate(sql);
            TimsLogger.debug("sql = " + sql + " rows = " + rows);
            return rows == 1;
            {
            }
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("setCurrentVersion()# sql = " + sql + " => " + ex.getMessage());
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }
}

