/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Constants;

public class Connexion
extends MainElement {
    public static final String table = "connexion";
    private int cle = 0;
    private int cleUser = 0;
    private Timestamp connexion = new Timestamp(new Date().getTime());
    private Timestamp deconnexion = null;
    private boolean closed = false;

    public int getCleUser() {
        return this.cleUser;
    }

    public void setCleUser(int cleUser) {
        this.cleUser = cleUser;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public Timestamp getConnexion() {
        return this.connexion;
    }

    public void setConnexion(Timestamp connexion) {
        this.connexion = connexion;
    }

    public Timestamp getDeconnexion() {
        return this.deconnexion;
    }

    public void setDeconnexion(Timestamp deconnexion) {
        this.deconnexion = deconnexion;
    }

    public void insert() {
        try {
            TimsLogger.verbose("#Connexion.insert# insertion");
            this.statement = this.getPreparedStatement();
            this.statement.setObject(1, (Object)this.cleUser, 4);
            this.statement.setTimestamp(2, this.connexion);
            this.statement.setTimestamp(3, this.deconnexion);
            this.statement.setObject(4, (Object)(this.closed ? 1 : 0), 4);
            this.statement.setObject(5, (Object)Transport.res.getResourceString("executableVersion"), 12);
            this.statement.executeUpdate();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            TimsLogger.error("insert()# error => " + e.getMessage());
        }
    }

    public PreparedStatement getPreparedStatement() {
        if (this.statement == null) {
            String sql = "";
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + " (CLE, CLE_USER, CONNEXION, DECONNEXION, CLOSED, VERSION) " + "VALUES (GEN_CONNEXION.nextval,?,?,?,?,?)";
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO " + BddTransport.getBaseDefault(true) + table + " (CLE_USER, CONNEXION, DECONNEXION, CLOSED, VERSION) " + "VALUES (?,?,?,?,?)";
            }
            try {
                this.statement = Connexion.getConnection().prepareStatement(sql);
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
            }
            catch (Exception ex) {
                TimsLogger.error("getPreparedStatement()# sql = " + sql + " => " + ex.getMessage());
            }
        }
        return this.statement;
    }

    public void update() {
        String sql = "";
        sql = "UPDATE " + BddTransport.getBaseDefault(true) + table + " SET " + " DECONNEXION = ?, " + " CLOSED =  ?" + " WHERE CLE_USER = ?" + " AND CONNEXION = ?";
        try {
            this.statement = Connexion.getConnection().prepareStatement(sql);
            this.statement.setTimestamp(1, this.deconnexion);
            this.statement.setObject(2, (Object)(this.closed ? 1 : 0), 4);
            this.statement.setObject(3, (Object)this.cleUser, 4);
            this.statement.setTimestamp(4, this.connexion);
            this.statement.executeUpdate();
            this.statement.close();
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.deconnexion = new Timestamp(new Date().getTime());
        this.closed = true;
        this.update();
    }

    public static String getMaxVersion(int userId) {
        String toReturn = "0.0.0";
        String sql = "SELECT max(VERSION) as max  FROM " + BddTransport.getBaseDefault(true) + table + " WHERE CLE_USER = " + userId;
        try {
            ResultSet rs = null;
            Statement stm = Connexion.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                toReturn = rs.getString("max");
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("getMaxVersion()# sql = " + sql + " => " + ex.getMessage());
        }
        TimsLogger.info("#Connexion.getMaxVersion()# return " + toReturn);
        return toReturn;
    }
}

