/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class ConsumptionEvalCriteria
extends MainElement {
    public static final String table = "CONSUMPTION_CRITERIA";
    private static Vector<ConsumptionEvalCriteria> list = null;
    private int id = 0;
    private String name = "";

    public ConsumptionEvalCriteria() {
    }

    public ConsumptionEvalCriteria(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public boolean equals(Object o) {
        return o instanceof ConsumptionEvalCriteria && this.name == ((ConsumptionEvalCriteria)o).getName();
    }

    public Object clone() {
        return new ConsumptionEvalCriteria(this.id, this.name);
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + ConsumptionEvalCriteria.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = ConsumptionEvalCriteria.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.name = rs.getString("NAME");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("genericLoad()# sql = " + sql + " => " + ex.getMessage());
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.info("insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO CONSUMPTION_CRITERIA (" + ConsumptionEvalCriteria.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO CONSUMPTION_CRITERIA (" + ConsumptionEvalCriteria.getAllFields().substring(ConsumptionEvalCriteria.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?)";
        }
        try {
            this.statement = ConsumptionEvalCriteria.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.error("insert()# sql = " + sql + " => " + ex.getMessage());
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE CONSUMPTION_CRITERIA SET  NAME=?  WHERE ID=?";
        try {
            this.statement = ConsumptionEvalCriteria.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.error("updateValue()# sql = " + sql + " => " + ex.getMessage());
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private static String getAllFields() {
        return "ID, NAME";
    }

    public boolean compareAndUpdate(String name) {
        String tracer = String.valueOf(LanguageTranslator.getString("consumption.criteria")) + " n\u00b0 " + this.id + "\n";
        if (Fonctions.fieldChange(name, this.name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.name") + " '" + this.name + "' => '" + name + "'\n";
            this.setName(name);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("consumption.criteria")) + " n\u00b0 " + this.id + "\n")) {
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("compareAndUpdate# no changes");
        return true;
    }

    public void delete() {
        String sql = "DELETE FROM CONSUMPTION_CRITERIA WHERE ID=?";
        try {
            this.statement = ConsumptionEvalCriteria.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Vector<ConsumptionEvalCriteria> loadList() {
        Vector<ConsumptionEvalCriteria> liste = new Vector<ConsumptionEvalCriteria>();
        String sql = "SELECT " + ConsumptionEvalCriteria.getAllFields() + " FROM " + table + " ORDER BY NAME";
        try {
            ResultSet rs = null;
            Statement stm = ConsumptionEvalCriteria.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                ConsumptionEvalCriteria tmp = new ConsumptionEvalCriteria(rs.getInt("ID"), rs.getString("NAME"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("loadList()# sql = " + sql + " => " + ex.getMessage());
        }
        return liste;
    }

    public static ConsumptionEvalCriteria get(Vector<ConsumptionEvalCriteria> crList, int crId) throws DBObjectNotFoundException {
        if (crList == null) {
            crList = ConsumptionEvalCriteria.getList();
        }
        for (ConsumptionEvalCriteria tmp : crList) {
            if (tmp.getId() != crId) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException("ConsumptionEvalCriteria");
    }

    public static Vector<ConsumptionEvalCriteria> getList() {
        if (list == null) {
            list = ConsumptionEvalCriteria.loadList();
        }
        return list;
    }

    public static void setList(Vector<ConsumptionEvalCriteria> list) {
        ConsumptionEvalCriteria.list = list;
    }
}

