/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;

public class ConsumptionMark
extends MainElement {
    public static final String table = "CONSUMPTION_MARK";
    private int id = 0;
    private int driverId = 0;
    private int criteriaId = 0;
    private int consumptionEvalId = 0;

    public ConsumptionMark() {
    }

    public ConsumptionMark(int id, int driverId, int criteriaId, int consumptionEvalId) {
        this.id = id;
        this.driverId = driverId;
        this.criteriaId = criteriaId;
        this.consumptionEvalId = consumptionEvalId;
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + ConsumptionMark.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = ConsumptionMark.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.driverId = rs.getInt("DRIVER_ID");
                    this.criteriaId = rs.getInt("CRITERIA_ID");
                    this.consumptionEvalId = rs.getInt("PERCENTAGE");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("genericLoad()# sql = " + sql + " => " + ex.getMessage());
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("insert()");
        try {
            try {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO CONSUMPTION_MARK (" + ConsumptionMark.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?)";
                    this.statement = ConsumptionMark.getConnection().prepareStatement(sql);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO CONSUMPTION_MARK (" + ConsumptionMark.getAllFields().substring(ConsumptionMark.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?)";
                    this.statement = ConsumptionMark.getConnection().prepareStatement(sql, 1);
                }
                this.statement.setObject(1, (Object)this.driverId, 4);
                this.statement.setObject(2, (Object)this.criteriaId, 4);
                this.statement.setObject(3, (Object)this.consumptionEvalId, 4);
                this.statement.executeUpdate();
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    try {
                        ResultSet rs = this.statement.getGeneratedKeys();
                        if (!rs.next()) {
                            TimsLogger.warn("#ConsumptionMark.insert# no auto generated key availaible");
                        } else {
                            TimsLogger.debug("#ConsumptionMark.insert# auto generated key value = " + rs.getInt(1));
                            this.id = rs.getInt(1);
                        }
                        rs.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (this.id == 0) {
                    if (this.loadId()) {
                        TimsLogger.debug("#ConsumptionMark.insert# generated key value = " + this.id);
                    } else {
                        TimsLogger.warn("#ConsumptionMark.insert# no generated key availaible");
                    }
                }
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("insert()# sql = " + sql + " => " + ex.getMessage());
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT MAX(ID) AS ID FROM CONSUMPTION_MARK WHERE DRIVER_ID = ?";
        PreparedStatement statement = null;
        try {
            try {
                statement = ConsumptionMark.getConnection().prepareStatement(sql);
                statement.setObject(1, (Object)this.driverId, 4);
                rs = statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("ID");
                    TimsLogger.debug("#ConsumptionMark.loadId# id found " + rs.getInt("ID"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.error("loadId()#  sql = " + sql + " => " + ex.getMessage());
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE CONSUMPTION_MARK SET  DRIVER_ID=? , CRITERIA_ID=? , CONSUMPTION_EVAL_ID=?  WHERE ID=?";
        try {
            this.statement = ConsumptionMark.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.driverId, 4);
            this.statement.setObject(2, (Object)this.criteriaId, 12);
            this.statement.setObject(3, (Object)this.consumptionEvalId, 4);
            this.statement.setObject(4, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.error("updateValue()# sql = " + sql + " => " + ex.getMessage());
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getCriteriaId() {
        return this.criteriaId;
    }

    public void setCriteriaId(int agencyId) {
        this.criteriaId = agencyId;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public int getConsumptionEvalId() {
        return this.consumptionEvalId;
    }

    public void setConsumptionEvalId(int consumptionEvalId) {
        this.consumptionEvalId = consumptionEvalId;
    }

    private static String getAllFields() {
        return "ID, DRIVER_ID, CRITERIA_ID, CONSUMPTION_EVAL_ID";
    }

    public boolean compareAndUpdate(int driverId, int criteriaId, int consumptionEvalId) {
        String tracer = String.valueOf(LanguageTranslator.getString("consumption.mark")) + " n\u00b0 " + this.id + "\n";
        if (driverId != this.driverId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.driver") + " '" + this.driverId + "' => '" + driverId + "'\n";
            this.setDriverId(driverId);
        }
        if (criteriaId != this.criteriaId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("consumption.evaluation.criteria") + " '" + this.criteriaId + "' => '" + criteriaId + "'\n";
            this.setCriteriaId(criteriaId);
        }
        if (consumptionEvalId != this.consumptionEvalId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("consumption.evaluation") + " '" + this.consumptionEvalId + "' => '" + consumptionEvalId + "'\n";
            this.setConsumptionEvalId(consumptionEvalId);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("consumption.mark")) + " n\u00b0 " + this.id + "\n")) {
            if (this.id == 0) {
                if (this.insert()) {
                    new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                    return true;
                }
                return false;
            }
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("compareAndUpdate# no changes");
        return true;
    }

    public void delete() {
        String sql = "DELETE FROM CONSUMPTION_MARK WHERE ID=?";
        try {
            this.statement = ConsumptionMark.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Vector<ConsumptionMark> loadList(int criteriaId, int driverId) {
        String filters = String.valueOf(criteriaId != 0 ? " AND CIRTERIA_ID =" + criteriaId : "") + (driverId != 0 ? " AND DRIVER_ID =" + driverId : "");
        return ConsumptionMark.loadList(filters);
    }

    public static Vector<ConsumptionMark> loadList(String filters) {
        Vector<ConsumptionMark> liste = new Vector<ConsumptionMark>();
        String sql = "SELECT " + ConsumptionMark.getAllFields() + " FROM " + table + (filters != null && !filters.equals("") ? " WHERE " + filters.substring(4) : "");
        try {
            ResultSet rs = null;
            Statement stm = ConsumptionMark.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                ConsumptionMark tmp = new ConsumptionMark(rs.getInt("ID"), rs.getInt("DRIVER_ID"), rs.getInt("CRITERIA_ID"), rs.getInt("CONSUMPTION_EVAL_ID"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("loadList()# sql = " + sql + " => " + ex.getMessage());
        }
        return liste;
    }
}

