/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class CustomReportParameter
extends MainElement {
    public static final String table = "CUSTOM_REPORT_PARAMETER";
    private int id = 0;
    private int customReportId = 0;
    private String name = null;
    private String value = null;
    private String type = null;

    public CustomReportParameter(int id, int reportId, String name, String value, String type) {
        this.id = id;
        this.customReportId = reportId;
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getCustomReportId() {
        return this.customReportId;
    }

    public void setCustomReportId(int reportId) {
        this.customReportId = reportId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean insert() {
        TimsLogger.debug("#CusRepPar.insert# " + this.name + " " + this.type + " " + this.value);
        boolean toReturn = true;
        try {
            this.statement = this.getPreparedStatement();
            this.statement.setObject(1, (Object)this.customReportId, 4);
            this.statement.setObject(2, (Object)this.name, 12);
            this.statement.setObject(3, (Object)this.value, 12);
            this.statement.setObject(4, (Object)this.type, 12);
            this.statement.executeUpdate();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
        }
        catch (CommunicationsException ex) {
            toReturn = false;
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            toReturn = false;
            TimsLogger.error("insert()# error => " + ex.getMessage());
        }
        return toReturn;
    }

    public PreparedStatement getPreparedStatement() {
        if (this.statement == null) {
            String sql = "";
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO CUSTOM_REPORT_PARAMETER (ID, CUSTOM_REPORT_ID, NAME, VALUE, TYPE) VALUES (GEN_CUSTOM_REPORT_PARAMETER.nextval,?,?,?,?)";
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO CUSTOM_REPORT_PARAMETER (CUSTOM_REPORT_ID, NAME, VALUE, TYPE) VALUES (?,?,?,?)";
            }
            try {
                this.statement = CustomReportParameter.getConnection().prepareStatement(sql);
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
            }
            catch (Exception ex) {
                TimsLogger.error("getPreparedStatement()# sql = " + sql + " => " + ex.getMessage());
            }
        }
        return this.statement;
    }

    public boolean delete() {
        boolean toReturn = false;
        String sql = "DELETE FROM CUSTOM_REPORT_PARAMETER WHERE ID=?";
        try {
            try {
                this.statement = CustomReportParameter.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return toReturn;
    }

    public static HashMap<String, Object> loadList(int columnReportId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String sql = "";
        try {
            sql = "SELECT ID, CUSTOM_REPORT_ID, TYPE, NAME, VALUE FROM CUSTOM_REPORT_PARAMETER";
            if (columnReportId != 0) {
                sql = String.valueOf(sql) + " WHERE CUSTOM_REPORT_ID = " + columnReportId;
            }
            TimsLogger.debug(sql);
            Statement stm = CustomReportParameter.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                if (rs.getString("TYPE") != null) continue;
                result.put(rs.getString("NAME"), rs.getString("VALUE"));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("loadList()# sql = " + sql + " => " + ex.getMessage());
        }
        return result;
    }
}

