/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Constants;

public class DCMissingVuActivity
extends MainElement
implements Cloneable {
    public static final String table = "DC_MISSING_VU_ACTIVITY";
    private int id = 0;
    private int vehicleId = 0;
    private int dataControlId = 0;
    private String session = "";
    private Date begin = null;
    private Date end = null;

    public DCMissingVuActivity() {
    }

    public DCMissingVuActivity clone() throws CloneNotSupportedException {
        return (DCMissingVuActivity)super.clone();
    }

    public int getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(int vehicleId) {
        this.vehicleId = vehicleId;
    }

    public int getDataControlId() {
        return this.dataControlId;
    }

    public void setDataControlId(int dataControlId) {
        this.dataControlId = dataControlId;
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public Date getBegin() {
        return this.begin;
    }

    public void setBegin(Date begin) {
        this.begin = begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public String toString() {
        return "DCMissingVuActivity id " + this.id + " : {vehicleId = " + this.vehicleId + "} {begin = " + this.begin + "} {end = " + this.end + "}";
    }

    public DCMissingVuActivity(int id, int dataControlId, int vehicleId, String session, Date begin, Date end) {
        this.id = id;
        this.dataControlId = dataControlId;
        this.vehicleId = vehicleId;
        this.session = session;
        this.begin = begin;
        this.end = end;
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = DCMissingVuActivity.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#DCMissingVuActivity.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#DCMissingVuActivity.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.vehicleId = rs.getInt("VEHICLE_ID");
                    this.dataControlId = rs.getInt("DATA_CONTROL_ID");
                    this.begin = rs.getDate("BEGIN");
                    this.end = rs.getDate("END");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#DCMissingVuActivity.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#DCMissingVuActivity.insert()#");
        try {
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO DC_MISSING_VU_ACTIVITY (" + DCMissingVuActivity.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?,?)";
                this.statement = DCMissingVuActivity.getConnection().prepareStatement(sql);
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO DC_MISSING_VU_ACTIVITY (" + DCMissingVuActivity.getAllFields().substring(DCMissingVuActivity.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?)";
                this.statement = DCMissingVuActivity.getConnection().prepareStatement(sql, 1);
            }
            this.statement.setObject(1, (Object)this.dataControlId, 4);
            this.statement.setObject(2, (Object)this.vehicleId, 4);
            this.statement.setObject(3, (Object)this.session, 12);
            this.statement.setTimestamp(4, new Timestamp(this.begin.getTime()));
            this.statement.setTimestamp(5, new Timestamp(this.end.getTime()));
            this.statement.executeUpdate();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    private static String getAllFields() {
        return "ID, DATA_CONTROL_ID, VEHICLE_ID, SESSION, BEGIN, END";
    }

    public static ArrayList<DCMissingVuActivity> loadList(int dataControlId) {
        ArrayList<DCMissingVuActivity> liste = new ArrayList<DCMissingVuActivity>();
        String sql = "SELECT " + DCMissingVuActivity.getAllFields() + " FROM " + table;
        if (dataControlId != 0) {
            sql = String.valueOf(sql) + " WHERE DATA_CONTROL_ID =" + dataControlId;
        }
        try {
            Transport.ps.startOperation();
            ResultSet rs = null;
            Statement stm = DCMissingVuActivity.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate liste import activit\u00e9", "#DCMissingVuActivity.loadLastList() => %s# sql = " + sql, 1);
            while (rs.next()) {
                DCMissingVuActivity tmp = new DCMissingVuActivity(rs.getInt("ID"), rs.getInt("DATA_CONTROL_ID"), rs.getInt("DRIVER_ID"), rs.getString("SESSION"), new Date(rs.getTimestamp("BEGIN").getTime()), new Date(rs.getTimestamp("END").getTime()));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("DCMissingVuActivity.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }
}

