/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.DayTypeNotFoundException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class DayPlanning
extends MainElement {
    public static final String table = "day_planning";
    public static final int NORMAL = 0;
    public static final int SEMI = 1;
    public static final int FULL = 2;
    public static int DEFAULT_LENGTH_VALUE = 480;
    public static int DEFAULT_BEGIN_VALUE = 480;
    private int id = 0;
    private int dayTypeId = 0;
    private int userId = 0;
    private int type = 0;
    private java.util.Date day = null;
    private int begin = 480;
    private int length = 0;
    private String comm = "";
    private ArrayList<Integer> drivers = new ArrayList();
    private ArrayList<Integer> vehicles = new ArrayList();

    public DayPlanning(int id, int dayTypeId, int userId, java.util.Date day, int begin, int length, int type, String comm) {
        this.id = id;
        this.dayTypeId = dayTypeId;
        this.userId = userId;
        this.day = day;
        this.begin = begin;
        this.length = length;
        this.type = type;
        this.comm = comm;
    }

    public DayPlanning() {
    }

    public String toString() {
        String drivers = "";
        String vehicles = "";
        for (Integer id : this.getDrivers()) {
            drivers = String.valueOf(drivers) + ", " + id;
        }
        for (Integer id : this.getVehicles()) {
            vehicles = String.valueOf(vehicles) + ", " + id;
        }
        return "{dayTypeId:" + this.dayTypeId + ",day:" + this.day + ",comm:" + this.comm + ",drivers: [" + drivers + "], vehicles: [" + vehicles + "]}";
    }

    public boolean equals(Object obj) {
        return obj instanceof DayPlanning && ((DayPlanning)obj).getDayTypeId() == this.dayTypeId && ((DayPlanning)obj).getDay().equals(this.day) && ((DayPlanning)obj).getType() == this.type;
    }

    private static String getAllFields() {
        return "DAY_TYPE_ID, USER_ID, DAY, BEGIN_HOUR, LENGTH, TYPE, COMM";
    }

    public boolean compareAndUpdate(int dayTypeId, String comm, Vector<Integer> vehicleIds) {
        if (this.id == 0) {
            return this.update();
        }
        String tracer = String.valueOf(LanguageTranslator.getString("generics.dayPlanning")) + " n\u00b0 " + this.id + " \n";
        if (dayTypeId != this.dayTypeId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.day") + " : '" + this.dayTypeId + "' => '" + dayTypeId + "'\n";
            this.setDayTypeId(dayTypeId);
        }
        if (Fonctions.fieldChange(comm, this.comm)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.comm") + " : '" + this.comm + "' => '" + comm + "'\n";
            this.setComm(comm);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.dayPlanning")) + " n\u00b0 " + this.id + " \n")) {
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new java.util.Date(), tracer).insert();
            return this.update();
        }
        TimsLogger.debug("#DayPlanning.compareAndUpdate# no changes");
        return true;
    }

    public boolean update() {
        if (this.id != 0) {
            return this.updateJour();
        }
        return this.insert();
    }

    public void affiche() {
        TimsLogger.info("#day_planning.affiche()# dayTypeId " + this.dayTypeId + " day = " + this.day + " cle=" + this.id);
    }

    public boolean insert() {
        boolean toReturn;
        block29: {
            toReturn = false;
            BddTransport.getInstance().startTransaction();
            try {
                String sql = "";
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO day_planning(ID, " + DayPlanning.getAllFields() + ") VALUES " + "(GEN_" + table + ".nextval,?,?,?,?,?,?,?)";
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO day_planning(" + DayPlanning.getAllFields() + ") VALUES " + "(?,?,?,?,?,?,?)";
                }
                this.statement = DayPlanning.getConnection().prepareStatement(sql, 1);
                this.statement.setObject(1, (Object)this.dayTypeId, 4);
                this.statement.setObject(2, (Object)this.userId, 4);
                this.statement.setDate(3, new Date(this.day.getTime()));
                this.statement.setObject(4, (Object)this.begin, 4);
                this.statement.setObject(5, (Object)this.length, 4);
                this.statement.setObject(6, (Object)this.type, 4);
                this.statement.setObject(7, (Object)this.comm, 12);
                this.statement.executeUpdate();
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    ResultSet rs = this.statement.getGeneratedKeys();
                    if (!rs.next()) {
                        TimsLogger.debug("#day_planning.insert# no auto generated key availaible");
                    } else {
                        TimsLogger.debug("#day_planning.insert# auto generated key value = " + rs.getInt(1));
                        this.id = rs.getInt(1);
                    }
                    rs.close();
                }
                if (this.id == 0) {
                    if (this.loadId()) {
                        TimsLogger.debug("#day_planning.insert# generated key value = " + this.id);
                    } else {
                        TimsLogger.debug("#day_planning.insert# no generated key availaible");
                    }
                }
                if (toReturn = this.updateDriver()) {
                    toReturn = this.updateVehicle();
                }
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    break block29;
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
                break block29;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    break block29;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (this.statement != null) {
                            this.statement.close();
                        }
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        if (toReturn) {
            BddTransport.getInstance().commit();
        } else {
            TimsLogger.warn("#day_planning.updateJour # Erreur de mise \u00e0 jour " + this.toString());
            BddTransport.getInstance().rollback();
        }
        return toReturn;
    }

    public boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT max(ID) as ID FROM day_planning WHERE USER_ID = ?";
        PreparedStatement statement = null;
        try {
            try {
                statement = DayPlanning.getConnection().prepareStatement(sql);
                statement.setObject(1, (Object)this.userId, 4);
                rs = statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("ID");
                    TimsLogger.info("#day_planning.loadId# id found " + rs.getInt("ID"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("#day_planning.loadId()  : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean delete() {
        String sql = "DELETE FROM day_planning WHERE ID = ?";
        try {
            TimsLogger.debug("#DayPlanning.delete# " + sql);
            this.statement = DayPlanning.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public boolean updateJour() {
        boolean toReturn;
        block21: {
            toReturn = true;
            BddTransport.getInstance().startTransaction();
            String sql = "UPDATE day_planning SET  DAY_TYPE_ID = ? , USER_ID = ? , DAY = ? , BEGIN_HOUR = ? , LENGTH = ? , TYPE = ?,  COMM = ?  WHERE ID = ?";
            try {
                this.statement = DayPlanning.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.dayTypeId, 4);
                this.statement.setObject(2, (Object)this.userId, 4);
                this.statement.setDate(3, new Date(this.day.getTime()));
                this.statement.setObject(4, (Object)this.begin, 4);
                this.statement.setObject(5, (Object)this.length, 4);
                this.statement.setObject(6, (Object)this.type, 4);
                this.statement.setObject(7, (Object)this.comm, 12);
                this.statement.setObject(8, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().executeCmd("DELETE FROM DRIVER_PLANNING WHERE DAY_PLANNING_ID = " + this.id);
                BddTransport.getInstance().executeCmd("DELETE FROM VEHICLE_PLANNING WHERE DAY_PLANNING_ID = " + this.id);
                toReturn = this.updateDriver();
                if (toReturn) {
                    this.updateVehicle();
                }
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                toReturn = false;
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    break block21;
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
                break block21;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    toReturn = false;
                    break block21;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (this.statement != null) {
                            this.statement.close();
                        }
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        if (toReturn) {
            BddTransport.getInstance().commit();
        } else {
            TimsLogger.warn("#day_planning.updateJour # Erreur de mise \u00e0 jour " + this.toString());
            BddTransport.getInstance().rollback();
        }
        return toReturn;
    }

    private boolean updateDriver() {
        boolean toReturn = true;
        try {
            try {
                this.statement = DayPlanning.getConnection().prepareStatement("INSERT INTO DRIVER_PLANNING (DAY_PLANNING_ID, DRIVER_ID) VALUES (?,?)");
                for (Integer toInsert : this.getDrivers()) {
                    this.statement.setObject(1, (Object)this.id, 4);
                    this.statement.setObject(2, (Object)toInsert, 4);
                    this.statement.executeUpdate();
                }
                this.statement.close();
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                toReturn = false;
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                toReturn = false;
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    private boolean updateVehicle() {
        boolean toReturn = true;
        try {
            try {
                this.statement = DayPlanning.getConnection().prepareStatement("INSERT INTO VEHICLE_PLANNING (DAY_PLANNING_ID, VEHICLE_ID) VALUES (?,?)");
                TimsLogger.debug("#DayPlanning.updateVehicle# INSERT " + this.getVehicles().size() + "VEHICLEs ");
                for (Integer toInsert : this.getVehicles()) {
                    TimsLogger.debug("#DayPlanning.updateVehicle# INSERT VEHICLE " + toInsert);
                    this.statement.setObject(1, (Object)this.id, 4);
                    this.statement.setObject(2, (Object)toInsert, 4);
                    this.statement.executeUpdate();
                }
                this.statement.close();
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                toReturn = false;
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                toReturn = false;
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean load(int dayTypeId, Timestamp day) {
        block4: {
            ResultSet rs = null;
            TimsLogger.debug("#day_planning.load()#");
            String sql = "SELECT " + DayPlanning.getAllFields() + " FROM " + table + " WHERE DAY_TYPE_ID = ? AND DAY = ?";
            this.statement = DayPlanning.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)dayTypeId, 12);
            this.statement.setTimestamp(2, day);
            rs = this.statement.executeQuery();
            if (!rs.next()) break block4;
            this.id = rs.getInt("ID");
            this.dayTypeId = rs.getInt("DAY_TYPE_ID");
            this.userId = rs.getInt("USER_ID");
            this.day = day;
            this.begin = rs.getInt("BEGIN_JOUR");
            this.length = rs.getInt("LENGTH");
            this.type = rs.getInt("TYPE");
            this.comm = rs.getString("COMM");
            this.statement.close();
            return true;
        }
        try {
            this.statement.close();
            return false;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getDayTypeId() {
        return this.dayTypeId;
    }

    public void setDayTypeId(int dayTypeId) {
        this.dayTypeId = dayTypeId;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public java.util.Date getDay() {
        return this.day;
    }

    public void setDay(java.util.Date day) {
        this.day = day;
    }

    public int getBegin() {
        return this.begin;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public String getComm() {
        return this.comm;
    }

    public void setComm(String comm) {
        this.comm = comm;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public ArrayList<Integer> getDrivers() {
        return this.drivers;
    }

    public void setDrivers(ArrayList<Integer> drivers) {
        this.drivers = drivers;
    }

    public ArrayList<Integer> getVehicles() {
        return this.vehicles;
    }

    public void setVehicles(ArrayList<Integer> vehicles) {
        this.vehicles = vehicles;
    }

    public int getDuree(int contractDayLength) {
        int returnLength = 0;
        if (this.type != 0) {
            JourType dayType = this.getDayType();
            if (dayType != null && "CP".equals(dayType.getCode()) && ConversionTime.getDayOfWeek(this.getDay(), false) == 7) {
                return 0;
            }
            int fullDayLength = 0;
            if (contractDayLength != 0) {
                fullDayLength = contractDayLength;
            } else if (this.dayTypeId != 0) {
                int n = fullDayLength = dayType != null ? dayType.getService() : 0;
            }
            if (this.type == 1) {
                returnLength = fullDayLength / 2;
            }
            if (this.type == 2) {
                returnLength = fullDayLength;
            }
        } else {
            returnLength = this.length;
        }
        return returnLength;
    }

    public int getPrintLength(int contractDayLength) {
        int dureeToReturn = 0;
        if (this.type != 0) {
            int toReturn = 0;
            if (contractDayLength != 0) {
                toReturn = contractDayLength;
            } else if (this.dayTypeId != 0) {
                JourType dayType = this.getDayType();
                int n = toReturn = dayType != null ? dayType.getService() : 420;
            }
            if (this.type == 1) {
                dureeToReturn = toReturn / 2;
            }
            if (this.type == 2) {
                dureeToReturn = toReturn;
            }
        }
        if (dureeToReturn == 0) {
            dureeToReturn = this.length;
        }
        return dureeToReturn == 0 ? DEFAULT_LENGTH_VALUE : dureeToReturn;
    }

    public JourType getDayType() {
        JourType toReturn = null;
        try {
            toReturn = JourType.getDayType(this.dayTypeId);
        }
        catch (DayTypeNotFoundException ex) {
            TimsLogger.warn("#LJC.getDayType()# impossible de trouver le jour type : " + this.dayTypeId);
        }
        return toReturn;
    }

    public String getDesignation() {
        String toReturn = "";
        try {
            toReturn = JourType.getDayType(this.dayTypeId).getDesignation();
        }
        catch (DayTypeNotFoundException ex) {
            ex.printStackTrace();
        }
        return toReturn;
    }

    public static Vector<DayPlanning> loadListByAgency(int agencyId, java.util.Date begin, java.util.Date end) {
        String res = "";
        if (agencyId != 0) {
            res = String.valueOf(res) + " AND (DRIVER_ID IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE CLE_AGENCE = " + agencyId + ") " + " OR VEHICLE_ID IN (SELECT CLE_VEHICULE FROM " + "t_vehicule" + " WHERE CLE_AGENCE = " + agencyId + "))";
        }
        if (begin != null) {
            res = end != null ? String.valueOf(res) + " AND DAY BETWEEN " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false) + " AND " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(end, "yyyy-MM-dd"), false) : String.valueOf(res) + " AND DAY =" + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false);
        }
        Vector<DayPlanning> toReturn = new Vector<DayPlanning>();
        String sql = "";
        try {
            sql = "SELECT day_p.ID, DAY_TYPE_ID, USER_ID, DAY, BEGIN_HOUR, LENGTH, TYPE, COMM, DRIVER_ID, VEHICLE_ID FROM day_planning day_p JOIN driver_planning dp on day_p.ID=dp.DAY_PLANNING_ID LEFT JOIN vehicle_planning vp on day_p.ID=vp.DAY_PLANNING_ID WHERE " + res.substring(5) + " ORDER BY DAY, DRIVER_ID";
            Statement stm = DayPlanning.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            TimsLogger.debug("#DayPlanning.loadListByAgency# " + sql);
            DayPlanning current = new DayPlanning();
            while (rs.next()) {
                if (current.getId() == rs.getInt("ID")) {
                    TimsLogger.debug("#day_planning.loadListByAgency# add " + rs.getInt("VEHICLE_ID"));
                    current.getVehicles().add(rs.getInt("VEHICLE_ID"));
                    continue;
                }
                current = new DayPlanning(rs.getInt("ID"), rs.getInt("DAY_TYPE_ID"), rs.getInt("USER_ID"), rs.getDate("DAY"), rs.getInt("BEGIN_HOUR"), rs.getInt("LENGTH"), rs.getInt("TYPE"), rs.getString("COMM"));
                current.getDrivers().add(rs.getInt("DRIVER_ID"));
                current.getVehicles().add(rs.getInt("VEHICLE_ID"));
                toReturn.add(current);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("DPlanning.loadList() : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return toReturn;
    }

    public static Vector<DayPlanning> findDriverPlanning(Vector<DayPlanning> toSearch, int driverId, java.util.Date date) {
        Vector<DayPlanning> toReturn = new Vector<DayPlanning>();
        for (DayPlanning ljc : toSearch) {
            if (date != null && !ljc.getDay().equals(date) || !ljc.getDrivers().contains(driverId)) continue;
            toReturn.add(ljc);
        }
        return toReturn;
    }

    public static Vector<DayPlanning> findVehiclePlanning(Vector<DayPlanning> toSearch, int vehicleId, java.util.Date date) {
        Vector<DayPlanning> toReturn = new Vector<DayPlanning>();
        for (DayPlanning ljc : toSearch) {
            if (date != null && !ljc.getDay().equals(date) || !ljc.getVehicles().contains(vehicleId)) continue;
            toReturn.add(ljc);
        }
        return toReturn;
    }

    public static boolean deleteDriverDay(int driverId, String begin, String end) {
        boolean toReturn = false;
        String sql = "";
        Statement stm = null;
        try {
            try {
                String dateFilter = begin != null ? (end != null && !end.equals("") ? "BETWEEN " + BddTransport.getDateStringToSGBDR(ConversionTime.dateFromFranceToBDD(begin, false), false) + " AND " + BddTransport.getDateStringToSGBDR(ConversionTime.dateFromFranceToBDD(end, false), false) : "= " + BddTransport.getDateStringToSGBDR(ConversionTime.dateFromFranceToBDD(begin, false), false)) : null;
                sql = "DELETE FROM day_planning WHERE ID in (SELECT DAY_PLANNING_ID FROM DRIVER_PLANNING WHERE DRIVER_ID = " + driverId + ")";
                if (dateFilter != null) {
                    sql = String.valueOf(sql) + " AND DAY " + dateFilter;
                }
                stm = DayPlanning.getConnection().prepareStatement(sql);
                TimsLogger.verbose("#deleteDayPlanning# sql = " + sql);
                Transport.ps.startOperation();
                stm.executeUpdate();
                Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate suppression jour planning conducteur", "#DayPlanning.delete() => %s# sql = " + sql, 1);
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                stm.close();
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (SQLException ex2) {
                    TimsLogger.error("DayPlanning.delete()# unable to close statement");
                }
            }
            catch (Exception ex) {
                TimsLogger.error("deleteExpenses()# sql = " + sql + " returns " + ex.getMessage());
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (SQLException ex3) {
                    TimsLogger.error("DayPlanning.delete()# unable to close statement");
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("DayPlanning.delete()# unable to close statement");
            }
        }
        return toReturn;
    }

    public static boolean deleteVehicleDay(int vehicleId, String begin, String end) {
        boolean toReturn = false;
        String sql = "";
        Statement stm = null;
        try {
            try {
                String dateFilter = begin != null ? (end != null && !end.equals("") ? "BETWEEN " + BddTransport.getDateStringToSGBDR(ConversionTime.dateFromFranceToBDD(begin, false), false) + " AND " + BddTransport.getDateStringToSGBDR(ConversionTime.dateFromFranceToBDD(end, false), false) : "= " + BddTransport.getDateStringToSGBDR(ConversionTime.dateFromFranceToBDD(begin, false), false)) : null;
                sql = "DELETE FROM day_planning WHERE ID in (SELECT DAY_PLANNING_ID FROM VEHICLE_PLANNING WHERE VEHICLE_ID = " + vehicleId + ")";
                if (dateFilter != null) {
                    sql = String.valueOf(sql) + " AND DAY " + dateFilter;
                }
                stm = DayPlanning.getConnection().prepareStatement(sql);
                TimsLogger.verbose("#deleteDayPlanning# sql = " + sql);
                Transport.ps.startOperation();
                stm.executeUpdate();
                Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate suppression jour planning conducteur", "#DayPlanning.delete() => %s# sql = " + sql, 1);
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                stm.close();
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (SQLException ex2) {
                    TimsLogger.error("DayPlanning.delete()# unable to close statement");
                }
            }
            catch (Exception ex) {
                TimsLogger.error("deleteExpenses()# sql = " + sql + " returns " + ex.getMessage());
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (SQLException ex3) {
                    TimsLogger.error("DayPlanning.delete()# unable to close statement");
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("DayPlanning.delete()# unable to close statement");
            }
        }
        return toReturn;
    }
}

