/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class DevAction
extends MainElement {
    public static final String table = String.valueOf(BddTransport.getBaseDefault(true)) + "DEV_ACTION";
    private static Vector<DevAction> list = null;
    private int id = 0;
    private Date date = null;
    private int categoryId = 0;
    private String description = null;
    private int stateId = 0;
    private int managerId = 0;
    private int detectionVersionId = 0;
    private int correctionVersionId = 0;
    private int typeId = 0;
    private int priorityId = 0;
    private String problem = null;
    private String solve = null;
    private int lengthInterv = 0;
    private String keywords = null;
    private int viewLevel = 0;

    public DevAction() {
    }

    public DevAction(int id, Date date, String description, int state, int managerId, int categoryId, int detectionVersionId, int correctionVersionId, int type, int priority, String problem, String solve, int lengthInterv, String keywords, int viewLevel) {
        this.id = id;
        this.date = date;
        this.description = description;
        this.stateId = state;
        this.managerId = managerId;
        this.categoryId = categoryId;
        this.detectionVersionId = detectionVersionId;
        this.correctionVersionId = correctionVersionId;
        this.typeId = type;
        this.priorityId = priority;
        this.problem = problem;
        this.solve = solve;
        this.lengthInterv = lengthInterv;
        this.keywords = keywords;
        this.viewLevel = viewLevel;
    }

    public String toString() {
        return String.valueOf(this.getId()) + " " + this.getDate();
    }

    public boolean loadByCompany(int companyId) {
        String sql = "SELECT " + DevAction.getAllFields() + " FROM " + table + " WHERE COMPANY_ID=" + companyId;
        return this.genericLoad(sql);
    }

    public boolean loadById(int id) {
        String sql = "SELECT " + DevAction.getAllFields() + " FROM " + table + " WHERE ID=" + id;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = DevAction.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#DevAction.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#DevAction.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.date = rs.getDate("ACTION_DATE");
                    this.description = rs.getString("DESCRIPTION");
                    this.stateId = rs.getInt("STATE_ID");
                    this.managerId = rs.getInt("MANAGER_ID");
                    this.detectionVersionId = rs.getInt("DETECTION_VERSION_ID");
                    this.correctionVersionId = rs.getInt("CORRECTION_VERSION_ID");
                    this.priorityId = rs.getInt("PRIORITY_ID");
                    this.problem = rs.getString("PROBLEM");
                    this.solve = rs.getString("SOLVE");
                    this.lengthInterv = rs.getInt("LENGTH_INTERV");
                    this.categoryId = rs.getInt("CATEGORY_ID");
                    this.keywords = rs.getString("KEYWORDS");
                    this.viewLevel = rs.getInt("VIEW_LEVEL");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#DevAction.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#CompanyAction.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO " + table + " (" + DevAction.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO " + table + " (" + DevAction.getAllFields().substring(DevAction.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        try {
            try {
                this.statement = DevAction.getConnection().prepareStatement(sql);
                this.statement.setTimestamp(1, new Timestamp(this.date.getTime()));
                this.statement.setObject(2, (Object)this.description, 12);
                this.statement.setObject(3, (Object)this.stateId, 4);
                this.statement.setObject(4, (Object)this.managerId, 4);
                this.statement.setObject(5, (Object)this.categoryId, 4);
                this.statement.setObject(6, (Object)this.detectionVersionId, 4);
                this.statement.setObject(7, (Object)this.correctionVersionId, 4);
                this.statement.setObject(8, (Object)this.typeId, 4);
                this.statement.setObject(9, (Object)this.priorityId, 4);
                this.statement.setObject(10, (Object)this.problem, 12);
                this.statement.setObject(11, (Object)this.solve, 12);
                this.statement.setObject(12, (Object)this.lengthInterv, 4);
                this.statement.setObject(13, (Object)this.keywords, 12);
                this.statement.setObject(14, (Object)this.viewLevel, 4);
                this.statement.executeUpdate();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE " + table + " SET " + " ACTION_DATE=? ," + " DESCRIPTION=? ," + " STATE_ID=? ," + " MANAGER_ID=? ," + " CATEGORY_ID=? ," + " DETECTION_VERSION_ID=? ," + " CORRECTION_VERSION_ID=? ," + " TYPE_ID=? ," + " PRIORITY_ID=? ," + " PROBLEM=?, " + " SOLVE=?, " + " LENGTH_INTERV=?," + " KEYWORDS=?," + " VIEW_LEVEL=?" + " WHERE ID=?";
        try {
            this.statement = DevAction.getConnection().prepareStatement(sql);
            this.statement.setTimestamp(1, new Timestamp(this.date.getTime()));
            this.statement.setObject(2, (Object)this.description, 12);
            this.statement.setObject(3, (Object)this.stateId, 4);
            this.statement.setObject(4, (Object)this.managerId, 4);
            this.statement.setObject(5, (Object)this.categoryId, 4);
            this.statement.setObject(6, (Object)this.detectionVersionId, 4);
            this.statement.setObject(7, (Object)this.correctionVersionId, 4);
            this.statement.setObject(8, (Object)this.typeId, 4);
            this.statement.setObject(9, (Object)this.priorityId, 4);
            this.statement.setObject(10, (Object)this.problem, 12);
            this.statement.setObject(11, (Object)this.solve, 12);
            this.statement.setObject(12, (Object)this.lengthInterv, 4);
            this.statement.setObject(13, (Object)this.keywords, 12);
            this.statement.setObject(14, (Object)this.viewLevel, 4);
            this.statement.setObject(15, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean compareAndUpdate(Date date, String description, int stateId, int managerId, int categoryId, int detectionVersionId, int correctionVersionId, int typeId, int priorityId, String problem, String solve, int lengthInterv, String keywords, int viewLevel) {
        String idS;
        String tracer = idS = String.valueOf(LanguageTranslator.getString("generics.companyAction")) + " n\u00b0 " + this.id + " (" + this.getDate() + ") \n";
        if (Fonctions.fieldChange(date, this.date)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.date") + " '" + this.date + "' => '" + date + "'\n";
            this.setDate(date);
        }
        if (Fonctions.fieldChange(description, this.description)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.description") + " '" + this.description + "' => '" + description + "'\n";
            this.setDescription(description);
        }
        if (this.stateId != stateId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.state") + " '" + this.stateId + "' => '" + stateId + "'\n";
            this.setStateId(stateId);
        }
        if (this.managerId != managerId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.manager") + " '" + this.managerId + "' => '" + managerId + "'\n";
            this.setManagerId(managerId);
        }
        if (this.categoryId != categoryId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.category") + " '" + this.categoryId + "' => '" + categoryId + "'\n";
            this.setCategoryId(categoryId);
        }
        if (this.detectionVersionId != detectionVersionId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.version") + " '" + this.detectionVersionId + "' => '" + detectionVersionId + "'\n";
            this.setDetectionVersionId(detectionVersionId);
        }
        if (this.correctionVersionId != correctionVersionId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.version") + " '" + this.correctionVersionId + "' => '" + correctionVersionId + "'\n";
            this.setCorrectionVersionId(correctionVersionId);
        }
        if (this.typeId != typeId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.action") + " '" + this.typeId + "' => '" + typeId + "'\n";
            this.setTypeId(typeId);
        }
        if (this.priorityId != priorityId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.priority") + " '" + this.priorityId + "' => '" + priorityId + "'\n";
            this.setPriorityId(priorityId);
        }
        if (Fonctions.fieldChange(problem, this.problem)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.problem") + " '" + this.problem + "' => '" + problem + "'\n";
            this.setProblem(problem);
        }
        if (Fonctions.fieldChange(solve, this.solve)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.solve") + " '" + this.solve + "' => '" + solve + "'\n";
            this.setSolve(solve);
        }
        if (this.lengthInterv != lengthInterv) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.lengthInterv") + " '" + this.lengthInterv + "' => '" + lengthInterv + "'\n";
            this.setLengthInterv(lengthInterv);
        }
        if (Fonctions.fieldChange(keywords, this.keywords)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.keywords") + " '" + this.keywords + "' => '" + keywords + "'\n";
            this.setKeywords(keywords);
        }
        if (this.viewLevel != viewLevel) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.viewLevel") + " '" + this.viewLevel + "' => '" + viewLevel + "'\n";
            this.setViewLevel(viewLevel);
        }
        if (!tracer.equals(idS)) {
            if (this.id == 0) {
                if (this.insert()) {
                    new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                    return true;
                }
                return false;
            }
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#DevAction# no changes");
        return true;
    }

    public void delete() {
        String sql = "DELETE FROM " + table + " WHERE ID=?";
        try {
            this.statement = DevAction.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getStateId() {
        return this.stateId;
    }

    public void setStateId(int stateId) {
        this.stateId = stateId;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public int getManagerId() {
        return this.managerId;
    }

    public void setManagerId(int managerId) {
        this.managerId = managerId;
    }

    public int getDetectionVersionId() {
        return this.detectionVersionId;
    }

    public void setDetectionVersionId(int detectionVersionId) {
        this.detectionVersionId = detectionVersionId;
    }

    public int getCorrectionVersionId() {
        return this.correctionVersionId;
    }

    public void setCorrectionVersionId(int correctionVersionId) {
        this.correctionVersionId = correctionVersionId;
    }

    public int getPriorityId() {
        return this.priorityId;
    }

    public void setPriorityId(int priorityId) {
        this.priorityId = priorityId;
    }

    public String getProblem() {
        return this.problem;
    }

    public void setProblem(String problem) {
        this.problem = problem;
    }

    public String getSolve() {
        return this.solve;
    }

    public void setSolve(String solve) {
        this.solve = solve;
    }

    public int getLengthInterv() {
        return this.lengthInterv;
    }

    public void setLengthInterv(int lengthInterv) {
        this.lengthInterv = lengthInterv;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int categoryId) {
        this.categoryId = categoryId;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public int getViewLevel() {
        return this.viewLevel;
    }

    public void setViewLevel(int viewLevel) {
        this.viewLevel = viewLevel;
    }

    private static String getAllFields() {
        return "ID, ACTION_DATE, DESCRIPTION, STATE_ID, MANAGER_ID, CATEGORY_ID, DETECTION_VERSION_ID, CORRECTION_VERSION_ID, TYPE_ID, PRIORITY_ID, PROBLEM, SOLVE, LENGTH_INTERV, KEYWORDS, VIEW_LEVEL";
    }

    public static Vector<DevAction> loadList(int categoryId, int managerId, int stateId, int detectionVersionId, int correctionVersionId, int typeId, int priorityId, Date begin, Date end) {
        Vector<DevAction> liste = new Vector<DevAction>();
        String sql = "SELECT " + DevAction.getAllFields() + " FROM " + table;
        String restrictions = "";
        if (categoryId != 0 && categoryId != -1) {
            restrictions = String.valueOf(restrictions) + " AND CATEGORY_ID = " + categoryId;
        }
        if (managerId != 0 && managerId != -1) {
            restrictions = String.valueOf(restrictions) + " AND MANAGER_ID = " + managerId;
        }
        if (typeId != 0 && typeId != -1) {
            restrictions = String.valueOf(restrictions) + " AND TYPE_ID = " + typeId;
        }
        if (stateId != 0 && stateId != -1) {
            restrictions = String.valueOf(restrictions) + " AND STATE_ID = " + stateId;
        }
        if (detectionVersionId != 0 && detectionVersionId != -1) {
            restrictions = String.valueOf(restrictions) + " AND DETECTION_VERSION_ID = " + detectionVersionId;
        }
        if (correctionVersionId != 0 && correctionVersionId != -1) {
            restrictions = String.valueOf(restrictions) + " AND CORRECTION_VERSION_ID = " + correctionVersionId;
        }
        if (priorityId != 0 && priorityId != -1) {
            restrictions = String.valueOf(restrictions) + " AND PRIORITY_ID = " + priorityId;
        }
        if (begin != null) {
            restrictions = end == null ? String.valueOf(restrictions) + " AND DATE(ACTION_DATE) = '" + ConversionTime.dateToString(begin, "yyyy-MM-dd") + "'" : String.valueOf(restrictions) + " AND ACTION_DATE BETWEEN '" + ConversionTime.dateToString(begin, "yyyy-MM-dd") + "' AND '" + ConversionTime.dateToString(end, "yyyy-MM-dd") + "'";
        }
        if (!restrictions.equals("")) {
            sql = String.valueOf(sql) + " WHERE " + restrictions.substring(5);
            TimsLogger.debug("sql += " + sql);
        }
        sql = String.valueOf(sql) + " ORDER BY ACTION_DATE DESC";
        try {
            ResultSet rs = null;
            Statement stm = DevAction.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                DevAction tmp = new DevAction(rs.getInt("ID"), rs.getTimestamp("ACTION_DATE"), rs.getString("DESCRIPTION"), rs.getInt("STATE_ID"), rs.getInt("MANAGER_ID"), rs.getInt("CATEGORY_ID"), rs.getInt("DETECTION_VERSION_ID"), rs.getInt("CORRECTION_VERSION_ID"), rs.getInt("TYPE_ID"), rs.getInt("PRIORITY_ID"), rs.getString("PROBLEM"), rs.getString("SOLVE"), rs.getInt("LENGTH_INTERV"), rs.getString("KEYWORDS"), rs.getInt("VIEW_LEVEL"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("DevAction.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }
}

