/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Constants;

public class DriverDownloadWarning
extends MainElement
implements Cloneable {
    public static final String table = "IMPORT_ACTIVITY_WARNING";
    private int id = 0;
    private int driverId = 0;
    private int importActivityId = 0;
    private Date lastDownload = null;
    private Date lastImport = null;

    public DriverDownloadWarning() {
    }

    public DriverDownloadWarning clone() throws CloneNotSupportedException {
        return (DriverDownloadWarning)super.clone();
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public Date getDownloadDate() {
        return this.lastDownload;
    }

    public void setDownloadDate(Date downloadDate) {
        this.lastDownload = downloadDate;
    }

    public Date getImportDate() {
        return this.lastImport;
    }

    public void setImportDate(Date importDate) {
        this.lastImport = importDate;
    }

    public int getImportActivityId() {
        return this.importActivityId;
    }

    public void setImportActivityId(int importActivityId) {
        this.importActivityId = importActivityId;
    }

    public String toString() {
        return "DriverDownloadWarning id " + this.id + " : {driverId = " + this.driverId + "} {downloadDate = " + this.lastDownload + "} {importDate = " + this.lastImport + "}";
    }

    public DriverDownloadWarning(int id, int importActivityId, int driverId, Date downloadDate, Date importDate) {
        this.id = id;
        this.importActivityId = importActivityId;
        this.driverId = driverId;
        this.lastDownload = downloadDate;
        this.lastImport = importDate;
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = DriverDownloadWarning.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#DriverDownloadDate.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#DriverDownloadDate.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.driverId = rs.getInt("DRIVER_ID");
                    this.lastDownload = rs.getDate("DOWNLOAD_DATE");
                    this.lastImport = rs.getDate("IMPORT_DATE");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#DriverDownladWarning.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#DriverDownladWarning.insert()#");
        try {
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO IMPORT_ACTIVITY_WARNING (" + DriverDownloadWarning.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?)";
                this.statement = DriverDownloadWarning.getConnection().prepareStatement(sql);
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO IMPORT_ACTIVITY_WARNING (" + DriverDownloadWarning.getAllFields().substring(DriverDownloadWarning.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?)";
                this.statement = DriverDownloadWarning.getConnection().prepareStatement(sql, 1);
            }
            this.statement.setObject(1, (Object)this.importActivityId, 4);
            this.statement.setObject(2, (Object)this.driverId, 4);
            this.statement.setTimestamp(3, new Timestamp(this.lastDownload.getTime()));
            this.statement.setTimestamp(4, new Timestamp(this.lastImport.getTime()));
            this.statement.executeUpdate();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    private static String getAllFields() {
        return "ID, IMPORT_ACTIVITY_ID, DRIVER_ID, LAST_DOWNLOAD, LAST_IMPORT";
    }

    public static ArrayList<DriverDownloadWarning> loadList(int importActivityId) {
        ArrayList<DriverDownloadWarning> liste = new ArrayList<DriverDownloadWarning>();
        String sql = "SELECT " + DriverDownloadWarning.getAllFields() + " FROM " + table;
        if (importActivityId != 0) {
            sql = String.valueOf(sql) + " WHERE IMPORT_ACTIVITY_ID =" + importActivityId;
        }
        try {
            Transport.ps.startOperation();
            ResultSet rs = null;
            Statement stm = DriverDownloadWarning.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate liste import activit\u00e9", "#DriverDownloadWarning.loadLastList() => %s# sql = " + sql, 1);
            while (rs.next()) {
                DriverDownloadWarning tmp = new DriverDownloadWarning(rs.getInt("ID"), rs.getInt("IMPORT_ACTIVITY_ID"), rs.getInt("DRIVER_ID"), new Date(rs.getTimestamp("LAST_DOWNLOAD").getTime()), new Date(rs.getTimestamp("LAST_IMPORT").getTime()));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("DriverDownladWarning.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }
}

