/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.ExpensesAmount;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Constants;

public class DriverExpenses
extends MainElement {
    public static final String table = "t_lien_jour_frais";
    public static int OFFSET = 118;
    private int id = 0;
    private int driverId = 0;
    private int expensesId = 0;
    private java.util.Date date = null;
    private boolean forfait = false;
    private float base = 0.0f;
    private float rate = 0.0f;
    private float amount = 0.0f;
    private boolean outside = false;
    private float userId = 0.0f;
    private int automatic = 0;

    public DriverExpenses() {
    }

    public DriverExpenses(int cle, int cleConducteur, java.util.Date dateJour, int cleFrais, boolean forfait, float base, float rate, float montant, boolean etranger, int automatic) {
        this.id = cle;
        this.driverId = cleConducteur;
        this.date = dateJour;
        this.expensesId = cleFrais;
        this.forfait = forfait;
        this.base = base;
        this.rate = rate;
        this.amount = montant;
        this.outside = etranger;
        this.automatic = automatic;
    }

    public boolean equals(Object o) {
        return o instanceof DriverExpenses && this.driverId == ((DriverExpenses)o).getDriverId() && this.expensesId == ((DriverExpenses)o).getExpensesId() && this.date.equals(((DriverExpenses)o).getDate());
    }

    public boolean load(int cle) {
        ResultSet rs = null;
        String sql = "SELECT CLE_LIEN_JOUR_FRAIS, CLE_CHAUFFEUR, DATE_JOUR, CLE_FRAIS, MONTANT, ETRANGER, BASE, TAUX, FORFAIT FROM t_lien_jour_frais WHERE CLE_LIEN_JOUR_FRAIS=?";
        try {
            this.statement = DriverExpenses.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)cle, 4);
            rs = this.statement.executeQuery();
            if (rs.next()) {
                this.id = cle;
                this.driverId = rs.getInt("CLE_CHAUFFEUR");
                this.date = rs.getDate("DATE_JOUR");
                this.expensesId = rs.getInt("CLE_FRAIS");
                this.amount = rs.getFloat("MONTANT");
                this.outside = rs.getBoolean("ETRANGER");
                this.base = rs.getFloat("BASE");
                this.rate = rs.getFloat("TAUX");
                this.forfait = rs.getBoolean("FORFAIT");
                this.forfait = rs.getBoolean("FORFAIT");
                return true;
            }
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.error("load()# sql = " + sql + " => " + ex.getMessage());
        }
        finally {
            try {
                this.statement.close();
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return false;
    }

    public boolean load(int cleConducteur, java.util.Date dateJour, int cleFrais) {
        boolean toReturn = false;
        ResultSet rs = null;
        String sql = "SELECT CLE_LIEN_JOUR_FRAIS, CLE_FRAIS, MONTANT, ETRANGER, BASE, TAUX, FORFAIT, AUTOMATIC FROM t_lien_jour_frais WHERE CLE_CHAUFFEUR = ? AND DATE_JOUR = ?";
        if (cleFrais != 0) {
            sql = String.valueOf(sql) + " AND CLE_FRAIS = ?";
        }
        try {
            try {
                this.statement = DriverExpenses.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)cleConducteur, 4);
                this.statement.setDate(2, new Date(this.date.getTime()));
                if (cleFrais != 0) {
                    this.statement.setObject(3, (Object)cleFrais, 4);
                }
                rs = this.statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("CLE_LIEN_JOUR_FRAIS");
                    this.driverId = cleConducteur;
                    this.date = dateJour;
                    this.expensesId = cleFrais;
                    this.amount = rs.getFloat("MONTANT");
                    this.outside = rs.getBoolean("ETRANGER");
                    this.base = rs.getFloat("BASE");
                    this.rate = rs.getFloat("TAUX");
                    this.automatic = rs.getInt("AUTOMATIC");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.error("load()# sql = " + sql + " => " + ex.getMessage());
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return toReturn;
    }

    public boolean loadExistingId() {
        boolean toReturn = false;
        ResultSet rs = null;
        String sql = "SELECT CLE_LIEN_JOUR_FRAIS FROM t_lien_jour_frais WHERE CLE_CHAUFFEUR = ? AND DATE_JOUR = ? AND CLE_FRAIS = ?";
        try {
            try {
                this.statement = DriverExpenses.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.driverId, 4);
                this.statement.setDate(2, new Date(this.date.getTime()));
                this.statement.setObject(3, (Object)this.expensesId, 4);
                rs = this.statement.executeQuery();
                if (rs.next()) {
                    this.id = rs.getInt("CLE_LIEN_JOUR_FRAIS");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    this.statement.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.error("loadExistingId()# sql = " + sql + " => " + ex.getMessage());
                try {
                    this.statement.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                this.statement.close();
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public String getInsertString() {
        return String.valueOf(this.getDriverId()) + "\t" + ConversionTime.dateToString(this.getDate(), "yyyy-MM-dd") + "\t" + this.getExpensesId() + "\t" + this.getAmount() + "\t" + (this.isOutside() ? 1 : 0) + "\t" + this.getBase() + "\t" + this.getRate() + "\t" + (this.isForfait() ? 1 : 0) + "\t" + this.getAutomatic();
    }

    public boolean insert() {
        if (this.expensesId == 0) {
            TimsLogger.warn("Impossible d'enregistrer un frais non connu pour un conducteur");
            return false;
        }
        boolean retour = false;
        String sql = "";
        TimsLogger.debug("#DriverExpenses.insert()#");
        try {
            try {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO t_lien_jour_frais (CLE_LIEN_JOUR_FRAIS, CLE_CHAUFFEUR, DATE_JOUR, CLE_FRAIS, MONTANT, ETRANGER, BASE, TAUX, FORFAIT, AUTOMATIC, CLE_USER) VALUES (GEN_T_LIEN_JOUR_FRAIS.nextval,?,?,?,?,?,?,?,?,?,?)";
                    this.statement = DriverExpenses.getConnection().prepareStatement(sql);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO t_lien_jour_frais (CLE_CHAUFFEUR, DATE_JOUR, CLE_FRAIS, MONTANT, ETRANGER, BASE, TAUX, FORFAIT, AUTOMATIC, CLE_USER) VALUES (?,?,?,?,?,?,?,?,?,?)";
                    this.statement = DriverExpenses.getConnection().prepareStatement(sql, 1);
                }
                this.statement.setObject(1, (Object)this.driverId, 4);
                this.statement.setDate(2, new Date(this.date.getTime()));
                this.statement.setObject(3, (Object)this.expensesId, 4);
                this.statement.setObject(4, (Object)Float.valueOf(this.amount), 6);
                this.statement.setObject(5, (Object)(this.outside ? 1 : 0), 4);
                this.statement.setObject(6, (Object)Float.valueOf(this.base), 6);
                this.statement.setObject(7, (Object)Float.valueOf(this.rate), 6);
                this.statement.setObject(8, (Object)(this.forfait ? 1 : 0), 4);
                this.statement.setObject(9, (Object)this.automatic, 4);
                this.statement.setObject(10, (Object)Float.valueOf(this.userId), 4);
                this.statement.executeUpdate();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                retour = true;
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    try {
                        ResultSet rs = this.statement.getGeneratedKeys();
                        if (!rs.next()) {
                            TimsLogger.warn("#DriverExpenses.insert# no auto generated key availaible");
                        } else {
                            TimsLogger.debug("#DriverExpenses.insert# auto generated key value = " + rs.getInt(1));
                            this.id = rs.getInt(1);
                        }
                        rs.close();
                    }
                    catch (Exception ex) {
                        TimsLogger.error("#DriverExpenses.insert# " + ex.getMessage());
                        ex.printStackTrace();
                    }
                }
                if (this.id == 0) {
                    if (this.loadId()) {
                        TimsLogger.debug("#DriverExpenses.insert# generated key value = " + this.id);
                    } else {
                        TimsLogger.warn("#DriverExpenses.insert# no generated key availaible");
                    }
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    TimsLogger.error("insert()# sql = " + sql + " => " + ex2.getMessage());
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    TimsLogger.error("insert()# sql = " + sql + " => " + ex.getMessage());
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("insert()# sql = " + sql + " => " + ex.getMessage());
            }
        }
        return retour;
    }

    public boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT MAX(ID) AS ID FROM t_lien_jour_frais WHERE CLE_CHAUFFEUR = ? AND DATE_JOUR = ? AND CLE_FRAIS= ?";
        PreparedStatement statement = null;
        try {
            try {
                statement = DriverExpenses.getConnection().prepareStatement(sql);
                statement.setObject(1, (Object)this.driverId, 12);
                statement.setObject(2, (Object)this.date, 12);
                statement.setObject(3, (Object)this.expensesId, 12);
                rs = statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("ID");
                    TimsLogger.debug("#DriverExpenses.loadId# id found " + rs.getInt("ID"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.error("loadId()#  sql = " + sql + " => " + ex.getMessage());
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean updateValue() {
        boolean retour = false;
        String sql = "UPDATE t_lien_jour_frais SET  CLE_CHAUFFEUR=? , DATE_JOUR=? , CLE_FRAIS=? , MONTANT=? , ETRANGER = ? , BASE = ? , TAUX = ? , FORFAIT = ? , AUTOMATIC = ?  WHERE CLE_LIEN_JOUR_FRAIS=?";
        try {
            try {
                this.statement = DriverExpenses.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.driverId, 4);
                this.statement.setDate(2, new Date(this.date.getTime()));
                this.statement.setObject(3, (Object)this.expensesId, 4);
                this.statement.setObject(4, (Object)Float.valueOf(this.amount), 6);
                this.statement.setObject(5, (Object)(this.outside ? 1 : 0), 4);
                this.statement.setObject(6, (Object)Float.valueOf(this.base), 6);
                this.statement.setObject(7, (Object)Float.valueOf(this.rate), 6);
                this.statement.setObject(8, (Object)(this.forfait ? 1 : 0), 4);
                this.statement.setObject(9, (Object)this.automatic, 4);
                this.statement.setObject(10, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    TimsLogger.error("updateValue()# sql = " + sql + " => " + ex2.getMessage());
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    TimsLogger.error("updateValue()# sql = " + sql + " => " + ex.getMessage());
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("updateValue()# sql = " + sql + " => " + ex.getMessage());
            }
        }
        return retour;
    }

    public boolean delete() {
        boolean retour = false;
        String sql = "DELETE FROM t_lien_jour_frais WHERE CLE_LIEN_JOUR_FRAIS=?";
        try {
            try {
                this.statement = DriverExpenses.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 1, new java.util.Date(), this.affiche()).insert();
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int cle) {
        this.id = cle;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int cleConducteur) {
        this.driverId = cleConducteur;
    }

    public int getExpensesId() {
        return this.expensesId;
    }

    public void setExpensesId(int cleFrais) {
        this.expensesId = cleFrais;
    }

    public java.util.Date getDate() {
        return this.date;
    }

    public void setDate(java.util.Date dateJour) {
        this.date = dateJour;
    }

    public boolean isOutside() {
        return this.outside;
    }

    public void setOutside(boolean etranger) {
        this.outside = etranger;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setAmount(float montant) {
        this.amount = montant;
    }

    public float getBase() {
        return this.base;
    }

    public void setBase(float base) {
        this.base = base;
    }

    public float getRate() {
        return this.rate;
    }

    public void setRate(float rate) {
        this.rate = rate;
    }

    public boolean isForfait() {
        return this.forfait;
    }

    public void setForfait(boolean forfait) {
        this.forfait = forfait;
    }

    public int getAutomatic() {
        return this.automatic;
    }

    public void setAutomatic(int automatic) {
        this.automatic = automatic;
    }

    public String affiche() {
        String returnString = "#DriverExpenses# driver:" + this.driverId + ", expenses:" + this.expensesId + ", date:" + this.date + ", montant:" + this.amount + ", base: " + this.base + ", rate: " + this.rate + " , outside: " + this.outside;
        TimsLogger.verbose(returnString);
        return returnString;
    }

    public byte[] write(OutputStream out) {
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            String activite = String.valueOf(ConversionTime.dateStringToBinary(ConversionTime.dateToString(this.date, "yyyy-MM-dd"))) + "000";
            int x = 0;
            while (x < 2) {
                tmp.write(Integer.parseInt(activite.substring(x * 8, (x + 1) * 8), 2));
                ++x;
            }
            tmp.write(this.expensesId);
            tmp.write(this.outside ? 1 : 0);
            tmp.write(Float.toString(this.amount).getBytes());
            out.write((byte)OFFSET);
            out.write((byte)(tmp.size() / 255 + 1));
            out.write((byte)tmp.size());
            tmp.writeTo(out);
            return tmp.toByteArray();
        }
        catch (Exception ex) {
            TimsLogger.error("insert()# write => " + ex.getMessage());
            return null;
        }
    }

    public void read(byte[] fileBuffer) {
        int x = 0;
        String tmp = "";
        while (x < 2) {
            tmp = String.valueOf(tmp) + Integer.toBinaryString(256 + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x])).substring(1);
            TimsLogger.debug("#DriverExpenses.read#" + (fileBuffer[x] < 0 ? fileBuffer[x] + 256 : fileBuffer[x]) + " => " + tmp.substring(x * 8));
            ++x;
        }
        this.date = ConversionTime.stringToDate(ConversionTime.binaryToDateString(tmp), "yyyy-MM-dd");
        this.expensesId = fileBuffer[2];
        this.outside = fileBuffer[3] == 1;
        this.amount = Float.parseFloat(new String(fileBuffer).substring(4));
    }

    public static Vector<DriverExpenses> loadList(int agencyId, Vector<Conducteur> drivers, java.util.Date begin, java.util.Date end) {
        String restriction = "";
        if (agencyId != 0) {
            restriction = String.valueOf(restriction) + " AND LJF.CLE_CHAUFFEUR IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE CLE_AGENCE = " + agencyId + ")";
        }
        restriction = drivers != null && drivers.size() != 0 ? String.valueOf(restriction) + " AND " + DriverExpenses.buildDriverFilters(drivers, "LJF.CLE_CHAUFFEUR") : String.valueOf(restriction) + " AND c.ARCHIVAGE = 0";
        String restrict = BddTransport.addNewRestriction(null, true, table, false);
        if (restrict != "") {
            restriction = String.valueOf(restriction) + " AND " + restrict;
        }
        if (begin != null) {
            restriction = end != null && !end.equals("") ? String.valueOf(restriction) + " AND DATE_JOUR BETWEEN " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false) + " AND " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(end, "yyyy-MM-dd"), false) : String.valueOf(restriction) + " AND DATE_JOUR =" + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false);
        }
        if (restriction != "") {
            restriction = " WHERE " + restriction.substring(5);
        }
        return DriverExpenses.loadList(restriction);
    }

    public static Vector<DriverExpenses> loadList(Vector<Agence> agencies, Vector<Conducteur> drivers, java.util.Date begin, java.util.Date end) {
        String restriction = "";
        if (drivers == null || drivers.size() == 0) {
            String agencyFilter = DriverExpenses.buildAgencyFilters(agencies, "CLE_AGENCE");
            restriction = String.valueOf(restriction) + " AND LJF.CLE_CHAUFFEUR IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE " + agencyFilter + ") AND c.ARCHIVAGE = 0";
        } else {
            restriction = String.valueOf(restriction) + " AND " + DriverExpenses.buildDriverFilters(drivers, "LJF.CLE_CHAUFFEUR");
        }
        String restrict = BddTransport.addNewRestriction(null, true, table, false);
        if (restrict != "") {
            restriction = String.valueOf(restriction) + " AND " + restrict;
        }
        if (begin != null) {
            restriction = end != null && !end.equals("") ? String.valueOf(restriction) + " AND DATE_JOUR BETWEEN '" + ConversionTime.dateToString(begin, "yyyy-MM-dd") + "' AND '" + ConversionTime.dateToString(end, "yyyy-MM-dd") + "'" : String.valueOf(restriction) + " AND DATE_JOUR ='" + ConversionTime.dateToString(begin, "yyyy-MM-dd") + "'";
        }
        if (restriction != "") {
            restriction = " WHERE " + restriction.substring(5);
        }
        return DriverExpenses.loadList(restriction);
    }

    public static Vector<DriverExpenses> loadList(int agencyId, int driverId, java.util.Date begin, java.util.Date end) {
        String restriction = "";
        if (agencyId != 0 && driverId == 0) {
            restriction = String.valueOf(restriction) + " AND LJF.CLE_CHAUFFEUR IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE CLE_AGENCE = " + agencyId + ")";
        }
        restriction = driverId != 0 ? String.valueOf(restriction) + " AND LJF.CLE_CHAUFFEUR = " + driverId : String.valueOf(restriction) + " AND c.ARCHIVAGE = 0";
        String restrict = BddTransport.addNewRestriction(null, true, table, false);
        if (restrict != "") {
            restriction = String.valueOf(restriction) + " AND " + restrict;
        }
        if (begin != null) {
            restriction = end != null && !end.equals("") ? String.valueOf(restriction) + " AND DATE_JOUR BETWEEN " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false) + " AND " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(end, "yyyy-MM-dd"), false) : String.valueOf(restriction) + " AND DATE_JOUR =" + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false);
        }
        if (restriction != "") {
            restriction = String.valueOf(restriction) + " WHERE " + restriction.substring(5);
        }
        return DriverExpenses.loadList(restriction);
    }

    public static Vector<DriverExpenses> loadList(String filters) {
        String sql = "";
        Vector<DriverExpenses> result = new Vector<DriverExpenses>();
        try {
            sql = "SELECT LJF.CLE_CHAUFFEUR, CLE_LIEN_JOUR_FRAIS, CLE_FRAIS, MONTANT, ETRANGER, DATE_JOUR, FORFAIT, BASE, TAUX, AUTOMATIC FROM t_lien_jour_frais LJF JOIN t_conducteur c on LJF.CLE_CHAUFFEUR=c.CLE_CHAUFFEUR " + filters + " ORDER BY NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, CLE_CHAUFFEUR, CLE_FRAIS";
            TimsLogger.debug("DriverExpenese.loadList# " + sql);
            PreparedStatement stm = DriverExpenses.getConnection().prepareStatement(sql);
            Transport.ps.startOperation();
            ResultSet rs = stm.executeQuery();
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate frais conducteur", "#DriverExpenses.loadList() => %s# sql = " + sql, 1);
            while (rs.next()) {
                result.add(new DriverExpenses(rs.getInt("CLE_LIEN_JOUR_FRAIS"), rs.getInt("CLE_CHAUFFEUR"), rs.getDate("DATE_JOUR"), rs.getInt("CLE_FRAIS"), rs.getBoolean("FORFAIT"), rs.getFloat("BASE"), rs.getFloat("TAUX"), rs.getFloat("MONTANT"), rs.getBoolean("ETRANGER"), rs.getInt("AUTOMATIC")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("loadList()# sql = " + sql + " returns " + ex.getMessage());
        }
        return result;
    }

    public static boolean deleteExpenses(int driverId, String begin, String end, int deleteType) {
        String sql = "";
        boolean toReturn = false;
        boolean validate = (deleteType & 8) != 0;
        boolean excludeWs = (deleteType & 4) != 0;
        boolean manualOnly = (deleteType & 2) != 0;
        boolean autoOnly = (deleteType & 1) != 0;
        Statement stm = null;
        try {
            try {
                String dateB = begin != null ? (end != null ? "BETWEEN " + BddTransport.getDateStringToSGBDR(begin, false) + " AND " + BddTransport.getDateStringToSGBDR(end, false) : "= " + BddTransport.getDateStringToSGBDR(begin, false)) : null;
                sql = "DELETE FROM t_lien_jour_frais WHERE CLE_CHAUFFEUR=" + driverId;
                if (excludeWs) {
                    sql = String.valueOf(sql) + " AND AUTOMATIC != 2";
                } else if (manualOnly) {
                    sql = String.valueOf(sql) + " AND AUTOMATIC = 0";
                } else if (autoOnly) {
                    sql = String.valueOf(sql) + " AND AUTOMATIC = 1";
                }
                if (dateB != null) {
                    sql = String.valueOf(sql) + " AND DATE_JOUR " + dateB;
                }
                if (!validate) {
                    sql = String.valueOf(sql) + " AND DATE_JOUR NOT IN (SELECT DAY FROM expenses_validation WHERE USER_UNVALID = -1 AND DRIVER_ID = " + driverId + " AND DAY " + dateB + ")";
                }
                stm = DriverExpenses.getConnection().prepareStatement(sql);
                TimsLogger.verbose("#deleteExpenses# sql = " + sql);
                Transport.ps.startOperation();
                stm.executeUpdate();
                Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate suppression frais conducteur", "#DriverExpenses.loadList() => %s# sql = " + sql, 1);
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                stm.close();
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (SQLException ex2) {
                    TimsLogger.error("deleteExpenses()# unable to close statement => " + ex2.getMessage());
                }
            }
            catch (Exception ex) {
                TimsLogger.error("deleteExpenses()# sql = " + sql + " returns " + ex.getMessage());
                try {
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (SQLException ex3) {
                    TimsLogger.error("deleteExpenses()# unable to close statement => " + ex3.getMessage());
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("deleteExpenses()# unable to close statement => " + ex.getMessage());
            }
        }
        return toReturn;
    }

    public static Vector<DriverExpenses> find(Vector<DriverExpenses> toSearch, int driverId, java.util.Date date) {
        Vector<DriverExpenses> toReturn = new Vector<DriverExpenses>();
        for (DriverExpenses de : toSearch) {
            if (!de.getDate().equals(date) || de.getDriverId() != driverId) continue;
            toReturn.add(de);
        }
        return toReturn;
    }

    public static boolean updateAmount(ExpensesType current, java.util.Date since) {
        TimsLogger.debug("#DE.updateAmount# on met \u00e0 jour le frais " + current.getCode() + " depuis le " + since);
        if (since == null) {
            since = ConversionTime.stringToDate("2000-01-01", "dd/MM/yyyy");
        }
        PreparedStatement stm = null;
        boolean toReturn = true;
        String sql = "UPDATE t_lien_jour_frais SET MONTANT=? WHERE CLE_FRAIS = ? AND ETRANGER=? AND FORFAIT=1 AND DATE_JOUR BETWEEN ? AND ?";
        try {
            BddTransport.getInstance().startTransaction();
            stm = DriverExpenses.getConnection().prepareStatement(sql);
            int x = 0;
            while (x < current.getMontants().size()) {
                java.util.Date until;
                ExpensesAmount toUpdate = current.getMontants().get(x);
                TimsLogger.debug("#DE.updateAmount# on v\u00e9rifie le montant depuis " + toUpdate.getEnacted());
                java.util.Date date = until = current.getMontants().size() == x + 1 ? ConversionTime.addDay(new java.util.Date(), 365) : ConversionTime.addDay(current.getMontants().get(x + 1).getEnacted(), -1);
                if (until.compareTo(since) <= 0) {
                    TimsLogger.debug("#DE.updateAmount# on est avant la date demand\u00e9e (" + until + " <= " + since + "). On passe ce montant");
                } else {
                    if (until.before(toUpdate.getEnacted())) {
                        TimsLogger.debug("#DE.updateAmount# " + until + " est avant " + toUpdate.getEnacted() + ". Ce n'est pas logique, il y a une erreur...");
                        BddTransport.getInstance().rollback();
                        toReturn = false;
                        break;
                    }
                    TimsLogger.debug("#DE.updateAmount# on met \u00e0 jour " + current.getCode() + " (" + current.getCle() + ") de " + toUpdate.getEnacted() + " \u00e0 " + until + " " + toUpdate.getFrenchAmount() + " (" + toUpdate.getForeignAmount() + ")");
                    stm.setObject(1, (Object)Float.valueOf(toUpdate.getFrenchAmount()), 6);
                    stm.setObject(2, (Object)current.getCle(), 4);
                    stm.setObject(3, (Object)0, 4);
                    stm.setTimestamp(4, new Timestamp(toUpdate.getEnacted().getTime()));
                    stm.setTimestamp(5, new Timestamp(until.getTime()));
                    stm.executeUpdate();
                    stm.setObject(1, (Object)Float.valueOf(toUpdate.getForeignAmount()), 6);
                    stm.setObject(3, (Object)1, 4);
                    stm.executeUpdate();
                }
                ++x;
            }
            BddTransport.getInstance().commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return toReturn;
    }
}

