/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.exception.DayTypeNotFoundException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.MainFrameTransport;
import transpo.system.util.Constants;

public class DriverPlanning
extends MainElement {
    public static final String table = "driver_planning";
    public static final int NORMAL = 0;
    public static final int SEMI = 1;
    public static final int FULL = 2;
    public static int DEFAULT_LENGTH_VALUE = 480;
    public static int DEFAULT_BEGIN_VALUE = 480;
    private int id = 0;
    private int driverId = 0;
    private int dayTypeId = 0;
    private int userId = 0;
    private int type = 0;
    private java.util.Date day = null;
    private int begin = 480;
    private int length = 0;
    private String comm = "";

    public DriverPlanning() {
    }

    public void setValues(int id, int driverId, int dayTypeId, int userId, java.util.Date day, int begin, int length, int type, String comm) {
        this.id = id;
        this.driverId = driverId;
        this.dayTypeId = dayTypeId;
        this.userId = userId;
        this.day = day;
        this.begin = begin;
        this.length = length;
        this.type = type;
        this.comm = comm;
    }

    public DriverPlanning(int driverId) {
        this.driverId = driverId;
    }

    public boolean equals(Object obj) {
        return obj instanceof DriverPlanning && ((DriverPlanning)obj).getDriverId() == this.driverId && ((DriverPlanning)obj).getDayTypeId() == this.dayTypeId && ((DriverPlanning)obj).getDay().equals(this.day) && ((DriverPlanning)obj).getType() == this.type;
    }

    private static String getAllFields() {
        return "DRIVER_ID, DAY_TYPE_ID, USER_ID, DAY, BEGIN_HOUR, LENGTH, TYPE, COMM";
    }

    public PreparedStatement getPreparedStatement() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO driver_planning(ID, " + DriverPlanning.getAllFields() + ") VALUES " + "(GEN_DRIVER_PLANNING.nextval,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO driver_planning(" + DriverPlanning.getAllFields() + ") VALUES " + "(?,?,?,?,?,?,?,?)";
        }
        try {
            this.statement = DriverPlanning.getConnection().prepareStatement(sql);
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            System.err.println("#DP.getPreparedStatement# erreur");
            ex.printStackTrace();
        }
        return this.statement;
    }

    public void update() {
        this.affiche();
        if (this.id != 0) {
            this.updateJour();
        } else {
            this.insert();
        }
    }

    public void affiche() {
        TimsLogger.info("#DP.affiche()# driver_id " + this.driverId + " day = " + this.day + " cle=" + this.id);
    }

    public boolean insert() {
        boolean toReturn = false;
        PreparedStatement statement = null;
        try {
            try {
                statement = this.getPreparedStatement();
                statement.setObject(1, (Object)this.driverId, 4);
                statement.setObject(2, (Object)this.dayTypeId, 4);
                statement.setObject(3, (Object)this.userId, 4);
                statement.setDate(4, new Date(this.day.getTime()));
                statement.setObject(5, (Object)this.begin, 4);
                statement.setObject(6, (Object)this.length, 4);
                statement.setObject(7, (Object)this.type, 4);
                statement.setObject(8, (Object)this.comm, 12);
                statement.executeUpdate();
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean delete() {
        String sql = "DELETE FROM driver_planning WHERE CLE= ?";
        try {
            this.statement = DriverPlanning.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public boolean updateJour() {
        String sql = "UPDATE driver_planning SET  DRIVER_ID = ? , DAY_TYPE_ID = ? , USER_ID = ? , DAY = ? , BEGIN_HOUR = ? , LENGTH = ? , TYPE = ?,  COMM = ?  WHERE ID = ?";
        try {
            this.statement = DriverPlanning.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.driverId, 4);
            this.statement.setObject(2, (Object)this.dayTypeId, 4);
            this.statement.setObject(3, (Object)this.dayTypeId, 4);
            this.statement.setDate(4, new Date(this.day.getTime()));
            this.statement.setObject(5, (Object)this.begin, 4);
            this.statement.setObject(6, (Object)this.length, 4);
            this.statement.setObject(7, (Object)this.type, 4);
            this.statement.setObject(8, (Object)this.comm, 12);
            this.statement.setObject(9, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public boolean load(int driverId, Timestamp day) {
        block4: {
            ResultSet rs = null;
            TimsLogger.debug("#LienJourConducteur.load()#");
            String sql = "SELECT " + DriverPlanning.getAllFields() + " FROM " + table + " WHERE DRIVER_ID = ? AND DAY = ?";
            this.statement = DriverPlanning.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)driverId, 12);
            this.statement.setTimestamp(2, day);
            rs = this.statement.executeQuery();
            if (!rs.next()) break block4;
            this.id = rs.getInt("ID");
            this.driverId = driverId;
            this.dayTypeId = rs.getInt("DAY_TYPE_ID");
            this.userId = rs.getInt("USER_ID");
            this.day = day;
            this.begin = rs.getInt("BEGIN_JOUR");
            this.length = rs.getInt("LENGTH");
            this.type = rs.getInt("TYPE");
            this.comm = rs.getString("COMM");
            this.statement.close();
            return true;
        }
        try {
            this.statement.close();
            return false;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public int getDayTypeId() {
        return this.dayTypeId;
    }

    public void setDayTypeId(int dayTypeId) {
        this.dayTypeId = dayTypeId;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public java.util.Date getDay() {
        return this.day;
    }

    public void setDay(java.util.Date day) {
        this.day = day;
    }

    public int getBegin() {
        return this.begin;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public String getComm() {
        return this.comm;
    }

    public void setComm(String comm) {
        this.comm = comm;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getDuree(int contractDayLength) {
        int returnLength = 0;
        if (this.type != 0) {
            JourType dayType = this.getDayType();
            if (dayType != null && "CP".equals(dayType.getCode()) && ConversionTime.getDayOfWeek(this.getDay(), false) == 7) {
                return 0;
            }
            int fullDayLength = 0;
            if (contractDayLength != 0) {
                fullDayLength = contractDayLength;
            } else if (this.dayTypeId != 0) {
                int n = fullDayLength = dayType != null ? dayType.getService() : 0;
            }
            if (this.type == 1) {
                returnLength = fullDayLength / 2;
            }
            if (this.type == 2) {
                returnLength = fullDayLength;
            }
        } else {
            returnLength = this.length;
        }
        return returnLength;
    }

    public int getPrintLength(int contractDayLength) {
        int dureeToReturn = 0;
        if (this.type != 0) {
            int toReturn = 0;
            if (contractDayLength != 0) {
                toReturn = contractDayLength;
            } else if (this.dayTypeId != 0) {
                JourType dayType = this.getDayType();
                int n = toReturn = dayType != null ? dayType.getService() : 420;
            }
            if (this.type == 1) {
                dureeToReturn = toReturn / 2;
            }
            if (this.type == 2) {
                dureeToReturn = toReturn;
            }
        }
        if (dureeToReturn == 0) {
            dureeToReturn = this.length;
        }
        return dureeToReturn == 0 ? DEFAULT_LENGTH_VALUE : dureeToReturn;
    }

    public JourType getDayType() {
        JourType toReturn = null;
        try {
            toReturn = JourType.getDayType(this.dayTypeId);
        }
        catch (DayTypeNotFoundException ex) {
            TimsLogger.warn("#LJC.getDayType()# impossible de trouver le jour type : " + this.dayTypeId);
        }
        return toReturn;
    }

    public String getDesignation() {
        String toReturn = "";
        try {
            toReturn = JourType.getDayType(this.dayTypeId).getDesignation();
        }
        catch (DayTypeNotFoundException ex) {
            ex.printStackTrace();
        }
        return toReturn;
    }

    public static Vector<DriverPlanning> loadList(int agencyId, int driverId, java.util.Date begin, java.util.Date end) {
        String res = "";
        if (begin != null) {
            res = end != null ? String.valueOf(res) + " AND DAY BETWEEN " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false) + " AND " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(end, "yyyy-MM-dd"), false) : String.valueOf(res) + " AND DAY =" + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false);
        }
        if (agencyId != 0 && driverId == 0) {
            res = String.valueOf(res) + " AND ljc.DRIVER_ID IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE CLE_AGENCE = " + agencyId + ")";
        }
        if (driverId != 0) {
            res = String.valueOf(res) + " AND ljc.DRIVER_ID = " + driverId;
        }
        return DriverPlanning.loadList(res);
    }

    public static Vector<DriverPlanning> loadList(Vector<Agence> agencies, Vector<Conducteur> drivers, java.util.Date begin, java.util.Date end) {
        String res = "";
        if (drivers == null || drivers.size() == 0) {
            if (agencies != null && agencies.size() != 0) {
                String agencyFilter = DriverPlanning.buildAgencyFilters(agencies, "CLE_AGENCE");
                res = String.valueOf(res) + " AND ljc.DRIVER_ID IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE " + agencyFilter + ")";
            }
        } else {
            res = String.valueOf(res) + " AND " + DriverPlanning.buildDriverFilters(drivers, "ljc.CLE_CHAUFFEUR");
        }
        if (begin != null) {
            res = end != null ? String.valueOf(res) + " AND DAY BETWEEN " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false) + " AND " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(end, "yyyy-MM-dd"), false) : String.valueOf(res) + " AND DAY =" + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false);
        }
        return DriverPlanning.loadList(res);
    }

    public static Vector<DriverPlanning> loadList(int agencyId, Vector<Conducteur> drivers, java.util.Date begin, java.util.Date end) {
        String res = "";
        if (agencyId != 0) {
            res = String.valueOf(res) + " AND ljc.DRIVER_ID IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE CLE_AGENCE = " + agencyId + ")";
        }
        if (drivers != null && drivers.size() != 0) {
            res = String.valueOf(res) + " AND " + DriverPlanning.buildDriverFilters(drivers, "ljc.DRIVER_ID");
        }
        if (begin != null) {
            res = end != null ? String.valueOf(res) + " AND DAY BETWEEN " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false) + " AND " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(end, "yyyy-MM-dd"), false) : String.valueOf(res) + " AND DAY =" + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false);
        }
        return DriverPlanning.loadList(res);
    }

    public static Vector<DriverPlanning> loadList(String filters) {
        Vector<DriverPlanning> toReturn = new Vector<DriverPlanning>();
        String sql = "";
        try {
            sql = "SELECT ljc." + DriverPlanning.getAllFields() + " FROM " + table + " ljc JOIN " + "t_conducteur" + " on ljc.DRIVER_ID=" + "t_conducteur" + ".CLE_CHAUFFEUR " + " WHERE " + "t_conducteur" + ".ARCHIVAGE = " + (MainFrameTransport.archivage ? "1" : "0") + filters + " ORDER BY NOM_CONDUCTEUR, PRENOM_CONDUCTEUR, ljc.DRIVER_ID, DAY";
            Statement stm = DriverPlanning.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                DriverPlanning tmp = new DriverPlanning();
                tmp.setValues(rs.getInt("ID"), rs.getInt("DRIVER_ID"), rs.getInt("DAY_TYPE_ID"), rs.getInt("USER_ID"), rs.getDate("DAY"), rs.getInt("BEGIN_HOUR"), rs.getInt("LENGTH"), rs.getInt("TYPE"), rs.getString("COMM"));
                toReturn.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("DPlanning.loadList() : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return toReturn;
    }

    public static Vector<DriverPlanning> find(Vector<DriverPlanning> toSearch, int driverId, java.util.Date date) {
        Vector<DriverPlanning> toReturn = new Vector<DriverPlanning>();
        for (DriverPlanning ljc : toSearch) {
            if (date != null && !ljc.getDay().equals(date) || ljc.getDriverId() != driverId) continue;
            toReturn.add(ljc);
        }
        return toReturn;
    }
}

