/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.EmployeeObligationType;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class EmployeeObligation
extends MainElement
implements Cloneable {
    public static final String table = "EMPLOYEE_OBLIGATION";
    public static final int DONE = 0;
    public static final int SCHEDULED = 1;
    public static final int CANCELLED = 2;
    public static final int SUGGESTED = 3;
    public static final int SUGGESTED_AND_LATE = 4;
    private int id = 0;
    private int typeId = 0;
    private int driverId = 0;
    private java.util.Date day = null;
    private java.util.Date expiration = null;
    private int length = 0;
    private String place = null;
    private String comment = null;
    private float cost = 0.0f;
    private String attachment = null;
    private int state = 1;

    public EmployeeObligation() {
    }

    public EmployeeObligation clone() throws CloneNotSupportedException {
        return (EmployeeObligation)super.clone();
    }

    public String toString() {
        return "Intervention id " + this.id + " : {typeId = " + this.typeId + "} {driverId = " + this.driverId + "}" + " {day = " + this.day + "} {expiration = " + this.expiration + "} {place = " + this.place + "} {comment = " + this.comment + "}{cost = " + this.cost + "} {state = " + this.state + "} {attachment = " + this.attachment + "}";
    }

    public EmployeeObligation(int id, int typeId, int driverId, java.util.Date day, java.util.Date expiration, int length, String place, String comment, float cost, int state, String attachment) {
        this.id = id;
        this.typeId = typeId;
        this.driverId = driverId;
        this.day = day;
        this.expiration = expiration;
        this.length = length;
        this.place = place;
        this.comment = comment;
        this.cost = cost;
        this.state = state;
        this.attachment = attachment;
    }

    public boolean loadByDay(java.util.Date day, int driverId) {
        return false;
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + EmployeeObligation.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = EmployeeObligation.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#EmployeeObligation.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#EmployeeObligation.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.typeId = rs.getInt("TYPE_ID");
                    this.driverId = rs.getInt("DRIVER_ID");
                    this.day = rs.getDate("DAY");
                    this.expiration = rs.getDate("EXPIRATION");
                    this.length = rs.getInt("LENGTH");
                    this.place = rs.getString("PLACE");
                    this.comment = rs.getString("COMM");
                    this.cost = rs.getInt("COST");
                    this.state = rs.getInt("STATE");
                    this.attachment = rs.getString("ATTACHMENT");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#EmployeeObligation.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#EmployeeObligation.insert()#");
        try {
            block13: {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO EMPLOYEE_OBLIGATION (" + EmployeeObligation.getAllFields() + ")" + " VALUES (GEN_EMPLOYEE_OBLIGATION.nextval,?,?,?,?,?,?,?,?,?,?)";
                    this.statement = EmployeeObligation.getConnection().prepareStatement(sql);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO EMPLOYEE_OBLIGATION (" + EmployeeObligation.getAllFields().substring(EmployeeObligation.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?,?,?,?)";
                    this.statement = EmployeeObligation.getConnection().prepareStatement(sql, 1);
                }
                this.statement.setObject(1, (Object)this.typeId, 4);
                this.statement.setObject(2, (Object)this.driverId, 4);
                this.statement.setDate(3, new Date(this.day.getTime()));
                this.statement.setDate(4, this.expiration == null ? null : new Date(this.expiration.getTime()));
                this.statement.setObject(5, (Object)this.length, 4);
                this.statement.setObject(6, (Object)this.place, 12);
                this.statement.setObject(7, (Object)this.comment, 12);
                this.statement.setObject(8, (Object)Float.valueOf(this.cost), 4);
                this.statement.setObject(9, (Object)this.state, 4);
                this.statement.setObject(10, (Object)this.attachment, 12);
                this.statement.executeUpdate();
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    try {
                        ResultSet rs = this.statement.getGeneratedKeys();
                        if (!rs.next()) {
                            TimsLogger.debug("#EmployeeObligation.insert# no auto generated key availaible");
                        } else {
                            TimsLogger.debug("#EmployeeObligation.insert# auto generated key value = " + rs.getInt(1));
                            this.id = rs.getInt(1);
                        }
                        rs.close();
                    }
                    catch (Exception ex) {
                        TimsLogger.warn("#EmployeeObligation.insert# unable to retrieve auto generated key");
                        if (Transport.debug < 1) break block13;
                        ex.printStackTrace();
                    }
                }
            }
            if (this.id == 0) {
                if (this.loadId()) {
                    TimsLogger.debug("#EmployeeObligation.insert# generated key value = " + this.id);
                } else {
                    TimsLogger.debug("#EmployeeObligation.insert# no generated key availaible");
                }
            }
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT MAX(ID) AS ID FROM EMPLOYEE_OBLIGATION WHERE DRIVER_ID = ?";
        PreparedStatement statement = null;
        try {
            try {
                statement = EmployeeObligation.getConnection().prepareStatement(sql);
                statement.setObject(1, (Object)this.driverId, 4);
                rs = statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("ID");
                    TimsLogger.debug("#EmployeeObligation.loadId# id found " + rs.getInt("ID"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("EmployeeObligation.loadId()# exception sql = " + sql);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE EMPLOYEE_OBLIGATION SET  TYPE_ID=? , DRIVER_ID=? , DAY=? , EXPIRATION=? , LENGTH=? , PLACE=? , COMM=? , COST=?,  STATE=?,  ATTACHMENT=?  WHERE ID=?";
        try {
            try {
                this.statement = EmployeeObligation.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.typeId, 4);
                this.statement.setObject(2, (Object)this.driverId, 4);
                this.statement.setDate(3, new Date(this.day.getTime()));
                this.statement.setDate(4, new Date(this.expiration.getTime()));
                this.statement.setObject(5, (Object)this.length, 4);
                this.statement.setObject(6, (Object)this.place, 12);
                this.statement.setObject(7, (Object)this.comment, 12);
                this.statement.setObject(8, (Object)Float.valueOf(this.cost), 6);
                this.statement.setObject(9, (Object)this.state, 4);
                this.statement.setObject(10, (Object)this.attachment, 12);
                this.statement.setObject(11, (Object)this.id, 4);
                this.statement.executeUpdate();
                toReturn = true;
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int vehicleId) {
        this.driverId = vehicleId;
    }

    public java.util.Date getDay() {
        return this.day;
    }

    public void setDay(java.util.Date day) {
        this.day = day;
    }

    public java.util.Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(java.util.Date expiration) {
        this.expiration = expiration;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getPlace() {
        return this.place;
    }

    public void setPlace(String performer) {
        this.place = performer;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public float getCost() {
        return this.cost;
    }

    public void setCost(float cost) {
        this.cost = cost;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public boolean compareAndUpdate(int typeId, int vehicleId, java.util.Date day, java.util.Date expiration, int length, String place, String comment, float cost, int state, String attachment) {
        TimsLogger.debug("#Intervention.compareAndUpdate# " + this.toString());
        String tracer = String.valueOf(LanguageTranslator.getString("generics.employeeObligation")) + " n\u00b0 " + this.id + " (" + this.getId() + ") \n";
        if (this.id == 0) {
            this.setTypeId(typeId);
            this.setDriverId(vehicleId);
            this.setDay(day);
            this.setExpiration(expiration);
            this.setLength(length);
            this.setPlace(place);
            this.setComment(comment);
            this.setCost(cost);
            this.setState(state);
            this.setAttachment(attachment);
            tracer = String.valueOf(LanguageTranslator.getString("generics.employeeObligation")) + "\n" + LanguageTranslator.getString("employeeObligation.type") + " => " + this.typeId + LanguageTranslator.getString("generics.driver") + " => " + this.driverId + LanguageTranslator.getString("generics.date") + " => " + this.day;
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new java.util.Date(), tracer).insert();
            return this.insert();
        }
        if (typeId != this.typeId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("employeeObligation.type") + " '" + this.typeId + "' => '" + typeId + "'\n";
            this.setTypeId(typeId);
        }
        if (vehicleId != this.driverId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.driver") + " '" + this.driverId + "' => '" + vehicleId + "'\n";
            this.setDriverId(vehicleId);
        }
        if (Fonctions.fieldChange(day, this.day)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.date") + " '" + this.day + "' => '" + day + "'\n";
            this.setDay(day);
        }
        if (Fonctions.fieldChange(expiration, this.expiration)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.expiration") + " '" + this.expiration + "' => '" + expiration + "'\n";
            this.setExpiration(expiration);
        }
        if (length != this.length) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.length") + " '" + this.length + "' => '" + length + "'\n";
            this.setLength(length);
        }
        if (Fonctions.fieldChange(place, this.place)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.place") + " '" + this.place + "' => '" + place + "'\n";
            this.setPlace(place);
        }
        if (Fonctions.fieldChange(comment, this.comment)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.comment") + " '" + this.comment + "' => '" + comment + "'\n";
            this.setComment(comment);
        }
        if (cost != this.cost) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.cost") + " '" + this.cost + "' => '" + cost + "'\n";
            this.setCost(cost);
        }
        if (state != this.state) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.state") + " '" + this.state + "' => '" + state + "'\n";
            this.setState(state);
        }
        if (Fonctions.fieldChange(attachment, this.attachment)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.attachmentAcronym") + " '" + this.attachment + "' => '" + attachment + "'\n";
            this.setAttachment(attachment);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.designation")) + " n\u00b0 " + this.id + " (" + this.getId() + ") \n")) {
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new java.util.Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#EmployeeObligation# no changes");
        return true;
    }

    public boolean delete() {
        boolean toReturn = false;
        String sql = "DELETE FROM EMPLOYEE_OBLIGATION WHERE ID=?";
        try {
            try {
                this.statement = EmployeeObligation.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 1, new java.util.Date(), String.valueOf(LanguageTranslator.getString("generics.obligation")) + " n\u00b0 " + this.id + " => date " + this.getDay() + " driver " + this.getDriverId() + " type " + this.getTypeId()).insert();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return toReturn;
    }

    public static String getStatusLibelle(int state) {
        if (state == 0) {
            return LanguageTranslator.getString("generics.done");
        }
        if (state == 1) {
            return LanguageTranslator.getString("generics.scheduled");
        }
        if (state == 2) {
            return LanguageTranslator.getString("generics.cancelled");
        }
        if (state == 3) {
            return LanguageTranslator.getString("generics.suggested");
        }
        return LanguageTranslator.getString("generics.unknown");
    }

    private static String getAllFields() {
        return "ID, TYPE_ID, DRIVER_ID, DAY, EXPIRATION, LENGTH, PLACE, COMM, COST, STATE, ATTACHMENT";
    }

    public static Vector<EmployeeObligation> loadList(int agencyId, int driverId, String begin, String end) {
        Vector<EmployeeObligation> liste = new Vector<EmployeeObligation>();
        String sql = "SELECT " + EmployeeObligation.getAllFields() + " FROM " + table;
        String restriction = " TYPE_ID IN (SELECT ID FROM EMPLOYEE_OBLIGATION_TYPE WHERE ARCHIVED = 0)";
        if (agencyId != 0) {
            restriction = String.valueOf(restriction) + " AND DRIVER_ID IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE CLE_AGENCE = " + agencyId + ")";
        }
        if (driverId != 0) {
            restriction = String.valueOf(restriction) + " AND DRIVER_ID = " + driverId;
        }
        if (begin != null) {
            restriction = String.valueOf(restriction) + " AND DAY >= '" + begin + "'";
        }
        if (end != null) {
            restriction = String.valueOf(restriction) + " AND DAY <= '" + end + "'";
        }
        sql = String.valueOf(sql) + " WHERE " + restriction;
        sql = String.valueOf(sql) + " ORDER BY DRIVER_ID, TYPE_ID, DAY";
        try {
            Transport.ps.startOperation();
            ResultSet rs = null;
            Statement stm = EmployeeObligation.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate obligations", "#EmployeeObligation.loadLastList() => %s# sql = " + sql, 1);
            while (rs.next()) {
                EmployeeObligation tmp = new EmployeeObligation(rs.getInt("ID"), rs.getInt("TYPE_ID"), rs.getInt("DRIVER_ID"), new java.util.Date(rs.getDate("DAY").getTime()), rs.getDate("EXPIRATION") == null ? null : new java.util.Date(rs.getDate("EXPIRATION").getTime()), rs.getInt("LENGTH"), rs.getString("PLACE"), rs.getString("COMM"), rs.getFloat("COST"), rs.getInt("STATE"), rs.getString("ATTACHMENT"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("EmployeeObligation.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }

    public static Vector<EmployeeObligation> loadLastList(int agencyId, int driverId) {
        Vector<EmployeeObligation> liste = new Vector<EmployeeObligation>();
        String sql = "SELECT " + EmployeeObligation.getAllFields() + " FROM " + table + " e" + " WHERE day = (select max(day) from " + table + " emp where emp.type_id = e.type_id and emp.driver_id = e.driver_id) ";
        String restriction = " AND TYPE_ID IN (SELECT ID FROM EMPLOYEE_OBLIGATION_TYPE WHERE ARCHIVED = 0)";
        if (agencyId != 0) {
            restriction = String.valueOf(restriction) + " AND DRIVER_ID IN (SELECT CLE_CHAUFFEUR FROM t_conducteur WHERE CLE_AGENCE = " + agencyId + ")";
        }
        if (driverId != 0) {
            restriction = String.valueOf(restriction) + " AND DRIVER_ID = " + driverId;
        }
        if (!restriction.equals("")) {
            sql = String.valueOf(sql) + restriction;
        }
        sql = String.valueOf(sql) + " ORDER BY TYPE_ID";
        try {
            Transport.ps.startOperation();
            ResultSet rs = null;
            Statement stm = EmployeeObligation.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate derni\u00e8re obligation", "#EmployeeObligation.loadLastList() => %s# sql = " + sql, 1);
            while (rs.next()) {
                EmployeeObligation tmp = new EmployeeObligation(rs.getInt("ID"), rs.getInt("TYPE_ID"), rs.getInt("DRIVER_ID"), new java.util.Date(rs.getDate("DAY").getTime()), rs.getDate("EXPIRATION") == null ? null : new java.util.Date(rs.getDate("EXPIRATION").getTime()), rs.getInt("LENGTH"), rs.getString("PLACE"), rs.getString("COMM"), rs.getFloat("COST"), rs.getInt("STATE"), rs.getString("ATTACHMENT"));
                boolean substitued = false;
                for (EmployeeObligation eo : liste) {
                    EmployeeObligationType ceot = EmployeeObligationType.getObligationType(tmp.getTypeId());
                    EmployeeObligationType eot = EmployeeObligationType.getObligationType(eo.getTypeId());
                    if (ceot.getSubstitute() == eo.getTypeId()) {
                        liste.remove(eo);
                        break;
                    }
                    if (eot.getSubstitute() != tmp.getTypeId()) continue;
                    substitued = true;
                }
                if (substitued) continue;
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("EmployeeObligation.loadLastList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }

    public static Vector<EmployeeObligation> loadList(String nameRegExp) {
        Vector<EmployeeObligation> liste = new Vector<EmployeeObligation>();
        String sql = "SELECT " + EmployeeObligation.getAllFields() + " FROM " + table + " WHERE ATTACHMENT LIKE \"%" + nameRegExp + "%\" AND TYPE_ID IN (SELECT ID FROM " + "EMPLOYEE_OBLIGATION_TYPE" + " WHERE ARCHIVED = 0)";
        sql = String.valueOf(sql) + " ORDER BY TYPE_ID";
        try {
            Transport.ps.startOperation();
            ResultSet rs = null;
            Statement stm = EmployeeObligation.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate derni\u00e8re obligation", "#EmployeeObligation.loadLastList() => %s# sql = " + sql, 1);
            while (rs.next()) {
                EmployeeObligation tmp = new EmployeeObligation(rs.getInt("ID"), rs.getInt("TYPE_ID"), rs.getInt("DRIVER_ID"), new java.util.Date(rs.getDate("DAY").getTime()), rs.getDate("EXPIRATION") == null ? null : new java.util.Date(rs.getDate("EXPIRATION").getTime()), rs.getInt("LENGTH"), rs.getString("PLACE"), rs.getString("COMM"), rs.getFloat("COST"), rs.getInt("STATE"), rs.getString("ATTACHMENT"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("EmployeeObligation.loadLastList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }
}

