/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class EmployeeObligationType
extends MainElement {
    public static final String table = "EMPLOYEE_OBLIGATION_TYPE";
    private static Vector<EmployeeObligationType> list = null;
    private int id = 0;
    private int groupId = 0;
    private String name = null;
    private String code = null;
    private int length = 0;
    private int periodExpiration = 0;
    private boolean manualExpiration = false;
    private float defaultCost = 0.0f;
    private int warningThreshold = 0;
    private int errorThreshold = 0;
    private int permissionRequired = 0;
    private int substitute = 0;
    private boolean habilitation = false;
    private boolean archived = false;

    public EmployeeObligationType() {
    }

    public EmployeeObligationType(int id, int groupId, String name, String code, int length, int periodExpiration, float cost, int warningThreshold, int errorThreshold, int permissionRequired, boolean habilitation, boolean manualExpiration, int substitute, boolean archive) {
        this.id = id;
        this.groupId = groupId;
        this.name = name;
        this.code = code;
        this.length = length;
        this.periodExpiration = periodExpiration;
        this.archived = archive;
        this.permissionRequired = permissionRequired;
        this.defaultCost = cost;
        this.warningThreshold = warningThreshold;
        this.errorThreshold = errorThreshold;
        this.habilitation = habilitation;
        this.manualExpiration = manualExpiration;
        this.substitute = substitute;
    }

    public boolean equals(Object o) {
        return o instanceof EmployeeObligationType && this.name.equals(((EmployeeObligationType)o).getName());
    }

    public String toString() {
        return this.getName();
    }

    public boolean loadByName(String designation) {
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append(EmployeeObligationType.getAllFields()).append(" FROM ").append(table).append(" WHERE NAME='");
        BddTransport.getInstance();
        String sql = stringBuilder.append(BddTransport.addSlashes(designation)).append("'").toString();
        return this.genericLoad(sql);
    }

    public boolean loadByCode(String code) {
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append(EmployeeObligationType.getAllFields()).append(" FROM ").append(table).append(" WHERE CODE='");
        BddTransport.getInstance();
        String sql = stringBuilder.append(BddTransport.addSlashes(code)).append("'").toString();
        return this.genericLoad(sql);
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + EmployeeObligationType.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = EmployeeObligationType.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#EmployeeObligationType.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#EmployeeObligationType.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.groupId = rs.getInt("GROUP_ID");
                    this.name = rs.getString("NAME");
                    this.code = rs.getString("CODE");
                    this.length = rs.getInt("LENGTH");
                    this.periodExpiration = rs.getInt("PERIOD_EXPIRATION");
                    this.defaultCost = rs.getInt("DEFAULT_COST");
                    this.permissionRequired = rs.getInt("PERMISSION_REQUIRED");
                    this.habilitation = rs.getBoolean("HABILITATION");
                    this.manualExpiration = rs.getBoolean("MANUAL_EXPIRATION");
                    this.substitute = rs.getInt("SUBSTITUTE");
                    this.archived = rs.getBoolean("ARCHIVED");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#EmployeeObligationType.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#EmployeeObligationType.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO EMPLOYEE_OBLIGATION_TYPE (" + EmployeeObligationType.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO EMPLOYEE_OBLIGATION_TYPE (" + EmployeeObligationType.getAllFields().substring(EmployeeObligationType.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        try {
            this.statement = EmployeeObligationType.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.groupId, 4);
            this.statement.setObject(2, (Object)this.name, 12);
            this.statement.setObject(3, (Object)this.code, 12);
            this.statement.setObject(4, (Object)this.length, 4);
            this.statement.setObject(5, (Object)this.periodExpiration, 4);
            this.statement.setObject(6, (Object)Float.valueOf(this.defaultCost), 4);
            this.statement.setObject(7, (Object)this.warningThreshold, 4);
            this.statement.setObject(8, (Object)this.errorThreshold, 4);
            this.statement.setObject(9, (Object)this.permissionRequired, 4);
            this.statement.setObject(10, (Object)(this.habilitation ? "1" : "0"), 4);
            this.statement.setObject(11, (Object)(this.manualExpiration ? "1" : "0"), 4);
            this.statement.setObject(12, (Object)this.substitute, 4);
            this.statement.setObject(13, (Object)(this.archived ? "1" : "0"), 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE EMPLOYEE_OBLIGATION_TYPE SET  GROUP_ID=? , NAME=? , CODE=? , LENGTH=? , PERIOD_EXPIRATION=? , DEFAULT_COST=? , WARNING_THRESHOLD=?,  ERROR_THRESHOLD=?,  PERMISSION_REQUIRED=?,  ARCHIVED=?,  HABILITATION=?,  MANUAL_EXPIRATION=?,  SUBSTITUTE=?  WHERE ID=?";
        try {
            this.statement = EmployeeObligationType.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.groupId, 4);
            this.statement.setObject(2, (Object)this.name, 12);
            this.statement.setObject(3, (Object)this.code, 12);
            this.statement.setObject(4, (Object)this.length, 4);
            this.statement.setObject(5, (Object)this.periodExpiration, 4);
            this.statement.setObject(6, (Object)Float.valueOf(this.defaultCost), 4);
            this.statement.setObject(7, (Object)this.warningThreshold, 4);
            this.statement.setObject(8, (Object)this.errorThreshold, 4);
            this.statement.setObject(9, (Object)this.permissionRequired, 4);
            this.statement.setObject(10, (Object)(this.archived ? "1" : "0"), 4);
            this.statement.setObject(11, (Object)(this.habilitation ? "1" : "0"), 4);
            this.statement.setObject(12, (Object)(this.manualExpiration ? "1" : "0"), 4);
            this.statement.setObject(13, (Object)this.substitute, 4);
            this.statement.setObject(14, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getPeriodExpiration() {
        return this.periodExpiration;
    }

    public void setPeriodExpiration(int periodExpiration) {
        this.periodExpiration = periodExpiration;
    }

    public float getDefaultCost() {
        return this.defaultCost;
    }

    public void setDefaultCost(float cost) {
        this.defaultCost = cost;
    }

    public int getWarningThreshold() {
        return this.warningThreshold;
    }

    public void setWarningThreshold(int warningThreshold) {
        this.warningThreshold = warningThreshold;
    }

    public int getErrorThreshold() {
        return this.errorThreshold;
    }

    public void setErrorThreshold(int errorThreshold) {
        this.errorThreshold = errorThreshold;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setPermissionRequired(int permissionRequired) {
        this.permissionRequired = permissionRequired;
    }

    public int getPermissionRequired() {
        return this.permissionRequired;
    }

    public void setSubstitute(int substitute) {
        this.substitute = substitute;
    }

    public int getSubstitute() {
        return this.substitute;
    }

    public boolean isHabilitation() {
        return this.habilitation;
    }

    public void setHabilitation(boolean habilitation) {
        this.habilitation = habilitation;
    }

    public boolean isManualExpiration() {
        return this.manualExpiration;
    }

    public void setManualExpiration(boolean manualExpiration) {
        this.manualExpiration = manualExpiration;
    }

    private static String getAllFields() {
        return "ID, GROUP_ID, NAME, CODE, LENGTH, PERIOD_EXPIRATION, DEFAULT_COST, WARNING_THRESHOLD, ERROR_THRESHOLD, PERMISSION_REQUIRED, HABILITATION, MANUAL_EXPIRATION, SUBSTITUTE, ARCHIVED";
    }

    public boolean compareAndUpdate(int groupId, String name, String code, int length, int periodExpiration, float cost, int warningThreshold, int errorThreshold, int permissionRequired, boolean habilitation, boolean manualExpiration, int substitute, boolean archive) {
        String tracer = String.valueOf(LanguageTranslator.getString("employee.obligation.type")) + " n\u00b0 " + this.id + " (" + this.getName() + ") \n";
        if (groupId != this.groupId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.group") + " '" + this.groupId + "' => '" + groupId + "'\n";
            this.setGroupId(groupId);
        }
        if (Fonctions.fieldChange(name, this.name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.designation") + " '" + this.name + "' => '" + name + "'\n";
            this.setName(name);
        }
        if (Fonctions.fieldChange(code, this.code)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.code") + " '" + this.code + "' => '" + code + "'\n";
            this.setCode(code);
        }
        if (length != this.length) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.length") + " '" + this.length + "' => '" + length + "'\n";
            this.setLength(length);
        }
        if (periodExpiration != this.periodExpiration) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("obligation.period") + " '" + this.periodExpiration + "' => '" + periodExpiration + "'\n";
            this.setPeriodExpiration(periodExpiration);
        }
        if (cost != this.defaultCost) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.cost") + " '" + this.defaultCost + "' => '" + cost + "'\n";
            this.setDefaultCost(cost);
        }
        if (warningThreshold != this.warningThreshold) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.threshold.warning") + " '" + this.warningThreshold + "' => '" + warningThreshold + "'\n";
            this.setWarningThreshold(warningThreshold);
        }
        if (errorThreshold != this.errorThreshold) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.threshold.error") + " '" + this.errorThreshold + "' => '" + errorThreshold + "'\n";
            this.setErrorThreshold(errorThreshold);
        }
        if (archive != this.archived) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("eot.permissionRequired") + " '" + this.archived + "' => '" + archive + "'\n";
            this.setArchived(archive);
        }
        if (permissionRequired != this.permissionRequired) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.permissionRequired") + " '" + this.permissionRequired + "' => '" + permissionRequired + "'\n";
            this.setPermissionRequired(permissionRequired);
        }
        if (habilitation != this.habilitation) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.habilitation") + " '" + this.habilitation + "' => '" + habilitation + "'\n";
            this.setHabilitation(habilitation);
        }
        if (manualExpiration != this.manualExpiration) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.manualExpiration") + " '" + this.manualExpiration + "' => '" + manualExpiration + "'\n";
            this.setManualExpiration(manualExpiration);
        }
        if (substitute != this.substitute) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.substitute") + " '" + this.substitute + "' => '" + substitute + "'\n";
            this.setSubstitute(substitute);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("employee.obligation.type")) + " n\u00b0 " + this.id + " (" + this.getName() + ") \n")) {
            if (this.id == 0) {
                if (this.insert()) {
                    new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                    return true;
                }
                return false;
            }
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#EmployeeObligationType# no changes");
        return true;
    }

    public void delete() {
        String sql = "DELETE FROM EMPLOYEE_OBLIGATION_TYPE WHERE ID=?";
        try {
            this.statement = EmployeeObligationType.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archive) {
        this.archived = archive;
    }

    public static Vector<EmployeeObligationType> loadList(boolean archive) {
        Vector<EmployeeObligationType> liste = new Vector<EmployeeObligationType>();
        String sql = "SELECT " + EmployeeObligationType.getAllFields() + " FROM " + table + " WHERE ARCHIVED = " + (archive ? "1" : "0") + " ORDER BY NAME";
        try {
            ResultSet rs = null;
            Statement stm = EmployeeObligationType.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                EmployeeObligationType tmp = new EmployeeObligationType(rs.getInt("ID"), rs.getInt("GROUP_ID"), rs.getString("NAME"), rs.getString("CODE"), rs.getInt("LENGTH"), rs.getInt("PERIOD_EXPIRATION"), rs.getFloat("DEFAULT_COST"), rs.getInt("WARNING_THRESHOLD"), rs.getInt("ERROR_THRESHOLD"), rs.getInt("PERMISSION_REQUIRED"), rs.getBoolean("HABILITATION"), rs.getBoolean("MANUAL_EXPIRATION"), rs.getInt("SUBSTITUTE"), rs.getBoolean("ARCHIVED"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("EmployeeObligationType.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }

    public static Vector<EmployeeObligationType> getList() {
        if (list == null) {
            list = EmployeeObligationType.loadList(false);
        }
        return list;
    }

    public static void setList(Vector<EmployeeObligationType> list) {
        EmployeeObligationType.list = list;
    }

    public static EmployeeObligationType getObligationType(int idType) throws DBObjectNotFoundException {
        for (EmployeeObligationType tmp : EmployeeObligationType.getList()) {
            if (tmp.getId() != idType) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException("EmployeeObligationType");
    }
}

