/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class ExpensesAmount
extends MainElement
implements Comparable<ExpensesAmount> {
    public static final String table = "expense_amount";
    public static int OFFSET = 118;
    private int id = 0;
    private int expenseTypeId = 0;
    private java.util.Date enacted = null;
    private float frenchAmount = 0.0f;
    private float foreignAmount = 0.0f;

    public ExpensesAmount() {
    }

    public ExpensesAmount(int id, int expenseTypeId, java.util.Date enacted, float frenchAmount, float foreignAmount) {
        this.id = id;
        this.expenseTypeId = expenseTypeId;
        this.enacted = enacted;
        this.frenchAmount = frenchAmount;
        this.foreignAmount = foreignAmount;
    }

    public Object clone() {
        return new ExpensesAmount(this.id, this.expenseTypeId, this.enacted, this.frenchAmount, this.foreignAmount);
    }

    @Override
    public int compareTo(ExpensesAmount o) {
        return this.getEnacted().compareTo(o.getEnacted());
    }

    public int getExpenseTypeId() {
        return this.expenseTypeId;
    }

    public void setExpenseTypeId(int expenseTypeId) {
        this.expenseTypeId = expenseTypeId;
    }

    public java.util.Date getEnacted() {
        return this.enacted;
    }

    public void setEnacted(java.util.Date enacted) {
        this.enacted = enacted;
    }

    public float getFrenchAmount() {
        return this.frenchAmount;
    }

    public void setFrenchAmount(float frenchAmount) {
        this.frenchAmount = frenchAmount;
    }

    public float getForeignAmount() {
        return this.foreignAmount;
    }

    public void setForeignAmount(float foreignAmount) {
        this.foreignAmount = foreignAmount;
    }

    public boolean compareAndUpdate(java.util.Date begin, float frenchAmount, float foreignAmount) {
        String tracer = String.valueOf(LanguageTranslator.getString("expensesAmount")) + " n\u00b0 " + this.id + "\n";
        if (frenchAmount != this.frenchAmount) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("expenses.frenchRate") + " '" + this.frenchAmount + "' => '" + frenchAmount + "'\n";
            this.setFrenchAmount(frenchAmount);
        }
        if (foreignAmount != this.foreignAmount) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("expenses.foreignRate") + " '" + this.frenchAmount + "' => '" + frenchAmount + "'\n";
            this.setFrenchAmount(frenchAmount);
        }
        if (Fonctions.fieldChange(begin, this.enacted)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.begin") + " '" + this.enacted + "' => '" + begin + "'\n";
            this.setEnacted(begin);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("expensesAmount")) + " n\u00b0 " + this.id + "\n")) {
            if (this.update()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new java.util.Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#ExpensesAmount# no changes");
        return true;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean retour = false;
        String sql = "";
        TimsLogger.debug("#ExpensesValidation.insert()#");
        try {
            try {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO expense_amount (" + ExpensesAmount.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?)";
                    this.statement = ExpensesAmount.getConnection().prepareStatement(sql);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO expense_amount (" + ExpensesAmount.getAllFields().substring(ExpensesAmount.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?)";
                    this.statement = ExpensesAmount.getConnection().prepareStatement(sql, 1);
                }
                this.statement.setObject(1, (Object)this.expenseTypeId, 4);
                this.statement.setDate(2, new Date(this.enacted.getTime()));
                this.statement.setObject(3, (Object)Float.valueOf(this.frenchAmount), 6);
                this.statement.setObject(4, (Object)Float.valueOf(this.foreignAmount), 6);
                this.statement.executeUpdate();
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    ResultSet rs = this.statement.getGeneratedKeys();
                    if (!rs.next()) {
                        TimsLogger.debug("#ExpensesAmount.insert# no auto generated key availaible");
                    } else {
                        TimsLogger.debug("#ExpensesAmount.insert# auto generated key value = " + rs.getInt(1));
                        this.id = rs.getInt(1);
                    }
                    rs.close();
                }
                if (this.id == 0) {
                    if (this.loadId()) {
                        TimsLogger.debug("#ExpensesAmount.insert# generated key value = " + this.id);
                    } else {
                        TimsLogger.debug("#ExpensesAmount.insert# no generated key availaible");
                    }
                }
                this.statement.close();
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new java.util.Date(), "Add amount (" + this.frenchAmount + "," + this.foreignAmount + ") on " + ConversionTime.dateToStringFr(this.enacted) + "on expenses " + this.expenseTypeId).insert();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    TimsLogger.warn("Erreur sql = " + sql);
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    TimsLogger.warn("Erreur sql = " + sql);
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("Erreur sql = " + sql);
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT MAX(ID) AS ID FROM expense_amount WHERE EXPENSE_TYPE_ID = ?";
        try {
            try {
                this.statement = ExpensesAmount.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.expenseTypeId, 12);
                rs = this.statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("ID");
                    TimsLogger.debug("#ExpensesAmount.loadId# id found " + rs.getInt("ID"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("#ExpensesValidation.loadId()#  : " + ex);
                ex.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean updateValue() {
        boolean retour = false;
        String sql = "UPDATE expense_amount SET  EXPENSE_TYPE_ID=? , ENACTED=? , FRENCH_AMOUNT=? , FOREIGN_AMOUNT=?  WHERE ID=?";
        try {
            try {
                this.statement = ExpensesAmount.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.expenseTypeId, 4);
                this.statement.setDate(2, new Date(this.enacted.getTime()));
                this.statement.setObject(3, (Object)Float.valueOf(this.frenchAmount), 6);
                this.statement.setObject(4, (Object)Float.valueOf(this.foreignAmount), 6);
                this.statement.setObject(5, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    TimsLogger.warn("Erreur sql = " + sql);
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    TimsLogger.warn("Erreur sql = " + sql);
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("Erreur sql = " + sql);
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int cle) {
        this.id = cle;
    }

    private static String getAllFields() {
        return "ID, EXPENSE_TYPE_ID, ENACTED, FRENCH_AMOUNT, FOREIGN_AMOUNT";
    }

    public static ArrayList<ExpensesAmount> loadList(int expenseTypeId) {
        String sql = "";
        ArrayList<ExpensesAmount> toReturn = new ArrayList<ExpensesAmount>();
        try {
            sql = "SELECT " + ExpensesAmount.getAllFields() + " FROM " + table;
            if (expenseTypeId != 0) {
                sql = String.valueOf(sql) + " WHERE EXPENSE_TYPE_ID = " + expenseTypeId;
            }
            sql = String.valueOf(sql) + " ORDER BY EXPENSE_TYPE_ID, ENACTED";
            PreparedStatement stm = ExpensesAmount.getConnection().prepareStatement(sql);
            ResultSet rs = stm.executeQuery();
            while (rs.next()) {
                ExpensesAmount toAdd = new ExpensesAmount(rs.getInt("ID"), rs.getInt("EXPENSE_TYPE_ID"), rs.getDate("ENACTED"), rs.getFloat("FRENCH_AMOUNT"), rs.getFloat("FOREIGN_AMOUNT"));
                toReturn.add(toAdd);
            }
            rs.close();
            stm.close();
            TimsLogger.debug("#ExpensesAmount.loadList()# toReturn size " + toReturn.size());
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("#ExpensesAmount.loadList()# ex : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return toReturn;
    }

    public static Vector<ExpensesAmount> find(Vector<ExpensesAmount> toSearch, int expensesTypeId) {
        Vector<ExpensesAmount> toReturn = new Vector<ExpensesAmount>();
        if (toSearch == null) {
            return toReturn;
        }
        for (ExpensesAmount de : toSearch) {
            if (de.getExpenseTypeId() != expensesTypeId) continue;
            toReturn.add(de);
        }
        return toReturn;
    }
}

