/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ExpensesAmount;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.MultiBoxItem;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.ExpensesNotFoundException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class ExpensesType
extends MainElement
implements MultiBoxItem {
    public static final int FRENCH = 0;
    public static final int FOREIGN = 1;
    public static final String table = "T_FRAIS";
    public static final int SUPERIEUR = 1;
    public static final int INFERIEUR = 2;
    public static final int EGAL = 3;
    private static Vector<ExpensesType> list = null;
    private int cle = 0;
    private String designation = null;
    private String code = null;
    private int beginAfter = -1;
    private int beginBefore = -1;
    private int endAfter = -1;
    private int endBefore = -1;
    private int cumulService = 0;
    private int cumulAvant = 0;
    private int cumulApres = 0;
    private int maxDistance = -1;
    private boolean fromHome = false;
    private boolean fromCompany = false;
    private boolean fromAgency = false;
    private ArrayList<ExpensesAmount> montants = null;
    private float montantFrance = 0.0f;
    private float montantEtranger = 0.0f;
    private int hour = 0;
    private int beginView = 0;
    private int endView = 0;
    private boolean fastView = false;
    private boolean actif = false;
    private Vector<Integer> enabledDay = null;
    private Vector<Integer> quencher = null;
    private boolean archived = false;
    private int employeeTypeId = 0;
    private int export = 0;

    public ExpensesType() {
        this.montants = new ArrayList();
    }

    public ExpensesType(int cle, String designation, String code, int hour, int beginBefore, int beginAfter, int endBefore, int endAfter, int cumulService, int cumulAvant, int cumulApres, int maxDistance, boolean fromHome, boolean fromCompany, boolean fromAgency, float montantFrance, float montantEtranger, int beginView, int endView, boolean fastView, boolean actif, String quencher, String enabledDay, int employeeTypeId, int export, boolean archive) {
        int x;
        this.cle = cle;
        this.designation = designation;
        this.code = code;
        this.hour = hour;
        this.beginAfter = beginAfter;
        this.beginBefore = beginBefore;
        this.endAfter = endAfter;
        this.endBefore = endBefore;
        this.cumulService = cumulService;
        this.cumulAvant = cumulAvant;
        this.cumulApres = cumulApres;
        this.montantFrance = montantFrance;
        this.montantEtranger = montantEtranger;
        this.maxDistance = maxDistance;
        this.fromHome = fromHome;
        this.fromCompany = fromCompany;
        this.fromAgency = fromAgency;
        this.beginView = beginView;
        this.endView = endView;
        this.fastView = fastView;
        this.actif = actif;
        this.employeeTypeId = employeeTypeId;
        this.export = export;
        this.archived = archive;
        if (quencher != null && quencher.length() != 0) {
            String[] quenchersId = quencher.split(";");
            this.quencher = new Vector();
            x = 0;
            while (x < quenchersId.length) {
                this.quencher.add(Integer.parseInt(quenchersId[x]));
                ++x;
            }
        }
        if (enabledDay != null && enabledDay.length() != 0) {
            String[] days = enabledDay.split(";");
            this.enabledDay = new Vector();
            x = 0;
            while (x < days.length) {
                this.enabledDay.add(Integer.parseInt(days[x]));
                ++x;
            }
        }
    }

    public boolean equals(Object o) {
        return o instanceof ExpensesType && this.designation.equals(((ExpensesType)o).getDesignation());
    }

    public String toString() {
        return this.getDesignation();
    }

    private static String getAllFields() {
        return "CLE, DESIGNATION, CODE, HOUR, BEGIN_BEFORE, BEGIN_AFTER, END_BEFORE, END_AFTER, CUMUL_SERVICE, CUMUL_AVANT, CUMUL_APRES, MAX_DISTANCE, FROM_HOME, FROM_COMPANY,  FROM_AGENCY, MONTANT_FRANCE, MONTANT_ETRANGER, FAST_VIEW, BEGIN_VIEW, END_VIEW,  ACTIF, QUENCHER, ENABLED_DAY, EMPLOYEE_TYPE_ID, EXPORT, ARCHIVED";
    }

    public boolean loadByName(String designation) {
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append(ExpensesType.getAllFields()).append(" FROM ").append(table).append(" WHERE DESIGNATION='");
        BddTransport.getInstance();
        String sql = stringBuilder.append(BddTransport.addSlashes(designation)).append("'").toString();
        return this.genericLoad(sql);
    }

    public boolean loadByCode(String code) {
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append(ExpensesType.getAllFields()).append(" FROM ").append(table).append(" WHERE CODE='");
        BddTransport.getInstance();
        String sql = stringBuilder.append(BddTransport.addSlashes(code)).append("'").toString();
        return this.genericLoad(sql);
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + ExpensesType.getAllFields() + " FROM " + table + " WHERE CLE=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = ExpensesType.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    TimsLogger.debug("#ExpensesType.genericLoad# Found id " + rs.getInt("CLE") + " (" + rs.getString("CODE") + ")");
                    this.cle = rs.getInt("CLE");
                    this.designation = rs.getString("DESIGNATION");
                    this.code = rs.getString("CODE");
                    this.hour = rs.getInt("HOUR");
                    this.beginBefore = rs.getInt("BEGIN_BEFORE");
                    this.beginAfter = rs.getInt("BEGIN_AFTER");
                    this.endBefore = rs.getInt("END_BEFORE");
                    this.endAfter = rs.getInt("END_AFTER");
                    this.cumulService = rs.getInt("CUMUL_SERVICE");
                    this.cumulAvant = rs.getInt("CUMUL_AVANT");
                    this.cumulApres = rs.getInt("CUMUL_APRES");
                    this.montantFrance = rs.getFloat("MONTANT_FRANCE");
                    this.montantEtranger = rs.getFloat("MONTANT_ETRANGER");
                    this.maxDistance = rs.getInt("MAX_DISTANCE");
                    this.fromHome = rs.getBoolean("FROM_HOME");
                    this.fromCompany = rs.getBoolean("FROM_COMPANY");
                    this.fromAgency = rs.getBoolean("FROM_AGENCY");
                    this.beginView = rs.getInt("BEGIN_VIEW");
                    this.endView = rs.getInt("END_VIEW");
                    this.fastView = rs.getBoolean("FAST_VIEW");
                    this.actif = rs.getBoolean("ACTIF");
                    this.employeeTypeId = rs.getInt("EMPLOYEE_TYPE_ID");
                    this.export = rs.getInt("EXPORT");
                    this.archived = rs.getBoolean("ARCHIVED");
                    this.montants = ExpensesAmount.loadList(this.getCle());
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#Expense.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.cle == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#ExpensesType.insert()");
        try {
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                sql = "INSERT INTO T_FRAIS (" + ExpensesType.getAllFields() + ")" + " VALUES (GEN_T_FRAIS.nextval,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                this.statement = ExpensesType.getConnection().prepareStatement(sql);
            }
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                sql = "INSERT INTO T_FRAIS (" + ExpensesType.getAllFields().substring(ExpensesType.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                this.statement = ExpensesType.getConnection().prepareStatement(sql, 1);
            }
            this.statement.setObject(1, (Object)this.designation, 12);
            this.statement.setObject(2, (Object)this.code, 12);
            this.statement.setObject(3, (Object)this.hour, 4);
            this.statement.setObject(4, (Object)this.beginBefore, 4);
            this.statement.setObject(5, (Object)this.beginAfter, 4);
            this.statement.setObject(6, (Object)this.endBefore, 4);
            this.statement.setObject(7, (Object)this.endAfter, 4);
            this.statement.setObject(8, (Object)this.cumulService, 4);
            this.statement.setObject(9, (Object)this.cumulAvant, 4);
            this.statement.setObject(10, (Object)this.cumulApres, 4);
            this.statement.setObject(11, (Object)this.maxDistance, 4);
            this.statement.setObject(12, (Object)(this.fromHome ? 1 : 0), 4);
            this.statement.setObject(13, (Object)(this.fromCompany ? 1 : 0), 4);
            this.statement.setObject(14, (Object)(this.fromAgency ? 1 : 0), 4);
            this.statement.setObject(15, (Object)Float.valueOf(this.montantFrance), 6);
            this.statement.setObject(16, (Object)Float.valueOf(this.montantEtranger), 6);
            this.statement.setObject(17, (Object)(this.fastView ? 1 : 0), 4);
            this.statement.setObject(18, (Object)this.beginView, 4);
            this.statement.setObject(19, (Object)this.endView, 4);
            this.statement.setObject(20, (Object)this.actif, 4);
            this.statement.setObject(21, (Object)Fonctions.vectorToString(this.quencher, ";"), 12);
            this.statement.setObject(22, (Object)Fonctions.vectorToString(this.enabledDay, ";"), 12);
            this.statement.setObject(23, (Object)this.employeeTypeId, 4);
            this.statement.setObject(24, (Object)this.export, 4);
            this.statement.setObject(25, (Object)this.archived, 4);
            this.statement.executeUpdate();
            if (this.loadId(this.statement)) {
                TimsLogger.debug("#ExpensesType.insert# generated key value = " + this.cle);
            } else {
                TimsLogger.debug("#ExpensesType.insert# no generated key availaible");
            }
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            String tracer = String.valueOf(LanguageTranslator.getString("generics.expenses")) + " (" + this.getDesignation() + ") \n";
            new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
            this.statement.close();
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE t_frais SET  DESIGNATION=? , CODE=? , HOUR=? , BEGIN_BEFORE=? , BEGIN_AFTER=? , END_BEFORE=? , END_AFTER=? , CUMUL_SERVICE=? , CUMUL_AVANT=? , CUMUL_APRES=? , MONTANT_FRANCE=? , MONTANT_ETRANGER=? , MAX_DISTANCE=? , FROM_HOME=? , FROM_COMPANY=? , FROM_AGENCY=? , FAST_VIEW=? , BEGIN_VIEW=? , END_VIEW=? , ACTIF=?,  QUENCHER=?,  ENABLED_DAY=?,  EMPLOYEE_TYPE_ID=?,  EXPORT=?,  ARCHIVED=?  WHERE CLE=?";
        try {
            try {
                this.statement = ExpensesType.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.designation, 12);
                this.statement.setObject(2, (Object)this.code, 12);
                this.statement.setObject(3, (Object)this.hour, 12);
                this.statement.setObject(4, (Object)this.beginBefore, 4);
                this.statement.setObject(5, (Object)this.beginAfter, 4);
                this.statement.setObject(6, (Object)this.endBefore, 4);
                this.statement.setObject(7, (Object)this.endAfter, 4);
                this.statement.setObject(8, (Object)this.cumulService, 4);
                this.statement.setObject(9, (Object)this.cumulAvant, 4);
                this.statement.setObject(10, (Object)this.cumulApres, 4);
                this.statement.setObject(11, (Object)Float.valueOf(this.montantFrance), 6);
                this.statement.setObject(12, (Object)Float.valueOf(this.montantEtranger), 6);
                this.statement.setObject(13, (Object)this.maxDistance, 4);
                this.statement.setObject(14, (Object)(this.fromHome ? 1 : 0), 4);
                this.statement.setObject(15, (Object)(this.fromCompany ? 1 : 0), 4);
                this.statement.setObject(16, (Object)(this.fromAgency ? 1 : 0), 4);
                this.statement.setObject(17, (Object)(this.fastView ? 1 : 0), 4);
                this.statement.setObject(18, (Object)this.beginView, 4);
                this.statement.setObject(19, (Object)this.endView, 4);
                this.statement.setObject(20, (Object)this.actif, 4);
                this.statement.setObject(21, (Object)Fonctions.vectorToString(this.quencher, ";"), 12);
                this.statement.setObject(22, (Object)Fonctions.vectorToString(this.enabledDay, ";"), 12);
                this.statement.setObject(23, (Object)this.employeeTypeId, 4);
                this.statement.setObject(24, (Object)this.export, 4);
                this.statement.setObject(25, (Object)this.archived, 4);
                this.statement.setObject(26, (Object)this.cle, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
                toReturn = true;
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean loadId(PreparedStatement fromStatement) throws SQLException {
        boolean retour = false;
        ResultSet rs = null;
        if (fromStatement != null && System.getProperty("SGBDR", "mysql").equals("mysql")) {
            rs = fromStatement.getGeneratedKeys();
            if (!rs.next()) {
                TimsLogger.debug("#ExpensesType.loadId# no auto generated key availaible");
            } else {
                TimsLogger.debug("#ExpensesType.loadId# auto generated key value = " + rs.getInt(1));
                this.cle = rs.getInt(1);
                retour = true;
            }
            rs.close();
        }
        if (retour) {
            return retour;
        }
        String sql = "SELECT MAX(CLE) AS CLE FROM T_FRAIS WHERE CODE = ? AND ARCHIVED=0";
        try {
            try {
                this.statement = ExpensesType.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.code, 12);
                rs = this.statement.executeQuery();
                while (rs.next()) {
                    this.cle = rs.getInt("CLE");
                    TimsLogger.debug("#ExpensesType.loadId# id found " + rs.getInt("CLE"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("#ExpensesType.loadId()#  : " + ex);
                ex.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean compareAndUpdate(String designation, String code, int hour, int beginBefore, int beginAfter, int endBefore, int endAfter, int cumulService, int cumulAvant, int cumulApres, int maxDistance, boolean fromHome, boolean fromCompany, boolean fromAgency, boolean fastView, int beginView, int endView, boolean actif, Vector<Integer> quencher, Vector<Integer> enabledDay, int employeeTypeId, int export, boolean archive, ArrayList<ExpensesAmount> list) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.expenses")) + " n\u00b0 " + this.cle + " (" + this.getDesignation() + ")\n";
        if (Fonctions.fieldChange(designation, this.designation)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.designation") + " '" + this.designation + "' => '" + designation + "'\n";
            this.setDesignation(designation);
        }
        if (Fonctions.fieldChange(this.code, code)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.code") + " '" + this.code + "' => '" + code + "'\n";
            this.setCode(code);
        }
        if (hour != this.hour) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.hour") + " '" + this.hour + "' => '" + hour + "'\n";
            this.setHour(hour);
        }
        if (beginBefore != this.beginBefore) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.begin") + " '" + this.beginBefore + "' => '" + beginBefore + "'\n";
            this.setBeginBefore(beginBefore);
        }
        if (beginAfter != this.beginAfter) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.begin") + " '" + this.beginAfter + "' => '" + beginAfter + "'\n";
            this.setBeginAfter(beginAfter);
        }
        if (endBefore != this.endBefore) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.end") + " '" + this.endBefore + "' => '" + endBefore + "'\n";
            this.setEndBefore(endBefore);
        }
        if (endAfter != this.endAfter) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.end") + " '" + this.endAfter + "' => '" + endAfter + "'\n";
            this.setEndAfter(endAfter);
        }
        if (cumulService != this.cumulService) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("expenses.totalWorked") + " '" + this.cumulService + "' => '" + cumulService + "'\n";
            this.setCumulService(cumulService);
        }
        if (cumulAvant != this.cumulAvant) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.before") + " '" + this.cumulAvant + "' => '" + cumulAvant + "'\n";
            this.setCumulAvant(cumulAvant);
        }
        if (cumulApres != this.cumulApres) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.after") + " '" + this.cumulApres + "' => '" + cumulApres + "'\n";
            this.setCumulApres(cumulApres);
        }
        if (maxDistance != this.maxDistance) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("expense.max.distance") + " '" + this.maxDistance + "' => '" + maxDistance + "'\n";
            this.setMaxDistance(maxDistance);
        }
        if (fromHome != this.fromHome) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("expense.from.home") + " '" + this.fromHome + "' => '" + fromHome + "'\n";
            this.setFromHome(fromHome);
        }
        if (fromCompany != this.fromCompany) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("expense.from.company") + " '" + this.fromCompany + "' => '" + fromCompany + "'\n";
            this.setFromCompany(fromCompany);
        }
        if (fromAgency != this.fromAgency) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("expense.fromrom.agency") + " '" + this.fromAgency + "' => '" + fromAgency + "'\n";
            this.setFromAgency(fromAgency);
        }
        if (fastView != this.fastView) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("expenses.fastView") + " '" + this.fastView + "' => '" + fastView + "'\n";
            this.setFastView(fastView);
        }
        if (beginView != this.beginView) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("expenses.beginView") + " '" + this.beginView + "' => '" + beginView + "'\n";
            this.setBeginView(beginView);
        }
        if (endView != this.endView) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("expenses.endView") + " '" + this.endView + "' => '" + endView + "'\n";
            this.setEndView(endView);
        }
        if (actif != this.actif) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.active") + " '" + this.actif + "' => '" + actif + "'\n";
            this.setActif(actif);
        }
        if (employeeTypeId != this.employeeTypeId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.employeeTypeId") + " '" + this.employeeTypeId + "' => '" + employeeTypeId + "'\n";
            this.setEmployeeTypeId(employeeTypeId);
        }
        if (export != this.export) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.export") + " '" + this.export + "' => '" + export + "'\n";
            this.setExport(export);
        }
        if (archive != this.archived) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.archive") + " '" + this.archived + "' => '" + archive + "'\n";
            this.setArchived(archive);
        }
        if (Fonctions.fieldChange(Fonctions.vectorToString(quencher, ";"), Fonctions.vectorToString(this.quencher, ";"))) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("expenses.quencher") + " '" + Fonctions.vectorToString(this.quencher, ";") + "' => '" + Fonctions.vectorToString(quencher, ";") + "'\n";
            this.setQuencher(quencher);
        }
        if (Fonctions.fieldChange(Fonctions.vectorToString(enabledDay, ";"), Fonctions.vectorToString(this.enabledDay, ";"))) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.code") + " '" + Fonctions.vectorToString(this.enabledDay, ";") + "' => '" + Fonctions.vectorToString(enabledDay, ";") + "'\n";
            this.setEnabledDay(enabledDay);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.expenses")) + " n\u00b0 " + this.cle + " (" + this.getDesignation() + ")\n")) {
            if (this.cle == 0) {
                TimsLogger.debug("#ExpenseType# on ins\u00e8re le nouveau frais");
                if (!this.insert()) return false;
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                return this.compareAndupdateExpensesAmount(list);
            } else {
                TimsLogger.debug("#ExpenseType# on met \u00e0 jour le frais " + this.cle);
                if (!this.updateValue()) return false;
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
            }
            return this.compareAndupdateExpensesAmount(list);
        } else {
            TimsLogger.debug("#ExpenseType# no changes before amount");
        }
        return this.compareAndupdateExpensesAmount(list);
    }

    public boolean compareAndupdateExpensesAmount(ArrayList<ExpensesAmount> list) {
        if (list == null) {
            return true;
        }
        TimsLogger.debug("ExpensesType.compareAndupdateExpensesAmount# " + list.size() + " montants \u00e0 mettre \u00e0 jour");
        boolean toReturn = true;
        for (ExpensesAmount toUpdate : list) {
            boolean found = false;
            if (this.montants != null) {
                for (ExpensesAmount original : this.montants) {
                    if (original.getId() != toUpdate.getId()) continue;
                    if (!original.compareAndUpdate(toUpdate.getEnacted(), toUpdate.getFrenchAmount(), toUpdate.getForeignAmount())) {
                        toReturn = false;
                    }
                    found = true;
                    break;
                }
            }
            if (found) continue;
            toUpdate.setExpenseTypeId(this.cle);
            toUpdate.insert();
            this.montants.add(toUpdate);
        }
        Collections.sort(this.montants);
        for (ExpensesAmount amount : this.montants) {
            TimsLogger.debug("#ExpensesType.compareAndUpdateAmount# montant " + amount.getEnacted() + " " + amount.getFrenchAmount() + " " + amount.getForeignAmount());
        }
        return toReturn;
    }

    public void delete() {
        String sql = "DELETE FROM t_frais WHERE CLE=?";
        try {
            this.statement = ExpensesType.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.cle, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean isActif() {
        return this.actif;
    }

    public void setActif(boolean actif) {
        this.actif = actif;
    }

    public int getCle() {
        return this.cle;
    }

    public void setCle(int cle) {
        this.cle = cle;
    }

    public int getCumulApres() {
        return this.cumulApres;
    }

    public void setCumulApres(int cumulApres) {
        this.cumulApres = cumulApres;
    }

    public int getCumulAvant() {
        return this.cumulAvant;
    }

    public void setCumulAvant(int cumulAvant) {
        this.cumulAvant = cumulAvant;
    }

    public int getCumulService() {
        return this.cumulService;
    }

    public void setCumulService(int cumulService) {
        this.cumulService = cumulService;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(int maxDistance) {
        this.maxDistance = maxDistance;
    }

    public boolean isFromHome() {
        return this.fromHome;
    }

    public void setFromHome(boolean fromHome) {
        this.fromHome = fromHome;
    }

    public boolean isFromCompany() {
        return this.fromCompany;
    }

    public void setFromCompany(boolean fromCompany) {
        this.fromCompany = fromCompany;
    }

    public boolean isFromAgency() {
        return this.fromAgency;
    }

    public void setFromAgency(boolean fromAgency) {
        this.fromAgency = fromAgency;
    }

    public String getDesignation() {
        return this.designation;
    }

    public void setDesignation(String designation) {
        this.designation = designation;
    }

    public int getBeginAfter() {
        return this.beginAfter;
    }

    public void setBeginAfter(int beginAfter) {
        this.beginAfter = beginAfter;
    }

    public int getBeginBefore() {
        return this.beginBefore;
    }

    public void setBeginBefore(int beginBefore) {
        this.beginBefore = beginBefore;
    }

    public int getEndAfter() {
        return this.endAfter;
    }

    public void setEndAfter(int endAfter) {
        this.endAfter = endAfter;
    }

    public int getEndBefore() {
        return this.endBefore;
    }

    public void setEndBefore(int endBefore) {
        this.endBefore = endBefore;
    }

    public ArrayList<ExpensesAmount> getMontants() {
        return this.montants;
    }

    public void setMontants(ArrayList<ExpensesAmount> montants) {
        this.montants = montants;
    }

    public float getMontant(Date date, int type) {
        float amountToReturn = 0.0f;
        if (date == null) {
            date = new Date();
        }
        if (this.getMontants() == null) {
            return 0.0f;
        }
        for (ExpensesAmount amount : this.getMontants()) {
            if (amount.getEnacted().after(date)) break;
            float f = amountToReturn = type == 0 ? amount.getFrenchAmount() : amount.getForeignAmount();
        }
        return amountToReturn;
    }

    public Date getLastEnactement() {
        if (this.getMontants() == null || this.getMontants().size() == 0) {
            return null;
        }
        return this.getMontants().get(this.getMontants().size() - 1).getEnacted();
    }

    public int getBeginView() {
        return this.beginView;
    }

    public void setBeginView(int beginView) {
        this.beginView = beginView;
    }

    public int getEndView() {
        return this.endView;
    }

    public void setEndView(int endView) {
        this.endView = endView;
    }

    public boolean isFastView() {
        return this.fastView;
    }

    public void setFastView(boolean fastView) {
        this.fastView = fastView;
    }

    public Vector<Integer> getEnabledDay() {
        return this.enabledDay;
    }

    public void setEnabledDay(Vector<Integer> enabledDay) {
        this.enabledDay = enabledDay;
    }

    public String getCode() {
        if (this.code == null || this.code.equals("")) {
            return Fonctions.getFirstLetters(this.designation).toUpperCase();
        }
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public void addEnabledDay(int dayId) {
        if (this.enabledDay == null) {
            this.enabledDay = new Vector();
        }
        this.enabledDay.add(dayId);
    }

    public Vector<Integer> getQuencher() {
        return this.quencher;
    }

    public void setQuencher(Vector<Integer> quencher) {
        this.quencher = quencher;
    }

    public void addQuencher(int quencherId) {
        if (this.quencher == null) {
            this.quencher = new Vector();
        }
        this.quencher.add(quencherId);
    }

    public int getEmployeeTypeId() {
        return this.employeeTypeId;
    }

    public void setEmployeeTypeId(int employeeTypeId) {
        this.employeeTypeId = employeeTypeId;
    }

    public int getExport() {
        return this.export;
    }

    public void setExport(int export) {
        this.export = export;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archive) {
        this.archived = archive;
    }

    public static Vector<ExpensesType> loadListWithAmount(boolean archive) {
        Vector<ExpensesType> liste = new Vector<ExpensesType>();
        String sql = "SELECT " + ExpensesType.getAllFields() + ", a.ID, ENACTED, FRENCH_AMOUNT, FOREIGN_AMOUNT" + " FROM " + table + " f" + " LEFT JOIN " + "expense_amount" + " a" + " ON f.cle=a.expense_type_id" + " WHERE ARCHIVED = " + (archive ? "1" : "0") + " ORDER BY " + (System.getProperty("expense.hourOrder", "0").equals("1") ? "HOUR" : "DESIGNATION") + ", CLE, ENACTED";
        TimsLogger.debug(String.valueOf(System.getProperty("expense.hourOrder", "0")) + " : " + sql);
        try {
            ResultSet rs = null;
            Statement stm = ExpensesType.getConnection().createStatement();
            int currentId = 0;
            ArrayList<ExpensesAmount> amountList = null;
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                if (currentId != rs.getInt("CLE")) {
                    ExpensesType tmp = new ExpensesType(rs.getInt("CLE"), rs.getString("DESIGNATION"), rs.getString("CODE"), rs.getInt("HOUR"), rs.getInt("BEGIN_BEFORE"), rs.getInt("BEGIN_AFTER"), rs.getInt("END_BEFORE"), rs.getInt("END_AFTER"), rs.getInt("CUMUL_SERVICE"), rs.getInt("CUMUL_AVANT"), rs.getInt("CUMUL_APRES"), rs.getInt("MAX_DISTANCE"), rs.getInt("FROM_HOME") == 1, rs.getInt("FROM_COMPANY") == 1, rs.getInt("FROM_AGENCY") == 1, rs.getFloat("MONTANT_FRANCE"), rs.getFloat("MONTANT_ETRANGER"), rs.getInt("BEGIN_VIEW"), rs.getInt("END_VIEW"), rs.getInt("FAST_VIEW") == 1, rs.getInt("ACTIF") == 1, rs.getString("QUENCHER"), rs.getString("ENABLED_DAY"), rs.getInt("EMPLOYEE_TYPE_ID"), rs.getInt("EXPORT"), rs.getBoolean("ARCHIVED"));
                    liste.add(tmp);
                    amountList = new ArrayList<ExpensesAmount>();
                    tmp.setMontants(amountList);
                    currentId = rs.getInt("CLE");
                }
                amountList.add(new ExpensesAmount(rs.getInt("a.ID"), rs.getInt("CLE"), rs.getDate("ENACTED"), rs.getFloat("FRENCH_AMOUNT"), rs.getFloat("FOREIGN_AMOUNT")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("ExpensesType.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        for (ExpensesType type : liste) {
            TimsLogger.debug(type.print());
        }
        return liste;
    }

    public String print() {
        return String.valueOf(this.getDesignation()) + " (" + this.getCode() + "), " + (this.isActif() ? " auto is on " + (this.getCumulService() != 0 ? "cumul " + this.getCumulService() + " entre " + this.getCumulApres() + " et " + this.getCumulAvant() : "amplitude, debut " + this.getBeginAfter() + " " + this.getBeginBefore() + ", fin " + this.getEndAfter() + " " + this.getEndBefore()) : "auto is off");
    }

    public static Vector<ExpensesType> getList() {
        if (list == null) {
            list = ExpensesType.loadListWithAmount(false);
        }
        return list;
    }

    public static void setList(Vector<ExpensesType> list) {
        ExpensesType.list = list;
    }

    public static ExpensesType getExpenses(int idExpenses) throws ExpensesNotFoundException {
        for (ExpensesType tmp : ExpensesType.getList()) {
            if (tmp.getCle() != idExpenses) continue;
            return tmp;
        }
        throw new ExpensesNotFoundException();
    }

    @Override
    public int getId() {
        return this.cle;
    }
}

