/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class ExpensesValidation
extends MainElement {
    public static final String table = "expenses_validation";
    public static int OFFSET = 118;
    private int id = 0;
    private int driverId = 0;
    private java.util.Date date = null;
    private java.util.Date valid = null;
    private int userValid = 0;
    private java.util.Date unvalid = null;
    private int userUnvalid = 0;

    public ExpensesValidation() {
    }

    public ExpensesValidation(int id, int driverId, java.util.Date date, java.util.Date valid, int userValid, java.util.Date unvalid, int userUnvalid) {
        this.id = id;
        this.driverId = driverId;
        this.date = date;
        this.valid = valid;
        this.userValid = userValid;
        this.unvalid = unvalid;
        this.userUnvalid = userUnvalid;
    }

    public boolean load(int cle) {
        ResultSet rs = null;
        String sql = "SELECT ID, DRIVER_ID, DAY, VALID_DATE, USER_VALID, UNVALID_DATE, USER_UNVALID FROM expenses_validation WHERE ID=?";
        try {
            this.statement = ExpensesValidation.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)cle, 4);
            rs = this.statement.executeQuery();
            if (rs.next()) {
                this.id = cle;
                this.driverId = rs.getInt("CLE_CHAUFFEUR");
                this.date = rs.getDate("DAY");
                this.valid = rs.getDate("VALID_DATE");
                this.userValid = rs.getInt("USER_VALID");
                this.unvalid = rs.getDate("UNVALID_DATE");
                this.userUnvalid = rs.getInt("USER_UNVALID");
                return true;
            }
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.warn("#ExpensesValidation.load()# " + ex);
        }
        finally {
            try {
                this.statement.close();
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return false;
    }

    public boolean unlock() {
        if (this.userUnvalid != -1) {
            return true;
        }
        return this.compareAndUpdate(ConnexionSettings.getInstance().getUserCle(), new java.util.Date());
    }

    public boolean compareAndUpdate(int userUnvalid, java.util.Date unvalid) {
        String tracer = String.valueOf(LanguageTranslator.getString("expensesValidation")) + " n\u00b0 " + this.id + "\n";
        if (userUnvalid != this.userUnvalid) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user") + " '" + this.userUnvalid + "' => '" + userUnvalid + "'\n";
            this.setUserUnvalid(userUnvalid);
        }
        if (Fonctions.fieldChange(unvalid, this.unvalid)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.date") + " '" + this.unvalid + "' => '" + unvalid + "'\n";
            this.setUnvalid(unvalid);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("expensesValidation")) + " n\u00b0 " + this.id + "\n")) {
            if (this.update()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new java.util.Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#ExpensesValidation# no changes");
        return true;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean retour = false;
        String sql = "";
        TimsLogger.debug("#ExpensesValidation.insert()#");
        try {
            try {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO expenses_validation (ID, DRIVER_ID, DAY, VALID_DATE, USER_VALID, UNVALID_DATE, USER_UNVALID) VALUES (GEN_T_LIEN_JOUR_FRAIS.nextval,?,?,?,?,?,?)";
                    this.statement = ExpensesValidation.getConnection().prepareStatement(sql);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO expenses_validation (DRIVER_ID, DAY, VALID_DATE, USER_VALID, UNVALID_DATE, USER_UNVALID) VALUES (?,?,?,?,?,?)";
                    this.statement = ExpensesValidation.getConnection().prepareStatement(sql, 1);
                }
                this.statement.setObject(1, (Object)this.driverId, 4);
                this.statement.setDate(2, new Date(this.date.getTime()));
                this.statement.setTimestamp(3, new Timestamp(this.valid.getTime()));
                this.statement.setObject(4, (Object)this.userValid, 4);
                this.statement.setTimestamp(5, this.unvalid != null ? new Timestamp(this.unvalid.getTime()) : null);
                this.statement.setObject(6, (Object)this.userUnvalid, 4);
                this.statement.executeUpdate();
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    ResultSet rs = this.statement.getGeneratedKeys();
                    if (!rs.next()) {
                        TimsLogger.debug("#ExpensesValidation.insert# no auto generated key availaible");
                    } else {
                        TimsLogger.debug("#ExpensesValidation.insert# auto generated key value = " + rs.getInt(1));
                        this.id = rs.getInt(1);
                    }
                    rs.close();
                }
                if (this.id == 0) {
                    if (this.loadId()) {
                        TimsLogger.debug("#ExpensesValidation.insert# generated key value = " + this.id);
                    } else {
                        TimsLogger.debug("#ExpensesValidation.insert# no generated key availaible");
                    }
                }
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    TimsLogger.warn("Erreur sql = " + sql);
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    TimsLogger.warn("Erreur sql = " + sql);
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("Erreur sql = " + sql);
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT MAX(ID) AS ID FROM expenses_validation WHERE DRIVER_ID = ? AND DAY = ?";
        try {
            try {
                this.statement = ExpensesValidation.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.driverId, 12);
                this.statement.setDate(2, new Date(this.date.getTime()));
                rs = this.statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("ID");
                    TimsLogger.debug("#ExpensesValidation.loadId# id found " + rs.getInt("ID"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("#ExpensesValidation.loadId()#  : " + ex);
                ex.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean updateValue() {
        boolean retour = false;
        String sql = "UPDATE expenses_validation SET  DRIVER_ID=? , DAY=? , VALID_DATE=? , USER_VALID=? , UNVALID_DATE = ? , USER_UNVALID = ?  WHERE ID=?";
        try {
            try {
                this.statement = ExpensesValidation.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.driverId, 4);
                this.statement.setDate(2, new Date(this.date.getTime()));
                this.statement.setTimestamp(3, new Timestamp(this.valid.getTime()));
                this.statement.setObject(4, (Object)this.userValid, 4);
                this.statement.setTimestamp(5, new Timestamp(this.unvalid.getTime()));
                this.statement.setObject(6, (Object)this.userUnvalid, 4);
                this.statement.setObject(7, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    TimsLogger.warn("Erreur sql = " + sql);
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    TimsLogger.warn("Erreur sql = " + sql);
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("Erreur sql = " + sql);
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int cle) {
        this.id = cle;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int cleConducteur) {
        this.driverId = cleConducteur;
    }

    public java.util.Date getDate() {
        return this.date;
    }

    public void setDate(java.util.Date dateJour) {
        this.date = dateJour;
    }

    public java.util.Date getValid() {
        return this.valid;
    }

    public void setValid(java.util.Date valid) {
        this.valid = valid;
    }

    public int getUserValid() {
        return this.userValid;
    }

    public void setUserValid(int userValid) {
        this.userValid = userValid;
    }

    public java.util.Date getUnvalid() {
        return this.unvalid;
    }

    public void setUnvalid(java.util.Date unvalid) {
        this.unvalid = unvalid;
    }

    public int getUserUnvalid() {
        return this.userUnvalid;
    }

    public void setUserUnvalid(int userUnvalid) {
        this.userUnvalid = userUnvalid;
    }

    public static Vector<ExpensesValidation> loadList(int driverId, java.util.Date begin, java.util.Date end) {
        String sql = "";
        Vector<ExpensesValidation> result = new Vector<ExpensesValidation>();
        try {
            String restrict;
            sql = "SELECT ID, DRIVER_ID, DAY, VALID_DATE, USER_VALID, UNVALID_DATE, USER_UNVALID FROM expenses_validation";
            String restriction = "";
            if (driverId != 0) {
                restriction = String.valueOf(restriction) + " AND DRIVER_ID = " + driverId;
            }
            if (!(restrict = BddTransport.addNewRestriction(null, true, table, false)).equals("")) {
                restriction = String.valueOf(restriction) + " AND " + restrict;
            }
            if (begin != null) {
                restriction = end != null && !end.equals("") ? String.valueOf(restriction) + " AND DAY BETWEEN ? AND ?" : String.valueOf(restriction) + " AND DAY = ?";
            }
            sql = String.valueOf(sql) + " WHERE USER_UNVALID = -1";
            if (!restriction.equals("")) {
                sql = String.valueOf(sql) + " AND " + restriction.substring(5);
            }
            sql = String.valueOf(sql) + " ORDER BY DRIVER_ID";
            PreparedStatement stm = ExpensesValidation.getConnection().prepareStatement(sql);
            if (begin != null) {
                if (begin != null) {
                    stm.setDate(1, new Date(begin.getTime()));
                }
                if (end != null) {
                    stm.setDate(2, new Date(end.getTime()));
                }
            }
            Transport.ps.startOperation();
            ResultSet rs = stm.executeQuery();
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate cl\u00f4ture frais", "#ExpensesValidation.loadList() => %s# sql = " + sql, 1);
            while (rs.next()) {
                result.add(new ExpensesValidation(rs.getInt("ID"), rs.getInt("DRIVER_ID"), rs.getDate("DAY"), rs.getTimestamp("VALID_DATE"), rs.getInt("USER_VALID"), rs.getTimestamp("UNVALID_DATE"), rs.getInt("USER_UNVALID")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("#ExpensesValidation.loadList()# ex : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }

    public static Vector<ExpensesValidation> find(Vector<ExpensesValidation> toSearch, int driverId, java.util.Date date) {
        Vector<ExpensesValidation> toReturn = new Vector<ExpensesValidation>();
        if (toSearch == null) {
            return toReturn;
        }
        for (ExpensesValidation de : toSearch) {
            if (!de.getDate().equals(date) || de.getDriverId() != driverId) continue;
            toReturn.add(de);
        }
        return toReturn;
    }

    public static boolean checkLocked(java.util.Date date, int driverId) {
        boolean toReturn = false;
        String sql = "SELECT ID FROM expenses_validation WHERE DRIVER_ID = ? AND DAY = ? AND USER_UNVALID = -1";
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            try {
                stm = ExpensesValidation.getConnection().prepareStatement(sql);
                stm.setObject(1, (Object)driverId, 4);
                stm.setDate(2, new Date(date.getTime()));
                rs = stm.executeQuery();
                if (rs.next()) {
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    stm.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("#DriverExpenses.load()# " + ex);
                try {
                    stm.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                stm.close();
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return toReturn;
    }

    public static void validAll(int driverId, java.util.Date begin, java.util.Date end) {
        java.util.Date curDay = begin;
        while (curDay.compareTo(end) <= 0) {
            TimsLogger.debug("check " + curDay);
            if (!ExpensesValidation.checkLocked(curDay, driverId)) {
                TimsLogger.debug("ExpensesValidation.validAll# add lock on " + curDay + " for " + driverId);
                new ExpensesValidation(0, driverId, curDay, new java.util.Date(), ConnexionSettings.getInstance().getUserCle(), null, -1).insert();
            }
            curDay = ConversionTime.addDay(curDay, 1);
        }
    }
}

