/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Constants;

public class ExportUpdate
extends MainElement {
    public static final String table = "t_export_update";
    public static int OFFSET = 118;
    private int id = 0;
    private int driverId = 0;
    private Date date = null;
    private int userId = 0;
    private boolean automatic = false;

    public ExportUpdate() {
    }

    public ExportUpdate(int id, int driverId, Date date, int userId, boolean automatic) {
        this.id = id;
        this.driverId = driverId;
        this.date = date;
        this.userId = userId;
        this.automatic = automatic;
    }

    public boolean load(int id, Date day) {
        boolean toReturn = false;
        ResultSet rs = null;
        String sql = "SELECT " + ExportUpdate.getAllFields() + " FROM " + table + " WHERE CLE_CHAUFFEUR = ?" + " AND TIMESTAMP_EXPORT = ?";
        try {
            try {
                this.statement = ExportUpdate.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)id, 4);
                this.statement.setTimestamp(2, new Timestamp(day.getTime()));
                rs = this.statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("CLE_EXPORT_UPDATE");
                    this.driverId = rs.getInt("CLE_CHAUFFEUR");
                    this.date = rs.getDate("TIMESTAMP_EXPORT");
                    this.userId = rs.getInt("USER_ID");
                    this.automatic = rs.getInt("AUTO_UPDATE") == 1;
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    this.statement.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("#ExportUpdate.load()# " + ex);
                try {
                    this.statement.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                this.statement.close();
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return toReturn;
    }

    public boolean insert() {
        boolean retour = false;
        String sql = "";
        TimsLogger.debug("#ExportUpdate.insert()#");
        try {
            try {
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO t_export_update (" + ExportUpdate.getAllFields() + ")" + " VALUES (GEN_T_LIEN_JOUR_FRAIS.nextval,?,?,?,?)";
                    this.statement = ExportUpdate.getConnection().prepareStatement(sql);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO t_export_update (" + ExportUpdate.getAllFields().substring(ExportUpdate.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?)";
                    this.statement = ExportUpdate.getConnection().prepareStatement(sql, 1);
                }
                this.statement.setObject(1, (Object)this.driverId, 4);
                this.statement.setTimestamp(2, new Timestamp(this.date.getTime()));
                this.statement.setObject(3, (Object)this.userId, 4);
                this.statement.setObject(4, (Object)(this.automatic ? 1 : 0), 4);
                this.statement.executeUpdate();
                this.statement.close();
                this.loadId();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    TimsLogger.warn("Erreur sql = " + sql);
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    TimsLogger.warn("Erreur sql = " + sql);
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("Erreur sql = " + sql);
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT MAX(CLE_EXPORT_UPDATE) AS CLE_EXPORT_UPDATE FROM t_export_update WHERE CLE_CHAUFFEUR = ? AND TIMESTAMP_EXPORT = ?";
        try {
            try {
                this.statement = ExportUpdate.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.driverId, 12);
                this.statement.setTimestamp(2, new Timestamp(this.date.getTime()));
                rs = this.statement.executeQuery();
                while (rs.next()) {
                    this.id = rs.getInt("CLE_EXPORT_UPDATE");
                    TimsLogger.debug("#ExportUpdate.loadId# id found " + rs.getInt("ID"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("#ExportUpdate.loadId()#  : " + ex);
                ex.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean delete() {
        String sql = "DELETE FROM t_export_update WHERE CLE_EXPORT_UPDATE= ?";
        try {
            this.statement = ExportUpdate.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int cle) {
        this.id = cle;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int cleConducteur) {
        this.driverId = cleConducteur;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date dateJour) {
        this.date = dateJour;
    }

    private static String getAllFields() {
        return "CLE_EXPORT_UPDATE, CLE_CHAUFFEUR, TIMESTAMP_EXPORT, USER_ID, AUTO_UPDATE";
    }

    public static Vector<ExportUpdate> loadList(int driverId, Date begin, Date end) {
        String sql = "";
        Vector<ExportUpdate> result = new Vector<ExportUpdate>();
        try {
            String restrict;
            sql = "SELECT " + ExportUpdate.getAllFields() + " FROM " + table;
            if (driverId != 0) {
                sql = String.valueOf(sql) + " AND CLE_CHAUFFEUR = " + driverId;
            }
            if ((restrict = BddTransport.addNewRestriction(null, true, table, false)) != "") {
                sql = String.valueOf(sql) + " AND " + restrict;
            }
            if (begin != null) {
                sql = end != null && !end.equals("") ? String.valueOf(sql) + " AND TIMESTAMP_EXPORT BETWEEN ? AND ?" : String.valueOf(sql) + " AND TIMESTAMP_EXPORT = ?";
            }
            sql = String.valueOf(sql) + " ORDER BY CLE_CHAUFFEUR";
            PreparedStatement stm = ExportUpdate.getConnection().prepareStatement(sql);
            if (begin != null) {
                if (begin != null) {
                    stm.setTimestamp(1, new Timestamp(begin.getTime()));
                }
                if (end != null) {
                    stm.setTimestamp(2, new Timestamp(end.getTime()));
                }
            }
            Transport.ps.startOperation();
            ResultSet rs = stm.executeQuery();
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate load export update", "#ExportUpdate.loadList() => %s# sql = " + sql, 1);
            while (rs.next()) {
                result.add(new ExportUpdate(rs.getInt("CLE_EXPORT_UPDATE"), rs.getInt("CLE_CHAUFFEUR"), rs.getTimestamp("TIMESTAMP_EXPORT"), rs.getInt("USER_ID"), rs.getInt("AUTO_UPDATE") == 1));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("#ExportUpdate.loadList()# ex : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }

    public static boolean exist(int id, Date day) {
        boolean toReturn = false;
        ResultSet rs = null;
        String sql = "SELECT ID FROM t_export_update WHERE CLE_CHAUFFEUR = ? AND TIMESTAMP_EXPORT = ?";
        PreparedStatement stm = null;
        try {
            try {
                stm = ExportUpdate.getConnection().prepareStatement(sql);
                stm.setObject(1, (Object)id, 4);
                stm.setTimestamp(2, new Timestamp(day.getTime()));
                rs = stm.executeQuery();
                if (rs.next()) {
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    stm.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("#ExportUpdate.load()# " + ex);
                try {
                    stm.close();
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                stm.close();
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return toReturn;
    }

    public static Vector<ExportUpdate> find(Vector<ExportUpdate> toSearch, int driverId, Date date) {
        Vector<ExportUpdate> toReturn = new Vector<ExportUpdate>();
        if (toSearch == null) {
            return toReturn;
        }
        for (ExportUpdate de : toSearch) {
            if (!de.getDate().equals(date) || de.getDriverId() != driverId) continue;
            toReturn.add(de);
        }
        return toReturn;
    }
}

