/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ChangementActivite;
import fr.pgh.data.bdd.MainElement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;

public class ExternalDay
extends MainElement {
    public static final String table = "external_day";
    private int id = 0;
    private int driverId = 0;
    private int userId = 0;
    private Date begin = null;
    private Date end = null;
    private Vector<ChangementActivite> activities = null;
    private int driving = 0;
    private int work = 0;
    private int availability = 0;
    private int rest = 0;
    private int crew = 0;
    private int unk = 0;
    private int other = 0;
    private int total = 0;
    private int beginTime = 0;
    private int endTime = 0;
    private int distance = 0;

    public ExternalDay(int id, int driverId, int userId, Date begin, Date end, Vector<ChangementActivite> activities, int driving, int work, int availability, int rest, int crew, int unk, int other, int total, int beginTime, int endTime, int distance) {
        this.id = id;
        this.driverId = driverId;
        this.userId = userId;
        this.begin = begin;
        this.end = end;
        this.activities = activities;
        this.driving = driving;
        this.work = work;
        this.availability = availability;
        this.rest = rest;
        this.crew = crew;
        this.unk = unk;
        this.other = other;
        this.total = total;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.distance = distance;
    }

    public ExternalDay(int id, int driverId, int userId, Date begin, Date end, byte[] dbRepresentation, int driving, int work, int availability, int rest, int crew, int unk, int other, int total, int beginTime, int endTime, int distance) {
        this.id = id;
        this.driverId = driverId;
        this.userId = userId;
        this.begin = begin;
        this.end = end;
        this.activities = this.fromDBRepresentation(dbRepresentation);
        this.driving = driving;
        this.work = work;
        this.availability = availability;
        this.rest = rest;
        this.crew = crew;
        this.unk = unk;
        this.other = other;
        this.total = total;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.distance = distance;
    }

    /*
     * Loose catch block
     */
    public boolean insert() {
        boolean retour = false;
        PreparedStatement statement = null;
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO external_day(ID, DRIVER_ID, BEGIN_DATE, END_DATE, ACTIVITIES, USER_ID, DRIVING, WORK, AVAILABILITY, REST, CREW, EVENT, OTHER, TOTAL, DISTANCE, BEGIN_TIME, END_TIME) VALUES (GEN_T_JOUR.nextval,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO external_day(DRIVER_ID, BEGIN_DATE, END_DATE, ACTIVITIES, USER_ID, DRIVING, WORK, AVAILABILITY, REST, CREW, EVENT, OTHER, TOTAL, DISTANCE, BEGIN_TIME, END_TIME) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        try {
            try {
                statement = ExternalDay.getConnection().prepareStatement(sql);
                statement.setObject(1, (Object)this.driverId, 12);
                statement.setDate(2, new java.sql.Date(this.begin.getTime()));
                statement.setDate(3, new java.sql.Date(this.end.getTime()));
                statement.setBytes(4, this.toDBRepresentation(this.activities));
                statement.setObject(5, (Object)this.userId, 4);
                statement.setObject(6, (Object)this.driving, 4);
                statement.setObject(7, (Object)this.work, 4);
                statement.setObject(8, (Object)this.availability, 4);
                statement.setObject(9, (Object)this.rest, 4);
                statement.setObject(10, (Object)this.crew, 4);
                statement.setObject(11, (Object)this.unk, 4);
                statement.setObject(12, (Object)this.other, 4);
                statement.setObject(13, (Object)this.total, 4);
                statement.setObject(14, (Object)this.distance, 4);
                statement.setObject(15, (Object)this.beginTime, 4);
                statement.setObject(16, (Object)this.endTime, 4);
                statement.executeUpdate();
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (CommunicationsException ex2) {
                    BddTransport.getInstance().showTimeout();
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (CommunicationsException ex) {
                    BddTransport.getInstance().showTimeout();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (CommunicationsException ex4) {
                    BddTransport.getInstance().showTimeout();
                }
                catch (SQLException ex5) {
                    ex5.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return retour;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int cleConducteur) {
        this.driverId = cleConducteur;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Vector<ChangementActivite> getActivities() {
        return this.activities;
    }

    public void setActivities(Vector<ChangementActivite> activities) {
        this.activities = activities;
    }

    public Date getBegin() {
        return this.begin;
    }

    public void setBegin(Date day) {
        this.begin = day;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public int getDriving() {
        return this.driving;
    }

    public void setDriving(int driving) {
        this.driving = driving;
    }

    public int getWork() {
        return this.work;
    }

    public void setWork(int work) {
        this.work = work;
    }

    public int getAvailability() {
        return this.availability;
    }

    public void setAvailability(int availability) {
        this.availability = availability;
    }

    public int getRest() {
        return this.rest;
    }

    public void setRest(int rest) {
        this.rest = rest;
    }

    public int getCrew() {
        return this.crew;
    }

    public void setCrew(int crew) {
        this.crew = crew;
    }

    public int getUnk() {
        return this.unk;
    }

    public void setUnk(int unk) {
        this.unk = unk;
    }

    public int getOther() {
        return this.other;
    }

    public void setOther(int other) {
        this.other = other;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(int begin) {
        this.beginTime = begin;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setEndTime(int end) {
        this.endTime = end;
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    public static Vector<ExternalDay> loadList(int agencyId, int driverId, Date begin, Date end) {
        Vector<ExternalDay> toReturn = new Vector<ExternalDay>();
        String res = "";
        if (agencyId != 0) {
            res = String.valueOf(res) + " AND DRIVER_ID IN (SELECT CLE_CHAUFFEUR FROM T_CONDUCTEUR WHERE CLE_AGENCE = ?)";
        }
        if (driverId != 0) {
            res = String.valueOf(res) + " AND DRIVER_ID = ?";
        }
        if (begin != null) {
            res = end != null ? String.valueOf(res) + " AND BEGIN_DATE BETWEEN ? AND ?" : String.valueOf(res) + " AND BEGIN_DATE = ?";
        }
        String sql = "SELECT * FROM external_day";
        if (!res.equals("")) {
            sql = String.valueOf(sql) + " WHERE " + res.substring(5);
        }
        sql = String.valueOf(sql) + " ORDER BY DRIVER_ID, BEGIN_DATE";
        try {
            Transport.ps.startOperation();
            PreparedStatement stm = ExternalDay.getConnection().prepareStatement(sql);
            int idx = 1;
            if (driverId != 0) {
                stm.setObject(idx, (Object)driverId, 4);
                ++idx;
            }
            if (begin != null) {
                stm.setDate(idx, new java.sql.Date(begin.getTime()));
                ++idx;
            }
            if (end != null) {
                stm.setDate(idx, new java.sql.Date(end.getTime()));
                ++idx;
            }
            ResultSet rs = stm.executeQuery();
            long duration = Transport.ps.endOperation(PerformanceScanner.PROCESS, "Requ\u00eate Informatique embarqu\u00e9e");
            TimsLogger.debug("#ExternalDay.loadList() => " + duration + " ms# sql = " + sql);
            while (rs.next()) {
                byte[] tbl;
                byte[] byArray = tbl = rs.getBytes("ACTIVITIES");
                int n = tbl.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    TimsLogger.debug(String.valueOf(Integer.toHexString(b & 0xFF)) + " ");
                    ++n2;
                }
                TimsLogger.debug("\r\n" + tbl.length + " byte = " + rs.getString("ACTIVITIES"));
                TimsLogger.debug("\r\n" + tbl.length + " byte = " + rs.getDate("END_DATE"));
                toReturn.add(new ExternalDay(rs.getInt("ID"), rs.getInt("DRIVER_ID"), rs.getInt("USER_ID"), (Date)rs.getDate("BEGIN_DATE"), (Date)rs.getDate("END_DATE"), rs.getBytes("ACTIVITIES"), rs.getInt("DRIVING"), rs.getInt("WORK"), rs.getInt("AVAILABILITY"), rs.getInt("REST"), rs.getInt("CREW"), rs.getInt("EVENT"), rs.getInt("OTHER"), rs.getInt("TOTAL"), rs.getInt("BEGIN_TIME"), rs.getInt("END_TIME"), rs.getInt("DISTANCE")));
            }
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.warn("#ExternalDay.loadList()# " + ex);
            ex.printStackTrace();
            TimsLogger.debug(sql);
        }
        return toReturn;
    }

    /*
     * Unable to fully structure code
     */
    public static Vector<ExternalDay>[] loadListOrderedByWeek(int driverId, Date begin) {
        result = new Vector[7];
        i = 0;
        while (i < 7) {
            result[i] = new Vector<E>();
            ++i;
        }
        calendrier = new GregorianCalendar();
        calendrier.setTime(begin);
        calendrier.add(5, 7);
        end = calendrier.getTime();
        toOrder = ExternalDay.loadList(0, driverId, begin, end);
        if (toOrder.size() == 0) {
            return result;
        }
        calendrier.setTime(begin);
        calendrier.add(5, 1);
        y = 0;
        x = 0;
        ** GOTO lbl26
        {
            result[x].add(toOrder.get(y));
            ++y;
            do {
                if (y < toOrder.size() && toOrder.get(y).getBegin().before(calendrier.getTime())) continue block1;
                calendrier.add(5, 1);
                ++x;
lbl26:
                // 2 sources

            } while (x < 7);
        }
        return result;
    }

    private Vector<ChangementActivite> fromDBRepresentation(byte[] toConvert) {
        Vector<ChangementActivite> toReturn = new Vector<ChangementActivite>();
        int activityCount = toConvert.length / 2;
        int x = 0;
        while (x < activityCount) {
            toReturn.add(this.fromDBRepresentationOne(toConvert, x * 2));
            ++x;
        }
        return toReturn;
    }

    private ChangementActivite fromDBRepresentationOne(byte[] toConvert, int beginOff) {
        String byte1 = Integer.toString(toConvert[beginOff] + (int)Math.pow(2.0, 8.0), 2).substring(1);
        String byte2 = Integer.toString(toConvert[beginOff + 1] + (int)Math.pow(2.0, 8.0), 2).substring(1);
        if (byte1.length() < 8) {
            byte1 = "1" + byte1;
        }
        if (byte2.length() < 8) {
            byte2 = "1" + byte2;
        }
        String tmp = String.valueOf(byte1) + byte2;
        TimsLogger.debug(String.valueOf(toConvert[beginOff]) + " " + toConvert[beginOff + 1] + " = " + byte1 + " + " + byte2 + " = " + tmp);
        int time = Integer.parseInt(tmp.substring(0, 11), 2);
        int type = Integer.parseInt(tmp.substring(11, 16), 2);
        ChangementActivite toReturn = new ChangementActivite(type, this.begin, time, "", "", "", "", "");
        return toReturn;
    }

    private byte[] toDBRepresentation(Vector<ChangementActivite> activities) {
        byte[] toReturn = new byte[activities.size() * 2];
        int x = 0;
        for (ChangementActivite tmp : activities) {
            byte[] tbl = this.toDBRepresentationOne(tmp);
            toReturn[x] = tbl[0];
            toReturn[++x] = tbl[1];
            ++x;
        }
        return toReturn;
    }

    private byte[] toDBRepresentationOne(ChangementActivite toConvert) {
        int time = toConvert.getHeure();
        int type = toConvert.getTypeActivite();
        String toReturn = "";
        toReturn = String.valueOf(toReturn) + Integer.toBinaryString(time + (int)Math.pow(2.0, 11.0)).substring(1);
        toReturn = String.valueOf(toReturn) + Integer.toBinaryString(type + (int)Math.pow(2.0, 5.0)).substring(1);
        byte[] byteTo = new byte[]{(byte)Integer.parseInt(toReturn.substring(0, 8), 2), (byte)Integer.parseInt(toReturn.substring(8, 16), 2)};
        TimsLogger.debug(String.valueOf(toConvert.getHeure()) + "," + toConvert.getTypeActivite() + " = " + toReturn);
        return byteTo;
    }
}

