/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;

public class Fault
extends MainElement {
    public static final String table = "fault";
    public static final int EXP_ON_ABS = 1;
    public static final int ABS_ON_EXP = 2;
    public static final int ACT_ON_ABS = 3;
    public static final int ABS_ON_ACT = 4;
    public static final int EXP_ON_NONE = 5;
    private int id = 0;
    private int driverId = 0;
    private Date day = null;
    private int userId = 0;
    private int type = 0;

    public Fault(int id, int driverId, Date day, int userId, int type) {
        this.id = id;
        this.driverId = driverId;
        this.day = day;
        this.userId = userId;
        this.type = type;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public Date getDay() {
        return this.day;
    }

    public void setDay(Date day) {
        this.day = day;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean insert() {
        String sql = "";
        TimsLogger.debug("#Fault.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO fault (ID,DRIVER_ID, DAY, TYPE, USER_ID) VALUES (GEN_FAULT.nextval,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO fault (DRIVER_ID, DAY, TYPE, USER_ID) VALUES (?,?,?,?)";
        }
        try {
            this.statement = Fault.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.driverId, 4);
            this.statement.setDate(2, new java.sql.Date(this.day.getTime()));
            this.statement.setObject(3, (Object)this.type, 4);
            this.statement.setObject(4, (Object)this.userId, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE fault SET DRIVER_ID=?, DAY=?, TYPE=?, USER_ID=?, WHERE ID = ?";
        try {
            try {
                this.statement = Fault.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.driverId, 4);
                this.statement.setDate(2, new java.sql.Date(this.day.getTime()));
                this.statement.setObject(3, (Object)this.type, 4);
                this.statement.setObject(4, (Object)this.userId, 4);
                this.statement.setObject(5, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean delete() {
        boolean toReturn = false;
        String sql = "DELETE FROM fault WHERE ID = ?";
        try {
            try {
                this.statement = Fault.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.id, 4);
                this.statement.executeUpdate();
                this.statement.close();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public static Vector<Fault> loadList(int driverId, Date begin, Date end) {
        String sql = "";
        Vector<Fault> result = new Vector<Fault>();
        try {
            String res = "";
            if (driverId != 0) {
                res = String.valueOf(res) + " AND DRIVER_ID = ?";
            }
            if (begin != null) {
                res = end != null ? String.valueOf(res) + " AND DAY BETWEEN ? AND ?" : String.valueOf(res) + " AND DAY = ?";
            }
            sql = "SELECT ID,DRIVER_ID, DAY, TYPE, USER_ID FROM fault";
            if (!res.equals("")) {
                sql = String.valueOf(sql) + " WHERE " + res.substring(5);
            }
            sql = String.valueOf(sql) + " ORDER BY ID";
            PreparedStatement stm = Fault.getConnection().prepareStatement(sql);
            int ind = 1;
            if (driverId != 0) {
                stm.setObject(ind, (Object)driverId, 4);
                ++ind;
            }
            if (begin != null) {
                stm.setDate(ind, new java.sql.Date(begin.getTime()));
                ++ind;
            }
            if (end != null) {
                stm.setDate(ind, new java.sql.Date(end.getTime()));
            }
            ResultSet rs = stm.executeQuery();
            while (rs.next()) {
                result.add(new Fault(rs.getInt("ID"), rs.getInt("DRIVER_ID"), rs.getDate("DAY"), rs.getInt("USER_ID"), rs.getInt("TYPE")));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("#Fault.loadList()# ex : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }

    public static String getTypeLbl(int type) {
        switch (type) {
            case 1: {
                return LanguageTranslator.getString("fault.expOnAbs");
            }
            case 2: {
                return LanguageTranslator.getString("fault.absOnExp");
            }
            case 3: {
                return LanguageTranslator.getString("fault.actOnAbs");
            }
            case 4: {
                return LanguageTranslator.getString("fault.absOnAct");
            }
            case 5: {
                return LanguageTranslator.getString("fault.expOnNone");
            }
        }
        return LanguageTranslator.getString("generics.unknown");
    }
}

