/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class FuelConsumption
extends MainElement {
    public static final String table = "FUEL_CONSUMPTION";
    public static final int AGENCY = 0;
    public static final int DRIVER = 1;
    public static final int VEHICLE = 2;
    private int id = 0;
    private int agencyId = 0;
    private int driverId = 0;
    private int vehicleId = 0;
    private java.util.Date date = null;
    private float consumption = 0.0f;
    private float liters = 0.0f;
    private int length = 0;
    private float km = 0.0f;
    private int kmCpt = 0;
    private int stopLength = 0;
    private int stopLengthStrength = 0;
    private int stopLengthInTraffic = 0;
    private float lengthBrake = 0.0f;
    private int regDelta = 0;
    private int co2 = 0;
    private int travelNotation = 0;

    public FuelConsumption() {
    }

    public FuelConsumption(int id, int agencyId, int driverId, int vehicleId, java.util.Date date, float consumption, float liters, int length, float km, int kmCpt, int stopLength, int stopLengthStrength, int stopLengthInTraffic, float lengthBrake, int regDelta, int co2, int travelNotation) {
        this.id = id;
        this.agencyId = agencyId;
        this.driverId = driverId;
        this.vehicleId = vehicleId;
        this.date = date;
        this.consumption = consumption;
        this.liters = liters;
        this.length = length;
        this.km = km;
        this.kmCpt = kmCpt;
        this.stopLength = stopLength;
        this.stopLengthStrength = stopLengthStrength;
        this.stopLengthInTraffic = stopLengthInTraffic;
        this.lengthBrake = lengthBrake;
        this.regDelta = regDelta;
        this.co2 = co2;
        this.travelNotation = travelNotation;
    }

    public boolean equals(Object o) {
        return o instanceof FuelConsumption && this.date.equals(((FuelConsumption)o).getDate());
    }

    public boolean loadByDriverAndDate(int driverId, java.util.Date date) {
        String sql = "SELECT " + FuelConsumption.getAllFields() + " FROM " + table + " WHERE DRIVER_ID=" + driverId + " AND DATE=" + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(date, "yyyy-MM-dd HH:mm:ss"), true);
        return this.genericLoad(sql);
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + FuelConsumption.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = FuelConsumption.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.agencyId = rs.getInt("AGENCY_ID");
                    this.driverId = rs.getInt("DRIVER_ID");
                    this.vehicleId = rs.getInt("VEHICLE_ID");
                    this.date = rs.getDate("DATE");
                    this.consumption = rs.getFloat("CONSUMPTION");
                    this.liters = rs.getFloat("LITERS");
                    this.length = rs.getInt("LENGTH");
                    this.km = rs.getFloat("KM");
                    this.km = rs.getFloat("KM_CPT");
                    this.stopLength = rs.getInt("STOP_LENGTH");
                    this.stopLengthStrength = rs.getInt("STOP_LENGTH_STRENGTH");
                    this.stopLengthInTraffic = rs.getInt("STOP_LENGTH_IN_TRAFFIC");
                    this.lengthBrake = rs.getFloat("LENGTH_BRAKE");
                    this.regDelta = rs.getInt("REG_DELTA");
                    this.co2 = rs.getInt("CO2");
                    this.travelNotation = rs.getInt("TRAVEL_NOTATION");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.error("genericLoad()# sql = " + sql + " => " + ex.getMessage());
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO FUEL_CONSUMPTION (" + FuelConsumption.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO FUEL_CONSUMPTION (" + FuelConsumption.getAllFields().substring(FuelConsumption.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        }
        try {
            this.statement = FuelConsumption.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.agencyId, 4);
            this.statement.setObject(2, (Object)this.driverId, 4);
            this.statement.setObject(3, (Object)this.vehicleId, 4);
            this.statement.setTimestamp(4, new Timestamp(this.date.getTime()));
            this.statement.setObject(5, (Object)Float.valueOf(this.consumption), 6);
            this.statement.setObject(6, (Object)Float.valueOf(this.liters), 4);
            this.statement.setObject(7, (Object)this.length, 4);
            this.statement.setObject(8, (Object)Float.valueOf(this.km), 6);
            this.statement.setObject(9, (Object)this.kmCpt, 4);
            this.statement.setObject(10, (Object)this.stopLength, 4);
            this.statement.setObject(11, (Object)this.stopLengthStrength, 4);
            this.statement.setObject(12, (Object)this.stopLengthInTraffic, 4);
            this.statement.setObject(13, (Object)Float.valueOf(this.lengthBrake), 6);
            this.statement.setObject(14, (Object)this.regDelta, 4);
            this.statement.setObject(15, (Object)this.co2, 4);
            this.statement.setObject(16, (Object)this.travelNotation, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.error("insert()# sql = " + sql + " => " + ex.getMessage());
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE FUEL_CONSUMPTION SET  AGENCY_ID=? , DRIVER_ID=? , VEHICLE_ID=? , " + BddTransport.getChampDate() + "=? ," + " CONSUMPTION=?, " + " LITERS=?, " + " LENGTH=?, " + " KM=?, " + " KM_CPT=?, " + " STOP_LENGTH=?, " + " STOP_LENGTH_STRENGTH=?, " + " STOP_LENGTH_IN_TRAFFIC=?, " + " LENGTH_BRAKE=?, " + " REG_DELTA=?, " + " CO2=?, " + " TRAVEL_NOTATION=? " + " WHERE ID=?";
        try {
            this.statement = FuelConsumption.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.agencyId, 4);
            this.statement.setObject(2, (Object)this.driverId, 4);
            this.statement.setObject(3, (Object)this.vehicleId, 4);
            this.statement.setDate(4, new Date(this.date.getTime()));
            this.statement.setObject(5, (Object)Float.valueOf(this.consumption), 6);
            this.statement.setObject(6, (Object)Float.valueOf(this.liters), 4);
            this.statement.setObject(7, (Object)this.length, 4);
            this.statement.setObject(8, (Object)Float.valueOf(this.km), 6);
            this.statement.setObject(9, (Object)this.kmCpt, 4);
            this.statement.setObject(10, (Object)this.stopLength, 4);
            this.statement.setObject(11, (Object)this.stopLengthStrength, 4);
            this.statement.setObject(12, (Object)this.stopLengthInTraffic, 4);
            this.statement.setObject(13, (Object)Float.valueOf(this.lengthBrake), 6);
            this.statement.setObject(14, (Object)this.regDelta, 4);
            this.statement.setObject(15, (Object)this.co2, 4);
            this.statement.setObject(16, (Object)this.travelNotation, 4);
            this.statement.setObject(17, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.error("updateValue()# sql = " + sql + " => " + ex.getMessage());
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public int getAgencyId() {
        return this.agencyId;
    }

    public void setAgencyId(int agencyId) {
        this.agencyId = agencyId;
    }

    public int getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(int vehicleId) {
        this.vehicleId = vehicleId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public java.util.Date getDate() {
        return this.date;
    }

    public void setDate(java.util.Date date) {
        this.date = date;
    }

    public float getConsumption() {
        return this.consumption;
    }

    public void setConsumption(float consumption) {
        this.consumption = consumption;
    }

    public float getLiters() {
        return this.liters;
    }

    public void setLiters(float liters) {
        this.liters = liters;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public float getKm() {
        return this.km;
    }

    public void setKm(float km) {
        this.km = km;
    }

    public int getKmCpt() {
        return this.kmCpt;
    }

    public void setKmCpt(int kmCpt) {
        this.kmCpt = kmCpt;
    }

    public int getStopLength() {
        return this.stopLength;
    }

    public void setStopLength(int stopLength) {
        this.stopLength = stopLength;
    }

    public int getStopLengthStrength() {
        return this.stopLengthStrength;
    }

    public void setStopLengthStrength(int stopLengthStrength) {
        this.stopLengthStrength = stopLengthStrength;
    }

    public int getStopLengthInTraffic() {
        return this.stopLengthInTraffic;
    }

    public void setStopLengthInTraffic(int stopLengthInTraffic) {
        this.stopLengthInTraffic = stopLengthInTraffic;
    }

    public float getLengthBrake() {
        return this.lengthBrake;
    }

    public void setLengthBrake(float lengthBrake) {
        this.lengthBrake = lengthBrake;
    }

    public int getRegDelta() {
        return this.regDelta;
    }

    public void setRegDelta(int regDelta) {
        this.regDelta = regDelta;
    }

    public int getCo2() {
        return this.co2;
    }

    public void setCo2(int co2) {
        this.co2 = co2;
    }

    public int getTravelNotation() {
        return this.travelNotation;
    }

    public void setTravelNotation(int travelNotation) {
        this.travelNotation = travelNotation;
    }

    private static String getAllFields() {
        return "ID, AGENCY_ID, DRIVER_ID, VEHICLE_ID, " + BddTransport.getChampDate() + ", CONSUMPTION, LITERS, LENGTH, KM, KM_CPT," + " STOP_LENGTH, STOP_LENGTH_STRENGTH, STOP_LENGTH_IN_TRAFFIC, LENGTH_BRAKE, REG_DELTA, CO2, TRAVEL_NOTATION";
    }

    public boolean compareAndUpdate(int agencyId, int driverId, int vehicleId, java.util.Date date, float consumption, float liters, int length, float km, int kmCpt, int stopLength, int stopLengthStrength, int stopLengthInTraffic, float lengthBrake, int regDelta, int co2, int travelNotation) {
        String tracer = String.valueOf(LanguageTranslator.getString("fuel.consumption")) + " n\u00b0 " + this.id + "\n";
        if (agencyId != this.agencyId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.agency") + " '" + this.agencyId + "' => '" + agencyId + "'\n";
            this.setAgencyId(agencyId);
        }
        if (driverId != this.driverId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.driver") + " '" + this.driverId + "' => '" + driverId + "'\n";
            this.setDriverId(driverId);
        }
        if (vehicleId != this.vehicleId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.vehicle") + " '" + this.vehicleId + "' => '" + vehicleId + "'\n";
            this.setVehicleId(vehicleId);
        }
        if (Fonctions.fieldChange(date, this.date)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.date") + " '" + this.date + "' => '" + date + "'\n";
            this.setDate(date);
        }
        if (consumption != this.consumption) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("fuel.consumption") + " '" + this.consumption + "' => '" + consumption + "'\n";
            this.setConsumption(consumption);
        }
        if (length != this.length) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.length") + " '" + this.length + "' => '" + length + "'\n";
            this.setLength(length);
        }
        if (liters != this.liters) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.liters") + " '" + this.liters + "' => '" + liters + "'\n";
            this.setLiters(liters);
        }
        if (km != this.km) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.km") + " '" + this.km + "' => '" + km + "'\n";
            this.setKm(km);
        }
        if (kmCpt != this.kmCpt) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.km.cpt") + " '" + this.kmCpt + "' => '" + kmCpt + "'\n";
            this.setKmCpt(kmCpt);
        }
        if (stopLength != this.stopLength) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.stopLength") + " '" + this.stopLength + "' => '" + stopLength + "'\n";
            this.setStopLength(stopLength);
        }
        if (stopLengthStrength != this.stopLengthStrength) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.stopLengthStrength") + " '" + this.stopLengthStrength + "' => '" + stopLengthStrength + "'\n";
            this.setStopLengthStrength(stopLengthStrength);
        }
        if (stopLengthInTraffic != this.stopLengthInTraffic) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.stopLengthInTraffic") + " '" + this.stopLengthInTraffic + "' => '" + stopLengthInTraffic + "'\n";
            this.setStopLengthInTraffic(stopLengthInTraffic);
        }
        if (lengthBrake != this.lengthBrake) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.lengthBrake") + " '" + this.lengthBrake + "' => '" + lengthBrake + "'\n";
            this.setLengthBrake(lengthBrake);
        }
        if (regDelta != this.regDelta) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.regDelta") + " '" + this.regDelta + "' => '" + regDelta + "'\n";
            this.setRegDelta(regDelta);
        }
        if (co2 != this.co2) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.co2") + " '" + this.co2 + "' => '" + co2 + "'\n";
            this.setCo2(co2);
        }
        if (travelNotation != this.travelNotation) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.travelNotation") + " '" + this.travelNotation + "' => '" + travelNotation + "'\n";
            this.setTravelNotation(travelNotation);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("fuel.consumption")) + " n\u00b0 " + this.id + "\n")) {
            if (this.id == 0) {
                if (this.insert()) {
                    new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new java.util.Date(), tracer).insert();
                    return true;
                }
                return false;
            }
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new java.util.Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("compareAndUpdate# no changes");
        return true;
    }

    public void delete() {
        String sql = "DELETE FROM FUEL_CONSUMPTION WHERE ID=?";
        try {
            this.statement = FuelConsumption.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Vector<FuelConsumption> loadList(int agencyId, int driverId, int vehicleId, java.util.Date begin, java.util.Date end) {
        String filters = String.valueOf(agencyId != 0 ? " AND AGENCY_ID =" + agencyId : "") + (driverId != 0 ? " AND DRIVER_ID =" + driverId : "") + (vehicleId != 0 ? " AND VEHICLE_ID =" + vehicleId : "") + (begin != null ? (end != null ? " AND " + BddTransport.getChampDate() + " BETWEEN " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false) + " AND " + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(end, "yyyy-MM-dd"), false) : " AND " + BddTransport.getChampDate() + " =" + BddTransport.getDateStringToSGBDR(ConversionTime.dateToString(begin, "yyyy-MM-dd"), false)) : "");
        return FuelConsumption.loadList(filters);
    }

    public static Vector<FuelConsumption> loadTotal(int agencyId, int driverId, int vehicleId, java.util.Date begin, java.util.Date end, int avgTarget, int avgType) {
        TimsLogger.debug("loadTotal# on charge pour agencyId=" + agencyId + ", driverId=" + driverId + ", vehicleId=" + vehicleId + ", begin=" + begin + ", end=" + end + ", avgTarget=" + avgTarget + ", avgType=" + avgType);
        return FuelConsumption.loadTotal(FuelConsumption.loadList(agencyId, driverId, vehicleId, begin, end), avgTarget, avgType);
    }

    public static Vector<FuelConsumption> loadTotal(Vector<FuelConsumption> list, int avgTarget, int avgType) {
        TimsLogger.debug("FuelConsumption.loadTotal# on fait le total pour " + list.size() + " enregistrements, avgTarget=" + avgTarget + ", avgType=" + avgType);
        Vector<FuelConsumption> avg = new Vector<FuelConsumption>();
        HashMap<String, FuelConsumption> map = new HashMap<String, FuelConsumption>();
        String dateFormat = "*";
        if (avgType == 5) {
            dateFormat = "dd/MM/yyyy";
        } else if (avgType == 3) {
            dateFormat = "w";
        } else if (avgType == 2) {
            dateFormat = "MMM yyyy";
        } else if (avgType == 1) {
            dateFormat = "yyyy";
        }
        for (FuelConsumption tmp : list) {
            String period = dateFormat.equals("*") ? "" : ConversionTime.dateToString(tmp.getDate(), dateFormat);
            TimsLogger.debug("FuelConsumption.loadTotal# periode " + period + " (" + tmp.getDate() + ")");
            switch (avgTarget) {
                case 0: {
                    period = String.valueOf(period) + tmp.getAgencyId();
                    break;
                }
                case 1: {
                    period = String.valueOf(period) + tmp.getDriverId();
                    break;
                }
                case 2: {
                    period = String.valueOf(period) + tmp.getVehicleId();
                }
            }
            FuelConsumption toFill = (FuelConsumption)map.get(period);
            if (toFill == null) {
                toFill = new FuelConsumption();
                toFill.setDate(tmp.getDate());
                toFill.setAgencyId(tmp.getAgencyId());
                switch (avgTarget) {
                    case 1: {
                        toFill.setDriverId(tmp.getDriverId());
                        break;
                    }
                    case 2: {
                        toFill.setVehicleId(tmp.getVehicleId());
                    }
                }
                map.put(period, toFill);
                avg.add(toFill);
            }
            toFill.setLength(tmp.getLength() + toFill.getLength());
            toFill.setLiters(tmp.getLiters() + toFill.getLiters());
            toFill.setKm(tmp.getKm() + toFill.getKm());
            toFill.setConsumption(toFill.getLiters() / toFill.getKm() * 100.0f);
            toFill.setLengthBrake(tmp.getLengthBrake() + toFill.getLengthBrake());
            toFill.setStopLength(tmp.getStopLength() + toFill.getStopLength());
            toFill.setStopLengthStrength(tmp.getStopLengthStrength() + toFill.getStopLengthStrength());
            toFill.setStopLengthInTraffic(tmp.getStopLengthInTraffic() + toFill.getStopLengthInTraffic());
            switch (avgTarget) {
                case 1: {
                    TimsLogger.debug("FuelConsumption.loadTotal# " + ConversionTime.dateToString(tmp.getDate(), dateFormat) + " Driver " + tmp.getDriverId() + "." + " New liters = " + toFill.getLiters() + "(" + tmp.getLiters() + ")" + " New km = " + toFill.getKm() + "(" + tmp.getKm() + ")" + " New conso = " + toFill.getConsumption() + "(" + tmp.getConsumption() + ")");
                    break;
                }
                case 2: {
                    TimsLogger.debug("FuelConsumption.loadTotal# Vehicle " + tmp.getVehicleId() + "." + " New liters = " + toFill.getLiters() + "(" + tmp.getLiters() + ")" + " New km = " + toFill.getKm() + "(" + tmp.getKm() + ")" + " New conso = " + toFill.getConsumption() + "(" + tmp.getConsumption() + ")");
                }
            }
        }
        if (avgType == 0) {
            TimsLogger.debug("loadList# retourne " + avg.size() + " moyennes");
        }
        return avg;
    }

    public static Vector<FuelConsumption> loadList(String filters) {
        Vector<FuelConsumption> liste = new Vector<FuelConsumption>();
        String sql = "SELECT " + FuelConsumption.getAllFields() + " FROM " + table + (filters != null && !filters.equals("") ? " WHERE " + filters.substring(4) : "") + " ORDER BY " + BddTransport.getChampDate();
        TimsLogger.debug("loadList# sql = " + sql);
        try {
            ResultSet rs = null;
            Statement stm = FuelConsumption.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                FuelConsumption tmp = new FuelConsumption(rs.getInt("ID"), rs.getInt("AGENCY_ID"), rs.getInt("DRIVER_ID"), rs.getInt("VEHICLE_ID"), rs.getTimestamp("DATE"), rs.getFloat("CONSUMPTION"), rs.getFloat("LITERS"), rs.getInt("LENGTH"), rs.getFloat("KM"), rs.getInt("KM_CPT"), rs.getInt("STOP_LENGTH"), rs.getInt("STOP_LENGTH_STRENGTH"), rs.getInt("STOP_LENGTH_IN_TRAFFIC"), rs.getFloat("LENGTH_BRAKE"), rs.getInt("REG_DELTA"), rs.getInt("CO2"), rs.getInt("TRAVEL_NOTATION"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("loadList()# sql = " + sql + " => " + ex.getMessage());
        }
        return liste;
    }
}

