/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class GNSSPlace
extends MainElement {
    public static final String table = "gnss_place";
    private int id = 0;
    private int driverId = 0;
    private int vehicleId = 0;
    private Date pointTime = null;
    private int accuracy = 0;
    private POINT_TYPE type = POINT_TYPE.OTHER;
    private float longitude = 0.0f;
    private float latitude = 0.0f;
    private int heading = 0;
    private int vehicleOdometerValue = 0;

    public GNSSPlace() {
    }

    public GNSSPlace(int id, int driverId, int vehicleId, Date pointTime, POINT_TYPE type, int accuracy, float longitude, float latitude, int heading, int vehicleOdometerValue) {
        this.id = id;
        this.driverId = driverId;
        this.vehicleId = vehicleId;
        this.pointTime = pointTime;
        this.type = type;
        this.accuracy = accuracy;
        this.longitude = longitude;
        this.latitude = latitude;
        this.heading = heading;
        this.vehicleOdometerValue = vehicleOdometerValue;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public Date getPointTime() {
        return this.pointTime;
    }

    public void setPointTime(Date pointTime) {
        this.pointTime = pointTime;
    }

    public int getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(int vehicleId) {
        this.vehicleId = vehicleId;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public void setLongitude(float longitude) {
        this.longitude = longitude;
    }

    public float getLatitude() {
        return this.latitude;
    }

    public void setLatitude(float latitude) {
        this.latitude = latitude;
    }

    public POINT_TYPE getType() {
        return this.type;
    }

    public void setType(POINT_TYPE type) {
        this.type = type;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(int accuracy) {
        this.accuracy = accuracy;
    }

    public int getHeading() {
        return this.heading;
    }

    public void setHeading(int heading) {
        this.heading = heading;
    }

    public int getVehicleOdometerValue() {
        return this.vehicleOdometerValue;
    }

    public void setVehicleOdometerValue(int vehicleOdometerValue) {
        this.vehicleOdometerValue = vehicleOdometerValue;
    }

    public boolean insert() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO gnss_place (" + GNSSPlace.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO gnss_place (" + GNSSPlace.getAllFields().substring(GNSSPlace.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?,?,?)";
        }
        try {
            this.statement = GNSSPlace.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.driverId, 4);
            this.statement.setObject(2, (Object)this.vehicleId, 4);
            this.statement.setTimestamp(3, new Timestamp(this.pointTime.getTime()));
            this.statement.setObject(4, (Object)this.type.getIdx(), 4);
            this.statement.setObject(5, (Object)this.accuracy, 4);
            this.statement.setObject(6, (Object)Float.valueOf(this.longitude), 6);
            this.statement.setObject(7, (Object)Float.valueOf(this.latitude), 6);
            this.statement.setObject(8, (Object)this.heading, 6);
            this.statement.setObject(9, (Object)this.vehicleOdometerValue, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean update() {
        String sql = "";
        TimsLogger.debug("#GnssPlace.update()");
        sql = "UPDATE gnss_place SET  DRIVER_ID = ?, VEHICLE_ID = ?, POINT_TIME = ?, TYPE = ?, ACCURACY = ?, LONGITUDE = ?, LATITUDE = ?, HEADING = ?, ODOMETER_VALUE = ? WHERE ID = ?";
        try {
            this.statement = GNSSPlace.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.driverId, 4);
            this.statement.setObject(2, (Object)this.vehicleId, 4);
            this.statement.setTimestamp(3, new Timestamp(this.pointTime.getTime()));
            this.statement.setObject(4, (Object)this.type, 4);
            this.statement.setObject(5, (Object)this.accuracy, 4);
            this.statement.setObject(6, (Object)Float.valueOf(this.longitude), 6);
            this.statement.setObject(7, (Object)Float.valueOf(this.latitude), 6);
            this.statement.setObject(8, (Object)this.heading, 4);
            this.statement.setObject(9, (Object)this.vehicleOdometerValue, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public String getSqlString() {
        return String.valueOf(this.driverId) + "\t" + this.vehicleId + "\t" + ConversionTime.dateToString(this.pointTime, "yyyy-MM-dd HH:mm:ss") + "\t" + this.type.getIdx() + "\t" + this.accuracy + "\t" + this.longitude + "\t" + this.latitude + "\t" + this.heading + "\t" + this.vehicleOdometerValue;
    }

    private static String getAllFields() {
        return "ID, DRIVER_ID, VEHICLE_ID, POINT_TIME, TYPE, ACCURACY, LONGITUDE, LATITUDE, HEADING, ODOMETER_VALUE";
    }

    public static ArrayList<GNSSPlace> getGnssDriverPlaces(int driverId, Date begin, Date end) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(driverId);
        return GNSSPlace.getGnssDriverPlaces(list, ConversionTime.stringToDateDb(begin + " HH:mm:ss"), ConversionTime.stringToDateDb(end + " HH:mm:ss"));
    }

    public static ArrayList<GNSSPlace> getGnssDriverPlaces(List<Integer> list, Date begin, Date end) {
        ArrayList<GNSSPlace> result = new ArrayList<GNSSPlace>();
        String sql = "";
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                sql = "SELECT " + GNSSPlace.getAllFields() + " FROM " + table;
                String restriction = "";
                if (list != null && list.size() != 0) {
                    for (int i : list) {
                        restriction = String.valueOf(restriction) + "," + i;
                    }
                    restriction = " AND DRIVER_ID IN (" + restriction.substring(1) + ")";
                }
                if (begin != null) {
                    restriction = String.valueOf(restriction) + " AND POINT_TIME >= ?";
                }
                if (end != null) {
                    restriction = String.valueOf(restriction) + " AND POINT_TIME <= ?";
                }
                if (!restriction.equals("")) {
                    sql = String.valueOf(sql) + " WHERE " + restriction.substring(5);
                }
                sql = String.valueOf(sql) + " ORDER BY DRIVER_ID, POINT_TIME";
                stm = GNSSPlace.getConnection().prepareStatement(sql);
                int idx = 1;
                if (begin != null) {
                    stm.setTimestamp(idx, new Timestamp(begin.getTime()));
                    ++idx;
                }
                if (end != null) {
                    stm.setTimestamp(idx, new Timestamp(end.getTime()));
                    ++idx;
                }
                TimsLogger.debug("#GNSSPlace.getGnssDriverPlaces # " + stm.toString());
                rs = stm.executeQuery();
                while (rs.next()) {
                    result.add(new GNSSPlace(rs.getInt("ID"), rs.getInt("DRIVER_ID"), rs.getInt("VEHICLE_ID"), rs.getTimestamp("POINT_TIME"), POINT_TYPE.getFromInt(rs.getInt("TYPE")), rs.getInt("ACCURACY"), rs.getFloat("LONGITUDE"), rs.getFloat("LATITUDE"), rs.getInt("HEADING"), rs.getInt("ODOMETER_VALUE")));
                }
                rs.close();
                stm.close();
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception ex) {
                TimsLogger.warn("GnssPlace.getGnssPlaces(  )  : " + ex);
                TimsLogger.debug("sql = " + sql);
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static ArrayList<GNSSPlace> getGnssVehiclePlaces(List<Integer> list, Date begin, Date end) {
        ArrayList<GNSSPlace> result = new ArrayList<GNSSPlace>();
        String sql = "";
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                sql = "SELECT " + GNSSPlace.getAllFields() + " FROM " + table;
                String restriction = "";
                if (list != null && list.size() != 0) {
                    for (int i : list) {
                        restriction = String.valueOf(restriction) + "," + i;
                    }
                    restriction = " AND VEHICLE_ID IN (" + restriction.substring(1) + ")";
                }
                if (begin != null) {
                    restriction = String.valueOf(restriction) + " AND POINT_TIME >= ?";
                }
                if (end != null) {
                    restriction = String.valueOf(restriction) + " AND POINT_TIME <= ?";
                }
                if (!restriction.equals("")) {
                    sql = String.valueOf(sql) + " WHERE " + restriction.substring(5);
                }
                sql = String.valueOf(sql) + " ORDER BY VEHICLE_ID, POINT_TIME";
                stm = GNSSPlace.getConnection().prepareStatement(sql);
                int idx = 1;
                if (begin != null) {
                    stm.setTimestamp(idx, new Timestamp(begin.getTime()));
                    ++idx;
                }
                if (end != null) {
                    stm.setTimestamp(idx, new Timestamp(end.getTime()));
                    ++idx;
                }
                TimsLogger.debug("GNSSPlace.getLastDriverKnown # sql = " + sql + " " + list + " " + begin + " " + end);
                rs = stm.executeQuery();
                while (rs.next()) {
                    result.add(new GNSSPlace(rs.getInt("ID"), rs.getInt("DRIVER_ID"), rs.getInt("VEHICLE_ID"), rs.getTimestamp("POINT_TIME"), POINT_TYPE.getFromInt(rs.getInt("TYPE")), rs.getInt("ACCURACY"), rs.getFloat("LONGITUDE"), rs.getFloat("LATITUDE"), rs.getInt("HEADING"), rs.getInt("ODOMETER_VALUE")));
                }
                rs.close();
                stm.close();
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception ex) {
                TimsLogger.warn("GnssPlace.getGnssPlaces(  )  : " + ex);
                TimsLogger.debug("sql = " + sql);
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static ArrayList<GNSSPlace> getLastDriverPosition(int agencyId, int driverId, Date begin, Date end) {
        ArrayList<GNSSPlace> result = new ArrayList<GNSSPlace>();
        String sql = "";
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                String restriction = "";
                if (driverId != 0) {
                    restriction = String.valueOf(restriction) + " AND DRIVER_ID = ?";
                }
                if (begin != null) {
                    restriction = String.valueOf(restriction) + " AND POINT_TIME >= ?";
                }
                if (end != null) {
                    restriction = String.valueOf(restriction) + " AND POINT_TIME <= ?";
                }
                sql = "SELECT " + GNSSPlace.getAllFields() + " FROM " + table + " JOIN (SELECT DRIVER_ID DI, MAX(POINT_TIME) MAX_POINT FROM " + table;
                sql = String.valueOf(sql) + " WHERE DRIVER_ID != 0 " + restriction;
                sql = String.valueOf(sql) + " GROUP BY DI) AS MAX_T ON DRIVER_ID = DI AND POINT_TIME = MAX_POINT";
                stm = GNSSPlace.getConnection().prepareStatement(sql);
                int idx = 1;
                if (driverId != 0) {
                    stm.setObject(idx, driverId, 4);
                    ++idx;
                }
                if (begin != null) {
                    stm.setTimestamp(idx, new Timestamp(begin.getTime()));
                    ++idx;
                }
                if (end != null) {
                    stm.setTimestamp(idx, new Timestamp(end.getTime()));
                    ++idx;
                }
                TimsLogger.debug("GNSSPlace.getLastDriverKnown # sql = " + sql);
                rs = stm.executeQuery();
                while (rs.next()) {
                    result.add(new GNSSPlace(rs.getInt("ID"), rs.getInt("DRIVER_ID"), rs.getInt("VEHICLE_ID"), rs.getTimestamp("POINT_TIME"), POINT_TYPE.getFromInt(rs.getInt("TYPE")), rs.getInt("ACCURACY"), rs.getFloat("LONGITUDE"), rs.getFloat("LATITUDE"), rs.getInt("HEADING"), rs.getInt("ODOMETER_VALUE")));
                }
                rs.close();
                stm.close();
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception ex) {
                TimsLogger.warn("GnssPlace.getLastDriverKnown(  )  : " + ex);
                TimsLogger.debug("sql = " + sql);
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static ArrayList<GNSSPlace> getLastVehiclePosition(int agencyId, int vehicleId, Date begin, Date end) {
        ArrayList<GNSSPlace> result = new ArrayList<GNSSPlace>();
        String sql = "";
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                String restriction = "";
                if (agencyId != 0) {
                    restriction = String.valueOf(restriction) + " AND VEHICLE_ID IN (SELECT CLE_VEHICULE FROM t_vehicule WHERE CLE_AGENCE = ?)";
                }
                if (vehicleId != 0) {
                    restriction = String.valueOf(restriction) + " AND VEHICLE_ID = ?";
                }
                if (begin != null) {
                    restriction = String.valueOf(restriction) + " AND POINT_TIME >= ?";
                }
                if (end != null) {
                    restriction = String.valueOf(restriction) + " AND POINT_TIME <= ?";
                }
                sql = "SELECT " + GNSSPlace.getAllFields() + " FROM " + table + " JOIN (SELECT VEHICLE_ID VI, MAX(POINT_TIME) MAX_POINT FROM " + table;
                sql = String.valueOf(sql) + " WHERE VEHICLE_ID != 0 " + restriction;
                sql = String.valueOf(sql) + " GROUP BY VI) AS MAX_T ON VEHICLE_ID = VI AND POINT_TIME = MAX_POINT";
                stm = GNSSPlace.getConnection().prepareStatement(sql);
                int idx = 1;
                if (agencyId != 0) {
                    stm.setObject(idx, agencyId, 4);
                    ++idx;
                }
                if (vehicleId != 0) {
                    stm.setObject(idx, vehicleId, 4);
                    ++idx;
                }
                if (begin != null) {
                    stm.setTimestamp(idx, new Timestamp(begin.getTime()));
                    ++idx;
                }
                if (end != null) {
                    stm.setTimestamp(idx, new Timestamp(end.getTime()));
                    ++idx;
                }
                TimsLogger.debug("GNSSPlace.getLastVehicleKnown # sql = " + sql);
                TimsLogger.debug("GNSSPlace.getLastVehicleKnown # agencyId = " + agencyId);
                TimsLogger.debug("GNSSPlace.getLastVehicleKnown # vehicleId = " + vehicleId);
                TimsLogger.debug("GNSSPlace.getLastVehicleKnown # begin = " + begin);
                TimsLogger.debug("GNSSPlace.getLastVehicleKnown # end = " + end);
                rs = stm.executeQuery();
                while (rs.next()) {
                    result.add(new GNSSPlace(rs.getInt("ID"), rs.getInt("DRIVER_ID"), rs.getInt("VEHICLE_ID"), rs.getTimestamp("POINT_TIME"), POINT_TYPE.getFromInt(rs.getInt("TYPE")), rs.getInt("ACCURACY"), rs.getFloat("LONGITUDE"), rs.getFloat("LATITUDE"), rs.getInt("HEADING"), rs.getInt("ODOMETER_VALUE")));
                }
                rs.close();
                stm.close();
            }
            catch (CommunicationsException ex) {
                ex.printStackTrace();
                BddTransport.getInstance().showTimeout();
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception ex) {
                TimsLogger.warn("GnssPlace.getLastVehicleKnown(  )  : " + ex);
                TimsLogger.debug("sql = " + sql);
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static enum POINT_TYPE {
        CONTINUOUS_DRIVING(1, "CONTINUOUS_DRIVING"),
        PLACE_DETAIL(2, "PLACE_DETAIL"),
        BORDER_CROSSING(3, "BORDER_CROSSING"),
        LOAD_UNLOAD(4, "LOAD_UNLOAD"),
        OTHER(15, "UNKNOWN");

        int idx;
        String value;

        private POINT_TYPE(int idx, String value) {
            this.idx = idx;
            this.value = value;
        }

        public int getIdx() {
            return this.idx;
        }

        public String getValue() {
            return this.value;
        }

        public static POINT_TYPE getFromInt(int idx) {
            switch (idx) {
                case 1: {
                    return CONTINUOUS_DRIVING;
                }
                case 2: {
                    return PLACE_DETAIL;
                }
            }
            return OTHER;
        }
    }
}

