/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class Garage
extends MainElement {
    public static final String table = "GARAGE";
    private static Vector<Garage> list = null;
    private int id = 0;
    private int agencyId = 0;
    private String name = null;
    private String code = null;
    private String contact = null;
    private String address = null;
    private String city = null;
    private String postalCode = null;
    private String phone = null;
    private String fax = null;
    private boolean archive = false;

    public Garage() {
    }

    public Garage(int id, int agencyId, String name, String code, String contact, String address, String city, String postalCode, String phone, String fax, boolean archive) {
        this.id = id;
        this.agencyId = agencyId;
        this.name = name;
        this.code = code;
        this.contact = contact;
        this.address = address;
        this.city = city;
        this.postalCode = postalCode;
        this.phone = phone;
        this.fax = fax;
        this.archive = archive;
    }

    public boolean equals(Object o) {
        return o instanceof Garage && this.name.equals(((Garage)o).getName());
    }

    public String toString() {
        return String.valueOf(this.getName()) + " " + (this.getCity() == null ? "" : this.getCity());
    }

    public boolean loadByName(String designation) {
        String sql = "SELECT " + Garage.getAllFields() + " FROM " + table + " WHERE NAME='" + BddTransport.addSlashes(designation) + "'";
        return this.genericLoad(sql);
    }

    public boolean loadByCode(String code) {
        String sql = "SELECT " + Garage.getAllFields() + " FROM " + table + " WHERE CODE='" + BddTransport.addSlashes(code) + "'";
        return this.genericLoad(sql);
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + Garage.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = Garage.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#Garage.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#Garage.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.agencyId = rs.getInt("AGENCY_ID");
                    this.name = rs.getString("NAME");
                    this.code = rs.getString("CODE");
                    this.contact = rs.getString("CONTACT");
                    this.address = rs.getString("ADDRESS");
                    this.city = rs.getString("CITY");
                    this.postalCode = rs.getString("POSTAL_CODE");
                    this.phone = rs.getString("PHONE");
                    this.fax = rs.getString("FAX");
                    this.archive = rs.getBoolean("ARCHIVE");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#Garage.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#Garage.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO GARAGE (" + Garage.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO GARAGE (" + Garage.getAllFields().substring(Garage.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?,?,?,?)";
        }
        try {
            try {
                this.statement = Garage.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.agencyId, 4);
                this.statement.setObject(2, (Object)this.name, 12);
                this.statement.setObject(3, (Object)this.code, 12);
                this.statement.setObject(4, (Object)this.contact, 12);
                this.statement.setObject(5, (Object)this.address, 12);
                this.statement.setObject(6, (Object)this.city, 12);
                this.statement.setObject(7, (Object)this.postalCode, 12);
                this.statement.setObject(8, (Object)this.phone, 12);
                this.statement.setObject(9, (Object)this.fax, 12);
                this.statement.setObject(10, (Object)(this.archive ? 1 : 0), 4);
                this.statement.executeUpdate();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE GARAGE SET  AGENCY_ID=? , NAME=? , CODE=? , CONTACT=? , ADDRESS=? , CITY=? , POSTAL_CODE=? , PHONE=? , FAX=?,  ARCHIVE=?  WHERE ID=?";
        try {
            this.statement = Garage.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.agencyId, 12);
            this.statement.setObject(2, (Object)this.name, 12);
            this.statement.setObject(3, (Object)this.code, 12);
            this.statement.setObject(4, (Object)this.contact, 12);
            this.statement.setObject(5, (Object)this.address, 12);
            this.statement.setObject(6, (Object)this.city, 12);
            this.statement.setObject(7, (Object)this.postalCode, 12);
            this.statement.setObject(8, (Object)this.phone, 12);
            this.statement.setObject(9, (Object)this.fax, 12);
            this.statement.setObject(10, (Object)(this.archive ? 1 : 0), 4);
            this.statement.setObject(11, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean compareAndUpdate(int agencyId, String name, String code, String contact, String address, String city, String postalCode, String phone, String fax, boolean archive) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.garage")) + " n\u00b0 " + this.id + " (" + this.getName() + ") \n";
        if (this.agencyId != agencyId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.agency") + " '" + this.agencyId + "' => '" + agencyId + "'\n";
            this.setAgencyId(agencyId);
        }
        if (Fonctions.fieldChange(name, this.name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.designation") + " '" + this.name + "' => '" + name + "'\n";
            this.setName(name);
        }
        if (Fonctions.fieldChange(code, this.code)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.code") + " '" + this.code + "' => '" + code + "'\n";
            this.setCode(code);
        }
        if (Fonctions.fieldChange(contact, this.contact)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.contact") + " '" + this.contact + "' => '" + contact + "'\n";
            this.setContact(contact);
        }
        if (Fonctions.fieldChange(address, this.address)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.address") + " '" + this.address + "' => '" + address + "'\n";
            this.setAddress(address);
        }
        if (Fonctions.fieldChange(city, this.city)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.city") + " '" + this.city + "' => '" + city + "'\n";
            this.setCity(city);
        }
        if (Fonctions.fieldChange(postalCode, this.postalCode)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.postalCode") + " '" + this.postalCode + "' => '" + postalCode + "'\n";
            this.setPostalCode(postalCode);
        }
        if (Fonctions.fieldChange(phone, this.phone)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.phone") + " '" + this.phone + "' => '" + phone + "'\n";
            this.setPhone(phone);
        }
        if (Fonctions.fieldChange(fax, this.fax)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.fax") + " '" + this.fax + "' => '" + fax + "'\n";
            this.setFax(fax);
        }
        if (this.archive != archive) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.archive") + " '" + this.archive + "' => '" + archive + "'\n";
            this.setArchive(archive);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.garage")) + " n\u00b0 " + this.id + " (" + this.getName() + ") \n")) {
            if (this.id == 0) {
                if (this.insert()) {
                    new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                    return true;
                }
                return false;
            }
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#Garage# no changes");
        return true;
    }

    public void delete() {
        String sql = "DELETE FROM GARAGE WHERE ID=?";
        try {
            this.statement = Garage.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getAgencyId() {
        return this.agencyId;
    }

    public void setAgencyId(int agencyId) {
        this.agencyId = agencyId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public boolean isArchive() {
        return this.archive;
    }

    public void setArchive(boolean archive) {
        this.archive = archive;
    }

    private static String getAllFields() {
        return "ID, AGENCY_ID, NAME, CODE, CONTACT, ADDRESS, CITY, POSTAL_CODE, PHONE, FAX, ARCHIVE";
    }

    public static Vector<Garage> loadList(int agencyId, boolean archive) {
        Vector<Garage> liste = new Vector<Garage>();
        String userRestrict = BddTransport.addNewRestriction(table, true, null, false);
        String sql = "SELECT " + Garage.getAllFields() + " FROM " + table + " WHERE ARCHIVE = " + (archive ? "1" : "0");
        if (agencyId != 0 && agencyId != -1) {
            sql = String.valueOf(sql) + " AND AGENCY_ID = " + agencyId;
        }
        if (userRestrict != "") {
            sql = String.valueOf(sql) + " AND " + userRestrict;
        }
        sql = String.valueOf(sql) + " ORDER BY NAME";
        try {
            ResultSet rs = null;
            Statement stm = Garage.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                Garage tmp = new Garage(rs.getInt("ID"), rs.getInt("AGENCY_ID"), rs.getString("NAME"), rs.getString("CODE"), rs.getString("CONTACT"), rs.getString("ADDRESS"), rs.getString("CITY"), rs.getString("POSTAL_CODE"), rs.getString("PHONE"), rs.getString("FAX"), rs.getBoolean("ARCHIVE"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("Garage.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }

    public static Vector<Garage> getList() {
        if (list == null) {
            list = Garage.loadList(0, false);
        }
        return list;
    }

    public static void setList(Vector<Garage> list) {
        Garage.list = list;
    }

    public static Garage get(int idType) throws DBObjectNotFoundException {
        for (Garage tmp : Garage.getList()) {
            if (tmp.getId() != idType) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException("Garage " + idType);
    }
}

