/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.MainElement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class GlobalCalendarDay
extends MainElement {
    public static final String table = "CALENDAR_DAY";
    private int id = 0;
    private int calendarId = 0;
    private int dayTypeId = 0;
    private Date date = null;

    public GlobalCalendarDay() {
    }

    public GlobalCalendarDay(int id, int calendarId, int dayTypeId, Date date) {
        this.id = id;
        this.calendarId = calendarId;
        this.dayTypeId = dayTypeId;
        this.date = date;
    }

    public void setValues(int id, int calendarId, int dayTypeId, Date date) {
        this.id = id;
        this.calendarId = calendarId;
        this.dayTypeId = dayTypeId;
        this.date = date;
    }

    public GlobalCalendarDay(int calendarId) {
        this.calendarId = calendarId;
    }

    public void update() {
        if (this.id != 0) {
            this.updateJour();
        } else {
            this.insert();
        }
    }

    public void affiche() {
        TimsLogger.info("#GCD.affiche()# id calendar " + this.calendarId + ", id day type " + this.dayTypeId + ",  day = " + this.date);
    }

    public boolean insert() {
        boolean toReturn = false;
        try {
            try {
                String sql = null;
                if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    sql = "INSERT INTO CALENDAR_DAY(ID, CALENDAR_ID, DAY_TYPE_ID, DAY_DATE) VALUES (GEN_CALENDAR_DAY.nextval,?,?,?)";
                    this.statement = GlobalCalendarDay.getConnection().prepareStatement(sql);
                }
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    sql = "INSERT INTO CALENDAR_DAY(CALENDAR_ID, DAY_TYPE_ID, DAY_DATE) VALUES (?,?,?)";
                    this.statement = GlobalCalendarDay.getConnection().prepareStatement(sql, 1);
                }
                this.statement.setObject(1, (Object)this.calendarId, 4);
                this.statement.setObject(2, (Object)this.dayTypeId, 4);
                this.statement.setDate(3, new java.sql.Date(this.date.getTime()));
                this.statement.executeUpdate();
                if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                    ResultSet rs = this.statement.getGeneratedKeys();
                    if (!rs.next()) {
                        TimsLogger.debug("#GCD.insert# no auto generated key availaible");
                    } else {
                        TimsLogger.debug("#GCD.insert# auto generated key value = " + rs.getInt(1));
                        this.id = rs.getInt(1);
                    }
                    rs.close();
                } else if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                    if (this.loadId()) {
                        TimsLogger.debug("#GCD.insert# generated key value = " + this.id);
                    } else {
                        TimsLogger.debug("#GCD.insert# no generated key availaible");
                    }
                }
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean loadId() {
        boolean retour = false;
        ResultSet rs = null;
        String sql = "SELECT MAX(ID) AS ID FROM CALENDAR_DAY";
        try {
            try {
                Statement statement = GlobalCalendarDay.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    this.id = rs.getInt("ID");
                    TimsLogger.debug("#GCD.loadId# id found " + rs.getInt("ID"));
                }
                retour = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.warn("#GCD.loadId()#  : " + ex);
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return retour;
    }

    public boolean delete() {
        String sql = "DELETE FROM CALENDAR_DAY WHERE ID= ?";
        try {
            this.statement = GlobalCalendarDay.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public boolean updateJour() {
        String sql = "UPDATE CALENDAR_DAY SET  CALENDAR_ID = ? , DAY_TYPE_ID = ? , DAY_DATE = ?  WHERE ID= ?";
        try {
            this.statement = GlobalCalendarDay.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.calendarId, 4);
            this.statement.setObject(2, (Object)this.dayTypeId, 4);
            this.statement.setDate(3, new java.sql.Date(this.date.getTime()));
            this.statement.setObject(4, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public boolean load(int calendarId, Date dayDate) {
        block4: {
            ResultSet rs = null;
            TimsLogger.debug("#LienJourConducteur.load()#");
            String sql = "SELECT ID, CALENDAR_ID, DAY_TYPE_ID, DAY_DATE FROM CALENDAR_DAY WHERE CALENDAR_ID = ? AND DAY_DATE = ?";
            this.statement = GlobalCalendarDay.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)calendarId, 12);
            this.statement.setDate(2, new java.sql.Date(dayDate.getTime()));
            rs = this.statement.executeQuery();
            if (!rs.next()) break block4;
            this.id = rs.getInt("ID");
            this.calendarId = calendarId;
            this.dayTypeId = rs.getInt("DAY_TYPE_ID");
            this.date = dayDate;
            this.statement.close();
            return true;
        }
        try {
            this.statement.close();
            return false;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public int getCalendarId() {
        return this.calendarId;
    }

    public void setCalendarId(int calendarId) {
        this.calendarId = calendarId;
    }

    public int getDayTypeId() {
        return this.dayTypeId;
    }

    public void setDayTypeId(int dayTypeId) {
        this.dayTypeId = dayTypeId;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public static Vector<GlobalCalendarDay> loadList(int calendarId, Date begin, Date end) {
        Vector<GlobalCalendarDay> toReturn = new Vector<GlobalCalendarDay>();
        ResultSet rs = null;
        String res = "";
        if (calendarId != 0) {
            res = String.valueOf(res) + " AND CALENDAR_ID = ?";
        }
        if (begin != null) {
            res = end != null ? String.valueOf(res) + " AND DAY_DATE BETWEEN ? AND ?" : String.valueOf(res) + " AND DAY_DATE = ?";
        }
        String sql = "SELECT ID, CALENDAR_ID, DAY_TYPE_ID, DAY_DATE FROM CALENDAR_DAY";
        if (!res.equals("")) {
            sql = String.valueOf(sql) + " WHERE " + res.substring(5);
        }
        try {
            PreparedStatement stm = GlobalCalendarDay.getConnection().prepareStatement(sql);
            int idx = 1;
            if (calendarId != 0) {
                stm.setObject(idx, (Object)calendarId, 4);
                ++idx;
            }
            if (begin != null) {
                stm.setDate(idx, new java.sql.Date(begin.getTime()));
                ++idx;
            }
            if (end != null) {
                stm.setDate(idx, new java.sql.Date(end.getTime()));
                ++idx;
            }
            rs = stm.executeQuery();
            while (rs.next()) {
                toReturn.add(new GlobalCalendarDay(rs.getInt("ID"), rs.getInt("CALENDAR_ID"), rs.getInt("DAY_TYPE_ID"), rs.getDate("DAY_DATE")));
            }
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException ex) {
            TimsLogger.warn("#GCD.loadList()# " + ex);
            TimsLogger.debug(sql);
        }
        return toReturn;
    }

    public static ArrayList<LienJourConducteur> toLJC(Vector<GlobalCalendarDay> list, int driverId) {
        ArrayList<LienJourConducteur> toReturn = new ArrayList<LienJourConducteur>();
        for (GlobalCalendarDay tmp : list) {
            LienJourConducteur toAdd = new LienJourConducteur();
            toAdd.setValues(-1, driverId, tmp.getDayTypeId(), 0, tmp.getDate(), 0, 0, 2);
            toReturn.add(toAdd);
        }
        return toReturn;
    }
}

