/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Constants;

public class Hardness
extends MainElement {
    public static final String NIGHT_HARDNESS = "nuit";
    public static final String table = "hardness";
    private int id;
    private String name = null;
    private String code = null;
    private String calculatorClass = null;
    private int warningThreshold = 0;
    private int attributionThreshold = 0;
    private static Vector<Hardness> list = null;

    public String toString() {
        return this.name;
    }

    public Hardness() {
    }

    public Hardness(int regionId, String name, String code, String calculatorClass, int warningThreshold, int attributionThreshold) {
        this.id = regionId;
        this.name = name;
        this.code = code;
        this.calculatorClass = calculatorClass;
        this.warningThreshold = warningThreshold;
        this.attributionThreshold = attributionThreshold;
    }

    public int getStatus() {
        return 0;
    }

    public boolean isArchive() {
        return false;
    }

    public int getCle() {
        return this.getId();
    }

    public boolean equals(Object object) {
        boolean toReturn = object instanceof Hardness && ((Hardness)object).getName() != null && this.getName() != null && ((Hardness)object).getName().equals(this.getName());
        return toReturn;
    }

    public int hashCode() {
        int hash = (this.name == null ? 0 : this.name.hashCode()) + table.hashCode();
        return hash;
    }

    public boolean insert() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO hardness (" + Hardness.getAllFields() + ")" + " VALUES (GEN_REGION.nextval,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO hardness (" + Hardness.getAllFields().substring(Hardness.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?)";
        }
        try {
            this.statement = Hardness.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.code, 12);
            this.statement.setObject(3, (Object)this.calculatorClass, 12);
            this.statement.setObject(4, (Object)this.warningThreshold, 4);
            this.statement.setObject(5, (Object)this.attributionThreshold, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean update() {
        String sql = "UPDATE hardness SET NAME=? , CODE=? , CALCULATOR_CLASS=? , WARNING_THRESHOLD=? , ATTRIBUTION_THRESHOLD=? WHERE ID=?";
        try {
            this.statement = Hardness.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.code, 12);
            this.statement.setObject(3, (Object)this.calculatorClass, 12);
            this.statement.setObject(4, (Object)this.warningThreshold, 4);
            this.statement.setObject(5, (Object)this.attributionThreshold, 4);
            this.statement.setObject(6, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean delete() {
        String sql = "DELETE FROM hardness WHERE ID =?";
        try {
            this.statement = Hardness.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.id);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean load(int hardnessId) {
        boolean toReturn = false;
        ResultSet rs = null;
        String sql = "SELECT " + Hardness.getAllFields() + " FROM " + table + " WHERE ID=?";
        try {
            try {
                this.statement = Hardness.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)hardnessId, 4);
                rs = this.statement.executeQuery();
                if (rs.next()) {
                    this.id = hardnessId;
                    this.name = rs.getString("NAME");
                    this.code = rs.getString("CODE");
                    this.calculatorClass = rs.getString("CALCULATOR_CLASS");
                    this.warningThreshold = rs.getInt("WARNING_THRESHOLD");
                    this.attributionThreshold = rs.getInt("ATTRIBUTION_THRESHOLD");
                } else {
                    TimsLogger.info("#Hardness.load# no data for region n\u00b0" + hardnessId);
                }
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (Exception ex) {
                block24: {
                    TimsLogger.debug("#Hardness.load(String hardnessId)# : " + ex);
                    if (Transport.debug < 2) break block24;
                    ex.printStackTrace();
                }
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int hardnessId) {
        this.id = hardnessId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCalculatorClass() {
        return this.calculatorClass;
    }

    public void setCalculatorClass(String calculatorClass) {
        this.calculatorClass = calculatorClass;
    }

    public int getWarningThreshold() {
        return this.warningThreshold;
    }

    public void setWarningThreshold(int warningThreshold) {
        this.warningThreshold = warningThreshold;
    }

    public int getAttributionThreshold() {
        return this.attributionThreshold;
    }

    public void setAttributionThreshold(int attributionThreshold) {
        this.attributionThreshold = attributionThreshold;
    }

    public static Vector<Hardness> getList() {
        if (list == null) {
            list = Hardness.loadList();
        }
        return list;
    }

    public static Vector<Hardness> loadList() {
        Vector<Hardness> toReturn = new Vector<Hardness>();
        ResultSet rs = null;
        Statement stm = null;
        String sql = "SELECT " + Hardness.getAllFields() + " FROM " + table;
        sql = String.valueOf(sql) + " ORDER BY NAME";
        try {
            try {
                stm = Hardness.getConnection().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    toReturn.add(new Hardness(rs.getInt("ID"), rs.getString("NAME"), rs.getString("CODE"), rs.getString("CALCULATOR_CLASS"), rs.getInt("WARNING_THRESHOLD"), rs.getInt("ATTRIBUTION_THRESHOLD")));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("Hardness.loadList()  : " + ex);
                TimsLogger.debug(sql);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public static Hardness find(Vector<Hardness> hardnessList, int hardnessId) {
        if (hardnessList == null) {
            hardnessList = Hardness.getList();
        }
        for (Hardness tmp : hardnessList) {
            if (tmp.getId() != hardnessId) continue;
            return tmp;
        }
        return null;
    }

    public static Hardness find(Vector<Hardness> hardnessList, String hardnessName) {
        if (hardnessList == null) {
            hardnessList = Hardness.getList();
        }
        for (Hardness tmp : hardnessList) {
            if (!tmp.getName().equals(hardnessName)) continue;
            return tmp;
        }
        return null;
    }

    private static String getAllFields() {
        return "ID, NAME, CODE, CALCULATOR_CLASS, WARNING_THRESHOLD, ATTRIBUTION_THRESHOLD";
    }
}

