/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Constants;

public class HardnessAttribution
extends MainElement {
    public static final String table = "hardness_attribution";
    int id;
    int hardnessId;
    int driverId;
    Date year = null;
    boolean attribution = false;
    int userId = 0;
    Date creation = null;
    boolean enable = false;
    int counter = 0;

    public String toString() {
        return this.year + " (" + this.hardnessId + "," + this.driverId + ")=> " + this.attribution + " (by " + this.userId + " on " + this.creation + ")";
    }

    public HardnessAttribution() {
    }

    public HardnessAttribution(int id, int hardnessId, int driverId, Date year, boolean attribution, int userId, Date creation, boolean enable, int counter) {
        this.id = id;
        this.hardnessId = hardnessId;
        this.driverId = driverId;
        this.year = year;
        this.attribution = attribution;
        this.userId = userId;
        this.creation = creation;
        this.enable = enable;
        this.counter = counter;
    }

    public boolean equals(Object object) {
        boolean toReturn = object instanceof HardnessAttribution && ((HardnessAttribution)object).getDriverId() == this.getDriverId() && ((HardnessAttribution)object).getHardnessId() == this.getHardnessId() && ((HardnessAttribution)object).getYear().equals(this.getYear()) && ((HardnessAttribution)object).isEnable() == this.isEnable();
        return toReturn;
    }

    public boolean loadEnable(int driverId, int hardnessId, String year) {
        boolean toReturn = false;
        ResultSet rs = null;
        String sql = "SELECT " + HardnessAttribution.getAllFields() + " FROM " + table;
        String restriction = "";
        if (year != null) {
            restriction = String.valueOf(restriction) + " AND YEAR(YEAR) = " + year;
        }
        if (driverId != 0) {
            restriction = String.valueOf(restriction) + " AND DRIVER_ID = " + driverId;
        }
        if (hardnessId != 0) {
            restriction = String.valueOf(restriction) + " AND HARDNESS_ID = " + hardnessId;
        }
        sql = String.valueOf(sql) + " WHERE ENABLE = 1" + restriction;
        sql = String.valueOf(sql) + " ORDER BY YEAR, DRIVER_ID, HARDNESS_ID";
        try {
            try {
                this.statement = HardnessAttribution.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)hardnessId, 4);
                rs = this.statement.executeQuery();
                if (rs.next()) {
                    this.id = rs.getInt("ID");
                    this.hardnessId = rs.getInt("HARDNESS_ID");
                    this.driverId = rs.getInt("DRIVER_ID");
                    this.year = rs.getDate("YEAR");
                    this.attribution = rs.getInt("ATTRIBUTION") == 1;
                    this.userId = rs.getInt("USER_ID");
                    this.creation = rs.getDate("CREATION");
                    this.enable = rs.getInt("ENABLE") == 1;
                    this.counter = rs.getInt("COUNTER");
                } else {
                    TimsLogger.info("#HardnessAttribution.load# no data for n\u00b0" + hardnessId);
                }
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (Exception ex) {
                block27: {
                    TimsLogger.debug("#Hardness.load(String hardnessId)# : " + ex);
                    if (Transport.debug < 2) break block27;
                    ex.printStackTrace();
                }
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean insert() {
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO hardness_attribution (" + HardnessAttribution.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO hardness_attribution (" + HardnessAttribution.getAllFields().substring(HardnessAttribution.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?,?)";
        }
        try {
            this.statement = HardnessAttribution.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.hardnessId, 4);
            this.statement.setObject(2, (Object)this.driverId, 4);
            this.statement.setDate(3, new java.sql.Date(this.year.getTime()));
            this.statement.setObject(4, (Object)(this.attribution ? 1 : 0), 4);
            this.statement.setObject(5, (Object)this.userId, 4);
            this.statement.setTimestamp(6, new Timestamp(this.creation.getTime()));
            this.statement.setObject(7, (Object)this.enable, 4);
            this.statement.setObject(8, (Object)this.counter, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean update() {
        String sql = "UPDATE hardness_attribution SET HARDNESS_ID=? , DRIVER_ID=? ," + BddTransport.getYearField() + "=? ," + " ATTRIBUTION=? ," + " USER_ID=? ," + " CREATION=?, " + " ENABLE=?," + " COUNTER=?" + " WHERE ID=?";
        try {
            this.statement = HardnessAttribution.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.hardnessId, 4);
            this.statement.setObject(2, (Object)this.driverId, 12);
            this.statement.setDate(3, new java.sql.Date(this.year.getTime()));
            this.statement.setObject(4, (Object)this.attribution, 12);
            this.statement.setObject(5, (Object)this.userId, 12);
            this.statement.setDate(6, new java.sql.Date(this.creation.getTime()));
            this.statement.setObject(7, (Object)this.enable, 12);
            this.statement.setObject(8, (Object)this.counter, 4);
            this.statement.setObject(9, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean delete() {
        String sql = "DELETE FROM hardness_attribution WHERE ID =?";
        try {
            this.statement = HardnessAttribution.getConnection().prepareStatement(sql);
            this.statement.setObject(1, this.id);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
            return true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean load(int hardnessAttributionId) {
        boolean toReturn = false;
        ResultSet rs = null;
        String sql = "SELECT " + HardnessAttribution.getAllFields() + " FROM " + table + " WHERE ID=?";
        try {
            try {
                this.statement = HardnessAttribution.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.hardnessId, 4);
                rs = this.statement.executeQuery();
                if (rs.next()) {
                    this.id = hardnessAttributionId;
                    this.hardnessId = rs.getInt("HARDNESS_ID");
                    this.driverId = rs.getInt("DRIVER_ID");
                    this.year = rs.getDate("YEAR");
                    this.attribution = rs.getInt("ATTRIBUTION") == 1;
                    this.userId = rs.getInt("USER_ID");
                    this.creation = rs.getDate("CREATION");
                    this.enable = rs.getInt("ENABLE") == 1;
                    this.counter = rs.getInt("COUNTER");
                } else {
                    TimsLogger.info("#HardnessAttribution.load# no data for n\u00b0" + this.hardnessId);
                }
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (Exception ex) {
                block24: {
                    TimsLogger.debug("#Hardness.load(String hardnessId)# : " + ex);
                    if (Transport.debug < 2) break block24;
                    ex.printStackTrace();
                }
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int hardnessId) {
        this.id = hardnessId;
    }

    public int getHardnessId() {
        return this.hardnessId;
    }

    public void setHardnessId(int hardnessId) {
        this.hardnessId = hardnessId;
    }

    public int getDriverId() {
        return this.driverId;
    }

    public void setDriverId(int driverId) {
        this.driverId = driverId;
    }

    public Date getYear() {
        return this.year;
    }

    public void setYear(Date year) {
        this.year = year;
    }

    public boolean isAttribution() {
        return this.attribution;
    }

    public void setAttribution(boolean attribution) {
        this.attribution = attribution;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public Date getCreation() {
        return this.creation;
    }

    public void setCreation(Date creation) {
        this.creation = creation;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public static Vector<HardnessAttribution> loadList(String year) {
        Vector<HardnessAttribution> toReturn = new Vector<HardnessAttribution>();
        ResultSet rs = null;
        Statement stm = null;
        String sql = "SELECT " + HardnessAttribution.getAllFields() + " FROM " + table;
        String restriction = "";
        if (year != null) {
            restriction = String.valueOf(restriction) + " AND YEAR(YEAR) = " + year;
        }
        if (!restriction.equals("")) {
            sql = String.valueOf(sql) + " WHERE ENABLE=1 AND " + restriction.substring(5);
        }
        sql = String.valueOf(sql) + " ORDER BY YEAR, DRIVER_ID, HARDNESS_ID";
        try {
            try {
                stm = HardnessAttribution.getConnection().createStatement();
                rs = stm.executeQuery(sql);
                while (rs.next()) {
                    toReturn.add(new HardnessAttribution(rs.getInt("ID"), rs.getInt("HARDNESS_ID"), rs.getInt("DRIVER_ID"), rs.getDate("YEAR"), rs.getInt("ATTRIBUTION") == 1, rs.getInt("USER_ID"), rs.getDate("CREATION"), rs.getInt("ENABLE") == 1, rs.getInt("COUNTER")));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("HardnessAttribution.loadList()  : " + ex);
                TimsLogger.debug(sql);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public static boolean disable(int driverId, int hardnessId, String year) {
        TimsLogger.debug("HardnessAttribution.disable # Disable attribution on " + year + " for (" + driverId + " " + hardnessId + ")");
        boolean toReturn = false;
        ResultSet rs = null;
        Statement stm = null;
        String sql = "UPDATE hardness_attribution SET ENABLE = 0, USER_ID = " + ConnexionSettings.getInstance().getUserCle();
        String restriction = "";
        if (year != null) {
            restriction = String.valueOf(restriction) + " AND YEAR(YEAR) = " + year;
        }
        if (driverId != 0) {
            restriction = String.valueOf(restriction) + " AND DRIVER_ID = " + driverId;
        }
        if (hardnessId != 0) {
            restriction = String.valueOf(restriction) + " AND HARDNESS_ID = " + hardnessId;
        }
        if (!restriction.equals("")) {
            sql = String.valueOf(sql) + " WHERE ENABLE = 1" + restriction;
        }
        TimsLogger.verbose("HardnessAttribution.disable # sql = " + sql);
        try {
            try {
                stm = HardnessAttribution.getConnection().createStatement();
                stm.executeUpdate(sql);
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("HardnessAttribution.disable()  : " + ex);
                TimsLogger.debug(sql);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public static boolean recalculation(int driverId, int hardnessId, String year) {
        TimsLogger.debug("HardnessAttribution.recalculation # Mark for recalculation on " + year + " for (" + driverId + " " + hardnessId + ")");
        boolean toReturn = false;
        ResultSet rs = null;
        Statement stm = null;
        String sql = "UPDATE hardness_attribution SET RECALCULATION = 1";
        String restriction = "";
        if (year != null) {
            restriction = String.valueOf(restriction) + " AND YEAR(YEAR) = " + year;
        }
        if (driverId != 0) {
            restriction = String.valueOf(restriction) + " AND DRIVER_ID = " + driverId;
        }
        if (hardnessId != 0) {
            restriction = String.valueOf(restriction) + " AND HARDNESS_ID = " + hardnessId;
        }
        if (!restriction.equals("")) {
            sql = String.valueOf(sql) + " WHERE ENABLE = 1" + restriction;
        }
        TimsLogger.verbose("HardnessAttribution.recalculation # sql = " + sql);
        try {
            try {
                stm = HardnessAttribution.getConnection().createStatement();
                stm.executeUpdate(sql);
                toReturn = true;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("HardnessAttribution.recalculation()  : " + ex);
                TimsLogger.debug(sql);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    private static String getAllFields() {
        return "ID, HARDNESS_ID, DRIVER_ID, YEAR, ATTRIBUTION, USER_ID, CREATION, ENABLE, COUNTER";
    }
}

