/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class IcontactPerson
extends MainElement {
    public static final String table = String.valueOf(BddTransport.getBaseDefault(true)) + "icontact_person";
    private static Vector<IcontactPerson> list = null;
    private int id = 0;
    private int companyId = 0;
    private String firstName = null;
    private String lastName = null;
    private String phone = null;
    private String mail = null;

    public IcontactPerson() {
    }

    public IcontactPerson(int id, int companyId, String lastName, String firstName, String phone, String mail) {
        this.id = id;
        this.companyId = companyId;
        this.phone = phone;
        this.lastName = lastName;
        this.firstName = firstName;
        this.mail = mail;
    }

    public String toString() {
        return String.valueOf(this.getLastName()) + " " + this.getFirstName();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(int companyId) {
        this.companyId = companyId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getMail() {
        return this.mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public boolean compareAndUpdate(String firstName, String lastName, int companyId, String mail, String phone) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.contact")) + " n\u00b0 " + this.id + " (" + this.getLastName() + ") \n";
        if (Fonctions.fieldChange(firstName, this.firstName)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.firstName") + " '" + this.firstName + "' => '" + firstName + "'\n";
            this.setFirstName(firstName);
        }
        if (Fonctions.fieldChange(lastName, this.lastName)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("user.lastName") + " '" + this.lastName + "' => '" + lastName + "'\n";
            this.setLastName(lastName);
        }
        if (Fonctions.fieldChange(mail, this.mail)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.mail") + " '" + this.mail + "' => '" + mail + "'\n";
            this.setMail(mail);
        }
        if (Fonctions.fieldChange(phone, this.phone)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.phone") + " '" + this.phone + "' => '" + phone + "'\n";
            this.setPhone(phone);
        }
        if (companyId != this.companyId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.region") + " '" + this.companyId + "' => '" + companyId + "'\n";
            this.setCompanyId(companyId);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.contact")) + " n\u00b0 " + this.id + " (" + this.getLastName() + ") \n")) {
            if (this.id == 0 && this.insert()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                return true;
            }
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#TypeActivite# no changes");
        return true;
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            return toReturn;
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO " + table + " (" + IcontactPerson.getAllFields().substring(IcontactPerson.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?)";
        }
        try {
            try {
                this.statement = BddTransport.getInstance().getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.companyId, 12);
                this.statement.setObject(2, (Object)this.firstName, 12);
                this.statement.setObject(3, (Object)this.lastName, 12);
                this.statement.setObject(4, (Object)this.phone, 12);
                this.statement.setObject(5, (Object)this.mail, 12);
                this.statement.executeUpdate();
                this.statement.close();
                toReturn = true;
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    this.statement.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                this.statement.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE " + table + " SET " + " FIRST_NAME=? ," + " LAST_NAME=? ," + " MAIL=? ," + " PHONE=? ," + " COMPANY_ID=? " + " WHERE ID=?";
        try {
            this.statement = IcontactPerson.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.firstName, 12);
            this.statement.setObject(2, (Object)this.lastName, 12);
            this.statement.setObject(3, (Object)this.mail, 12);
            this.statement.setObject(4, (Object)this.phone, 12);
            this.statement.setObject(5, (Object)this.companyId, 12);
            this.statement.setObject(6, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public static String getAllFields() {
        return "ID, COMPANY_ID, FIRST_NAME, LAST_NAME, PHONE, MAIL";
    }

    public static IcontactPerson loadByName(String nom, String prenom) {
        IcontactPerson result = null;
        String sql = "";
        try {
            sql = "SELECT " + IcontactPerson.getAllFields() + " FROM " + table + " WHERE LAST_NAME = '" + nom + "' AND" + " FIRST_NAME ='" + prenom + "' ";
            Statement stm = BddTransport.getInstance().getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                if (result != null) continue;
                result = new IcontactPerson(rs.getInt("ID"), rs.getInt("COMPANY_ID"), rs.getString("FIRST_NAME"), rs.getString("LAST_NAME"), rs.getString("PHONE"), rs.getString("MAIL"));
            }
            rs.close();
            stm.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }

    public static Vector<IcontactPerson> loadList() {
        String sql = "";
        Vector<IcontactPerson> result = new Vector<IcontactPerson>();
        try {
            sql = "SELECT " + IcontactPerson.getAllFields() + " FROM " + table + " ORDER BY LAST_NAME, FIRST_NAME";
            Statement stm = IcontactPerson.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                IcontactPerson toAdd = new IcontactPerson(rs.getInt("ID"), rs.getInt("COMPANY_ID"), rs.getString("LAST_NAME"), rs.getString("FIRST_NAME"), rs.getString("PHONE"), rs.getString("MAIL"));
                result.add(toAdd);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("IcontactPerson.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
        }
        return result;
    }

    public static Vector<IcontactPerson> getList() {
        if (list == null) {
            list = IcontactPerson.loadList();
        }
        return list;
    }

    public static void setList(Vector<IcontactPerson> list) {
        IcontactPerson.list = list;
    }

    public static IcontactPerson get(int id) throws DBObjectNotFoundException {
        for (IcontactPerson tmp : IcontactPerson.getList()) {
            if (tmp.getId() != id) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException("IcontactPerson " + id);
    }

    public static Vector<IcontactPerson> filterCompany(int companyId) {
        Vector<IcontactPerson> toReturn = new Vector<IcontactPerson>();
        for (IcontactPerson tmp : IcontactPerson.getList()) {
            if (companyId != 0 && tmp.getCompanyId() != companyId) continue;
            toReturn.add(tmp);
        }
        return toReturn;
    }
}

