/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class IcontactRegion
extends MainElement {
    public static final String table = String.valueOf(BddTransport.getBaseDefault(true)) + "REGION";
    private static Vector<IcontactRegion> list = null;
    private int id = 0;
    private String name = null;

    public IcontactRegion() {
    }

    public IcontactRegion(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public boolean equals(Object o) {
        return o instanceof IcontactRegion && this.name.equals(((IcontactRegion)o).getName());
    }

    public String toString() {
        return this.getName();
    }

    public boolean loadByName(String designation) {
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append(IcontactRegion.getAllFields()).append(" FROM ").append(table).append(" WHERE NAME='");
        BddTransport.getInstance();
        String sql = stringBuilder.append(BddTransport.addSlashes(designation)).append("'").toString();
        return this.genericLoad(sql);
    }

    public boolean loadByCode(String code) {
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append(IcontactRegion.getAllFields()).append(" FROM ").append(table).append(" WHERE CODE='");
        BddTransport.getInstance();
        String sql = stringBuilder.append(BddTransport.addSlashes(code)).append("'").toString();
        return this.genericLoad(sql);
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + IcontactRegion.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = IcontactRegion.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#IcontactRegion.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#IcontactRegion.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.name = rs.getString("NAME");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#IcontactRegion.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#IcontactRegion.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO " + table + " (" + IcontactRegion.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO " + table + " (" + IcontactRegion.getAllFields().substring(IcontactRegion.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?)";
        }
        try {
            this.statement = IcontactRegion.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE " + table + " SET " + " NAME=? " + " WHERE ID=?";
        try {
            this.statement = IcontactRegion.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private static String getAllFields() {
        return "ID, NAME";
    }

    public boolean compareAndUpdate(int id, String name, String code, boolean archive) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.type")) + " n\u00b0 " + id + " (" + this.getName() + ") \n";
        if (Fonctions.fieldChange(name, this.name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.designation") + " '" + this.name + "' => '" + name + "'\n";
            this.setName(name);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.type")) + " n\u00b0 " + id + " (" + this.getName() + ") \n")) {
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#IcontactRegion# no changes");
        return true;
    }

    public void delete() {
        String sql = "DELETE FROM " + table + " WHERE ID=?";
        try {
            this.statement = IcontactRegion.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Vector<IcontactRegion> loadList(boolean archive) {
        Vector<IcontactRegion> liste = new Vector<IcontactRegion>();
        String sql = "SELECT " + IcontactRegion.getAllFields() + " FROM " + table + " ORDER BY NAME";
        try {
            ResultSet rs = null;
            Statement stm = IcontactRegion.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                IcontactRegion tmp = new IcontactRegion(rs.getInt("ID"), rs.getString("NAME"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("IcontactRegion.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }

    public static Vector<IcontactRegion> getList() {
        if (list == null) {
            list = IcontactRegion.loadList(false);
        }
        return list;
    }

    public static void setList(Vector<IcontactRegion> list) {
        IcontactRegion.list = list;
    }

    public static IcontactRegion get(int id) throws DBObjectNotFoundException {
        for (IcontactRegion tmp : IcontactRegion.getList()) {
            if (tmp.getId() != id) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException("IcontactRegion " + id);
    }
}

