/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class ImportField
extends MainElement {
    public static final String table = "IMPORT_FIELD";
    private int id = 0;
    private int importModuleId = 0;
    private String name = null;
    private String fieldValue = null;

    public ImportField() {
    }

    public ImportField(int id, int importModuleId, String name, String fieldValue) {
        this.id = id;
        this.importModuleId = importModuleId;
        this.name = name;
        this.fieldValue = fieldValue;
    }

    public boolean equals(Object o) {
        return o instanceof ImportField && this.name.equals(((ImportField)o).getName());
    }

    public String toString() {
        return this.getName();
    }

    public boolean loadByName(String designation, int importModuleId) {
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append(ImportField.getAllFields()).append(" FROM ").append(table).append(" WHERE NAME='");
        BddTransport.getInstance();
        String sql = stringBuilder.append(BddTransport.addSlashes(designation)).append("'").append(" AND IMPORT_MODULE_ID = ").append(importModuleId).toString();
        return this.genericLoad(sql);
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + ImportField.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = ImportField.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#ImportField.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#ImportField.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.importModuleId = rs.getInt("IMPORT_MODULE_ID");
                    this.name = rs.getString("NAME");
                    this.fieldValue = rs.getString("FIELD_VALUE");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#ImportField.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#ImportField.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO IMPORT_FIELD (" + ImportField.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO IMPORT_FIELD (" + ImportField.getAllFields().substring(ImportField.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?)";
        }
        try {
            this.statement = ImportField.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.importModuleId, 4);
            this.statement.setObject(2, (Object)this.name, 12);
            this.statement.setObject(3, (Object)this.fieldValue, 12);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE IMPORT_FIELD SET  IMPORT_MODULE_ID=? , NAME=? , FIELD_VALUE=?  WHERE ID=?";
        try {
            this.statement = ImportField.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.importModuleId, 4);
            this.statement.setObject(2, (Object)this.name, 12);
            this.statement.setObject(3, (Object)this.fieldValue, 12);
            this.statement.setObject(4, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getImportModuleId() {
        return this.importModuleId;
    }

    public void setImportModuleId(int importModuleId) {
        this.importModuleId = importModuleId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    private static String getAllFields() {
        return "IMPORT_FIELD.ID, IMPORT_MODULE_ID, IMPORT_FIELD.NAME, FIELD_VALUE";
    }

    public boolean compareAndUpdate(int id, int importModuleId, String name, String fieldValue) {
        String tracer = String.valueOf(LanguageTranslator.getString("import")) + " n\u00b0 " + id + " (" + this.getName() + ") \n";
        if (importModuleId != this.importModuleId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.id") + " '" + this.importModuleId + "' => '" + importModuleId + "'\n";
            this.setImportModuleId(importModuleId);
        }
        if (Fonctions.fieldChange(name, this.name)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.designation") + " '" + this.name + "' => '" + name + "'\n";
            this.setName(name);
        }
        if (Fonctions.fieldChange(fieldValue, this.fieldValue)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.code") + " '" + this.fieldValue + "' => '" + fieldValue + "'\n";
            this.setFieldValue(fieldValue);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("import")) + " n\u00b0 " + id + " (" + this.getName() + ") \n")) {
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#ImportField# no changes");
        return true;
    }

    public void delete() {
        String sql = "DELETE FROM IMPORT_FIELD WHERE ID=?";
        try {
            this.statement = ImportField.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Vector<ImportField> loadList(String module) {
        Vector<ImportField> liste = new Vector<ImportField>();
        String sql = "SELECT " + ImportField.getAllFields() + " FROM " + table + " JOIN " + "IMPORT_MODULE" + " i ON IMPORT_MODULE_ID = i.ID" + " WHERE i.NAME = '" + module + "'";
        try {
            ResultSet rs = null;
            Statement stm = ImportField.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                ImportField tmp = new ImportField(rs.getInt("ID"), rs.getInt("IMPORT_MODULE_ID"), rs.getString("NAME"), rs.getString("FIELD_VALUE"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("ImportField.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }

    public static HashMap<String, String> loadHashMap(String module) {
        HashMap<String, String> list = new HashMap<String, String>();
        String sql = "SELECT " + ImportField.getAllFields() + " FROM " + table + " JOIN " + "IMPORT_MODULE" + " i ON IMPORT_MODULE_ID = i.ID" + " WHERE i.NAME = '" + module + "'";
        try {
            TimsLogger.debug("sql = " + sql);
            Statement stm = ImportField.getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            while (rs.next()) {
                list.put(rs.getString("NAME"), rs.getString("FIELD_VALUE"));
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("ImportField.loadHashMap()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return list;
    }

    public static ImportField get(Vector<ImportField> list, int id) throws DBObjectNotFoundException {
        for (ImportField tmp : list) {
            if (tmp.getId() != id) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException("ImportField " + id);
    }
}

