/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Constants;

public class ImportModule
extends MainElement {
    public static final String table = "IMPORT_MODULE";
    private static Vector<ImportModule> list = null;
    private int id = 0;
    private String name = null;

    public ImportModule() {
    }

    public ImportModule(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public boolean equals(Object o) {
        return o instanceof ImportModule && this.name.equals(((ImportModule)o).getName());
    }

    public String toString() {
        return this.getName();
    }

    public boolean loadByName(String designation) {
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append(ImportModule.getAllFields()).append(" FROM ").append(table).append(" WHERE NAME='");
        BddTransport.getInstance();
        String sql = stringBuilder.append(BddTransport.addSlashes(designation)).append("'").toString();
        return this.genericLoad(sql);
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + ImportModule.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = ImportModule.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#ImportModule.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#VehImportModuleicleBody.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.name = rs.getString("NAME");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#ImportModule.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#ImportModule.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO IMPORT_MODULE (" + ImportModule.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO IMPORT_MODULE (" + ImportModule.getAllFields().substring(ImportModule.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?)";
        }
        try {
            this.statement = ImportModule.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE IMPORT_MODULE SET  NAME=?  WHERE ID=?";
        try {
            this.statement = ImportModule.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.name, 12);
            this.statement.setObject(2, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private static String getAllFields() {
        return "ID, NAME";
    }

    public void delete() {
        String sql = "DELETE FROM IMPORT_MODULE WHERE ID=?";
        try {
            this.statement = ImportModule.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Vector<ImportModule> loadList() {
        Vector<ImportModule> liste = new Vector<ImportModule>();
        String sql = "SELECT " + ImportModule.getAllFields() + " FROM " + table + " BY NAME";
        try {
            ResultSet rs = null;
            Statement stm = ImportModule.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                ImportModule tmp = new ImportModule(rs.getInt("ID"), rs.getString("NAME"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("ImportModule.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }

    public static Vector<ImportModule> getList() {
        if (list == null) {
            list = ImportModule.loadList();
        }
        return list;
    }

    public static void setList(Vector<ImportModule> list) {
        ImportModule.list = list;
    }

    public static ImportModule get(int id) throws DBObjectNotFoundException {
        for (ImportModule tmp : ImportModule.getList()) {
            if (tmp.getId() != id) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException("ImportModule " + id);
    }
}

