/*
 * Decompiled with CFR 0.152.
 */
package fr.pgh.data.bdd;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.data.BddEvent;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.MainElement;
import fr.pgh.data.bdd.Tracking;
import fr.pgh.exception.DBObjectNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Constants;
import transpo.system.util.Fonctions;

public class Injured
extends MainElement {
    public static final String table = "INJURED";
    private static Vector<Injured> list = null;
    private int id = 0;
    private int accidentId = 0;
    private boolean employee = false;
    private String firstName = null;
    private String lastName = null;
    private String address = null;
    private String city = null;
    private String postalCode = null;
    private String phone = null;

    public Injured() {
    }

    public Injured(int id, int accidentId, boolean employee, String firstName, String lastName, String address, String city, String postalCode, String phone) {
        this.id = id;
        this.accidentId = accidentId;
        this.employee = employee;
        this.firstName = firstName;
        this.lastName = lastName;
        this.address = address;
        this.city = city;
        this.postalCode = postalCode;
        this.phone = phone;
    }

    public boolean equals(Object o) {
        return o instanceof Injured && this.firstName.equals(((Injured)o).getFirstName()) && this.lastName.equals(((Injured)o).getLastName());
    }

    public Object clone() {
        return new Injured(this.id, this.accidentId, this.employee, this.firstName, this.lastName, this.address, this.city, this.postalCode, this.phone);
    }

    public String toString() {
        if (this.firstName == null || this.lastName == null) {
            return null;
        }
        return String.valueOf(this.firstName) + "  " + this.lastName + " - " + this.address + ", " + this.city + " " + this.postalCode + " - " + this.phone;
    }

    public boolean loadByName(String firstName, String lastName) {
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append(Injured.getAllFields()).append(" FROM ").append(table).append(" WHERE FIRST_NAME='");
        BddTransport.getInstance();
        StringBuilder stringBuilder2 = stringBuilder.append(BddTransport.addSlashes(firstName)).append("'").append(" AND LAST_NAME='");
        BddTransport.getInstance();
        String sql = stringBuilder2.append(BddTransport.addSlashes(lastName)).append("'").toString();
        return this.genericLoad(sql);
    }

    public boolean loadById(int cle) {
        String sql = "SELECT " + Injured.getAllFields() + " FROM " + table + " WHERE ID=" + cle;
        return this.genericLoad(sql);
    }

    public boolean genericLoad(String sql) {
        boolean toReturn = false;
        ResultSet rs = null;
        Statement statement = null;
        try {
            try {
                statement = Injured.getConnection().createStatement();
                rs = statement.executeQuery(sql);
                TimsLogger.debug("#Injured.genericLoad# sql " + sql);
                while (rs.next()) {
                    TimsLogger.debug("#Injured.genericLoad# Found id " + rs.getInt("ID"));
                    this.id = rs.getInt("ID");
                    this.accidentId = rs.getInt("ACCIDENT_ID");
                    this.employee = rs.getInt("EMPLOYEE") == 1;
                    this.firstName = rs.getString("FIRST_NAME");
                    this.lastName = rs.getString("LAST_NAME");
                    this.address = rs.getString("ADDRESS");
                    this.city = rs.getString("CITY");
                    this.postalCode = rs.getString("POSTAL_CODE");
                    this.phone = rs.getString("PHONE");
                    toReturn = true;
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (SQLException ex) {
                TimsLogger.warn("#Injured.genericLoad() # : " + ex);
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public boolean update() {
        if (this.id == 0) {
            return this.insert();
        }
        return this.updateValue();
    }

    public boolean insert() {
        boolean toReturn = false;
        String sql = "";
        TimsLogger.debug("#Injured.insert()");
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            sql = "INSERT INTO INJURED (" + Injured.getAllFields() + ")" + " VALUES (GEN_" + table + ".nextval,?,?,?,?,?,?,?,?)";
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            sql = "INSERT INTO INJURED (" + Injured.getAllFields().substring(Injured.getAllFields().indexOf(",") + 1) + ")" + " VALUES (?,?,?,?,?,?,?,?)";
        }
        try {
            this.statement = Injured.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.accidentId, 4);
            this.statement.setObject(2, (Object)(this.employee ? 1 : 0), 4);
            this.statement.setObject(3, (Object)this.firstName, 12);
            this.statement.setObject(4, (Object)this.lastName, 12);
            this.statement.setObject(5, (Object)this.address, 12);
            this.statement.setObject(6, (Object)this.city, 12);
            this.statement.setObject(7, (Object)this.postalCode, 12);
            this.statement.setObject(8, (Object)this.phone, 12);
            this.statement.executeUpdate();
            this.statement.close();
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.CREATE));
            toReturn = true;
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean updateValue() {
        boolean toReturn = false;
        String sql = "UPDATE INJURED SET  ACCIDENT_ID=? , EMPLOYEE=? , FIRST_NAME=? , LAST_NAME=? , ADDRESS=? , CITY=? , POSTAL_CODE=? , PHONE=?  WHERE ID=?";
        try {
            this.statement = Injured.getConnection().prepareStatement(sql);
            this.statement.setObject(1, (Object)this.accidentId, 4);
            this.statement.setObject(2, (Object)(this.employee ? 1 : 0), 4);
            this.statement.setObject(3, (Object)this.firstName, 12);
            this.statement.setObject(4, (Object)this.lastName, 12);
            this.statement.setObject(5, (Object)this.address, 12);
            this.statement.setObject(6, (Object)this.city, 12);
            this.statement.setObject(7, (Object)this.postalCode, 12);
            this.statement.setObject(8, (Object)this.phone, 12);
            this.statement.setObject(9, (Object)this.id, 4);
            this.statement.executeUpdate();
            this.statement.close();
            toReturn = true;
            BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.UPDATE));
        }
        catch (CommunicationsException ex) {
            BddTransport.getInstance().showTimeout();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean compareAndUpdate(int accidentId, boolean employee, String firstName, String lastName, String address, String city, String postalCode, String phone) {
        String tracer = String.valueOf(LanguageTranslator.getString("generics.injuried")) + " n\u00b0 " + this.id + " (" + this.getLastName() + ") \n";
        if (this.accidentId != accidentId) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("accident") + " '" + this.accidentId + "' => '" + accidentId + "'\n";
            this.setAccidentId(accidentId);
        }
        if (this.employee != employee) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.employee") + " '" + this.employee + "' => '" + employee + "'\n";
            this.setEmployee(employee);
        }
        if (Fonctions.fieldChange(firstName, this.firstName)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.firstName") + " '" + this.firstName + "' => '" + firstName + "'\n";
            this.setFirstName(firstName);
        }
        if (Fonctions.fieldChange(lastName, this.lastName)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.lastName") + " '" + this.lastName + "' => '" + lastName + "'\n";
            this.setLastName(lastName);
        }
        if (Fonctions.fieldChange(address, this.address)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.address") + " '" + this.address + "' => '" + address + "'\n";
            this.setAddress(address);
        }
        if (Fonctions.fieldChange(city, this.city)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.city") + " '" + this.city + "' => '" + city + "'\n";
            this.setCity(city);
        }
        if (Fonctions.fieldChange(postalCode, this.postalCode)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.postalCode") + " '" + this.postalCode + "' => '" + postalCode + "'\n";
            this.setPostalCode(postalCode);
        }
        if (Fonctions.fieldChange(phone, this.phone)) {
            tracer = String.valueOf(tracer) + LanguageTranslator.getString("generics.phone") + " '" + this.phone + "' => '" + phone + "'\n";
            this.setPhone(phone);
        }
        if (!tracer.equals(String.valueOf(LanguageTranslator.getString("generics.injuried")) + " n\u00b0 " + this.id + " (" + this.getLastName() + ") \n")) {
            if (this.id == 0) {
                if (this.insert()) {
                    new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 0, new Date(), tracer).insert();
                    return true;
                }
                return false;
            }
            if (this.updateValue()) {
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 2, new Date(), tracer).insert();
                return true;
            }
            return false;
        }
        TimsLogger.debug("#Injured# no changes");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean delete() {
        boolean toReturn = false;
        String sql = "DELETE FROM INJURED WHERE ID=?";
        try {
            try {
                this.statement = Injured.getConnection().prepareStatement(sql);
                this.statement.setObject(1, (Object)this.id, 4);
                this.statement.executeUpdate();
                toReturn = true;
                new Tracking(0, ConnexionSettings.getInstance().getUserCle(), table, 1, new Date(), String.valueOf(LanguageTranslator.getString("generics.injured")) + " n\u00b0 " + this.id).insert();
                BddTransport.getInstance().fireDBChanged(new BddEvent(table, Constants.ACTION_TYPE.DELETE));
                return toReturn;
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                return toReturn;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (this.statement == null) return toReturn;
                try {
                    this.statement.close();
                    return toReturn;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return toReturn;
            }
        }
        finally {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getAccidentId() {
        return this.accidentId;
    }

    public void setAccidentId(int accidentId) {
        this.accidentId = accidentId;
    }

    public boolean isEmployee() {
        return this.employee;
    }

    public void setEmployee(boolean employee) {
        this.employee = employee;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    private static String getAllFields() {
        return "ID, ACCIDENT_ID, EMPLOYEE, FIRST_NAME, LAST_NAME, ADDRESS, CITY, POSTAL_CODE, PHONE";
    }

    public static Vector<Injured> loadList(int accidentId) {
        Vector<Injured> liste = new Vector<Injured>();
        String sql = "SELECT " + Injured.getAllFields() + " FROM " + table;
        if (accidentId != 0) {
            sql = String.valueOf(sql) + " WHERE ACCIDENT_ID =" + accidentId;
        }
        sql = String.valueOf(sql) + " ORDER BY LAST_NAME, FIRST_NAME";
        try {
            ResultSet rs = null;
            Statement stm = Injured.getConnection().createStatement();
            rs = stm.executeQuery(sql);
            while (rs.next()) {
                Injured tmp = new Injured(rs.getInt("ID"), rs.getInt("ACCIDENT_ID"), rs.getInt("EMPLOYEE") == 1, rs.getString("FIRST_NAME"), rs.getString("LAST_NAME"), rs.getString("ADDRESS"), rs.getString("CITY"), rs.getString("POSTAL_CODE"), rs.getString("PHONE"));
                liste.add(tmp);
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.warn("Injured.loadList()  : " + ex);
            TimsLogger.debug("sql = " + sql);
            ex.printStackTrace();
        }
        return liste;
    }

    public static Vector<Injured> getList() {
        if (list == null) {
            list = Injured.loadList(0);
        }
        return list;
    }

    public static void setList(Vector<Injured> list) {
        Injured.list = list;
    }

    public static Injured get(int idType) throws DBObjectNotFoundException {
        for (Injured tmp : Injured.getList()) {
            if (tmp.getId() != idType) continue;
            return tmp;
        }
        throw new DBObjectNotFoundException("Injured");
    }
}

